######################################################################
#
# 1120_utf8jp_by_jipse.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x80"],
        ["\x01",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x81"],
        ["\x02",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x82"],
        ["\x03",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x83"],
        ["\x37",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x84"],
        ["\x2D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x85"],
        ["\x2E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x86"],
        ["\x2F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x87"],
        ["\x16",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x88"],
        ["\x05",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x89"],
        ["\x15",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8A"],
        ["\x0B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8B"],
        ["\x0C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8C"],
        ["\x0D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8D"],
        ["\x0E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8E"],
        ["\x0F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8F"],
        ["\x10",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x90"],
        ["\x11",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x91"],
        ["\x12",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x92"],
        ["\x13",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x93"],
        ["\x3C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x94"],
        ["\x3D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x95"],
        ["\x32",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x96"],
        ["\x26",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x97"],
        ["\x18",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x98"],
        ["\x19",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x99"],
        ["\x3F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9A"],
        ["\x27",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9B"],
        ["\x1C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9C"],
        ["\x1D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9D"],
        ["\x1E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9E"],
        ["\x1F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9F"],
        ["\x40",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA0"],
        ["\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA1"],
        ["\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA2"],
        ["\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA3"],
        ["\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA4"],
        ["\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA5"],
        ["\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA6"],
        ["\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA7"],
        ["\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA8"],
        ["\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA9"],
        ["\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAA"],
        ["\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAB"],
        ["\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAC"],
        ["\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAD"],
        ["\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAE"],
        ["\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAF"],
        ["\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB0"],
        ["\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB1"],
        ["\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB2"],
        ["\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB3"],
        ["\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB4"],
        ["\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB5"],
        ["\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB6"],
        ["\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB7"],
        ["\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB8"],
        ["\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB9"],
        ["\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBA"],
        ["\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBB"],
        ["\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBC"],
        ["\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBD"],
        ["\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBE"],
        ["\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBF"],
        ["\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x80"],
        ["\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x81"],
        ["\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x82"],
        ["\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x83"],
        ["\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x84"],
        ["\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x85"],
        ["\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x86"],
        ["\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x87"],
        ["\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x88"],
        ["\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x89"],
        ["\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8A"],
        ["\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8B"],
        ["\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8C"],
        ["\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8D"],
        ["\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8E"],
        ["\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8F"],
        ["\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x90"],
        ["\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x91"],
        ["\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x92"],
        ["\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x93"],
        ["\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x94"],
        ["\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x95"],
        ["\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x96"],
        ["\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x97"],
        ["\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x98"],
        ["\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x99"],
        ["\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9A"],
        ["\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9B"],
        ["\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9C"],
        ["\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9D"],
        ["\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9E"],
        ["\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9F"],
        ["\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA0"],
        ["\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA1"],
        ["\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA2"],
        ["\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA3"],
        ["\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA4"],
        ["\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA5"],
        ["\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA6"],
        ["\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA7"],
        ["\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA8"],
        ["\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA9"],
        ["\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAA"],
        ["\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAB"],
        ["\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAC"],
        ["\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAD"],
        ["\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAE"],
        ["\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAF"],
        ["\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB0"],
        ["\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB1"],
        ["\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB2"],
        ["\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB3"],
        ["\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB4"],
        ["\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB5"],
        ["\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB6"],
        ["\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB7"],
        ["\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB8"],
        ["\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB9"],
        ["\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBA"],
        ["\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBB"],
        ["\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBC"],
        ["\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBD"],
        ["\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBE"],
        ["\x07",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBF"],
        ["\x20",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x80"],
        ["\x21",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x81"],
        ["\x22",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x82"],
        ["\x23",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x83"],
        ["\x24",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x84"],
        ["\x25",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x85"],
        ["\x06",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x86"],
        ["\x17",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x87"],
        ["\x28",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x88"],
        ["\x29",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x89"],
        ["\x2A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8A"],
        ["\x2B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8B"],
        ["\x2C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8C"],
        ["\x09",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8D"],
        ["\x0A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8E"],
        ["\x1B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8F"],
        ["\x30",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x90"],
        ["\x31",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x91"],
        ["\x1A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x92"],
        ["\x33",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x93"],
        ["\x34",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x94"],
        ["\x35",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x95"],
        ["\x36",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x96"],
        ["\x08",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x97"],
        ["\x38",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x98"],
        ["\x39",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x99"],
        ["\x3A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9A"],
        ["\x3B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9B"],
        ["\x04",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9C"],
        ["\x14",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9D"],
        ["\x3E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9E"],
        ["\xE1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9F"],
        ["\xB1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA0"],
        ["\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA1"],
        ["\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA2"],
        ["\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA3"],
        ["\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA4"],
        ["\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA5"],
        ["\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA6"],
        ["\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA7"],
        ["\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA8"],
        ["\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA9"],
        ["\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAA"],
        ["\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAB"],
        ["\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAC"],
        ["\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAD"],
        ["\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAE"],
        ["\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAF"],
        ["\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB0"],
        ["\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB1"],
        ["\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB2"],
        ["\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB3"],
        ["\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB4"],
        ["\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB5"],
        ["\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB6"],
        ["\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB7"],
        ["\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB8"],
        ["\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB9"],
        ["\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBA"],
        ["\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBB"],
        ["\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBC"],
        ["\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBD"],
        ["\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBE"],
        ["\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBF"],
        ["\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x80"],
        ["\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x81"],
        ["\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x82"],
        ["\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x83"],
        ["\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x84"],
        ["\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x85"],
        ["\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x86"],
        ["\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x87"],
        ["\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x88"],
        ["\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x89"],
        ["\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8A"],
        ["\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8B"],
        ["\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8C"],
        ["\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8D"],
        ["\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8E"],
        ["\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8F"],
        ["\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x90"],
        ["\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x91"],
        ["\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x92"],
        ["\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x93"],
        ["\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x94"],
        ["\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x95"],
        ["\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x96"],
        ["\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x97"],
        ["\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x98"],
        ["\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x99"],
        ["\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9A"],
        ["\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9B"],
        ["\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9C"],
        ["\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9D"],
        ["\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9E"],
        ["\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9F"],
        ["\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA0"],
        ["\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA1"],
        ["\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA2"],
        ["\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA3"],
        ["\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA4"],
        ["\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA5"],
        ["\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA6"],
        ["\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA7"],
        ["\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA8"],
        ["\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA9"],
        ["\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAA"],
        ["\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAB"],
        ["\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAC"],
        ["\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAD"],
        ["\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAE"],
        ["\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAF"],
        ["\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB0"],
        ["\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB1"],
        ["\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB2"],
        ["\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB3"],
        ["\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB4"],
        ["\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB5"],
        ["\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB6"],
        ["\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB7"],
        ["\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB8"],
        ["\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB9"],
        ["\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBA"],
        ["\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBB"],
        ["\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBC"],
        ["\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBD"],
        ["\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBE"],
        ["\xFF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBF"],
        ["\x4F\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\x4F\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\x4F\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\x4F\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\x4F\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\x4F\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\x4F\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\x4F\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\x4F\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\x4F\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\x4F\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\x4F\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\x4F\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\x4F\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\x4F\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\x4F\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\x4F\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\x4F\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\x4F\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\x4F\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\x4F\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\x4F\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\x4F\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\x4F\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\x4F\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\x4F\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\x4F\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\x4F\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\x4F\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\x4F\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\x4F\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\x4F\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],
        ["\x4F\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\x4F\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],
        ["\x4F\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\x4F\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\x4F\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\x4F\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\x4F\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\x4F\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\x4F\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\x4F\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\x4F\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\x4F\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\x4F\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\x4F\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\x4F\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\x4F\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\x4F\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\x4F\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\x4F\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\x4F\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\x4F\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\x4F\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\x4F\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\x4F\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\x4F\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\x4F\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\x4F\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\x4F\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\x4F\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],
        ["\x4F\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\x4F\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\x4F\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\x4F\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\x4F\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\x4F\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\x4F\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\x4F\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\x4F\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\x4F\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\x4F\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\x4F\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\x4F\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\x4F\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\x4F\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\x4F\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\x4F\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\x4F\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\x4F\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\x4F\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],
        ["\x4F\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],
        ["\x4F\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\x4F\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\x4F\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\x4F\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\x4F\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\x4F\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\x4F\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\x4F\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\x4F\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\x4F\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\x4F\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\x4F\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\x7F\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\x7F\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\x7F\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\x7F\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\x7F\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\x7F\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\x7F\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\x7F\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\x7F\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\x7F\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\x7F\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\x7F\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\x7F\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\x7F\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\x45\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\x45\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\x46\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\x46\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\x45\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\x45\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\x60\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\x60\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\x45\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\x45\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\x46\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\x46\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\x45\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\x45\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\x60\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\x60\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\x46\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\x45\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\x46\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\x60\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\x60\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\x45\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\x45\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\x60\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\x45\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\x45\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\x60\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\x60\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\x46\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\x44\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\x44\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\x46\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\x46\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\x46\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\x45\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\x45\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\x45\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\x46\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\x7B\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\x7B\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\x7B\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\x7B\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\x7B\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\x7B\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\x7B\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\x7B\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\x7B\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\x7B\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\x7B\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\x7B\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\x7B\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\x7B\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\x7B\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\x7B\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\x7B\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\x7B\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\x7B\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\x7B\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\x7B\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\x7B\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\x7B\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\x7B\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\x7B\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\x7B\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\x7B\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\x7B\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\x7B\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\x7B\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\x7B\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\x7B\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\x7B\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\x7B\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\x7B\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\x7B\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\x7B\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\x7B\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\x7B\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\x7B\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\x7B\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\x7B\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\x7B\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\x7B\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\x7B\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\x7B\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\x7B\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\x7B\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\x7B\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\x7B\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\x7B\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\x7B\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\x7B\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\x7B\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\x7B\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\x7B\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\x7B\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\x7B\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\x7B\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\x7B\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\x7B\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\x7B\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\xE0\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\xE0\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\xE0\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\xE0\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\xE0\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\xE0\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\xE0\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\xE0\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\xE0\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\xE0\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\xE0\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\xE0\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\xE0\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\xE0\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\xE0\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\xE0\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\xE0\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\xE0\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\xE0\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\xE0\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\xE0\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\xE0\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\xE0\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\xE0\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\xE0\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\xE0\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\xE0\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\xE0\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\xE0\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\xE0\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\xE0\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\xE0\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\xE0\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\xE0\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\xE0\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\xE0\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\xE0\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\xE0\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\xE0\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\xE0\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\xE0\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\xE0\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\xE0\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\xE0\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\xE0\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\xE0\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\xE0\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\xE0\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\xE0\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\xE0\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\xE0\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\xE0\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\xE0\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\xE0\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\xE0\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\xE0\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\xE0\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\xE0\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\xE0\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\xE0\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\xE0\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\xE0\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\xE0\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\xE0\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\xE0\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\xE0\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\xE0\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\xE0\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\xE0\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\xE0\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\xE0\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\xE0\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\xE0\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\xE0\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\xE0\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\xE0\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\xE0\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\xE0\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\xE0\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\xE0\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\xE0\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\xE0\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\xE0\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\x6C\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\x6C\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\x6C\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\x6C\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\x6C\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\x6C\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\x6C\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\x6C\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\x6C\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\x6C\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\x6C\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\x6C\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\x6C\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\x6C\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\x6C\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\x6C\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\x6C\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\x6C\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\x6C\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\x6C\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\x6C\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\x6C\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\x6C\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\x6C\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\x6C\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\x6C\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\x6C\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\x6C\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\x6C\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\x6C\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\x6C\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\x6C\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\x6C\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\x6C\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\x6C\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\x6C\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\x6C\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\x6C\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\x6C\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\x6C\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\x6C\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\x6C\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\x6C\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\x6C\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\x6C\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\x6C\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\x6C\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\x6C\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\x6C\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\x6C\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\x6C\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\x6C\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\x6C\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\x6C\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\x6C\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\x6C\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\x6C\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\x6C\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\x6C\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\x6C\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\x6C\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\x6C\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\x6C\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\x6C\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\x6C\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\x6C\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\x6C\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\x6C\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\x6C\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\x6C\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\x6C\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\x6C\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\x6C\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\x6C\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\x6C\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\x6C\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\x6C\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\x6C\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\x6C\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\x6C\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\x6C\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\x6C\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\x6C\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\x6C\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\x6C\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\x6C\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\x50\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\x50\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\x50\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\x50\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\x50\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\x50\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\x50\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\x50\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\x50\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\x50\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\x50\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\x50\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\x50\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\x50\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\x50\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\x50\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\x50\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\x50\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\x50\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\x50\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\x50\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\x50\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\x50\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\x50\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\x50\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\x50\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\x50\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\x50\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\x50\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\x50\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\x50\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\x50\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\x50\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\x50\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\x50\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\x50\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\x50\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\x50\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\x50\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\x50\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\x50\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\x50\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\x50\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\x50\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\x50\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\x50\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\x50\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\x50\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\x7D\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\x7D\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\x7D\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\x7D\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\x7D\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\x7D\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\x7D\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\x7D\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\x7D\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\x7D\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\x7D\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\x7D\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\x7D\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\x7D\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\x7D\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\x7D\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\x7D\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\x7D\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\x7D\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\x7D\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\x7D\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\x7D\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\x7D\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\x7D\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\x7D\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\x7D\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\x7D\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\x7D\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\x7D\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\x7D\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\x7D\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\x7D\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\x7D\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\x7D\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\x7D\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\x7D\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\x7D\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\x7D\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\x7D\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\x7D\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\x7D\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\x7D\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\x7D\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\x7D\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\x7D\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\x7D\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\x7D\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\x7D\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\x7D\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\x7D\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\x7D\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\x7D\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\x7D\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\x7D\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\x7D\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\x7D\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\x7D\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\x7D\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\x7D\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\x7D\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\x7D\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\x7D\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\x7D\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\x7D\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\x7D\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\x7D\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\x60\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],
        ["\x60\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],
        ["\x60\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],
        ["\x60\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],
        ["\x60\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],
        ["\x60\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],
        ["\x60\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],
        ["\x60\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],
        ["\x60\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],
        ["\x60\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],
        ["\x60\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],
        ["\x60\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],
        ["\x60\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],
        ["\x60\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],
        ["\x60\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],
        ["\x60\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],
        ["\x60\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],
        ["\x60\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],
        ["\x60\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],
        ["\x60\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],
        ["\x60\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],
        ["\x60\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],
        ["\x60\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],
        ["\x60\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],
        ["\x60\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],
        ["\x60\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],
        ["\x60\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],
        ["\x60\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],
        ["\x60\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],
        ["\x60\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],
        ["\x60\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],
        ["\x60\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],
        ["\x60\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],
        ["\x60\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],
        ["\x60\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],
        ["\x60\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],
        ["\x60\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],
        ["\x60\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],
        ["\x60\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],
        ["\x60\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],
        ["\x60\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],
        ["\x60\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],
        ["\x60\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],
        ["\x60\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],
        ["\x60\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],
        ["\x60\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],
        ["\x60\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],
        ["\x60\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],
        ["\x60\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],
        ["\x60\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],
        ["\x60\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],
        ["\x60\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],
        ["\x60\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],
        ["\x60\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],
        ["\x60\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],
        ["\x60\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],
        ["\x60\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\x60\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],
        ["\x60\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],
        ["\x60\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],
        ["\x60\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],
        ["\x60\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],
        ["\x60\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],
        ["\x60\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],
        ["\x60\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],
        ["\x60\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],
        ["\x60\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],
        ["\x60\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],
        ["\x60\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],
        ["\x60\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],
        ["\x60\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],
        ["\x60\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],
        ["\x60\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],
        ["\xF0\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\xF0\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\xF0\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\xF0\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\xF0\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\xF0\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\xF0\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\xF0\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\xF0\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\xF0\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\xF0\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\xF0\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\xF0\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\xF0\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\xF0\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\xF0\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\xF0\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\xF0\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\x77\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\xF0\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\xF0\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\xF0\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\xF0\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\xF0\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\xF0\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\xF0\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\xF0\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\xF0\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\xF0\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\xF0\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\xF0\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\xF0\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\xF0\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\xF0\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\xF0\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\xF0\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\xF0\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\xF0\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\xF0\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\xF0\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\xF0\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\xF0\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\xF0\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\xF0\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\xF0\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\xF0\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\xF0\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\xF0\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\xF0\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\xF0\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\xF0\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\xF0\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\xF0\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\xF0\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\xF0\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\xF0\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\xF0\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\xF0\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\xF0\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\xF0\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\xF0\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\xF0\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\xF0\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\xF0\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\xF0\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\xF0\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\xF0\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\xF0\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\xF0\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\xF0\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\xF0\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\xF0\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\xF0\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\xF0\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\xF0\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\xF0\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\xF0\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\xF0\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\xF0\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\xF0\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\xF0\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\xF0\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\xF0\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\xF0\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\xF0\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\xF0\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\xF0\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\xF0\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\xF0\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\xF0\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\xF0\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\xF0\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\xF0\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\xF0\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\xF1\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\xF1\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\xF1\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\xF1\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\xF1\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\xF1\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\xF1\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\xF1\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\xF1\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\xF1\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\xF1\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\xF1\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\xF1\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\xF1\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\xF1\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\xF1\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\xF1\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\xF1\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\xF1\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\xF1\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\xF1\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\xF1\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\xF1\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\xF1\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\xF1\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\xF1\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\xF1\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\xF1\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\xF1\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\xF1\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\xF1\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\xF1\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\xF1\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\xF1\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\xF1\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\xF1\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\xF1\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\xF1\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\xF1\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\xF1\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\xF1\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\xF1\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\xF1\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\xF1\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\xF1\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\xF1\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\xF1\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\xF1\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\xF1\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\xF1\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\xF1\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\xF1\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\xF1\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\xF1\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\xF1\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\xF1\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\xF1\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\xF1\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\xF1\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\xF1\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\xF1\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\xF1\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\xF1\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\xF1\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\xF1\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\xF1\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\xF1\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\xF1\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\xF1\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\xF1\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\xF1\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\xF1\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\xF1\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\xF1\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\xF1\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\xF1\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\xF1\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\xF1\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\xF1\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\xF1\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\xF1\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\xF1\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\xF1\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\xF1\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\xF1\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\xF1\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\xF1\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\xF1\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\xF1\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\xF1\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\xF1\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\xF1\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\xF1\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\xF1\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\xF2\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\xF2\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\xF2\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\xF2\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\xF2\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\xF2\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\xF2\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\xF2\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\x77\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\xF2\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\xF2\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\xF2\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\xF2\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\xF2\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\xF2\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\xF2\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\xF2\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\xF2\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\xF2\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\xF2\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\xF2\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\xF2\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\xF2\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\xF2\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\xF2\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\xF2\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\xF2\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\xF2\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\xF2\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\xF2\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\xF2\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\xF2\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\xF2\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\xF2\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\xF2\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\xF2\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\xF2\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\xF2\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\xF2\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\xF2\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\xF2\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\xF2\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\xF2\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\xF2\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\xF2\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\xF2\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\xF2\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\xF2\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\xF2\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\xF2\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\xF2\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\xF2\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\xF2\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\xF2\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\xF2\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\xF2\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\xF2\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\xF2\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\xF2\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\xF2\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\xF2\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\xF2\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\xF2\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\xF2\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\xF2\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\xF2\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\xF2\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\xF2\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\xF2\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\xF2\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\xF2\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\xF2\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\xF2\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\xF2\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\xF2\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\xF2\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\xF2\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\xF2\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\xF2\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\xF2\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\xF2\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\xF2\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\xF2\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\xF2\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\xF2\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\xF2\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\xF2\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\xF2\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\xF2\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\xF2\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\xF2\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\xF2\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\xF2\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\xF2\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\xF3\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\xF3\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\xF3\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\xF3\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\xF3\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\xF3\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\xF3\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\xF3\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\xF3\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\xF3\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\xF3\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\xF3\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\xF3\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\xF3\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\xF3\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\xF3\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\xF3\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\xF3\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\xF3\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\xF3\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\xF3\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\xF3\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\xF3\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\xF3\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\xF3\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\xF3\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\xF3\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\xF3\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\xF3\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\xF3\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\xF3\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\xF3\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\xF3\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\x68\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\xF3\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\xF3\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\xF3\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\xF3\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\xF3\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\xF3\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\xE8\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\xF3\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\xF3\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\xF3\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\xF3\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\xF3\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\xF3\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\xF3\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\xF3\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\xF3\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\xF3\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\xF3\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\xF3\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\xF3\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\xF3\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\xF3\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\xF3\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\xF3\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\xF3\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\xF3\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\xF3\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\xF3\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\xF3\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\xF3\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\xF3\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\xF3\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\xF3\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\xF3\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\xF3\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\xF3\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\xF3\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\xF3\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\xF3\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\xF3\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\xF3\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\xF3\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\xF3\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\xF3\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\xF3\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\xF3\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\xF3\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\xF3\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\xF3\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\xF3\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\xF3\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\x62\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\xF3\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\xF3\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\xF3\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\xF3\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\xF3\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\xF3\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\xF3\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\xF3\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\xF4\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\xF4\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\xF4\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\xF4\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\xF4\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\xF4\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\xF4\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\xF4\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\xF4\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\xF4\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\xF4\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\xF4\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\xF4\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\xF4\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\xF4\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\xF4\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\xF4\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\xF4\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\xF4\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\xF4\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\xF4\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\xF4\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\xF4\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\xF4\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\xF4\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\xF4\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\xF4\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\xF4\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\xF4\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\xF4\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\xF4\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\xF4\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\xF4\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\xF4\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\x5F\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\xF4\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\xF4\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\xF4\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\xF4\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\xF4\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\xF4\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\xF4\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\xF4\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\xF4\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\xF4\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\xF4\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\xF4\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\xF4\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\xF4\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\x70\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\xF4\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\xF4\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\xF4\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\xF4\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\xF4\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\xF4\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\xF4\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\xF4\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\xF4\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\xF4\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\xF4\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\xF4\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\xF4\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\xF4\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\xF4\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\xF4\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\xF4\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\xF4\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\xF4\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\xF4\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\xF4\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\xF4\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\xF4\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\xF4\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\xF4\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\xF4\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\xF4\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\xF4\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\xF4\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\xF4\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\xF4\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\xF4\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\xF4\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\xF4\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\xF4\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\xF4\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\xF4\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\xF4\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\xF4\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\xF4\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\xF4\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\xF4\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\xF4\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\xF4\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\xF5\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\xF5\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\xF5\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\xF5\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\xF5\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\xF5\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\xF5\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\xF5\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\xF5\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\xF5\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\xF5\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\xF5\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\xF5\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\xF5\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\xF5\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\xF5\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\xF5\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\xF5\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\xF5\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\xF5\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\xF5\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\xF5\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\xF5\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\xF5\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\xF5\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\xF5\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\xF5\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\xF5\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\xF5\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\xF5\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\xF5\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\xF5\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\xF5\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\xF5\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\xF5\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\xF5\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\xF5\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\xF5\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\xF5\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\xF5\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\xF5\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\xF5\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\xF5\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\xF5\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\xF5\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\xF5\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\xF5\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\xF5\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\xF5\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\xF5\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\xF5\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\xF5\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\xF5\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\xF5\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\xF5\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\xF5\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\xF5\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\xF5\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\xF5\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\xF5\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\xF5\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\xF5\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\xF5\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\xF5\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\xF5\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\xF5\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\xF5\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\xF5\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\xF5\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\xF5\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\xF5\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\xF5\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\xF5\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\xF5\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\xF5\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\xF5\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\xF5\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\xF5\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\xF5\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\xF5\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\xF5\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\xF5\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\xF5\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\xF5\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\xF5\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\xF5\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\xF5\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\xF5\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\xF5\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\xF5\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\xF5\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\xF5\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\xF5\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\xF5\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\xF6\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\xF6\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\xF6\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\xF6\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\xF6\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\xF6\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\xF6\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\xF6\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\xF6\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\xF6\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\xF6\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\xF6\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\xF6\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\xF6\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\xF6\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\xF6\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\xF6\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\xF6\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\xF6\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\xF6\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\xF6\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\xF6\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\xF6\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\xF6\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\xF6\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\xF6\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\xF6\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\xF6\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\xF6\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\xF6\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\xF6\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\xF6\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\xF6\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\xF6\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\xF6\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\xF6\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\xF6\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\x86\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\xF6\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\xF6\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\xF6\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\xF6\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\xF6\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\xF6\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\xF6\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\xF6\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\xF6\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\xF6\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\xF6\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\xF6\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\xF6\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\xF6\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\xF6\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\xF6\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\xF6\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\xF6\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\xF6\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\xF6\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\xF6\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\xF6\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\xF6\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\xF6\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\xF6\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\xF6\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\xF6\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\xF6\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\xF6\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\xF6\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\xF6\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\xF6\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\xF6\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\xF6\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\xF6\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\xF6\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\xF6\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\xF6\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\xF6\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\xF6\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\xF6\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\xF6\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\xF6\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\xF6\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\xF6\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\xF6\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\xF6\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\xF6\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\xF6\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\xF6\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\xF6\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\xF6\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\xF6\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\xF6\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\xF6\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\xF6\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\xF7\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\xF7\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\xF7\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\xF7\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\xF7\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\xF7\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\xF7\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\xF7\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\xF7\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\xF7\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\xF7\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\xF7\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\xF7\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\xF7\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\xF7\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\xF7\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\xF7\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\xF7\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\xF7\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\xF7\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\xF7\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\xF7\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\xF7\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\xF7\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\xF7\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\xF7\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\xF7\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\xF7\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\xF7\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\xF7\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\xF7\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\xF7\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\xF7\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\xF7\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\xF7\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\xF7\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\xF7\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\xF7\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\xF7\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\xF7\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\xF7\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\xF7\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\xF7\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\xF7\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\xF7\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\xF7\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\xF7\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\xF7\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\xF7\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\xF7\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\xF7\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\xF7\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\xF7\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\xF7\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\xF7\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\xF7\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\xF7\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\xF7\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\x75\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\xF7\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\xF7\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\xF7\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\xF7\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\xF7\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\xF7\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\xF7\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\xF7\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\xF7\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\xF7\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\xF7\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\xF7\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\xF7\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\xF7\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\xF7\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\xF7\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\xF7\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\xF7\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\xF7\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\xF7\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\xF7\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\xF7\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\xF7\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\xF7\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\xF7\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\xF7\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\xF7\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\xF7\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\xF7\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\xF7\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\xF7\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\xF7\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\xF7\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\xF7\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\xF7\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\xF8\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\xF8\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\xF8\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\xF8\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\xF8\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\xF8\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\xF8\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\xF8\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\xF8\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\xF8\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\xF8\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\xF8\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\xF8\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\xF8\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\xF8\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\xF8\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\xF8\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\xF8\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\xF8\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\xF8\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\xF8\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\xF8\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\xF8\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\xF8\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\xF8\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\xF8\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\xF8\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\xF8\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\xF8\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\xF8\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\xF8\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\xF8\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\xF8\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\xF8\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\xF8\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\xF8\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\xF8\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\xF8\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\xF8\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\xF8\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\xF8\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\xF8\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\xF8\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\xF8\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\xF8\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\xF8\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\xF8\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\xF8\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\xF8\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\xF8\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\xF8\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\xF8\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\xF8\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\xF8\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\xF8\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\xF8\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\xF8\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\xF8\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\xF8\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\xF8\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\xF8\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\xF8\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\xF8\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\xF8\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\xF8\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\xF8\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\xF8\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\xF8\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\xF8\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\xF8\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\xF8\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\xF8\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\xF8\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\xF8\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\xF8\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\xF8\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\xF8\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\xF8\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\xF8\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\xF8\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\xF8\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\xF8\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\xF8\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\xF8\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\xF8\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\xF8\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\xF8\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\xF8\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\xF8\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\xF8\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\xF8\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\xF8\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\xF8\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\xF8\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\xF9\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\xF9\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\xF9\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\xF9\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\xF9\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\xF9\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\xF9\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\xF9\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\xF9\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\xF9\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\xF9\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\xF9\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\xF9\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\xF9\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\xF9\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\xF9\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\xF9\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\xF9\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\xF9\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\xF9\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\xF9\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\xF9\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\xF9\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\xF9\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\xF9\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\xF9\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\xF9\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\xF9\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\xF9\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\xF9\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\xF9\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\xF9\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\xF9\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\xF9\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\xF9\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\xF9\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\xF9\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\xF9\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\xF9\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\xF9\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\xF9\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\xF9\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\xF9\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\xF9\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\xF9\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\xF9\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\xF9\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\xF9\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\xF9\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\xF9\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\xF9\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\xF9\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\xF9\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\xF9\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\xF9\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\xF9\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\xF9\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\xF9\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\xF9\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\x59\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\xF9\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\xF9\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\xF9\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\xF9\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\xF9\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\xF9\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\xF9\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\xF9\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\xF9\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\xF9\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\xF9\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\xF9\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\xF9\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\xF9\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\xF9\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\xF9\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\xAC\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\xF9\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\xF9\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\xF9\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\xF9\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\xF9\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\xF9\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\xF9\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\xF9\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\xF9\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\xF9\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\xF9\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\xF9\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\xF9\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\xF9\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\xF9\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\xF9\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\xF9\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\x7A\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\x7A\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\x7A\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\x7A\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\x7A\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\x7A\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\x7A\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\x7A\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\x7A\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\x7A\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\x7A\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\x7A\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\x7A\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\x7A\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\x7A\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\x7A\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\x7A\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\x7A\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\x7A\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\x7A\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\x7A\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\x7A\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\x7A\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\x7A\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\x7A\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\x7A\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\x7A\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\x7A\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\x7A\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\x7A\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\x7A\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\x7A\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\x7A\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\x7A\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\x7A\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\x7A\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\x7A\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\x7A\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\x7A\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\x7A\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\x7A\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\x7A\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\x7A\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\x7A\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\x7A\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\x7A\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\x7A\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\x7A\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\x7A\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\x7A\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\x7A\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\x7A\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\x7A\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\x7A\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\x7A\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\x7A\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\x7A\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\x7A\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\x7A\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\x7A\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\x7A\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\x7A\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\x7A\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\x7A\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\x7A\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\x7A\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\x7A\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\x7A\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\x7A\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\x7A\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\x7A\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\x7A\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\x7A\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\x7A\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\x7A\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\x7A\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\x7A\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\x7A\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\x7A\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\x7A\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\x7A\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\x7A\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\x7A\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\x7A\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\x7A\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\x7A\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\x7A\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\x7A\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\x7A\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\x7A\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\x7A\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\x7A\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\x7A\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\x7A\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\x5E\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\x5E\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\x5E\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\x5E\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\x5E\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\x5E\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\x5E\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\x5E\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\x5E\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\x5E\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\x5E\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\x5E\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\x5E\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\x5E\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\x5E\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\x5E\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\x5E\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\x5E\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\x5E\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\x5E\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\x5E\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\x5E\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\x5E\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\x5E\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\x5E\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\x5E\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\x5E\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\x5E\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\x5E\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\x5E\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\x5E\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\x5E\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\x5E\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\x5E\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\x5E\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\x5E\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\x5E\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\x5E\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\x5E\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\x5E\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\x5E\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\x5E\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\x5E\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\x5E\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\x5E\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\x5E\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\x5E\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\x5E\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\x5E\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\x5E\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\x5E\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\x5E\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\x5E\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\x5E\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\x5E\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\x5E\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\x5E\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\x5E\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\x5E\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\x5E\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\x5E\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\x5E\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\x5E\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\x5E\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\x5E\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\x5E\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\x5E\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\x5E\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\x5E\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\x5E\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\x5E\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\x5E\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\x5E\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\x5E\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\x5E\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\x5E\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\x5E\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\x5E\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\x5E\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\x5E\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\x5E\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\x5E\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\x5E\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\x5E\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\x5E\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\x5E\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\x5E\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\x5E\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\x5E\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\x5E\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\x5E\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\x5E\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\x5E\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\x5E\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\x4C\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\x4C\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\x4C\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\x4C\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\x4C\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\x4C\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\x4C\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\x4C\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\x4C\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\x4C\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\x4C\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\x4C\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\x4C\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\x4C\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\x4C\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\x4C\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\x4C\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\x4C\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\x4C\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\x4C\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\x4C\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\x4C\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\x4C\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\x4C\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\x4C\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\x4C\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\x4C\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\x4C\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\x4C\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\x4C\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\x4C\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\x4C\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\x4C\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\x4C\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\x4C\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\x4C\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\x4C\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\x4C\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\x4C\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\x4C\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\x68\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\x4C\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\x4C\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\x4C\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\x4C\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\x4C\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\x4C\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\x4C\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\x4C\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\x4C\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\x4C\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\x4C\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\x4C\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\x4C\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\x4C\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\x4C\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\x4C\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\x4C\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\x4C\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\x4C\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\x4C\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\x4C\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\x4C\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\x4C\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\x4C\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\x4C\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\x4C\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\x4C\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\x4C\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\x4C\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\x4C\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\x4C\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\x4C\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\x4C\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\x4C\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\x4C\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\x4C\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\x4C\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\x4C\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\x4C\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\x4C\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\x4C\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\x4C\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\x4C\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\x4C\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\x4C\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\x4C\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\x4C\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\x4C\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\x4C\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\x4C\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\x4C\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\x4C\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\x4C\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\x7E\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\x7E\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\x7E\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\x7E\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\x7E\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\x7E\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\x7E\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\x7E\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\x7E\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\x7E\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\x7E\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\x7E\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\x7E\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\x7E\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\x7E\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\x7E\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\x7E\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\x7E\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\x7E\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\x7E\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\x7E\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\x7E\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\x7E\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\x7E\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\x7E\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\x7E\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\x7E\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\x7E\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\x7E\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\x7E\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\x7E\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\x7E\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\x7E\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\x7E\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\x7E\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\x7E\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\x7E\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\x7E\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\x7E\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\x7E\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\x7E\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\x7E\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\x7E\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\x7E\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\x7E\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\x7E\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\x7E\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\x7E\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\x7E\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\x7E\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\x7E\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\x7E\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\x7E\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\x7E\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\x7E\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\x7E\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\x7E\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\x7E\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\x7E\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\x7E\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\x7E\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\x7E\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\x7E\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\x7E\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\x7E\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\x7E\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\x7E\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\x7E\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\x7E\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\x7E\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\x7E\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\x7E\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\x7E\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\x7E\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\x7E\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\x7E\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\x7E\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\x7E\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\x7E\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\x7E\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\x7E\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\x7E\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\x7E\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\x7E\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\x7E\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\x7E\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\x7E\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\x7E\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\x7E\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\x7E\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\x7E\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\x7E\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\x7E\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\x7E\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\x6E\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\x6E\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\x6E\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\x6E\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\x6E\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\x6E\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\x6E\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\x6E\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\x6E\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\x6E\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\x6E\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\x6E\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\x6E\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\x6E\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\x6E\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\x6E\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\x6E\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\x6E\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\x6E\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\x6E\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\x6E\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\x6E\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\x6E\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\x6E\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\x6E\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\x6E\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\x6E\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\x6E\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\x6E\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\x6E\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\x6E\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\x6E\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\x6E\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\x6E\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\x6E\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\x6E\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\x6E\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\x6E\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\x6E\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\x6E\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\x6E\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\x6E\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\x6E\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\x6E\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\x6E\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\x6E\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\x6E\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\x6E\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\x6E\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\x6E\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\x6E\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\x6E\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\x6E\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\x6E\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\x6E\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\x6E\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\x6E\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\x6E\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\x6E\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\x6E\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\x6E\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\x6E\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\x6E\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\x6E\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\x6E\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\x6E\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\x6E\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\x6E\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\x6E\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\x6E\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\x6E\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\x6E\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\x6E\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\x6E\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\x6E\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\x6E\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\x6E\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\x6E\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\x6E\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\x6E\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\x6E\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\x6E\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\x6E\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\x6E\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\x6E\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\x6E\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\x6E\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\x6E\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\x6E\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\x6E\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\x6E\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\x6E\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\x6E\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\x6E\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\x6F\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\x6F\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\x6F\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\x6F\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\x6F\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\x6F\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\x6F\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\x6F\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\x6F\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\x6F\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\x6F\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\x6F\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\x6F\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\x6F\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\x6F\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\x6F\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\x6F\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\x6F\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\x6F\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\x6F\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\x6F\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\x6F\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\x6F\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\x6F\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\x6F\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\x6F\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\x6F\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\x6F\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\x6F\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\x6F\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\x6F\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\x6F\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\x6F\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\x6F\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\x6F\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\x6F\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\x6F\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\x6F\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\x6F\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\x6F\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\x6F\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\x6F\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\x6F\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\x6F\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\x6F\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\x6F\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\x6F\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\x6F\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\x6F\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\x6F\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\x6F\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\x6F\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\x6F\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\x6F\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\x6F\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\x6F\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\x75\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\x6F\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\x6F\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\x6F\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\x6F\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\x6F\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\x6F\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\x6F\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\x6F\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\x6F\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\x6F\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\x6F\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\x6F\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\x6F\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\x6F\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\x6F\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\x6F\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\x6F\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\x6F\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\x6F\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\x6F\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\x6F\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\x6F\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\x6F\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\x6F\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\x6F\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\x6F\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\x6F\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\x6F\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\x6F\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\x6F\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\x6F\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\x6F\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\x6F\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\x6F\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\x6F\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\x6F\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\x6F\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\x7C\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\x7C\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\x7C\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\x7C\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\x7C\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\x7C\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\x7C\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\x7C\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\x7C\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\x7C\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\x7C\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\x7C\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\x7C\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\x7C\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\x7C\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\x7C\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\x7C\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\x7C\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\x7C\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\x7C\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\x7C\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\x7C\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\x7C\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\x7C\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\x7C\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\x7C\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\x7C\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\x7C\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\x7C\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\x7C\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\x7C\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\x7C\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\x7C\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\x7C\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\x7C\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\x7C\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\x7C\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\x7C\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\x7C\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\x7C\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\x7C\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\x7C\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\x7C\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\x7C\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\x7C\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\x7C\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\x7C\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\x7C\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\x7C\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\x7C\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\x7C\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\x7C\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\x7C\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\x7C\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\x7C\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\x7C\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\x7C\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\x7C\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\x7C\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\x7C\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\x7C\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\x7C\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\x7C\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\x7C\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\x7C\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\x7C\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\x7C\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\x7C\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\x7C\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\x7C\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\x7C\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\x7C\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\x7C\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\x7C\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\x7C\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\x7C\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\x7C\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\x7C\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\x7C\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\x7C\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\x7C\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\x7C\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\x7C\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\x7C\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\x7C\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\x7C\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\x7C\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\x7C\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\x7C\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\x7C\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\x7C\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\x7C\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\x7C\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\x7C\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\xC1\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\xC1\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\xC1\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\xC1\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\xC1\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\xC1\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\xC1\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\x71\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\xC1\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\xC1\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\xC1\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\xC1\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\xC1\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\xC1\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\xC1\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\xC1\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\xC1\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\xC1\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\xC1\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\xC1\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\xC1\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\xC1\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\xC1\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\xC1\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\xC1\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\xC1\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\xC1\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\xC1\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\xC1\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\xC1\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\xC1\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\xC1\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\xC1\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\xC1\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\xC1\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\xC1\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\xC1\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\xC1\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\xC1\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\xC1\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\xC1\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\xC1\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\xC1\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\xC1\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\xC1\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\xC1\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\xC1\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\xC1\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\xC1\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\xC1\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\xC1\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\xC1\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\xC1\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\xC1\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\xC1\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\xC1\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\xC1\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\xC1\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\xC1\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\xC1\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\xC1\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\xC1\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\xC1\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\xC1\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\xC1\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\xC1\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\xC1\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\xC1\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\xC1\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\xC1\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\xC1\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\xC1\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\xC1\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\xC1\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\xC1\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\xC1\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\xC1\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\xC1\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\xC1\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\xC1\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\xC1\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\xC1\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\xC1\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\xC1\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\xC1\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\xC1\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\xC1\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\xC1\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\xC1\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\xC1\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\xC1\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\xC1\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\xC1\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\xC1\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\xC2\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\xC2\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\xC2\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\xC2\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\xC2\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\xC2\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\xC2\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\xC2\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\xC2\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\xC2\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\xC2\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\xC2\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\xC2\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\xC2\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\xC2\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\xC2\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\xC2\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\xC2\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\xC2\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\xC2\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\xC2\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\xC2\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\xC2\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\xC2\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\xC2\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\xC2\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\xC2\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\xC2\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\xC2\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\xC2\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\xC2\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\xC2\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\xC2\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\xC2\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\xC2\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\xC2\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\xC2\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\xC2\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\xC2\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\xC2\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\xC2\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\xC2\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\xC2\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\xC2\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\xC2\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\xC2\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\xC2\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\xC2\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\xC2\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\xC2\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\xC2\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\xC2\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\xC2\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\xC2\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\xC2\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\xC2\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\xC2\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\xC2\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\xC2\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\xC2\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\xC2\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\xC2\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\xC2\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\xC2\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\xC2\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\xC2\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\xC2\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\xC2\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\xC2\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\xC2\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\xC2\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\xC2\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\xC2\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\xC2\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\xC2\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\xC2\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\xC2\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\xC2\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\xC2\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\xC2\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\xC2\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\xC2\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\xC2\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\xC2\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\xC2\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\xC2\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\xC2\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\xC2\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\xC2\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\xC2\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\xC2\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\xC2\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\xC2\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\xC2\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\xC3\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\xC3\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\xC3\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\xC3\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\xC3\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\xC3\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\xC3\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\xC3\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\xC3\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\xC3\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\xC3\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\xC3\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\xC3\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\xC3\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\xC3\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\xC3\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\xC3\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\xC3\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\xC3\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\xC3\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\xC3\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\xC3\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\xC3\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\xC3\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\xC3\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\xC3\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\xC3\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\xC3\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\xC3\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\xC3\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\xC3\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\xC3\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\xC3\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\xC3\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\xC3\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\xC3\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\xC3\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\xC3\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\xC3\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\xC3\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\xC3\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\xC3\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\xC3\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\xC3\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\xC3\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\xC3\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\xC3\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\xC3\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\xC3\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\xC3\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\xC3\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\xC3\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\xC3\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\xC3\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\xC3\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\xC3\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\xC3\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\xC3\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\xC3\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\xC3\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\xC3\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\xC3\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\xC3\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\xC3\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\xC3\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\xC3\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\xC3\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\xC3\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\xC3\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\xC3\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\xC3\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\xC3\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\xC3\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\xC3\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\xC3\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\xC3\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\xC3\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\xC3\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\xC3\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\xC3\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\xC3\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\xC3\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\xC3\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\xC3\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\xC3\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\xC3\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\xC3\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\xC3\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\xC3\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\xC3\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\xC3\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\xC3\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\xC3\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\xC3\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\xC4\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\xC4\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\xC4\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\xC4\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\xC4\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\xC4\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\xC4\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\xC4\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\xC4\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\xC4\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\xC4\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\xC4\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\xC4\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\xC4\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\xC4\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\xC4\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\xC4\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\xC4\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\xC4\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\xC4\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\xC4\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\xC4\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\xC4\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\xC4\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\xC4\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\xC4\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\xC4\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\xC4\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\xC4\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\xC4\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\xC4\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\xC4\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\xC4\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\xC4\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\xC4\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\xC4\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\xC4\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\xC4\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\xC4\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\xC4\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\xC4\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\xC4\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\xC4\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\xC4\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\xC4\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\xC4\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\xC4\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\xC4\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\xC4\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\xC4\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\xC4\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\xC4\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\xC4\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\xC4\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\xC4\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\xC4\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\xC4\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\xC4\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\xE3\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\xC4\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\xC4\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\xC4\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\xC4\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\xC4\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\xC4\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\xC4\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\xC4\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\xC4\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\xC4\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\xC4\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\xC4\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\xC4\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\xC4\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\xC4\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\xC4\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\xC4\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\xC4\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\xC4\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\xC4\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\xC4\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\xC4\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\xC4\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\xC4\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\xC4\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\xC4\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\xC4\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\xC4\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\xC4\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\xC4\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\xC4\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\xC4\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\xC4\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\xC4\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\xC4\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\xC5\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\xC5\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\xC5\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\xC5\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\xC5\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\xC5\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\xC5\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\xC5\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\xC5\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\xC5\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\xC5\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\xC5\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\xC5\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\xC5\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\xC5\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\xC5\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\xC5\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\xC5\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\xC5\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\xC5\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\xC5\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\xAC\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\xC5\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\xC5\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\xC5\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\xC5\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\xC5\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\xC5\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\xC5\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\xC5\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\xA9\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\xC5\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\xC5\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\xC5\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\xC5\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\xC5\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\xC5\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\xC5\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\xC5\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\xC5\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\xC5\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\xC5\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\xC5\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\xC5\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\xC5\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\xC5\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\xC5\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\xC5\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\xC5\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\xC5\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\xC5\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\xC5\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\xC5\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\xC5\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\x59\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\xC5\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\xC5\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\xC5\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\xC5\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\xC5\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\xC5\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\xC5\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\xC5\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\xC5\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\xC5\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\xC5\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\xC5\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\xC5\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\xC5\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\xC5\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\xC5\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\xC5\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\xC5\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\xC5\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\xC5\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\xC5\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\xC5\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\x4A\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\xC5\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\xC5\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\xC5\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\xC5\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\x5F\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\xC5\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\xC5\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\xC5\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\xC5\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\xC5\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\xC5\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\xC5\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\xC5\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\xC5\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\xC5\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\xC5\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\xC6\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\xC6\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\xC6\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\xC6\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\xC6\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\xC6\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\xC6\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\xC6\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\xC6\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\xC6\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\xC6\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\xC6\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\xC6\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\xC6\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\xC6\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\xC6\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\xC6\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\xC6\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\xC6\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\xC6\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\xC6\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\xC6\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\xC6\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\xC6\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\xC6\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\xC6\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\xC6\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\xC6\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\xC6\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\xC6\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\xC6\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\xC6\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\xC6\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\xC6\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\xC6\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\xC6\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\xC6\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\xC6\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\xC6\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\xC6\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\xC6\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\xC6\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\xC6\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\xC6\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\xC6\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\xC6\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\xC6\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\xC6\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\xC6\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\xC6\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\xC6\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\xC6\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\xC6\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\xC6\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\xC6\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\xC6\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\xC6\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\xC6\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\xC6\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\xC6\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\xC6\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\xC6\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\xC6\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\xC6\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\xC6\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\xC6\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\xC6\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\xC6\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\xC6\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\xC6\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\xC6\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\xC6\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\xC6\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\xC6\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\xC6\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\xC6\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\xC6\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\xC6\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\xC6\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\xC6\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\xC6\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\xC6\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\xC6\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\xC6\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\xC6\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\x72\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\xC6\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\xC6\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\xC6\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\xC6\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\xC6\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\xC6\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\xC6\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\xC6\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\xC7\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\xC7\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\xC7\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\xC7\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\xC7\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\xC7\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\xC7\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\xC7\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\xC7\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\xC7\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\xC7\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\xC7\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\xC7\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\xC7\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\xC7\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\xC7\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\xC7\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\xC7\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\xC7\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\xC7\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\xC7\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\xC7\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\xC7\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\xC7\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\xC7\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\xC7\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\xC7\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\xC7\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\xC7\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\xC7\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\xC7\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\xC7\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\xC7\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\xC7\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\xC7\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\xC7\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\xC7\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\xC7\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\xC7\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\xC7\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\xC7\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\xC7\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\xC7\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\xC7\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\xC7\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\xC7\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\xC7\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\xC7\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\xC7\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\xC7\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\xC7\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\xC7\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\xC7\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\xC7\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\xC7\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\xC7\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\xC7\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\xC7\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\xC7\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\xC7\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\xC7\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\xC7\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\xC7\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\xC7\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\xC7\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\xC7\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\xC7\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\xC7\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\xC7\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\xC7\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\xC7\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\x69\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\xC7\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\xC7\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\xC7\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\xC7\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\xC7\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\xC7\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\xC7\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\xC7\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\xC7\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\xC7\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\xC7\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\xC7\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\xC7\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\xC7\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\xC7\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\xC7\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\xC7\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\xC7\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\xC7\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\xC7\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\xC7\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\xC7\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\xC8\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\xC8\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\xC8\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\xC8\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\xC8\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\xC8\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\xC8\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\xC8\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\xC8\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\xC8\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\xC8\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\xC8\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\xC8\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\xC8\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\xC8\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\xC8\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\xC8\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\xC8\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\xC8\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\xC8\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\xC8\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\xC8\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\xC8\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\xC8\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\xC8\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\xC8\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\xC8\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\xC8\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\xC8\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\xC8\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\xC8\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\xC8\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\xC8\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\xC8\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\xC8\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\xC8\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\xC8\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\xC8\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\xC8\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\xC8\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\xC8\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\xC8\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\xC8\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\xC8\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\xC8\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\xC8\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\xC8\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\xC8\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\xC8\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\xC8\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\xC8\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\xC8\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\xC8\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\xC8\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\xC8\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\xC8\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\xC8\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\xC8\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\xC8\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\xC8\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\xC8\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\xC8\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\xC8\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\xC8\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\xC8\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\xC8\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\xC8\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\xC8\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\xC8\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\xC8\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\xC8\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\xC8\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\xC8\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\xC8\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\xC8\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\xC8\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\xC8\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\xC8\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\xC8\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\xC8\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\xC8\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\xC8\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\xC8\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\xC8\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\xC8\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\xC8\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\xC8\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\xC8\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\xC8\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\xC8\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\xC8\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\xC8\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\xC8\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\xC8\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\xC9\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\xC9\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\xC9\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\xC9\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\xC9\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\xC9\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\xC9\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\xC9\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\xC9\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\xC9\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\xC9\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\xC9\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\xC9\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\xC9\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\xC9\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\x4A\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\xC9\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\xC9\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\xC9\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\xC9\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\xC9\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\xC9\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\xC9\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\xC9\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\xC9\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\xC9\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\xC9\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\xC9\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\xC9\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\xC9\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\xC9\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\xC9\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\xC9\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\xC9\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\xC9\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\xC9\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\xC9\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\xC9\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\xC9\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\xC9\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\xC9\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\xC9\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\xC9\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\xC9\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\xC9\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\xC9\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\xC9\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\xC9\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\xC9\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\xC9\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\xC9\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\xC9\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\xC9\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\xC9\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\xC9\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\xC9\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\xC9\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\xC9\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\xC9\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\xC9\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\xC9\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\xC9\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\xC9\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\xC9\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\xC9\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\xC9\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\xC9\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\xC9\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\xC9\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\xC9\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\xC9\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\xC9\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\xC9\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\xC9\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\xC9\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\xC9\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\xC9\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\xC9\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\xC9\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\xC9\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\xC9\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\xC9\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\xC9\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\xC9\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\xC9\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\xC9\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\xC9\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\xC9\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\xC9\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\xC9\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\xC9\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\xC9\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\xC9\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\xC9\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\xD1\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\xD1\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\xD1\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\xD1\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\xD1\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\xD1\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\xD1\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\xD1\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\xD1\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\xD1\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\xD1\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\xD1\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\xD1\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\xD1\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\xD1\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\xD1\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\xD1\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\xD1\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\xD1\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\xD1\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\xD1\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\xD1\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\xD1\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\xD1\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\xD1\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\xD1\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\xD1\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\xD1\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\xD1\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\xD1\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\xD1\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\xD1\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\xD1\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\xD1\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\xD1\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\xD1\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\xD1\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\xD1\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\xD1\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\xD1\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\xD1\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\xD1\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\xD1\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\xD1\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\xD1\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\xD1\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\xD1\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\xD1\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\xD1\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\xD1\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\xD1\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\xD1\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\xD1\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\xD1\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\xD1\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\xD1\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\xD1\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\xD1\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\xD1\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\xD1\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\xD1\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\xD1\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\xD1\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\xD1\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\xD1\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\xD1\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\xD1\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\xD1\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\xD1\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\xD1\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\xD1\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\xD1\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\xD1\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\xD1\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\xD1\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\xD1\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\xD1\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\xD1\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\xD1\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\xD1\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\xD1\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\xD1\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\xD1\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\xD1\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\xD1\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\xD1\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\xD1\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\xD1\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\xD1\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\xD1\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\xD1\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\xD1\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\xD1\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\xD1\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\xD2\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\xD2\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\xD2\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\xD2\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\xD2\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\xD2\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\xD2\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\xD2\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\xD2\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\xD2\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\xD2\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\xD2\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\xD2\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\xD2\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\xD2\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\xD2\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\xD2\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\xD2\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\xD2\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\xD2\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\xD2\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\xD2\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\xD2\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\xD2\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\xD2\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\xD2\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\xD2\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\xD2\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\xD2\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\xD2\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\xD2\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\xD2\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\xD2\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\xD2\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\xD2\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\xD2\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\xD2\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\xD2\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\xD2\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\xD2\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\xD2\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\xD2\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\xD2\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\xD2\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\xD2\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\xD2\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\xD2\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\xD2\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\xD2\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\xD2\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\xD2\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\xD2\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\xD2\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\xD2\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\xD2\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\xD2\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\xD2\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\xD2\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\xD2\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\xD2\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\xD2\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\xD2\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\xD2\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\xD2\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\xD2\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\xD2\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\xD2\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\xD2\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\xD2\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\xD2\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\xD2\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\xD2\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\xD2\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\x90\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\xD2\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\xD2\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\xD2\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\xD2\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\xD2\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\xD2\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\xD2\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\xD2\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\xD2\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\xD2\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\xD2\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\xD2\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\xD2\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\xD2\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\xD7\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\xD2\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\xD2\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\xD2\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\xD2\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\xD2\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\xD3\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\xD3\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\xD3\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\xD3\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\xD3\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\xD3\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\xD3\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\xD3\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\xD3\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\xD3\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\xD3\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\xD3\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\xD3\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\xD3\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\xD3\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\xD3\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\xD3\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\xD3\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\xD3\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\xD3\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\xD3\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\xD3\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\xD3\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\xD3\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\xD3\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\xD3\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\xD3\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\xD3\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\xD3\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\xD3\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\xD3\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\xD3\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\xD3\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\xD3\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\xD3\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\xD3\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\xD3\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\xD3\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\xD3\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\xD3\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\xD3\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\xD3\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\xD3\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\xD3\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\xD3\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\xD3\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\xD3\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\xD3\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\xD3\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\xD3\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\xD3\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\xD3\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\xD3\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\xD3\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\xD3\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\xD3\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\xD3\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\xD3\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\xD3\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\xD3\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\xD3\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\xD3\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\xD3\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\xD3\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\xD3\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\xD3\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\xD3\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\xD3\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\xD3\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\xD3\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\xD3\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\xD3\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\xD3\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\xD3\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\xD3\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\xD3\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\xD3\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\xD3\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\xD3\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\xD3\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\xD3\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\xD3\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\xD3\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\xD3\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\xD3\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\xD3\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\xD3\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\xD3\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\x68\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\xD3\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\xD3\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\xD3\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\xD3\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\xD3\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\xD4\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\xD4\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\xD4\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\xD4\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\xD4\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\xD4\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\xD4\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\xD4\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\xD4\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\xD4\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\xD4\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\xD4\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\xD4\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\xD4\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\xD4\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\xD4\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\xD4\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\xD4\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\xD4\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\xD4\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\xD4\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\xD4\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\xD4\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\xD4\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\xD4\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\xD4\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\xD4\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\xD4\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\xD4\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\xD4\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\xD4\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\xD4\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\xD4\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\xD4\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\xD4\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\xD4\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\xD4\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\xD4\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\xD4\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\xD4\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\xD4\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\xD4\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\xD4\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\xD4\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\xD4\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\xD4\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\xD4\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\xD4\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\xD4\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\xD4\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\xD4\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\xD4\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\xD4\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\xD4\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\xD4\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\xD4\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\xD4\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\xA5\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\xD4\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\xD4\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\xD4\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\xD4\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\xD4\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\xD4\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\xD4\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\xD4\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\xD4\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\xD4\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\xD4\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\xD4\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\xD4\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\xD4\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\xD4\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\xD4\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\xD4\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\xD4\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\xD4\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\xD4\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\xD4\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\xD4\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\xD4\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\xD4\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\xD4\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\xD4\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\xD4\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\xD4\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\xD4\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\xD4\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\xD4\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\xD4\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\xD4\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\xD4\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\xD4\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\xD4\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\xD5\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\xD5\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\xD5\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\xD5\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\xD5\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\xD5\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\xD5\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\xD5\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\xD5\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\xD5\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\xD5\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\xD5\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\xD5\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\xD5\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\xD5\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\xD5\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\xD5\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\xD5\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\xD5\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\xD5\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\xD5\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\xD5\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\xD5\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\xD5\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\xD5\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\xD5\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\xD5\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\xD5\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\xD5\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\xD5\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\xD5\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\xD5\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\xD5\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\xD5\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\xD5\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\xD5\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\xD5\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\xD5\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\xD5\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\xD5\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\xD5\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\xD5\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\xD5\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\xD5\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\xD5\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\xD5\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\xD5\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\xD5\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\xD5\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\xD5\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\xD5\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\xD5\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\xD5\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\xD5\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\xD5\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\xD5\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\xD5\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\xD5\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\xD5\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\xD5\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\xD5\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\xD5\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\xD5\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\xD5\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\xD5\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\xD5\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\xD5\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\xD5\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\xD5\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\xD5\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\xD5\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\xD5\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\xD5\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\xD5\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\xD5\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\xD5\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\xD5\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\xD5\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\xD5\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\xD5\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\xD5\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\xD5\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\xD5\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\xD5\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\xD5\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\xD5\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\xD5\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\xD5\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\xD5\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\xD5\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\xD5\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\xD5\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\xD5\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\xD5\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\xD6\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\xD6\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\xD6\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\xD6\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\xD6\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\xD6\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\xD6\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\xD6\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\xD6\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\xD6\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\xD6\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\xD6\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\xD6\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\xD6\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\xD6\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\xD6\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\xD6\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\xD6\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\xD6\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\xD6\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\xD6\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\x63\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\xD6\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\xD6\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\xD6\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\xD6\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\xD6\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\xD6\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\xD6\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\xD6\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\xD6\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\xD6\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\xD6\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\xD6\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\xD6\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\xD6\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\xD6\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\xD6\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\xD6\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\xD6\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\xD6\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\xD6\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\xD6\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\xD6\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\xD6\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\xD6\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\xD6\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\xD6\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\xD6\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\xD6\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\xD6\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\xD7\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\xD7\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\xD7\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\xD7\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\xD7\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\xD7\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\xD7\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\xD7\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\xD7\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\xD7\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\xD7\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\xD7\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\xD7\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\xD7\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\xD7\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\xD7\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\xD7\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\xD7\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\xD7\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\xD7\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\xD7\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\xD7\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\xD7\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\xD7\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\xD7\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\xD7\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\xD7\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\xD7\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\xD7\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\xD7\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\xD7\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\xD7\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\xD7\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\xD7\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\xD7\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\xD7\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\xD7\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\xD7\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\xD7\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\xD7\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\xD7\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\xD7\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\xD7\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\xD7\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\xD7\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\xD7\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\xD7\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\xD7\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\xD7\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\xD7\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\xD7\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\xD7\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\xD7\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\xD2\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\xD7\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\xD7\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\xD7\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\xD7\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\xD7\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\xD7\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\xD7\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\xD7\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\xD7\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\xD7\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\xD7\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\xD7\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\xD7\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\xD7\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\xD7\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\xD7\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\xD7\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\xD7\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\xD7\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\xD7\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\xD7\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\xD7\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\xD7\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\xD7\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\xD7\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\xD7\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\xD7\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\xD7\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\xD7\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\xD7\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\xD7\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\xD7\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\xD7\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\xD7\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\xD7\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\xD7\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\xD7\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\xD7\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\xD7\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\xD7\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\xD8\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\xD8\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\xD8\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\xD8\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\xD8\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\xD8\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\xD8\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\xD8\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\xD8\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\xD8\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\xD8\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\xD8\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\xD8\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\xD8\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\xD8\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\xD8\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\xD8\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\xD8\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\xD8\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\xD8\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\xD8\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\xD8\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\xD8\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\xD8\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\xD8\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\xD8\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\xD8\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\xD8\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\xD8\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\xD8\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\xD8\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\xD8\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\xD8\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\xD8\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\xD8\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\xD8\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\xD8\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\xD8\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\xD8\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\xD8\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\xD8\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\xD8\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\xD8\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\xD8\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\xD8\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\xD8\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\xD8\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\xD8\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\xD8\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\xD8\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\xD8\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\xD8\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\xD8\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\xD8\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\xD8\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\xD8\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\xD8\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\xD8\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\xD8\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\xD8\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\xD8\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\xD8\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\xD8\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\xD8\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\xD8\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\xD8\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\xD8\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\xD8\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\xD8\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\xD8\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\xD8\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\xD8\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\xD8\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\xD8\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\xD8\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\xD8\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\xD8\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\xD8\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\xD8\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\xD8\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\xD8\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\xD8\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\xD8\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\xD8\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\xD8\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\xD8\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\xD8\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\xD8\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\xD8\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\xD8\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\xD8\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\xD8\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\xD8\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\xD8\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\xD9\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\xD9\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\xD9\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\xD9\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\xD9\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\xD9\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\xD9\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\xD9\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\xD9\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\xD9\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\xD9\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\xD9\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\xD9\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\xD9\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\xD9\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\xD9\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\xD9\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\xD9\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\xD9\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\xD9\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\xD9\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\xD9\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\xD9\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\xD9\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\xD9\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\xD9\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\xD9\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\xD9\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\xD9\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\xD9\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\xD9\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\xD9\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\xD9\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\xD9\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\xD9\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\xD9\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\xD9\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\xD9\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\xD9\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\xD9\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\xD9\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\xD9\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\xD9\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\xD9\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\xD9\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\xD9\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\xD9\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\xD9\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\xD9\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\xD9\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\xD9\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\xD9\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\xD9\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\xD9\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\xD9\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\xD9\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\xD9\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\xD9\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\xD9\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\xD9\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\xD9\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\xD9\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\xD9\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\xD9\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\xD9\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\xD9\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\xD9\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\xD9\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\xD9\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\xD9\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\xD9\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\xD9\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\xD9\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\xD9\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\xD9\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\xD9\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\xD9\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\xD9\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\xD9\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\xD9\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\xD9\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\xD9\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\xD9\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\xD9\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\xD9\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\xD9\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\xD9\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\xD9\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\xD9\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\xD9\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\xD9\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\xD9\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\xD9\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\xD9\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\xE2\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\xE2\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\xE2\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\xE2\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\xE2\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\xE2\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\xE2\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\xE2\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\xE2\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\xE2\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\xE2\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\xE2\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\xE2\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\xE2\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\xE2\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\xE2\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\xE2\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\xE2\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\xE2\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\xE2\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\xE2\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\xE2\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\xE2\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\xE2\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\xE2\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\xE2\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\xE2\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\xE2\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\xE2\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\xE2\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\xE2\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\xE2\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\xE2\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\xE2\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\xE2\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\xE2\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\xE2\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\xE2\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\xE2\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\xE2\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\xE2\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\xE2\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\xE2\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\xE2\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\xE2\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\xE2\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\xE2\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\xE2\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\xE2\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\xE2\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\xE2\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\xE2\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\xE2\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\xE2\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\xE2\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\xE2\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\xE2\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\xE2\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\xE2\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\xE2\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\xE2\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\xE2\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\xE2\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\xE2\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\xE2\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\xE2\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\xE2\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\xE2\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\xE2\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\xE2\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\xE2\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\xE2\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\xE2\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\xE2\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\xE2\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\xE2\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\xE2\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\xE2\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\xE2\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\xE2\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\xE2\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\xE2\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\xE2\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\xE2\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\xE2\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\xE2\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\xE2\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\xE2\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\xE2\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\xE2\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\xE2\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\xE2\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\xE2\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\xE2\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\xE3\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\xE3\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\xE3\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\xE3\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\xE3\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\xE3\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\xE3\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\xE3\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\xE3\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\xE3\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\xE3\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\xE3\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\xE3\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\xE3\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\xE3\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\xE3\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\xE3\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\xE3\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\xE3\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\xE3\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\xE3\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\xE3\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\xE3\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\xE3\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\xE3\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\xE3\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\xE3\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\xE3\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\xE3\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\xE3\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\xE3\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\xE3\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\xE3\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\xE3\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\xE3\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\xE3\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\xE3\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\xE3\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\xE3\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\xE3\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\xE3\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\xE3\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\xE3\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\xE3\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\xE3\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\xE3\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\xE3\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\xE3\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\xE3\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\xE3\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\xE3\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\xE3\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\xE3\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\xE3\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\xE3\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\xE3\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\xE3\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\xE3\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\xE3\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\xE3\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\xE3\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\xE3\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\xE3\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\xE3\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\xE3\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\xE3\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\xE3\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\xC4\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\xE3\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\xE3\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\xE3\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\xE3\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\xE3\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\xE3\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\xE3\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\xE3\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\xE3\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\xE3\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\xE3\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\xE3\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\xE3\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\xE3\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\xE3\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\xE3\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\xE3\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\xE3\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\xE3\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\xE3\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\xE3\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\xE3\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\xE3\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\xE3\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\xE3\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\xE3\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\xE4\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\xE4\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\xE4\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\xE4\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\xE4\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\xE4\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\xE4\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\xE4\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\xE4\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\xE4\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\xE4\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\xE4\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\xE4\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\xE4\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\xE4\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\xE4\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\xE4\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\xE4\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\xE4\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\xE4\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\xE4\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\xE4\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\xE4\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\xE4\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\xE4\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\xE4\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\xE4\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\xE4\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\xE4\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\xE4\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\xE4\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\xE4\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\xE4\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\xE4\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\xE4\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\xE4\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\xE4\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\xE4\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\xE4\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\xE4\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\xE4\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\xE4\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\xE4\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\xE4\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\xE4\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\xE4\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\xE4\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\xE4\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\xE4\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\xE4\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\xE4\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\xE4\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\xE4\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\xE4\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\xE4\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\xE4\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\xE4\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\xE4\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\xE4\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\xE4\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\xE4\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\xE4\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\xE4\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\xE4\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\xE4\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\xE4\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\xE4\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\xE4\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\xE4\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\xE4\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\xE4\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\xE4\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\xE4\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\xE4\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\xE4\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\xE4\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\xE4\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\xE4\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\xE4\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\xE4\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\xE4\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\xE4\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\xE4\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\xE4\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\xE4\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\xE4\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\xE4\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\xE4\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\xE4\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\xE4\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\xE4\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\xE4\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\xE4\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\xE4\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\xE5\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\xE5\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\xE5\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\xE5\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\xE5\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\xE5\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\xE5\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\xE5\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\xE5\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\xE5\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\xE5\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\xE5\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\xE5\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\xE5\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\xE5\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\xE5\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\xE5\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\xE5\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\xE5\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\xE5\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\xE5\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\xE5\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\xE5\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\xE5\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\xE5\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\xE5\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\xE5\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\xE5\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\xE5\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\xE5\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\xE5\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\xE5\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\xE5\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\xE5\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\xE5\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\xE5\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\xE5\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\xE5\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\xE5\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\xE5\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\xE5\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\xE5\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\xE5\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\xE5\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\xE5\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\xE5\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\xE5\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\xE5\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\xE5\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\xE5\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\xE5\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\xE5\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\xE5\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\xE5\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\xE5\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\xE5\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\xE5\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\xE5\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\xE5\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\xE5\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\xE5\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\xE5\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\xE5\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\xE5\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\xE5\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\xE5\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\xE5\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\xE5\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\xE5\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\xE5\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\xE5\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\xE5\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\xE5\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\xE5\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\xE5\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\xE5\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\xE5\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\xE5\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\xE5\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\xE5\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\xE5\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\xE5\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\xE5\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\xE5\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\xE5\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\xE5\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\xE5\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\xE5\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\xE5\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\xE5\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\xE5\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\xE5\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\xE5\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\xE5\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\xE6\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\xE6\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\xE6\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\xE6\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\xE6\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\xE6\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\xE6\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\xE6\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\xE6\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\xE6\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\xE6\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\xE6\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\xE6\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\xE6\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\xE6\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\xE6\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\xE6\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\xE6\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\xE6\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\xE6\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\xE6\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\xE6\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\xE6\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\xE6\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\xE6\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\xE6\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\xE6\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\xE6\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\xE6\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\xE6\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\xE6\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\xE6\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\xE6\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\xE6\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\xE6\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\xE6\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\xE6\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\xE6\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\xE6\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\xE6\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\xE6\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\xE6\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\xE6\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\xE6\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\xE6\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\xE6\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\xE6\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\xE6\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\xE6\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\xE6\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\xE6\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\xE6\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\xE6\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\xE6\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\xE6\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\xE6\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\xE6\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\xE6\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\xE6\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\xE6\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\xE6\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\xE6\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\xE6\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\xE6\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\xE6\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\xE6\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\xE6\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\xE6\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\xE6\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\xE6\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\xE6\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\xE6\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\xE6\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\xE6\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\xE6\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\xE6\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\xE6\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\xE6\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\xE6\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\xE6\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\xE6\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\xE6\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\xE6\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\xE6\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\xE6\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\xE6\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\xE6\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\xE6\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\xE6\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\xE6\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\xE6\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\xE6\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\xE6\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\xE7\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\xE7\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\xE7\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\xE7\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\xE7\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\xE7\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\xE7\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\xE7\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\xE7\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\xE7\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\xE7\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\xE7\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\xE7\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\xE7\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\xE7\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\xE7\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\xE7\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\xE7\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\xE7\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\xE7\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\xE7\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\xE7\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\xE7\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\xE7\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\xE7\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\xE7\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\xE7\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\xE7\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\xE7\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\xE7\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\xE7\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\xE7\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\xE7\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\xE7\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\xE7\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\xE7\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\xE7\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\xE7\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\xE7\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\xE7\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\xE7\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\xE7\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\xE7\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\xE7\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\xE7\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\xE7\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\xE7\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\xE7\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\xE7\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\xE7\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\xE7\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\xE7\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\xE7\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\xE7\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\xE7\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\xE7\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\xE7\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\xE7\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\xE7\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\xE7\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\xE7\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\xE7\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\xE7\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\xE7\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\xE7\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\xE7\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\xE7\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\xE7\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\xE7\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\xE7\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\xE7\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\xE7\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\xE7\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\xE7\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\xE7\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\xE7\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\xE7\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\xE7\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\xE7\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\xE7\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\xE7\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\xE7\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\xE7\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\xE7\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\xE7\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\xE7\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\xE7\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\xE7\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\xE7\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\xE7\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\xE7\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\xE7\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\xE7\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\xE7\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\xE8\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\xE8\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\xE8\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\xE8\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\xE8\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\xE8\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\xE8\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\xE8\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\xE8\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\xE8\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\xE8\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\xE8\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\xE8\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\xE8\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\xE8\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\xE8\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\xE8\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\xE8\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\xE8\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\xE8\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\xE8\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\xE8\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\xE8\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\xE8\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\xE8\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\xE8\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\xE8\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\xE8\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\xE8\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\xE8\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\xE8\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\xE8\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\xE8\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\xE8\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\xE8\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\xE8\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\xE8\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\xE8\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\xE8\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\xE8\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\xE8\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\xE8\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\xE8\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\xE8\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\xE8\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\xE8\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\xE8\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\xE8\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\xE8\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\xE8\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\xE8\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\xE8\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\xE8\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\xE8\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\xE8\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\xE8\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\xE8\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\xE8\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\xE8\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\xE8\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\xE8\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\xE8\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\xE8\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\xE8\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\xE8\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\xE8\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\xE8\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\xE8\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\xE8\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\xE8\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\xE8\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\xE8\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\xE8\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\xE8\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\xE8\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\xE8\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\xE8\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\xE8\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\xE8\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\xE8\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\xE8\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\xE8\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\xE8\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\xE8\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\xE8\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\xE8\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\xE8\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\xF3\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\xE8\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\xE8\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\xE8\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\xE8\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\xE8\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\xE8\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\xE9\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\xE9\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\xE9\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\xE9\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\xE9\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\xE9\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\xE9\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\xE9\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\xE9\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\xE9\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\xE9\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\xE9\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\xE9\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\xE9\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\xE9\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\xE9\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\xE9\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\xE9\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\xE9\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\xE9\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\xE9\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\xE9\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\xE9\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\xE9\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\xE9\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\xE9\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\xE9\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\xE9\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\xE9\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\xE9\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\xE9\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\xE9\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\xE9\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\xE9\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\xE9\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\xE9\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\xE9\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\xE9\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\xE9\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\xE9\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\xE9\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\xE9\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\xE9\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\xE9\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\xE9\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\xE9\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\xE9\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\xE9\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\xE9\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\xE9\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\xE9\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\xE9\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\xE9\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\xE9\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\xE9\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\xE9\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\xE9\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\xE9\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\xE9\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\xE9\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\xE9\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\xE9\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\xE9\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\xE9\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\xE9\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\xE9\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\xE9\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\xE9\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\xE9\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\xE9\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\xE9\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\xE9\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\xE9\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\xE9\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\xE9\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\xE9\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\xE9\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\xE9\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\xE9\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\xE9\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\xE9\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\xE9\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\xE9\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\xE9\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\xE9\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\xE9\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\xE9\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\xE9\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\xE9\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\xE9\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\xE9\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\xE9\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\xE9\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\xE9\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\x4A\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\x4A\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\x4A\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\x4A\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\x4A\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\x4A\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\x4A\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\x4A\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\x4A\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\x4A\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\x4A\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\x4A\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\x4A\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\x4A\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\x4A\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\x4A\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\x4A\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\x4A\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\x4A\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\x4A\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\x4A\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\x4A\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\x4A\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\x4A\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\x4A\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\x4A\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\x4A\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\x4A\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\x4A\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\x4A\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\x4A\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\x4A\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\x4A\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\x4A\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\x4A\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\x4A\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\x4A\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\x4A\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\x4A\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\x4A\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\x4A\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\x4A\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\x4A\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\x4A\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\x4A\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\x4A\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\x4A\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\x4A\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\x4A\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\x4A\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\x4A\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\x4A\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\x4A\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\x4A\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\x4A\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\xC9\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\x4A\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\x4A\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\x4A\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\x4A\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\x4A\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\x4A\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\x4A\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\x4A\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\x4A\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\x4A\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\x4A\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\x4A\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\x4A\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\x4A\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\x4A\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\x4A\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\x4A\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\x4A\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\x4A\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\x4A\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\xC5\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\x4A\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\x4A\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\x4A\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\x4A\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\x4A\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\x4A\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\x4A\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\x4A\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\x4A\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\x4A\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\x4A\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\x4A\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\x4A\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\x4A\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\x4A\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\x4A\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\x4A\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\x5B\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\x5B\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\x5B\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\x5B\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\x5B\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\x5B\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\x5B\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\x5B\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\x5B\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\x5B\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\x5B\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\x5B\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\x5B\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\x5B\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\x5B\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\x5B\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\x5B\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\x5B\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\x5B\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\x5B\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\x5B\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\x5B\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\x5B\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\x5B\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\x5B\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\x5B\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\x5B\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\x5B\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\x5B\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\x5B\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\x5B\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\x5B\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\x5B\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\x5B\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\x5B\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\x5B\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\x5B\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\x5B\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\x5B\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\x5B\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\x5B\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\x5B\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\x5B\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\x5B\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\x5B\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\x5B\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\x5B\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\x5B\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\x5B\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\x5B\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\x5B\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\x5B\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\x5B\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\x5B\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\x5B\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\x5B\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\x5B\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\x5B\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\x5B\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\x5B\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\x5B\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\x5B\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\x5B\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\x5B\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\x5B\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\x5B\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\x5B\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\x5B\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\x5B\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\x5B\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\x5B\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\x5B\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\x5B\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\x5B\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\x5B\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\x5B\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\x5B\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\x5B\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\x5B\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\x5B\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\x5B\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\x5B\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\x5B\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\x5B\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\x5B\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\x5B\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\x5B\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\x5B\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\x5B\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\x5B\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\x5B\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\x5B\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\x5B\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\x5B\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\x5A\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\x5A\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\x5A\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\x5A\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\x5A\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\x5A\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\x5A\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\x5A\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\x5A\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\x5A\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\x5A\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\x5A\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\x5A\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\x5A\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\x5A\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\x5A\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\x5A\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\x5A\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\x5A\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\x5A\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\x5A\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\x5A\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\x5A\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\x5A\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\x5A\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\x5A\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\x5A\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\x5A\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\x5A\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\x5A\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\x5A\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\x5A\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\x5A\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\x5A\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\x5A\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\x5A\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\x5A\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\x5A\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\x5A\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\x5A\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\x5A\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\x5A\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\x5A\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\x5A\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\x5A\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\x5A\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\x5A\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\x5A\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\x5A\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\x5A\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\x5A\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\x5A\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\x5A\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\x5A\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\x5A\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\x5A\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\x5A\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\x5A\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\x5A\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\x5A\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\x5A\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\x5A\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\x5A\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\x5A\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\x5A\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\x5A\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\x5A\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\x5A\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\x5A\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\x5A\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\x5A\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\x5A\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\x5A\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\x5A\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\x5A\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\x5A\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\x5A\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\x5A\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\x5A\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\x5A\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\x5A\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\x5A\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\x5A\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\x5A\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\x5A\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\x5A\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\x5A\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\x5A\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\x5A\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\x5A\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\x5A\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\x5A\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\x5A\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\x5A\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\x5F\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\x5F\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\x5F\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\x5F\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\x5F\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\x5F\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\x5F\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\x5F\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\x5F\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\x5F\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\x5F\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\x5F\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\x5F\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\x5F\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\x5F\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\x5F\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\x5F\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\x5F\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\x5F\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\x5F\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\x5F\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\x5F\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\x5F\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\x5F\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\xC5\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\x5F\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\x5F\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\x5F\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\x5F\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\x5F\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\x5F\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\x5F\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\x5F\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\x5F\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\x5F\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\x5F\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\x5F\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\x5F\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\x5F\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\x5F\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\x5F\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\x5F\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\x5F\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\x5F\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\x5F\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\x5F\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\x5F\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\x5F\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\x5F\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\x5F\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\x5F\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\x5F\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\x5F\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\x5F\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\x5F\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\x5F\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\x5F\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\x5F\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\x5F\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\x5F\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\x5F\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\x5F\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\x5F\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\x5F\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\x5F\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\x5F\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\x5F\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\x5F\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\x5F\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\x5F\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\x5F\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\x5F\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\x5F\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\x5F\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\x5F\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\x5F\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\x5F\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\x5F\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\x5F\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\x5F\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\x5F\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\x5F\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\x5F\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\x5F\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\xF4\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\x5F\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\x5F\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\x5F\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\x5F\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\x5F\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\x5F\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\x5F\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\x5F\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\x5F\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\x6D\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\x6D\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\x6D\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\x6D\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\x6D\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\x6D\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\x6D\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\x6D\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\x6D\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\x6D\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\x6D\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\x6D\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\x6D\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\x6D\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\x6D\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\x6D\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\x6D\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\x6D\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\x6D\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\x6D\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\x6D\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\x6D\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\x6D\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\x6D\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\x6D\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\x6D\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\x6D\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\x6D\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\x6D\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\x6D\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\x6D\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\x6D\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\x6D\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\x6D\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\x6D\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\x6D\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\x6D\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\x6D\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\x6D\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\x6D\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\x6D\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\x6D\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\x6D\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\x6D\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\x6D\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\x6D\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\x6D\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\x6D\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\x6D\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\x6D\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\x6D\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\x6D\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\x6D\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\x6D\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\x6D\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\x6D\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\x6D\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\x6D\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\x6D\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\x6D\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\x6D\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\x6D\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\x6D\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\x6D\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\x6D\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\x6D\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\x6D\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\x6D\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\x6D\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\x6D\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\x6D\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\x6D\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\x6D\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\x6D\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\x6D\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\x6D\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\x6D\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\x6D\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\x6D\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\x6D\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\x6D\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\x6D\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\x6D\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\x6D\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\x6D\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\x6D\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\x6D\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\x6D\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\x6D\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\x6D\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\x6D\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\x6D\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\x6D\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\x6D\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\x79\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\x79\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\x79\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\x79\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\x79\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\x79\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\x79\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\x79\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\x79\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\x79\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\x79\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\x79\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\x79\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\x79\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\x79\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\x79\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\x79\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\x79\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\x79\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\x79\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\x79\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\x79\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\x79\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\x79\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\x79\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\x79\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\x79\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\x79\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\x79\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\x79\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\x79\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\x79\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\x79\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\x79\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\x79\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\x79\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\x79\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\x79\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\x79\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\x79\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\x79\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\x79\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\x79\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\x79\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\x79\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\x79\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\x79\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\x79\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\x79\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\x79\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\x79\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\x79\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\x79\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\x79\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\x79\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\x79\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\x79\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\x79\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\x79\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\x79\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\x79\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\x79\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\x79\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\x79\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\x79\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\x79\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\x79\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\x79\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\x79\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\x79\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\x79\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\x79\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\x79\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\x79\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\x79\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\x79\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\x79\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\x79\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\x79\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\x79\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\x79\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\x79\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\x79\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\x79\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\x79\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\x95\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\x79\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\x79\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\x79\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\x79\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\x79\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\x79\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\x79\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\x79\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\x57\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\x57\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\x57\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\x57\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\x57\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\x57\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\x57\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\x57\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\x57\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\x57\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\x57\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\x57\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\x57\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\x57\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\x57\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\x57\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\x57\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\x57\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\x57\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\x57\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\x57\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\x57\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\x57\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\x57\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\x57\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\x57\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\x57\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\x57\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\x57\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\x57\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\x57\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\x57\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\x57\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\x57\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\x57\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\x57\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\x57\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\x57\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\x57\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\x57\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\x57\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\x57\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\x57\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\x57\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\x57\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\x57\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\x57\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\x57\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\x57\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\x57\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\x57\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\x57\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\x57\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\x57\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\x57\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\x57\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\x57\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\x57\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\x57\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\x57\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\x57\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\x57\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\x57\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\x57\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\x57\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\x57\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\x57\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\x57\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\x57\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\x57\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\x57\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\x57\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\x57\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\x57\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\x57\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\x57\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\x57\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\x57\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\x57\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\x57\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\x57\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\x57\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\x57\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\x57\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\x57\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\x57\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\x57\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\x57\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\x57\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\x57\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\x57\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\x57\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\x57\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\x57\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\x59\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\x59\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\x59\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\x59\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\x59\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\x59\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\x59\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\x59\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\x59\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\x59\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\x59\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\x59\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\x59\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\x59\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\x59\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\x59\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\x59\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\x59\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\x59\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\x59\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\x59\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\x59\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\x59\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\x59\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\x59\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\x59\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\x59\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\x59\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\x59\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\x59\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\x59\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\x59\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\x59\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\x59\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\x59\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\x59\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\x59\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\x59\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\x59\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\x59\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\x59\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\x59\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\x59\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\x59\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\x59\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\x59\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\x59\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\x59\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\x59\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\x59\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\x59\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\x59\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\x59\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\x59\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\x59\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\x59\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\x59\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\x59\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\x59\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\x59\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\x59\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\x59\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\x59\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\x59\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\x59\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\x59\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\x59\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\x59\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\x59\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\x59\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\x59\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\xF9\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\x59\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\xC5\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\x59\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\x59\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\x59\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\x59\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\x59\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\x59\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\x59\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\x59\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\x59\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\x59\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\x59\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\x59\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\x59\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\x59\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\x59\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\x59\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\x59\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\x59\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\x59\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\x59\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\x62\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\x62\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\x62\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\x62\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\x62\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\x62\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\x62\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\x62\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\x62\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\x62\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\x62\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\x62\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\x62\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\x62\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\x62\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\x62\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\x62\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\x62\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\x62\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\x62\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\x62\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\x62\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\x62\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\x62\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\x62\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\x62\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\x62\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\x62\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\x62\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\x62\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\x62\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\x62\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\x62\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\x62\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\x62\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\x62\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\x62\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\x62\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\x62\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\x62\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\x62\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\x62\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\x62\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\x62\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\x62\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\x62\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\x62\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\x62\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\x62\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\x62\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\x62\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\x62\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\x62\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\x62\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\x62\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\x62\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\x62\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\x62\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\x62\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\x62\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\x62\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\xF3\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\x62\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\x62\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\x62\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\x62\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\x62\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\x62\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\x62\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\x62\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\x62\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\x62\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\x62\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\x62\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\x62\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\x62\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\x62\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\x62\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\x62\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\x62\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\x62\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\x62\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\x62\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\x62\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\x62\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\x62\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\x62\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\x62\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\x62\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\x62\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\x62\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\x62\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\x62\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\x62\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\x63\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\x63\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\x63\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\x63\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\x63\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\x63\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\x63\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\x63\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\x63\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\x63\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\x63\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\x63\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\x63\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\x63\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\x63\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\x63\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\x63\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\x63\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\x63\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\x63\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\x63\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\x63\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\x63\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\x63\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\x63\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\x63\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\x63\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\x63\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\x63\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\x63\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\x63\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\x63\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\x63\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\x63\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\x63\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\x63\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\x63\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\xD6\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\x63\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\x63\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\x63\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\x63\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\x63\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\x63\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\x63\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\x63\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\x63\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\x63\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\x63\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\x63\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\x63\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\x63\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\x63\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\x63\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\x63\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\x63\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\x63\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\x63\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\x63\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\x63\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\x63\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\x63\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\x63\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\x63\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\x63\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\x63\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\x63\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\x63\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\x63\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\x63\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\x63\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\x63\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\x63\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\x63\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\x63\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\x63\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\x63\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\x63\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\x63\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\x63\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\x63\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\x63\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\x63\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\x63\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\x63\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\x63\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\x63\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\x63\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\x63\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\x63\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\x63\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\x63\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\x63\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\x63\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\x64\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\x64\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\x64\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\x64\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\x64\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\x64\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\x64\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\x64\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\x64\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\x64\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\x64\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\x64\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\x64\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\x64\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\x64\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\x64\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\x64\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\x64\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\x64\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\x64\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\x64\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\x64\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\x64\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\x64\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\x64\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\x64\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\x64\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\x64\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\x64\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\x64\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\x64\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\x64\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\x64\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\x64\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\x64\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\x64\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\x64\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\x64\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\x64\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\x64\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\x64\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\x64\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\x64\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\x64\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\x64\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\x64\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\x64\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\x64\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\x64\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\x64\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],
        ["\x64\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],
        ["\x64\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],
        ["\x64\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],
        ["\x64\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],
        ["\x64\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],
        ["\x64\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],
        ["\x64\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],
        ["\x64\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],
        ["\x64\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],
        ["\x64\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],
        ["\x64\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],
        ["\x64\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],
        ["\x64\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],
        ["\x64\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],
        ["\x64\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],
        ["\x64\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],
        ["\x64\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],
        ["\x64\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],
        ["\x64\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],
        ["\x64\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],
        ["\x64\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],
        ["\x64\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],
        ["\x64\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],
        ["\x64\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],
        ["\x64\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],
        ["\x64\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],
        ["\x64\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],
        ["\x64\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],
        ["\x64\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],
        ["\x64\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],
        ["\x64\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],
        ["\x64\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],
        ["\x64\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],
        ["\x64\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],
        ["\x64\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],
        ["\x64\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],
        ["\x64\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],
        ["\x64\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],
        ["\x64\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],
        ["\x64\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],
        ["\x64\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],
        ["\x64\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],
        ["\x64\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],
        ["\x64\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],
        ["\x65\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],
        ["\x65\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],
        ["\x65\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],
        ["\x65\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],
        ["\x65\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],
        ["\x65\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],
        ["\x65\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],
        ["\x65\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],
        ["\x65\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],
        ["\x65\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],
        ["\x65\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],
        ["\x65\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],
        ["\x65\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],
        ["\x65\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],
        ["\x65\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],
        ["\x65\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],
        ["\x65\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],
        ["\x65\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],
        ["\x65\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],
        ["\x65\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],
        ["\x65\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],
        ["\x65\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],
        ["\x65\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],
        ["\x65\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],
        ["\x65\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],
        ["\x65\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],
        ["\x65\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],
        ["\x65\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],
        ["\x65\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],
        ["\x65\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],
        ["\x65\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],
        ["\x65\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],
        ["\x65\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],
        ["\x65\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],
        ["\x65\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],
        ["\x65\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],
        ["\x65\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],
        ["\x65\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],
        ["\x65\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],
        ["\x65\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],
        ["\x65\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],
        ["\x65\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],
        ["\x65\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],
        ["\x65\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],
        ["\x65\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],
        ["\x65\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],
        ["\x65\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],
        ["\x65\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],
        ["\x65\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],
        ["\x65\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],
        ["\x65\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],
        ["\x65\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],
        ["\x65\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],
        ["\x65\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],
        ["\x65\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],
        ["\x65\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],
        ["\x65\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],
        ["\x65\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],
        ["\x65\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],
        ["\x65\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],
        ["\x65\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],
        ["\x65\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],
        ["\x65\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],
        ["\x65\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],
        ["\x65\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],
        ["\x65\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],
        ["\x65\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],
        ["\x65\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],
        ["\x65\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],
        ["\x65\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],
        ["\x65\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],
        ["\x65\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],
        ["\x65\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],
        ["\x65\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],
        ["\x65\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],
        ["\x65\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],
        ["\x65\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],
        ["\x65\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],
        ["\x65\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],
        ["\x65\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],
        ["\x65\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],
        ["\x65\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],
        ["\x65\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],
        ["\x65\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],
        ["\x65\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],
        ["\x65\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],
        ["\x65\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],
        ["\x65\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],
        ["\x65\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],
        ["\x65\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],
        ["\x65\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],
        ["\x65\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],
        ["\x65\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],
        ["\x65\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],
        ["\x66\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],
        ["\x66\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],
        ["\x66\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],
        ["\x66\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],
        ["\x66\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],
        ["\x66\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],
        ["\x66\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],
        ["\x66\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],
        ["\x66\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],
        ["\x66\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],
        ["\x66\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],
        ["\x66\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],
        ["\x66\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],
        ["\x66\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],
        ["\x66\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],
        ["\x66\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],
        ["\x66\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],
        ["\x66\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],
        ["\x66\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],
        ["\x66\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],
        ["\x66\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],
        ["\x66\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],
        ["\x66\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],
        ["\x66\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],
        ["\x66\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],
        ["\x66\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],
        ["\x66\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],
        ["\x66\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],
        ["\x66\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],
        ["\x66\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],
        ["\x66\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],
        ["\x66\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],
        ["\x66\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],
        ["\x66\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],
        ["\x66\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],
        ["\x66\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],
        ["\x66\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],
        ["\x66\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],
        ["\x66\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],
        ["\x66\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],
        ["\x66\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],
        ["\x66\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],
        ["\x66\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],
        ["\x66\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],
        ["\x66\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],
        ["\x66\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],
        ["\x66\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],
        ["\x66\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],
        ["\x66\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],
        ["\x66\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],
        ["\x66\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],
        ["\x66\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],
        ["\x66\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],
        ["\x66\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],
        ["\x66\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],
        ["\x66\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],
        ["\x66\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],
        ["\x66\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],
        ["\x66\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],
        ["\x66\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],
        ["\x66\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],
        ["\x66\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],
        ["\x66\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],
        ["\x66\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],
        ["\x66\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],
        ["\x66\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],
        ["\x66\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],
        ["\x66\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],
        ["\x66\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],
        ["\x66\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],
        ["\x66\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],
        ["\x66\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],
        ["\x66\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],
        ["\x66\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],
        ["\x66\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],
        ["\x66\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],
        ["\x66\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],
        ["\x66\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],
        ["\x66\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],
        ["\x66\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],
        ["\x66\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],
        ["\x66\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],
        ["\x66\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],
        ["\x66\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],
        ["\x66\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],
        ["\x66\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],
        ["\x66\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],
        ["\x66\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],
        ["\x66\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],
        ["\x66\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],
        ["\x66\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],
        ["\x66\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],
        ["\x66\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],
        ["\x66\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],
        ["\x67\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],
        ["\x67\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],
        ["\x67\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],
        ["\x67\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],
        ["\x67\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],
        ["\x67\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],
        ["\x67\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],
        ["\x67\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],
        ["\x67\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],
        ["\x67\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],
        ["\x67\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],
        ["\x67\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],
        ["\x67\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],
        ["\x67\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],
        ["\x67\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],
        ["\x67\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],
        ["\x67\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],
        ["\x67\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],
        ["\x67\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],
        ["\x67\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],
        ["\x67\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],
        ["\x67\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],
        ["\x67\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],
        ["\x67\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],
        ["\x67\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],
        ["\x67\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],
        ["\x67\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],
        ["\x67\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],
        ["\x67\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],
        ["\x67\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],
        ["\x67\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],
        ["\x67\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],
        ["\x67\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],
        ["\x67\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],
        ["\x67\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],
        ["\x67\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],
        ["\x67\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],
        ["\x67\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],
        ["\x67\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],
        ["\x67\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],
        ["\x67\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],
        ["\x67\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],
        ["\x67\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],
        ["\x67\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],
        ["\x67\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],
        ["\x67\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],
        ["\x67\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],
        ["\x67\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],
        ["\x67\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],
        ["\x67\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],
        ["\x67\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],
        ["\x67\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],
        ["\x67\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],
        ["\x67\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],
        ["\x67\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],
        ["\x67\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],
        ["\x67\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],
        ["\x67\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],
        ["\x67\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],
        ["\x67\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],
        ["\x67\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],
        ["\x67\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],
        ["\x67\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],
        ["\x67\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],
        ["\x67\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],
        ["\x67\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],
        ["\x67\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],
        ["\x67\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],
        ["\x67\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],
        ["\x67\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],
        ["\x67\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],
        ["\x67\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],
        ["\x67\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],
        ["\x67\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],
        ["\x67\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],
        ["\x67\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],
        ["\x67\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],
        ["\x67\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],
        ["\x67\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],
        ["\x67\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],
        ["\x67\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],
        ["\x67\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],
        ["\x67\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],
        ["\x67\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],
        ["\x67\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],
        ["\x67\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],
        ["\x67\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],
        ["\x67\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],
        ["\x67\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],
        ["\x67\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],
        ["\x67\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],
        ["\x67\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],
        ["\x67\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],
        ["\x67\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],
        ["\x68\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],
        ["\x4C\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],
        ["\x68\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],
        ["\x68\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],
        ["\x68\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],
        ["\x68\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],
        ["\x68\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],
        ["\x68\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],
        ["\x68\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],
        ["\x68\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],
        ["\x68\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],
        ["\x68\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],
        ["\x68\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],
        ["\xD3\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],
        ["\x68\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],
        ["\x68\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],
        ["\x68\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],
        ["\x68\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],
        ["\x68\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],
        ["\x68\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],
        ["\x68\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],
        ["\x68\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],
        ["\x68\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],
        ["\x68\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],
        ["\x68\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],
        ["\x68\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],
        ["\x68\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],
        ["\x68\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],
        ["\x68\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],
        ["\x68\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],
        ["\x68\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],
        ["\x68\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],
        ["\x68\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],
        ["\x68\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],
        ["\x68\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],
        ["\x68\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],
        ["\x68\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],
        ["\x68\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],
        ["\x68\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],
        ["\x68\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],
        ["\x68\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],
        ["\x68\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],
        ["\x68\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],
        ["\x68\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],
        ["\x68\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],
        ["\x68\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],
        ["\x68\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],
        ["\x68\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],
        ["\x68\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],
        ["\x68\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],
        ["\x68\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],
        ["\x68\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],
        ["\x68\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],
        ["\x68\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],
        ["\x68\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],
        ["\x68\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],
        ["\x68\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],
        ["\xF3\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],
        ["\x68\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],
        ["\x68\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],
        ["\x68\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],
        ["\x68\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],
        ["\x68\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],
        ["\x68\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],
        ["\x68\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],
        ["\x68\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],
        ["\x68\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],
        ["\x68\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],
        ["\x68\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],
        ["\x68\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],
        ["\x68\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],
        ["\x68\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],
        ["\x68\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],
        ["\x68\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],
        ["\x68\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],
        ["\x68\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],
        ["\x68\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],
        ["\x68\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],
        ["\x68\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],
        ["\x68\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],
        ["\x68\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],
        ["\x68\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],
        ["\x68\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],
        ["\x68\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],
        ["\x68\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],
        ["\x68\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],
        ["\x68\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],
        ["\x68\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],
        ["\x68\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],
        ["\x68\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],
        ["\x68\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],
        ["\x68\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],
        ["\x68\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],
        ["\x68\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],
        ["\x69\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],
        ["\x69\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],
        ["\x69\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],
        ["\xC7\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],
        ["\x69\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],
        ["\x69\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],
        ["\x69\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],
        ["\x69\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],
        ["\x69\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],
        ["\x69\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],
        ["\x69\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],
        ["\x69\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],
        ["\x69\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],
        ["\x69\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],
        ["\x69\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],
        ["\x69\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],
        ["\x69\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],
        ["\x69\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],
        ["\x69\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],
        ["\x69\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],
        ["\x69\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],
        ["\x69\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],
        ["\x69\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],
        ["\x69\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],
        ["\x69\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],
        ["\x69\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],
        ["\x69\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],
        ["\x69\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],
        ["\x69\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],
        ["\x69\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],
        ["\x69\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],
        ["\x69\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],
        ["\x69\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],
        ["\x69\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],
        ["\x69\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],
        ["\x69\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],
        ["\x69\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],
        ["\x69\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],
        ["\x69\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],
        ["\x69\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],
        ["\x69\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],
        ["\x69\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],
        ["\x69\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],
        ["\x69\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],
        ["\x69\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],
        ["\x69\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],
        ["\x69\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],
        ["\x69\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],
        ["\x69\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],
        ["\x69\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],
        ["\x69\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],
        ["\x69\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],
        ["\x69\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],
        ["\x69\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],
        ["\x69\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],
        ["\x69\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],
        ["\x69\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],
        ["\x69\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],
        ["\x69\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],
        ["\x69\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],
        ["\x69\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],
        ["\x69\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],
        ["\x69\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],
        ["\x69\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],
        ["\x69\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],
        ["\x69\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],
        ["\x69\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],
        ["\x69\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],
        ["\x69\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],
        ["\x69\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],
        ["\x69\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],
        ["\x69\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],
        ["\x69\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],
        ["\x69\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],
        ["\x69\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],
        ["\x69\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],
        ["\x69\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],
        ["\x69\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],
        ["\x69\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],
        ["\x69\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],
        ["\x69\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],
        ["\x69\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],
        ["\x69\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],
        ["\x69\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],
        ["\x69\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],
        ["\x69\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],
        ["\x69\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],
        ["\x69\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],
        ["\x69\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],
        ["\x69\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],
        ["\x69\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],
        ["\x69\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],
        ["\x69\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],
        ["\x69\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],
        ["\x70\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],
        ["\x70\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],
        ["\x70\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],
        ["\x70\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],
        ["\x70\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],
        ["\x70\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],
        ["\x70\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],
        ["\x70\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],
        ["\x70\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],
        ["\x70\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],
        ["\x70\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],
        ["\x70\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],
        ["\x70\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],
        ["\x70\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],
        ["\x70\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],
        ["\x70\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],
        ["\x70\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],
        ["\x70\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],
        ["\x70\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],
        ["\x70\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],
        ["\x70\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],
        ["\x70\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],
        ["\x70\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],
        ["\x70\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],
        ["\x70\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],
        ["\x70\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],
        ["\x70\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],
        ["\x70\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],
        ["\x70\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],
        ["\x70\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],
        ["\x70\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],
        ["\x70\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],
        ["\x70\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],
        ["\x70\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],
        ["\x70\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],
        ["\x70\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],
        ["\x70\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],
        ["\x70\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],
        ["\x70\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],
        ["\x70\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],
        ["\x70\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],
        ["\x70\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],
        ["\x70\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],
        ["\x70\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],
        ["\x70\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],
        ["\x70\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],
        ["\x70\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],
        ["\x70\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],
        ["\x70\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],
        ["\x70\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],
        ["\x70\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],
        ["\x70\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],
        ["\x70\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],
        ["\x70\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],
        ["\x70\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],
        ["\x70\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],
        ["\x70\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],
        ["\x70\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],
        ["\x70\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],
        ["\x70\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],
        ["\xF4\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],
        ["\x70\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],
        ["\x70\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],
        ["\x70\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],
        ["\x70\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],
        ["\x70\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],
        ["\x70\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],
        ["\x70\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],
        ["\x70\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],
        ["\x70\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],
        ["\x70\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],
        ["\x70\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],
        ["\x70\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],
        ["\x70\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],
        ["\x70\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],
        ["\x70\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],
        ["\x70\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],
        ["\x70\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],
        ["\x70\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],
        ["\x70\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],
        ["\x70\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],
        ["\x70\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],
        ["\x70\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],
        ["\x70\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],
        ["\x70\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],
        ["\x70\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],
        ["\x70\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],
        ["\x70\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],
        ["\x70\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],
        ["\x70\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],
        ["\x70\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],
        ["\x70\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],
        ["\x70\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],
        ["\x70\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],
        ["\x71\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],
        ["\x71\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],
        ["\x71\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],
        ["\x71\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],
        ["\x71\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],
        ["\x71\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],
        ["\x71\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],
        ["\x71\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],
        ["\x71\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],
        ["\x71\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],
        ["\x71\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],
        ["\x71\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],
        ["\x71\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],
        ["\x71\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],
        ["\x71\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],
        ["\x71\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],
        ["\x71\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],
        ["\x71\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],
        ["\x71\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],
        ["\x71\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],
        ["\x71\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],
        ["\x71\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],
        ["\x71\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],
        ["\x71\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],
        ["\x71\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],
        ["\x71\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],
        ["\x71\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],
        ["\x71\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],
        ["\x71\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],
        ["\x71\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],
        ["\x71\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],
        ["\x71\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],
        ["\x71\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],
        ["\x71\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],
        ["\x71\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],
        ["\x71\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],
        ["\x71\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],
        ["\x71\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],
        ["\x71\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],
        ["\x71\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],
        ["\x71\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],
        ["\x71\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],
        ["\x71\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],
        ["\x71\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],
        ["\xC1\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],
        ["\x71\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],
        ["\x71\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],
        ["\x71\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],
        ["\x71\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],
        ["\x71\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],
        ["\x71\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],
        ["\x71\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],
        ["\x71\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],
        ["\x71\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],
        ["\x71\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],
        ["\x71\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],
        ["\x71\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],
        ["\x71\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],
        ["\x71\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],
        ["\x71\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],
        ["\x71\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],
        ["\x71\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],
        ["\x71\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],
        ["\x71\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],
        ["\x71\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],
        ["\x71\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],
        ["\x71\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],
        ["\x71\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],
        ["\x71\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],
        ["\x71\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],
        ["\x71\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],
        ["\x71\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],
        ["\x71\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],
        ["\x71\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],
        ["\x71\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],
        ["\x71\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],
        ["\x71\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],
        ["\x71\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],
        ["\x71\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],
        ["\x71\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],
        ["\x71\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],
        ["\x71\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],
        ["\x71\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],
        ["\x71\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],
        ["\x71\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],
        ["\x71\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],
        ["\x71\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],
        ["\x71\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],
        ["\x71\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],
        ["\x71\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],
        ["\x71\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],
        ["\x71\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],
        ["\x71\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],
        ["\x71\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],
        ["\x72\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],
        ["\x72\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],
        ["\x72\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],
        ["\x72\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],
        ["\x72\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],
        ["\x72\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],
        ["\x72\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],
        ["\x72\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],
        ["\x72\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],
        ["\x72\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],
        ["\x72\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],
        ["\x72\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],
        ["\x72\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],
        ["\x72\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],
        ["\x72\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],
        ["\x72\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],
        ["\x72\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],
        ["\x72\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],
        ["\x72\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],
        ["\x72\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],
        ["\x72\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],
        ["\x72\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],
        ["\x72\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],
        ["\x72\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],
        ["\x72\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],
        ["\x72\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],
        ["\x72\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],
        ["\x72\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],
        ["\x72\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],
        ["\x72\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],
        ["\x72\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],
        ["\x72\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],
        ["\x72\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],
        ["\x72\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],
        ["\x72\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],
        ["\x72\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],
        ["\x72\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],
        ["\x72\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],
        ["\x72\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],
        ["\x72\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],
        ["\x72\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],
        ["\x72\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],
        ["\x72\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],
        ["\x72\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],
        ["\x72\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],
        ["\x72\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],
        ["\x72\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],
        ["\x72\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],
        ["\x72\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],
        ["\x72\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],
        ["\x72\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],
        ["\x72\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],
        ["\x72\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],
        ["\x72\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],
        ["\x72\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],
        ["\x72\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],
        ["\x72\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],
        ["\x72\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],
        ["\x72\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],
        ["\x72\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],
        ["\x72\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],
        ["\x72\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],
        ["\x72\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],
        ["\x72\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],
        ["\x72\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],
        ["\x72\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],
        ["\x72\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],
        ["\x72\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],
        ["\x72\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],
        ["\x72\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],
        ["\x72\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],
        ["\x72\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],
        ["\x72\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],
        ["\x72\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],
        ["\x72\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],
        ["\x72\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],
        ["\x72\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],
        ["\xC6\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],
        ["\x72\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],
        ["\x72\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB7"],
        ["\x72\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB8"],
        ["\x72\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB9"],
        ["\x72\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBA"],
        ["\x72\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBB"],
        ["\x72\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBC"],
        ["\x72\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBD"],
        ["\x72\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBE"],
        ["\x72\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBF"],
        ["\x72\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x80"],
        ["\x72\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x81"],
        ["\x72\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x82"],
        ["\x72\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x83"],
        ["\x72\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x84"],
        ["\x72\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x85"],
        ["\x73\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x86"],
        ["\x73\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x87"],
        ["\x73\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x88"],
        ["\x73\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x89"],
        ["\x73\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8A"],
        ["\x73\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8B"],
        ["\x73\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8C"],
        ["\x73\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8D"],
        ["\x73\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8E"],
        ["\x73\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8F"],
        ["\x73\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x90"],
        ["\x73\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x91"],
        ["\x73\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x92"],
        ["\x73\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x93"],
        ["\x73\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x94"],
        ["\x73\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x95"],
        ["\x73\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x96"],
        ["\x73\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x97"],
        ["\x73\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x98"],
        ["\x73\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x99"],
        ["\x73\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9A"],
        ["\x73\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9B"],
        ["\x73\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9C"],
        ["\x73\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9D"],
        ["\x73\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9E"],
        ["\x73\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9F"],
        ["\x73\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA0"],
        ["\x73\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA1"],
        ["\x73\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA2"],
        ["\x73\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA3"],
        ["\x73\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA4"],
        ["\x73\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA5"],
        ["\x73\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA6"],
        ["\x73\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA7"],
        ["\x73\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA8"],
        ["\x73\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA9"],
        ["\x73\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAA"],
        ["\x73\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAB"],
        ["\x73\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAC"],
        ["\x73\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAD"],
        ["\x73\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAE"],
        ["\x73\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAF"],
        ["\x73\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB0"],
        ["\x73\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB1"],
        ["\x73\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB2"],
        ["\x73\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB3"],
        ["\x73\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB4"],
        ["\x73\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB5"],
        ["\x73\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB6"],
        ["\x73\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB7"],
        ["\x73\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB8"],
        ["\x73\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB9"],
        ["\x73\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBA"],
        ["\x73\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBB"],
        ["\x73\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBC"],
        ["\x73\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBD"],
        ["\x73\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBE"],
        ["\x73\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBF"],
        ["\x73\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x80"],
        ["\x73\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x81"],
        ["\x73\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x82"],
        ["\x73\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x83"],
        ["\x73\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x84"],
        ["\x73\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x85"],
        ["\x73\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x86"],
        ["\x73\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x87"],
        ["\x73\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x88"],
        ["\x73\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x89"],
        ["\x73\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8A"],
        ["\x73\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8B"],
        ["\x73\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8C"],
        ["\x73\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8D"],
        ["\x73\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8E"],
        ["\x73\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8F"],
        ["\x73\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x90"],
        ["\x73\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x91"],
        ["\x73\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x92"],
        ["\x73\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x93"],
        ["\x73\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x94"],
        ["\x73\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x95"],
        ["\x73\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x96"],
        ["\x73\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x97"],
        ["\x73\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x98"],
        ["\x73\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x99"],
        ["\x73\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9A"],
        ["\x73\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9B"],
        ["\x73\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9C"],
        ["\x73\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9D"],
        ["\x73\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9E"],
        ["\x73\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9F"],
        ["\x73\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA0"],
        ["\x73\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA1"],
        ["\x73\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA2"],
        ["\x73\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA3"],
        ["\x74\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA4"],
        ["\x74\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA5"],
        ["\x74\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA6"],
        ["\x74\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA7"],
        ["\x74\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA8"],
        ["\x74\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA9"],
        ["\x74\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAA"],
        ["\x74\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAB"],
        ["\x74\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAC"],
        ["\x74\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAD"],
        ["\x74\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAE"],
        ["\x74\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAF"],
        ["\x74\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB0"],
        ["\x74\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB1"],
        ["\x74\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB2"],
        ["\x74\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB3"],
        ["\x74\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB4"],
        ["\x74\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB5"],
        ["\x74\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB6"],
        ["\x74\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB7"],
        ["\x74\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB8"],
        ["\x74\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB9"],
        ["\x74\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBA"],
        ["\x74\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBB"],
        ["\x74\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBC"],
        ["\x74\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBD"],
        ["\x74\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBE"],
        ["\x74\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBF"],
        ["\x74\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x80"],
        ["\x74\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x81"],
        ["\x74\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x82"],
        ["\x74\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x83"],
        ["\x74\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x84"],
        ["\x74\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x85"],
        ["\x74\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x86"],
        ["\x74\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x87"],
        ["\x74\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x88"],
        ["\x74\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x89"],
        ["\x74\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8A"],
        ["\x74\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8B"],
        ["\x74\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8C"],
        ["\x74\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8D"],
        ["\x74\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8E"],
        ["\x74\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8F"],
        ["\x74\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x90"],
        ["\x74\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x91"],
        ["\x74\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x92"],
        ["\x74\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x93"],
        ["\x74\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x94"],
        ["\x74\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x95"],
        ["\x74\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x96"],
        ["\x74\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x97"],
        ["\x74\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x98"],
        ["\x74\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x99"],
        ["\x74\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9A"],
        ["\x74\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9B"],
        ["\x74\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9C"],
        ["\x74\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9D"],
        ["\x74\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9E"],
        ["\x74\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9F"],
        ["\x74\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA0"],
        ["\x74\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA1"],
        ["\x74\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA2"],
        ["\x74\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA3"],
        ["\x74\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA4"],
        ["\x74\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA5"],
        ["\x74\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA6"],
        ["\x74\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA7"],
        ["\x74\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA8"],
        ["\x74\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA9"],
        ["\x74\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAA"],
        ["\x74\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAB"],
        ["\x74\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAC"],
        ["\x74\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAD"],
        ["\x74\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAE"],
        ["\x74\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAF"],
        ["\x74\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB0"],
        ["\x74\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB1"],
        ["\x74\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB2"],
        ["\x74\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB3"],
        ["\x74\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB4"],
        ["\x74\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB5"],
        ["\x74\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB6"],
        ["\x74\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB7"],
        ["\x74\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB8"],
        ["\x74\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB9"],
        ["\x74\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBA"],
        ["\x74\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBB"],
        ["\x74\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBC"],
        ["\x74\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBD"],
        ["\x74\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBE"],
        ["\x74\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBF"],
        ["\x74\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x80"],
        ["\x74\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x81"],
        ["\x75\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x82"],
        ["\x75\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x83"],
        ["\x75\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x84"],
        ["\x75\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x85"],
        ["\x75\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x86"],
        ["\x75\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x87"],
        ["\x75\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x88"],
        ["\x75\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x89"],
        ["\x75\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8A"],
        ["\x75\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8B"],
        ["\x75\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8C"],
        ["\x75\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8D"],
        ["\x75\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8E"],
        ["\x75\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8F"],
        ["\x75\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x90"],
        ["\x75\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x91"],
        ["\x75\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x92"],
        ["\x75\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x93"],
        ["\x75\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x94"],
        ["\x75\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x95"],
        ["\x75\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x96"],
        ["\x75\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x97"],
        ["\x75\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x98"],
        ["\x75\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x99"],
        ["\x75\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9A"],
        ["\x75\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9B"],
        ["\x75\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9C"],
        ["\x75\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9D"],
        ["\x75\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9E"],
        ["\x75\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9F"],
        ["\x75\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA0"],
        ["\x75\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA1"],
        ["\x75\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA2"],
        ["\x75\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA3"],
        ["\x75\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA4"],
        ["\x75\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA5"],
        ["\x75\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA6"],
        ["\x75\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA7"],
        ["\x75\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA8"],
        ["\x75\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA9"],
        ["\x75\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAA"],
        ["\x75\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAB"],
        ["\x75\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAC"],
        ["\x75\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAD"],
        ["\x75\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAE"],
        ["\x75\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAF"],
        ["\x75\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB0"],
        ["\x75\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB1"],
        ["\x75\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB2"],
        ["\x75\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB3"],
        ["\x75\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB4"],
        ["\x75\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB5"],
        ["\x75\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB6"],
        ["\x75\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB7"],
        ["\x6F\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB8"],
        ["\x75\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB9"],
        ["\x75\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBA"],
        ["\x75\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBB"],
        ["\x75\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBC"],
        ["\x75\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBD"],
        ["\x75\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBE"],
        ["\x75\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBF"],
        ["\x75\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x80"],
        ["\x75\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x81"],
        ["\x75\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x82"],
        ["\x75\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x83"],
        ["\x75\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x84"],
        ["\x75\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x85"],
        ["\x75\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x86"],
        ["\x75\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x87"],
        ["\x75\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x88"],
        ["\x75\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x89"],
        ["\x75\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8A"],
        ["\x75\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8B"],
        ["\x75\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8C"],
        ["\x75\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8D"],
        ["\x75\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8E"],
        ["\x75\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8F"],
        ["\x75\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x90"],
        ["\x75\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x91"],
        ["\x75\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x92"],
        ["\x75\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x93"],
        ["\x75\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x94"],
        ["\xF7\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x95"],
        ["\x75\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x96"],
        ["\x75\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x97"],
        ["\x75\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x98"],
        ["\x75\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x99"],
        ["\x75\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9A"],
        ["\x75\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9B"],
        ["\x75\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9C"],
        ["\x75\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9D"],
        ["\x75\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9E"],
        ["\x75\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9F"],
        ["\x76\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA0"],
        ["\x76\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA1"],
        ["\x76\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA2"],
        ["\x76\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA3"],
        ["\x76\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA4"],
        ["\x76\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA5"],
        ["\x76\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA6"],
        ["\x76\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA7"],
        ["\x76\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA8"],
        ["\x76\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA9"],
        ["\x76\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAA"],
        ["\x76\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAB"],
        ["\x76\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAC"],
        ["\x76\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAD"],
        ["\x76\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAE"],
        ["\x76\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAF"],
        ["\x76\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB0"],
        ["\x76\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB1"],
        ["\x76\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB2"],
        ["\x76\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB3"],
        ["\x76\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB4"],
        ["\x76\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB5"],
        ["\x76\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB6"],
        ["\x76\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB7"],
        ["\x76\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB8"],
        ["\x76\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB9"],
        ["\x76\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBA"],
        ["\x76\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBB"],
        ["\x76\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBC"],
        ["\x76\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBD"],
        ["\x76\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBE"],
        ["\x76\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBF"],
        ["\x76\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x80"],
        ["\x76\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x81"],
        ["\x76\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x82"],
        ["\x76\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x83"],
        ["\x76\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x84"],
        ["\x76\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x85"],
        ["\x76\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x86"],
        ["\x76\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x87"],
        ["\x76\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x88"],
        ["\x76\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x89"],
        ["\x76\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8A"],
        ["\x76\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8B"],
        ["\x76\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8C"],
        ["\x76\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8D"],
        ["\x76\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8E"],
        ["\x76\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8F"],
        ["\x76\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x90"],
        ["\x76\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x91"],
        ["\x76\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x92"],
        ["\x76\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x93"],
        ["\x76\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x94"],
        ["\x76\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x95"],
        ["\x76\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x96"],
        ["\x76\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x97"],
        ["\x76\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x98"],
        ["\x76\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x99"],
        ["\x76\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9A"],
        ["\x76\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9B"],
        ["\x76\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9C"],
        ["\x76\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9D"],
        ["\x76\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9E"],
        ["\x76\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9F"],
        ["\x76\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA0"],
        ["\x76\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA1"],
        ["\x76\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA2"],
        ["\x76\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA3"],
        ["\x76\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA4"],
        ["\x76\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA5"],
        ["\x76\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA6"],
        ["\x76\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA7"],
        ["\x76\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA8"],
        ["\x76\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA9"],
        ["\x76\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAA"],
        ["\x76\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAB"],
        ["\x76\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAC"],
        ["\x76\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAD"],
        ["\x76\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAE"],
        ["\x76\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAF"],
        ["\x76\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB0"],
        ["\x76\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB1"],
        ["\x76\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB2"],
        ["\x76\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB3"],
        ["\x76\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB4"],
        ["\x76\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB5"],
        ["\x76\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB6"],
        ["\x76\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB7"],
        ["\x76\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB8"],
        ["\x76\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB9"],
        ["\x76\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBA"],
        ["\x76\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBB"],
        ["\x76\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBC"],
        ["\x76\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBD"],
        ["\x77\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBE"],
        ["\x77\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBF"],
        ["\x77\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x80"],
        ["\x77\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x81"],
        ["\x77\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x82"],
        ["\x77\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x83"],
        ["\x77\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x84"],
        ["\x77\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x85"],
        ["\x77\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x86"],
        ["\x77\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x87"],
        ["\x77\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x88"],
        ["\x77\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x89"],
        ["\x77\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8A"],
        ["\x77\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8B"],
        ["\x77\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8C"],
        ["\x77\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8D"],
        ["\x77\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8E"],
        ["\x77\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8F"],
        ["\x77\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x90"],
        ["\x77\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x91"],
        ["\x77\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x92"],
        ["\x77\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x93"],
        ["\x77\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x94"],
        ["\x77\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x95"],
        ["\x77\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x96"],
        ["\x77\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x97"],
        ["\x77\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x98"],
        ["\x77\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x99"],
        ["\x77\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9A"],
        ["\x77\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9B"],
        ["\x77\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9C"],
        ["\x77\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9D"],
        ["\x77\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9E"],
        ["\x77\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9F"],
        ["\x77\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA0"],
        ["\x77\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA1"],
        ["\x77\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA2"],
        ["\x77\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA3"],
        ["\x77\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA4"],
        ["\x77\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA5"],
        ["\x77\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA6"],
        ["\x77\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA7"],
        ["\x77\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA8"],
        ["\x77\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA9"],
        ["\xF0\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAA"],
        ["\x77\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAB"],
        ["\x77\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAC"],
        ["\x77\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAD"],
        ["\x77\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAE"],
        ["\x77\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAF"],
        ["\x77\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB0"],
        ["\x77\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB1"],
        ["\x77\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB2"],
        ["\x77\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB3"],
        ["\x77\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB4"],
        ["\x77\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB5"],
        ["\x77\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB6"],
        ["\x77\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB7"],
        ["\x77\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB8"],
        ["\x77\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB9"],
        ["\x77\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBA"],
        ["\x77\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBB"],
        ["\x77\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBC"],
        ["\x77\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBD"],
        ["\x77\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBE"],
        ["\x77\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBF"],
        ["\x77\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x80"],
        ["\x77\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x81"],
        ["\x77\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x82"],
        ["\x77\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x83"],
        ["\x77\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x84"],
        ["\x77\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x85"],
        ["\x77\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x86"],
        ["\x77\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x87"],
        ["\x77\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x88"],
        ["\x77\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x89"],
        ["\x77\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8A"],
        ["\x77\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8B"],
        ["\x77\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8C"],
        ["\x77\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8D"],
        ["\x77\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8E"],
        ["\x77\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8F"],
        ["\x77\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x90"],
        ["\xF2\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x91"],
        ["\x77\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x92"],
        ["\x77\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x93"],
        ["\x77\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x94"],
        ["\x77\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x95"],
        ["\x77\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x96"],
        ["\x77\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x97"],
        ["\x77\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x98"],
        ["\x77\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x99"],
        ["\x77\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9A"],
        ["\x77\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9B"],
        ["\x78\x4F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9C"],
        ["\x78\x7F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9D"],
        ["\x78\x7B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9E"],
        ["\x78\xE0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9F"],
        ["\x78\x6C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA0"],
        ["\x78\x50",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA1"],
        ["\x78\x7D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA2"],
        ["\x78\x4D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA3"],
        ["\x78\x5D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA4"],
        ["\x78\x5C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA5"],
        ["\x78\x4E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA6"],
        ["\x78\x6B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA7"],
        ["\x78\x60",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA8"],
        ["\x78\x4B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA9"],
        ["\x78\x61",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAA"],
        ["\x78\xF0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAB"],
        ["\x78\xF1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAC"],
        ["\x78\xF2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAD"],
        ["\x78\xF3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAE"],
        ["\x78\xF4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAF"],
        ["\x78\xF5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB0"],
        ["\x78\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB1"],
        ["\x78\xF7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB2"],
        ["\x78\xF8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB3"],
        ["\x78\xF9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB4"],
        ["\x78\x7A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB5"],
        ["\x78\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB6"],
        ["\x78\x4C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB7"],
        ["\x78\x7E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB8"],
        ["\x78\x6E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB9"],
        ["\x78\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBA"],
        ["\x78\x7C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBB"],
        ["\x78\xC1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBC"],
        ["\x78\xC2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBD"],
        ["\x78\xC3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBE"],
        ["\x78\xC4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBF"],
        ["\x78\xC5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x80"],
        ["\x78\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x81"],
        ["\x78\xC7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x82"],
        ["\x78\xC8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x83"],
        ["\x78\xC9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x84"],
        ["\x78\xD1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x85"],
        ["\x78\xD2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x86"],
        ["\x78\xD3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x87"],
        ["\x78\xD4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x88"],
        ["\x78\xD5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x89"],
        ["\x78\xD6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8A"],
        ["\x78\xD7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8B"],
        ["\x78\xD8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8C"],
        ["\x78\xD9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8D"],
        ["\x78\xE2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8E"],
        ["\x78\xE3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8F"],
        ["\x78\xE4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x90"],
        ["\x78\xE5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x91"],
        ["\x78\xE6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x92"],
        ["\x78\xE7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x93"],
        ["\x78\xE8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x94"],
        ["\x78\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x95"],
        ["\x78\x4A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x96"],
        ["\x78\x5B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x97"],
        ["\x78\x5A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x98"],
        ["\x78\x5F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x99"],
        ["\x78\x6D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9A"],
        ["\x78\x79",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9B"],
        ["\x78\x57",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9C"],
        ["\x78\x59",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9D"],
        ["\x78\x62",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9E"],
        ["\x78\x63",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9F"],
        ["\x78\x64",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA0"],
        ["\x78\x65",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA1"],
        ["\x78\x66",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA2"],
        ["\x78\x67",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA3"],
        ["\x78\x68",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA4"],
        ["\x78\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA5"],
        ["\x78\x70",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA6"],
        ["\x78\x71",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA7"],
        ["\x78\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA8"],
        ["\x78\x73",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA9"],
        ["\x78\x74",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAA"],
        ["\x78\x75",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAB"],
        ["\x78\x76",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAC"],
        ["\x78\x77",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAD"],
        ["\x78\x78",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAE"],
        ["\x78\x80",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAF"],
        ["\x78\x8B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB0"],
        ["\x78\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB1"],
        ["\x78\x9C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB2"],
        ["\x78\xA0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB3"],
        ["\x78\xAB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB4"],
        ["\x78\xB0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB5"],
        ["\x78\xC0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB6"],
        ["\x78\x6A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB7"],
        ["\x78\xD0",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB8"],
        ["\x78\xA1",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB9"],
        ["\xF6\xC6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBA"],
        ["\xD2\x69",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBB"],
        ["\xD4\xE9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBC"],
        ["\x79\x9B",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBD"],
        ["\x84\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBE"],
        ["\x94\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBF"],
        ["\x42\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9C"],
        ["\x42\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9D"],
        ["\x42\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9E"],
        ["\x42\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9F"],
        ["\x42\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA0"],
        ["\x42\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA1"],
        ["\x42\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA2"],
        ["\x42\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA3"],
        ["\x42\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA4"],
        ["\x42\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA5"],
        ["\x45\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB1"],
        ["\x9A\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB8"],
        ["\xA3\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB9"],
        ["\x9F\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBC"],
        ["\x82\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBD"],
        ["\x8E\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBF"],
        ["\x90\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x80"],
        ["\xA7\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x81"],
        ["\x8E\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x82"],
        ["\x82\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x84"],
        ["\x82\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x85"],
        ["\x82\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x87"],
        ["\x82\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x88"],
        ["\x82\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x89"],
        ["\x82\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8A"],
        ["\x82\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8B"],
        ["\x82\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8C"],
        ["\x8A\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8D"],
        ["\x82\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8E"],
        ["\x82\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8F"],
        ["\x83\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x90"],
        ["\x83\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x91"],
        ["\x83\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x92"],
        ["\x83\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x93"],
        ["\x83\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x94"],
        ["\x83\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x95"],
        ["\x83\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x96"],
        ["\x83\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x97"],
        ["\x83\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x99"],
        ["\x83\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9A"],
        ["\x83\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9B"],
        ["\x83\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9C"],
        ["\x84\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9D"],
        ["\x84\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9F"],
        ["\x84\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA0"],
        ["\x84\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA1"],
        ["\x84\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA2"],
        ["\x84\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA3"],
        ["\x84\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA4"],
        ["\x85\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA7"],
        ["\x85\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA8"],
        ["\x85\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA9"],
        ["\x85\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAA"],
        ["\x85\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAC"],
        ["\x85\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAE"],
        ["\x85\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAF"],
        ["\x85\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB0"],
        ["\x86\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB2"],
        ["\x86\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB3"],
        ["\x86\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB4"],
        ["\x86\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB5"],
        ["\x87\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB9"],
        ["\x87\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBA"],
        ["\x87\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBC"],
        ["\x87\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBD"],
        ["\x87\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBF"],
        ["\x87\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x80"],
        ["\x88\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x81"],
        ["\x88\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x82"],
        ["\x88\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x83"],
        ["\x88\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x84"],
        ["\x88\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x86"],
        ["\x88\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x87"],
        ["\x88\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x88"],
        ["\x89\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8D"],
        ["\x89\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8E"],
        ["\x89\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8F"],
        ["\x89\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x90"],
        ["\x89\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x91"],
        ["\x8A\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x92"],
        ["\x8A\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x93"],
        ["\x8A\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x94"],
        ["\x85\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x99"],
        ["\x8C\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9A"],
        ["\x8C\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9B"],
        ["\x8C\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9D"],
        ["\x8C\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9F"],
        ["\x8C\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA0"],
        ["\x86\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA1"],
        ["\x8C\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA2"],
        ["\x8D\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA3"],
        ["\x8D\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA6"],
        ["\x8D\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA7"],
        ["\x8E\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA9"],
        ["\x8E\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAA"],
        ["\x8E\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAC"],
        ["\x8E\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAD"],
        ["\x8E\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAE"],
        ["\x8E\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAF"],
        ["\x8E\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB1"],
        ["\x8E\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB2"],
        ["\x8E\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB4"],
        ["\x8E\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB5"],
        ["\x96\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB6"],
        ["\x8F\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB7"],
        ["\x8F\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB8"],
        ["\x8F\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBA"],
        ["\x8F\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBC"],
        ["\x8F\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBD"],
        ["\x8F\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBE"],
        ["\x8F\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBF"],
        ["\x8F\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x81"],
        ["\x90\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x84"],
        ["\x97\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x86"],
        ["\x90\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x87"],
        ["\x90\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x88"],
        ["\x90\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8A"],
        ["\x90\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8B"],
        ["\x90\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8C"],
        ["\x91\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8E"],
        ["\x91\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8F"],
        ["\x91\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x90"],
        ["\x91\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x91"],
        ["\x91\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x92"],
        ["\x91\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x93"],
        ["\x91\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x94"],
        ["\x92\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x95"],
        ["\x92\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x96"],
        ["\x92\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x97"],
        ["\x92\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x98"],
        ["\x92\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x99"],
        ["\x92\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9D"],
        ["\x92\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9E"],
        ["\x92\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9F"],
        ["\x92\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA1"],
        ["\x93\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA2"],
        ["\x93\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA3"],
        ["\x93\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA4"],
        ["\x93\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA5"],
        ["\x93\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA6"],
        ["\x93\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA7"],
        ["\x93\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA9"],
        ["\x93\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAA"],
        ["\x94\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAB"],
        ["\x94\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAC"],
        ["\x94\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAD"],
        ["\x94\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAE"],
        ["\x94\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAF"],
        ["\x94\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB2"],
        ["\x94\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB3"],
        ["\x94\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB4"],
        ["\x94\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB5"],
        ["\x95\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB7"],
        ["\x95\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB8"],
        ["\x95\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB9"],
        ["\x95\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBA"],
        ["\x95\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBB"],
        ["\x95\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBC"],
        ["\x95\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBD"],
        ["\x95\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBF"],
        ["\x95\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x80"],
        ["\x95\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x81"],
        ["\x95\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x82"],
        ["\x95\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x84"],
        ["\x95\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x85"],
        ["\x96\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x87"],
        ["\x96\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x89"],
        ["\x96\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8B"],
        ["\x96\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8C"],
        ["\x96\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8E"],
        ["\x84\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8F"],
        ["\x97\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x90"],
        ["\x97\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x91"],
        ["\x97\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x92"],
        ["\x97\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x93"],
        ["\x98\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x98"],
        ["\x98\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9A"],
        ["\x98\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9B"],
        ["\x98\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9E"],
        ["\x99\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9F"],
        ["\x9A\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA1"],
        ["\x9A\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA3"],
        ["\x9A\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA6"],
        ["\x90\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA7"],
        ["\x9A\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA8"],
        ["\x9E\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAA"],
        ["\x9E\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAC"],
        ["\x9F\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAD"],
        ["\x9E\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAE"],
        ["\x9F\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAF"],
        ["\x9F\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB0"],
        ["\x9F\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB1"],
        ["\x9F\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB2"],
        ["\x9F\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB3"],
        ["\xA3\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBA"],
        ["\xA3\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBB"],
        ["\xA3\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBC"],
        ["\xA3\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBD"],
        ["\xA3\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBE"],
        ["\xA3\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBF"],
        ["\xA3\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x81"],
        ["\xA3\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x82"],
        ["\xA4\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x84"],
        ["\xA4\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x86"],
        ["\xA4\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x89"],
        ["\xA5\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x90"],
        ["\xA6\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x91"],
        ["\xA6\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x92"],
        ["\xA6\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x93"],
        ["\xA6\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x94"],
        ["\xA6\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x95"],
        ["\xA6\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x96"],
        ["\xA6\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x97"],
        ["\xA6\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x98"],
        ["\xA6\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x99"],
        ["\xA6\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9A"],
        ["\xA6\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9B"],
        ["\xA6\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9C"],
        ["\xA6\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9D"],
        ["\xA6\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9E"],
        ["\xA6\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9F"],
        ["\xA6\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA0"],
        ["\xA6\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA1"],
        ["\xA6\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA2"],
        ["\xA6\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA3"],
        ["\xA6\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA4"],
        ["\xA6\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA6"],
        ["\xA6\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA7"],
        ["\xA6\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA8"],
        ["\xA7\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA9"],
        ["\xA7\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAB"],
        ["\xA6\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAC"],
        ["\xA6\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAD"],
        ["\xA7\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAE"],
        ["\xA7\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAF"],
        ["\xA7\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB0"],
        ["\xA7\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB2"],
        ["\xA7\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB3"],
        ["\xA7\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB4"],
        ["\xA7\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB5"],
        ["\xA7\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB6"],
        ["\xA7\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB7"],
        ["\xA7\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB8"],
        ["\xA7\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB9"],
        ["\xA7\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBA"],
        ["\xA7\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBB"],
        ["\xA7\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBC"],
        ["\xA7\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBD"],
        ["\xA7\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBE"],
        ["\xA8\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x82"],
        ["\xA8\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x83"],
        ["\xA8\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x84"],
        ["\xA8\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x86"],
        ["\xA8\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x88"],
        ["\xA8\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8A"],
        ["\xA9\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8B"],
        ["\xA9\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8C"],
        ["\xA9\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8F"],
        ["\xA9\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x94"],
        ["\xA9\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x95"],
        ["\xA9\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x97"],
        ["\xA9\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x98"],
        ["\xAA\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x99"],
        ["\xAA\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9A"],
        ["\xA8\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9B"],
        ["\xAA\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9C"],
        ["\xAA\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9E"],
        ["\x45\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9E"],
        ["\x45\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9F"],
        ["\x45\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA0"],
        ["\x45\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB8"],
        ["\x45\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB9"],
        ["\x45\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBC"],
        ["\x45\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBD"],
        ["\x43\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBE"],
        ["\x43\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8C"],
        ["\x43\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8D"],
        ["\x43\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8E"],
        ["\x43\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8F"],
        ["\x43\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x90"],
        ["\x43\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x91"],
        ["\x43\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x92"],
        ["\x43\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x93"],
        ["\x43\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x94"],
        ["\x45\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x86"],
        ["\x44\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x89"],
        ["\x45\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBF"],
        ["\x45\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x81"],
        ["\x45\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x83"],
        ["\x45\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x85"],
        ["\x42\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9B"],
        ["\x42\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9C"],
        ["\x45\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x97"],
        ["\x45\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x98"],
        ["\x45\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9D"],
        ["\x45\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9F"],
        ["\x45\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA0"],
        ["\x45\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA3"],
        ["\x45\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA4"],
        ["\x45\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA5"],
        ["\x45\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA7"],
        ["\x45\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA9"],
        ["\x45\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAA"],
        ["\x45\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAC"],
        ["\x45\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAF"],
        ["\x45\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB0"],
        ["\x45\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB1"],
        ["\x45\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB2"],
        ["\x45\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB5"],
        ["\x45\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB6"],
        ["\x45\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB7"],
        ["\x45\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB9"],
        ["\x45\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBC"],
        ["\x45\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBD"],
        ["\x45\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBE"],
        ["\x45\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBF"],
        ["\x45\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x80"],
        ["\x45\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x82"],
        ["\x45\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x83"],
        ["\x45\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x86"],
        ["\x45\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x88"],
        ["\x45\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x89"],
        ["\x45\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8B"],
        ["\x45\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8D"],
        ["\x45\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8E"],
        ["\x45\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8F"],
        ["\x45\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x90"],
        ["\x45\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x93"],
        ["\x45\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x85"],
        ["\x45\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x86"],
        ["\x43\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9A"],
        ["\x43\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9B"],
        ["\x43\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9C"],
        ["\x43\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9D"],
        ["\x43\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9E"],
        ["\x43\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9F"],
        ["\x43\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA0"],
        ["\x43\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA1"],
        ["\x43\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA2"],
        ["\x43\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA3"],
        ["\x42\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB8"],
        ["\x42\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB9"],
        ["\x41\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBA"],
        ["\x41\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBB"],
        ["\x41\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBC"],
        ["\x41\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBD"],
        ["\x41\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBE"],
        ["\x41\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBF"],
        ["\x41\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x80"],
        ["\x41\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x81"],
        ["\x41\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x82"],
        ["\x41\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x83"],
        ["\x41\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x84"],
        ["\x44\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x85"],
        ["\x44\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x86"],
        ["\x44\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x87"],
        ["\x44\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x88"],
        ["\x44\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x89"],
        ["\x44\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8A"],
        ["\x44\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8B"],
        ["\x44\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8C"],
        ["\x44\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8D"],
        ["\x44\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8E"],
        ["\x44\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8F"],
        ["\x44\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x90"],
        ["\x44\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x91"],
        ["\x44\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x92"],
        ["\x44\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x93"],
        ["\x41\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x94"],
        ["\x41\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x95"],
        ["\x41\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x96"],
        ["\x42\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x97"],
        ["\x42\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x98"],
        ["\x42\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x99"],
        ["\x42\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9A"],
        ["\x42\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9B"],
        ["\x42\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9C"],
        ["\x42\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9D"],
        ["\x41\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA4"],
        ["\x41\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA7"],
        ["\x41\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA8"],
        ["\x41\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA9"],
        ["\x41\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAA"],
        ["\x41\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAB"],
        ["\x41\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAC"],
        ["\x42\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\x96"],
        ["\x42\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\xAE"],
        ["\x82\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9B"],
        ["\x82\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9C"],
        ["\x82\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9E"],
        ["\x82\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9F"],
        ["\x82\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA1"],
        ["\x82\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA3"],
        ["\x82\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA7"],
        ["\x82\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA9"],
        ["\x82\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAC"],
        ["\x83\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB2"],
        ["\x82\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB3"],
        ["\x83\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB4"],
        ["\x83\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB5"],
        ["\x83\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBA"],
        ["\x83\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBB"],
        ["\x83\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBC"],
        ["\x83\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBD"],
        ["\x83\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBF"],
        ["\x83\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x80"],
        ["\x83\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x82"],
        ["\x83\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x86"],
        ["\x84\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8C"],
        ["\x84\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8E"],
        ["\x84\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8F"],
        ["\x84\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x93"],
        ["\x84\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x94"],
        ["\x84\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x97"],
        ["\x85\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA4"],
        ["\x85\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA5"],
        ["\x85\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA8"],
        ["\x85\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAC"],
        ["\x85\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB0"],
        ["\x85\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB2"],
        ["\x85\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB3"],
        ["\x85\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB5"],
        ["\x85\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB7"],
        ["\x85\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBA"],
        ["\x85\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x80"],
        ["\x85\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x81"],
        ["\x86\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x83"],
        ["\x86\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x84"],
        ["\x86\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x85"],
        ["\x86\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x86"],
        ["\x86\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x88"],
        ["\x86\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8A"],
        ["\x86\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8C"],
        ["\x86\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8E"],
        ["\x86\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x90"],
        ["\x86\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x94"],
        ["\x86\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x97"],
        ["\x86\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x98"],
        ["\x86\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x99"],
        ["\x86\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA4"],
        ["\x86\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA6"],
        ["\x92\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA8"],
        ["\x86\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA9"],
        ["\xC5\xF6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAB"],
        ["\x86\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAC"],
        ["\x86\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAE"],
        ["\x87\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAF"],
        ["\x87\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB2"],
        ["\x87\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB5"],
        ["\x87\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB6"],
        ["\x87\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB7"],
        ["\x87\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB9"],
        ["\x87\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBA"],
        ["\x87\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBD"],
        ["\x87\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBE"],
        ["\x87\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBF"],
        ["\x87\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x81"],
        ["\x87\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x82"],
        ["\x87\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x83"],
        ["\x87\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x84"],
        ["\x87\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x85"],
        ["\x87\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x87"],
        ["\x87\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x88"],
        ["\x87\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x89"],
        ["\x87\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8B"],
        ["\x88\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8D"],
        ["\x88\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8F"],
        ["\x88\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAA"],
        ["\x88\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAB"],
        ["\x88\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB7"],
        ["\x88\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB8"],
        ["\x88\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB9"],
        ["\x88\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBB"],
        ["\x89\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBF"],
        ["\x89\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x80"],
        ["\x89\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8C"],
        ["\x89\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8E"],
        ["\xE6\x5E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\x83\xBE"],
        ["\x89\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x93"],
        ["\x89\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x94"],
        ["\x89\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x95"],
        ["\x8A\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x96"],
        ["\x8A\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x98"],
        ["\x8A\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9C"],
        ["\x8A\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA0"],
        ["\x8A\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA1"],
        ["\x8A\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA2"],
        ["\x8A\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA6"],
        ["\x8A\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA8"],
        ["\x8A\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA9"],
        ["\x8A\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAA"],
        ["\xA5\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAB"],
        ["\x8A\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAC"],
        ["\x8A\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAF"],
        ["\x8A\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB1"],
        ["\x8C\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB2"],
        ["\x8C\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB3"],
        ["\x8C\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB4"],
        ["\x8C\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB6"],
        ["\x8C\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB8"],
        ["\x8C\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBA"],
        ["\x8C\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBB"],
        ["\x8C\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x81"],
        ["\x8C\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x82"],
        ["\x8C\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x86"],
        ["\x8C\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x88"],
        ["\x8C\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8B"],
        ["\x8D\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8D"],
        ["\x8D\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8E"],
        ["\x8D\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8F"],
        ["\x8D\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x92"],
        ["\x8D\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x93"],
        ["\x8D\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x94"],
        ["\x8A\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x95"],
        ["\x8D\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x96"],
        ["\x8D\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x97"],
        ["\x8D\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x98"],
        ["\x8D\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x99"],
        ["\x8D\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9B"],
        ["\x8D\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA6"],
        ["\x8D\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA7"],
        ["\x8D\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA9"],
        ["\x8D\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAA"],
        ["\x8D\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAE"],
        ["\x8D\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB0"],
        ["\x8E\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB8"],
        ["\x8E\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBA"],
        ["\x8E\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBB"],
        ["\x8E\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x80"],
        ["\x8E\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x84"],
        ["\x8E\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x87"],
        ["\x8E\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x88"],
        ["\x8E\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x89"],
        ["\x8F\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8D"],
        ["\x8F\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8F"],
        ["\x8F\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x92"],
        ["\x8F\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x94"],
        ["\x8F\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x96"],
        ["\x8F\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x98"],
        ["\x8F\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9A"],
        ["\x8F\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9C"],
        ["\x8F\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9D"],
        ["\x8F\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9E"],
        ["\x8F\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA0"],
        ["\x8F\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA2"],
        ["\x8F\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA6"],
        ["\x8F\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA8"],
        ["\x8F\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAF"],
        ["\x90\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB1"],
        ["\x90\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB2"],
        ["\x90\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB3"],
        ["\x90\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB4"],
        ["\x90\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB5"],
        ["\x90\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB6"],
        ["\x90\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB7"],
        ["\x90\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBA"],
        ["\x90\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBB"],
        ["\x90\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBD"],
        ["\x90\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x80"],
        ["\x90\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8C"],
        ["\x90\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x91"],
        ["\x90\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x92"],
        ["\x90\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x94"],
        ["\x90\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x98"],
        ["\x91\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9E"],
        ["\x91\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA1"],
        ["\x91\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA4"],
        ["\x91\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA5"],
        ["\x91\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA6"],
        ["\x91\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAB"],
        ["\x91\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAD"],
        ["\x91\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAF"],
        ["\x91\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB4"],
        ["\x91\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB5"],
        ["\x91\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB6"],
        ["\x91\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBB"],
        ["\x91\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBE"],
        ["\x91\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x80"],
        ["\x91\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x81"],
        ["\x91\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x82"],
        ["\x91\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x83"],
        ["\x91\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x84"],
        ["\x92\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x87"],
        ["\x92\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x88"],
        ["\x92\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8A"],
        ["\x92\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8D"],
        ["\x92\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8F"],
        ["\x92\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x92"],
        ["\x92\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x95"],
        ["\x92\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x96"],
        ["\x92\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x97"],
        ["\x92\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9E"],
        ["\x92\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA0"],
        ["\x93\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA2"],
        ["\x93\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA4"],
        ["\x93\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA7"],
        ["\x93\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA9"],
        ["\x93\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAB"],
        ["\x93\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAD"],
        ["\x93\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAE"],
        ["\x93\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB0"],
        ["\x93\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB1"],
        ["\x93\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB3"],
        ["\x93\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB4"],
        ["\x93\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB5"],
        ["\x93\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB7"],
        ["\x93\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBC"],
        ["\x93\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBD"],
        ["\x93\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x83"],
        ["\x93\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x86"],
        ["\x8E\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x89"],
        ["\x93\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8B"],
        ["\x94\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8C"],
        ["\x94\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8D"],
        ["\x94\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8E"],
        ["\x94\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x91"],
        ["\x94\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x99"],
        ["\x94\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9B"],
        ["\x94\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9E"],
        ["\x94\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA0"],
        ["\x94\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA3"],
        ["\x94\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA5"],
        ["\x94\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA8"],
        ["\x94\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAB"],
        ["\x94\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAE"],
        ["\x94\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB1"],
        ["\x95\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB5"],
        ["\x95\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB6"],
        ["\x95\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBD"],
        ["\x95\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBF"],
        ["\x95\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x81"],
        ["\x95\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x84"],
        ["\x95\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x85"],
        ["\x95\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x88"],
        ["\x95\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8A"],
        ["\x95\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8D"],
        ["\x95\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x90"],
        ["\x95\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x92"],
        ["\x95\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x93"],
        ["\x95\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x97"],
        ["\x95\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x98"],
        ["\x95\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9B"],
        ["\x96\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9E"],
        ["\x96\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9F"],
        ["\x95\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA0"],
        ["\x96\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA3"],
        ["\x96\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA4"],
        ["\x96\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA5"],
        ["\x96\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA6"],
        ["\x96\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAC"],
        ["\x96\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAD"],
        ["\x96\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB0"],
        ["\x96\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB1"],
        ["\x96\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB5"],
        ["\x96\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB6"],
        ["\x96\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB8"],
        ["\x96\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBD"],
        ["\x96\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBE"],
        ["\x96\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x80"],
        ["\x96\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x86"],
        ["\x96\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x89"],
        ["\x96\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8A"],
        ["\x96\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8D"],
        ["\x96\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x90"],
        ["\x96\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x92"],
        ["\x96\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x94"],
        ["\x96\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x96"],
        ["\x96\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x97"],
        ["\x97\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9C"],
        ["\x97\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9E"],
        ["\x97\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA0"],
        ["\x97\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA4"],
        ["\x97\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA5"],
        ["\x97\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA9"],
        ["\x97\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAC"],
        ["\x97\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAD"],
        ["\x97\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB0"],
        ["\x97\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB1"],
        ["\x97\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB9"],
        ["\x98\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x83"],
        ["\x98\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x84"],
        ["\x89\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x85"],
        ["\x99\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x87"],
        ["\x98\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x89"],
        ["\x98\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8B"],
        ["\x98\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8D"],
        ["\x98\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8E"],
        ["\x96\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x91"],
        ["\x98\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x92"],
        ["\x98\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x96"],
        ["\x98\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x98"],
        ["\x99\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9A"],
        ["\x99\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9C"],
        ["\x99\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9E"],
        ["\x99\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9F"],
        ["\x99\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA0"],
        ["\x99\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA4"],
        ["\x99\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA5"],
        ["\x99\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA7"],
        ["\x96\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA9"],
        ["\x99\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAE"],
        ["\x99\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAF"],
        ["\x99\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB0"],
        ["\x99\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB2"],
        ["\x99\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB3"],
        ["\x99\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB6"],
        ["\x99\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB7"],
        ["\x99\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB9"],
        ["\x99\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBA"],
        ["\x99\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBB"],
        ["\x99\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBC"],
        ["\x9A\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBD"],
        ["\x9A\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBE"],
        ["\x9A\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x80"],
        ["\x9A\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x84"],
        ["\x9A\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x86"],
        ["\x9A\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x87"],
        ["\x9A\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8D"],
        ["\x9A\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8E"],
        ["\x9A\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8F"],
        ["\x9A\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x91"],
        ["\x9A\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x98"],
        ["\x9A\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x99"],
        ["\x9A\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9A"],
        ["\x9A\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9B"],
        ["\x9A\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9D"],
        ["\x9A\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9E"],
        ["\x9D\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA0"],
        ["\x9D\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA2"],
        ["\x9D\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA3"],
        ["\x9D\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA9"],
        ["\x9D\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAB"],
        ["\x9D\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAC"],
        ["\xAA\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB0"],
        ["\x9D\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB9"],
        ["\x9D\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBB"],
        ["\x9E\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBF"],
        ["\x9E\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x81"],
        ["\x9E\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x87"],
        ["\x9E\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x91"],
        ["\x9E\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x96"],
        ["\x9E\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x98"],
        ["\x9E\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x99"],
        ["\x9E\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9E"],
        ["\x9F\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA9"],
        ["\x9F\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB9"],
        ["\xA2\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBD"],
        ["\xA2\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBF"],
        ["\xA2\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x83"],
        ["\xA2\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x86"],
        ["\xA2\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x87"],
        ["\xA2\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x88"],
        ["\xA2\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8D"],
        ["\xA2\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x92"],
        ["\xA2\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x93"],
        ["\xA2\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x97"],
        ["\xA2\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9C"],
        ["\xA2\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA3"],
        ["\xA2\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA4"],
        ["\xA2\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA5"],
        ["\xA2\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA6"],
        ["\xA3\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAD"],
        ["\xA3\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAE"],
        ["\xA3\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAF"],
        ["\xA3\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB3"],
        ["\xA3\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB6"],
        ["\xA3\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB9"],
        ["\xA3\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBA"],
        ["\xA3\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBC"],
        ["\xA3\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBD"],
        ["\xA3\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBE"],
        ["\xA3\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBF"],
        ["\xA3\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x80"],
        ["\x86\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8A"],
        ["\xA3\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8B"],
        ["\xA3\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8C"],
        ["\xA4\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8F"],
        ["\xA4\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x92"],
        ["\xA4\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x95"],
        ["\xA4\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9A"],
        ["\xA4\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9B"],
        ["\xA4\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9C"],
        ["\xA4\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9D"],
        ["\xA4\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA1"],
        ["\xA4\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA5"],
        ["\xA4\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA6"],
        ["\xA4\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA7"],
        ["\xA4\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA9"],
        ["\x84\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAB"],
        ["\xA4\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAC"],
        ["\xA4\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAD"],
        ["\xA5\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAE"],
        ["\xA5\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAF"],
        ["\xA5\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB1"],
        ["\xA5\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB3"],
        ["\xA5\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB8"],
        ["\xA5\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB9"],
        ["\xA5\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBC"],
        ["\xA5\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBD"],
        ["\xA5\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBF"],
        ["\xA5\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x81"],
        ["\xA5\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x82"],
        ["\xA5\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x86"],
        ["\xA5\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8A"],
        ["\xA5\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8B"],
        ["\xA5\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8C"],
        ["\xA5\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8F"],
        ["\xA6\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x91"],
        ["\xA4\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x94"],
        ["\xA6\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x96"],
        ["\xA6\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9A"],
        ["\xA6\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9B"],
        ["\xA6\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9D"],
        ["\xA6\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA2"],
        ["\xA6\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA3"],
        ["\xA7\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAD"],
        ["\xA7\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB1"],
        ["\xA7\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB3"],
        ["\xA7\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB9"],
        ["\xA7\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBC"],
        ["\xA7\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBD"],
        ["\xA7\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBE"],
        ["\xA7\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBF"],
        ["\xA7\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x80"],
        ["\xA7\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x82"],
        ["\xA7\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x83"],
        ["\xA7\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x85"],
        ["\xA2\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x88"],
        ["\xA8\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8B"],
        ["\xA8\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8C"],
        ["\xA8\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8D"],
        ["\xA8\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x92"],
        ["\x86\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x93"],
        ["\xA8\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x97"],
        ["\xAA\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x99"],
        ["\xA8\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9B"],
        ["\xA8\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA0"],
        ["\xA3\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA2"],
        ["\xA8\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA4"],
        ["\xAA\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA7"],
        ["\xA8\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA8"],
        ["\xA8\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAA"],
        ["\xA8\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAE"],
        ["\xA8\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAF"],
        ["\xA8\xEC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB0"],
        ["\xA8\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB3"],
        ["\xA8\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB4"],
        ["\xA9\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB7"],
        ["\xC5\x6F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB8"],
        ["\xA9\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBB"],
        ["\xA9\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBC"],
        ["\xA9\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBD"],
        ["\xA9\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x81"],
        ["\xA9\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x82"],
        ["\xA9\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x85"],
        ["\xA9\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x86"],
        ["\xA9\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x87"],
        ["\xA9\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x90"],
        ["\xA9\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x91"],
        ["\xA9\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x95"],
        ["\xA9\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x96"],
        ["\xA9\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x97"],
        ["\xA9\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9A"],
        ["\xA9\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9D"],
        ["\xAA\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA0"],
        ["\xAA\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA1"],
        ["\xAA\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA5"],
        ["\xAA\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA9"],
        ["\xAA\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAA"],
        ["\xAA\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAC"],
        ["\xAA\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAD"],
        ["\xAA\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAE"],
        ["\xAA\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAF"],
        ["\xAA\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB0"],
        ["\xAA\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB4"],
        ["\xAA\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB6"],
        ["\xAA\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x81"],
        ["\xAA\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x82"],
        ["\xF9\x72",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x84"],
        ["\xAA\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x88"],
        ["\xAA\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x89"],
        ["\x8A\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8B"],
        ["\xAA\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8C"],
        ["\x86\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8E"],
        ["\x82\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x95"],
        ["\x82\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x99"],
        ["\x82\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9A"],
        ["\x82\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA7"],
        ["\x82\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAD"],
        ["\x82\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB0"],
        ["\x82\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB1"],
        ["\x82\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB6"],
        ["\x82\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB7"],
        ["\x82\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBB"],
        ["\x82\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x83"],
        ["\x82\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x84"],
        ["\x82\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x85"],
        ["\x82\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x86"],
        ["\x82\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x87"],
        ["\x83\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8A"],
        ["\x83\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8B"],
        ["\x83\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8D"],
        ["\x83\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8E"],
        ["\x83\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x96"],
        ["\x83\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x97"],
        ["\x83\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x98"],
        ["\x83\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x99"],
        ["\x83\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA7"],
        ["\x83\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB0"],
        ["\x88\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBF"],
        ["\x88\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x87"],
        ["\x88\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x98"],
        ["\x89\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9A"],
        ["\x89\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9D"],
        ["\x89\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9F"],
        ["\x89\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA8"],
        ["\x89\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAE"],
        ["\x89\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB0"],
        ["\x89\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB1"],
        ["\x89\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBC"],
        ["\x89\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x81"],
        ["\x89\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x83"],
        ["\x89\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x84"],
        ["\x89\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x87"],
        ["\x85\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9C"],
        ["\x84\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9F"],
        ["\x84\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA3"],
        ["\x84\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA4"],
        ["\x84\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA6"],
        ["\x84\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB8"],
        ["\x84\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBB"],
        ["\x9A\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBC"],
        ["\x84\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x80"],
        ["\x85\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x84"],
        ["\x85\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8E"],
        ["\x85\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8F"],
        ["\x85\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x99"],
        ["\x85\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA4"],
        ["\x85\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAC"],
        ["\x85\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAD"],
        ["\x85\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB1"],
        ["\x85\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB2"],
        ["\x85\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB4"],
        ["\x85\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB5"],
        ["\x85\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBB"],
        ["\x85\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x88"],
        ["\x86\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8C"],
        ["\x86\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x90"],
        ["\x86\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x91"],
        ["\x86\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9E"],
        ["\x86\x92",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA1"],
        ["\x86\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAE"],
        ["\x86\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB6"],
        ["\x86\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBA"],
        ["\x86\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x83"],
        ["\x86\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x87"],
        ["\x86\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8B"],
        ["\x86\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8C"],
        ["\x86\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8F"],
        ["\x87\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x97"],
        ["\x86\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x98"],
        ["\x87\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9C"],
        ["\x87\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA4"],
        ["\x87\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA8"],
        ["\x87\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB3"],
        ["\x87\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB6"],
        ["\x87\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB9"],
        ["\x87\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBB"],
        ["\x87\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBD"],
        ["\x87\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBF"],
        ["\x87\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x88"],
        ["\x87\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x89"],
        ["\x87\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8C"],
        ["\x87\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8D"],
        ["\x88\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x93"],
        ["\x88\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9B"],
        ["\x88\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9D"],
        ["\x88\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9F"],
        ["\x88\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA1"],
        ["\x88\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA6"],
        ["\x88\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA7"],
        ["\x8A\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB6"],
        ["\x82\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB7"],
        ["\x8A\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB8"],
        ["\x8A\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x83"],
        ["\x8A\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x87"],
        ["\x8A\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x89"],
        ["\x8A\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8A"],
        ["\x8A\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8B"],
        ["\x8A\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8C"],
        ["\x8C\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x90"],
        ["\x84\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x95"],
        ["\x8C\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9A"],
        ["\x8C\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9B"],
        ["\x8C\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA4"],
        ["\x8C\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA5"],
        ["\x8C\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA7"],
        ["\x8C\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAD"],
        ["\x8C\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB0"],
        ["\x8C\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB1"],
        ["\x8C\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB4"],
        ["\x8C\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB5"],
        ["\x8C\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB7"],
        ["\x8C\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB9"],
        ["\x8C\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBE"],
        ["\x8D\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x80"],
        ["\x8D\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x81"],
        ["\x8D\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8A"],
        ["\x8F\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8C"],
        ["\x8A\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x93"],
        ["\x8D\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x97"],
        ["\x8D\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x98"],
        ["\x8D\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9E"],
        ["\x8A\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA6"],
        ["\x8D\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAB"],
        ["\x8D\xAA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAD"],
        ["\x8D\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB3"],
        ["\x8D\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBC"],
        ["\x8D\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x81"],
        ["\x8D\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x84"],
        ["\x8D\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8D"],
        ["\x8E\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x94"],
        ["\x8E\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x95"],
        ["\x8E\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x99"],
        ["\x8E\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9A"],
        ["\x8E\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9C"],
        ["\x8E\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9D"],
        ["\x8E\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9E"],
        ["\x8E\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA0"],
        ["\x8E\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA1"],
        ["\x8E\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA6"],
        ["\x8E\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAA"],
        ["\x8E\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAB"],
        ["\x8E\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB1"],
        ["\x8E\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB5"],
        ["\x8F\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB6"],
        ["\x8F\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBD"],
        ["\x8F\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x83"],
        ["\x8F\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x86"],
        ["\x8F\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8B"],
        ["\x8F\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x96"],
        ["\x8F\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x99"],
        ["\x8F\xCF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA2"],
        ["\x84\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA7"],
        ["\x8F\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB1"],
        ["\x90\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB5"],
        ["\x90\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB7"],
        ["\x90\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x83"],
        ["\x90\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x84"],
        ["\x90\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x87"],
        ["\x90\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8E"],
        ["\x90\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x98"],
        ["\x89\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9A"],
        ["\x90\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9C"],
        ["\x90\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA1"],
        ["\x90\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAA"],
        ["\x90\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAE"],
        ["\x90\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB2"],
        ["\x90\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBB"],
        ["\x90\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x81"],
        ["\x90\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x82"],
        ["\x91\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x89"],
        ["\x91\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8E"],
        ["\x91\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8F"],
        ["\x91\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x96"],
        ["\x91\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x97"],
        ["\x91\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9B"],
        ["\x91\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9C"],
        ["\x91\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9D"],
        ["\xA6\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA9"],
        ["\x91\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAC"],
        ["\x8D\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAD"],
        ["\xA8\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAE"],
        ["\x91\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB2"],
        ["\x91\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB7"],
        ["\x91\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBB"],
        ["\x91\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBD"],
        ["\x91\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBF"],
        ["\x91\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x84"],
        ["\x91\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x87"],
        ["\x92\x42",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x88"],
        ["\x92\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8B"],
        ["\x92\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8C"],
        ["\x92\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8F"],
        ["\x92\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x92"],
        ["\x92\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x96"],
        ["\x92\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA7"],
        ["\x92\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA8"],
        ["\x92\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAB"],
        ["\x92\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAC"],
        ["\x92\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAE"],
        ["\x92\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBA"],
        ["\x92\xCC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBB"],
        ["\x92\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBD"],
        ["\x92\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBE"],
        ["\x92\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x84"],
        ["\x93\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x89"],
        ["\x93\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x90"],
        ["\x93\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x98"],
        ["\x93\x94",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x99"],
        ["\x93\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9A"],
        ["\x93\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9E"],
        ["\x93\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA3"],
        ["\x93\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAF"],
        ["\x93\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB7"],
        ["\x93\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB8"],
        ["\x98\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB9"],
        ["\x93\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBD"],
        ["\x83\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBE"],
        ["\x94\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x87"],
        ["\x94\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x88"],
        ["\x94\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8C"],
        ["\x94\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x90"],
        ["\x94\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x91"],
        ["\x8E\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x93"],
        ["\x94\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x98"],
        ["\x94\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9A"],
        ["\x9A\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAC"],
        ["\x94\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAF"],
        ["\x94\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB3"],
        ["\x94\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB4"],
        ["\x94\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB7"],
        ["\x94\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB8"],
        ["\x94\xDB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBD"],
        ["\x94\xDF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x85"],
        ["\xA2\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x88"],
        ["\x94\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x89"],
        ["\x94\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8B"],
        ["\x95\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8E"],
        ["\x95\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x95"],
        ["\x95\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x96"],
        ["\x95\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x99"],
        ["\x95\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9A"],
        ["\x95\x82",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9B"],
        ["\x95\x8C",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA0"],
        ["\x95\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA3"],
        ["\x95\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA4"],
        ["\x95\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA7"],
        ["\x95\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA9"],
        ["\x95\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAA"],
        ["\x95\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAB"],
        ["\x95\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAD"],
        ["\x95\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB2"],
        ["\x95\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB4"],
        ["\x95\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBB"],
        ["\x95\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x80"],
        ["\x96\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x81"],
        ["\x96\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x93"],
        ["\x96\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x96"],
        ["\x96\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9A"],
        ["\x96\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9D"],
        ["\x96\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9E"],
        ["\x96\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA7"],
        ["\x96\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB2"],
        ["\x96\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB9"],
        ["\x96\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBD"],
        ["\x96\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x80"],
        ["\x96\xB2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8D"],
        ["\x96\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA0"],
        ["\x96\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA2"],
        ["\x96\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA7"],
        ["\x96\xFD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA9"],
        ["\x97\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAC"],
        ["\x97\x47",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAE"],
        ["\x82\xDC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAF"],
        ["\x97\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB4"],
        ["\x97\x53",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB5"],
        ["\x97\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB8"],
        ["\x97\x96",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x84"],
        ["\x97\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x86"],
        ["\x97\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x89"],
        ["\x97\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8D"],
        ["\x97\x9F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8E"],
        ["\xA7\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x91"],
        ["\x97\xA5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x92"],
        ["\x97\xBC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x99"],
        ["\x97\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9C"],
        ["\x97\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9E"],
        ["\x97\xFA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9F"],
        ["\x98\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA2"],
        ["\x98\x83",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA8"],
        ["\x98\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAC"],
        ["\x98\x95",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB1"],
        ["\x98\x9D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB2"],
        ["\x98\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB4"],
        ["\x98\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB5"],
        ["\x98\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB8"],
        ["\x98\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBA"],
        ["\x98\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBE"],
        ["\x98\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x81"],
        ["\x98\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x88"],
        ["\x98\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8C"],
        ["\x99\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x98"],
        ["\x99\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9B"],
        ["\x99\x44",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9D"],
        ["\x99\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA5"],
        ["\x99\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA6"],
        ["\x99\x56",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA7"],
        ["\x99\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAC"],
        ["\x99\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAD"],
        ["\x99\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB1"],
        ["\x99\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB6"],
        ["\x99\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB8"],
        ["\x96\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBC"],
        ["\x99\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBE"],
        ["\x99\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x87"],
        ["\x99\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x90"],
        ["\x99\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x95"],
        ["\xA9\x8A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9A"],
        ["\x99\xED",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9E"],
        ["\x99\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9F"],
        ["\x9A\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA6"],
        ["\x9A\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA8"],
        ["\x9A\x51",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAE"],
        ["\x9A\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB4"],
        ["\x9A\x55",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB5"],
        ["\x9A\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBE"],
        ["\x9A\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x81"],
        ["\x9A\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x88"],
        ["\x9A\x97",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x89"],
        ["\x9A\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8A"],
        ["\x9A\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8F"],
        ["\x9A\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x90"],
        ["\x9A\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x93"],
        ["\x9A\xBE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9A"],
        ["\x9A\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9B"],
        ["\x9A\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9F"],
        ["\x9A\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA1"],
        ["\x9A\xCA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA2"],
        ["\x9A\xEA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAD"],
        ["\x9A\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB0"],
        ["\x9A\xFE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB2"],
        ["\x9D\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB3"],
        ["\x9D\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB6"],
        ["\x9D\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBB"],
        ["\x9D\x52",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBD"],
        ["\x9D\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x81"],
        ["\x9D\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8B"],
        ["\x9D\x91",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x93"],
        ["\x9D\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAA"],
        ["\x8F\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAC"],
        ["\x9D\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB4"],
        ["\x9D\xBB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB5"],
        ["\x9D\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB8"],
        ["\x9D\xBF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBA"],
        ["\x9D\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x89"],
        ["\x9E\x48",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x94"],
        ["\x9E\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA7"],
        ["\x9E\xEF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB3"],
        ["\x9F\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB8"],
        ["\x9F\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB9"],
        ["\x9F\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBD"],
        ["\x9F\x9A",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x88"],
        ["\x9F\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x92"],
        ["\x9F\xCB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA5"],
        ["\xA2\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x89"],
        ["\xA2\xA2",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8B"],
        ["\xA2\xA3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8C"],
        ["\xA2\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x95"],
        ["\xA2\xAF",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA4"],
        ["\xA2\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAE"],
        ["\xA2\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB9"],
        ["\xA2\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x89"],
        ["\xA2\xB5",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8B"],
        ["\xA2\xB8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8D"],
        ["\xA2\xB9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8F"],
        ["\xA5\xA9",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x94"],
        ["\xA2\xCE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x95"],
        ["\xA2\xEE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9F"],
        ["\xA3\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA4"],
        ["\xA3\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA6"],
        ["\x9A\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB3"],
        ["\xA3\x90",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB6"],
        ["\xA3\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x81"],
        ["\xA3\xAD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x87"],
        ["\xA3\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x88"],
        ["\xA3\xA8",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x89"],
        ["\xA3\xB6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8E"],
        ["\xA3\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8F"],
        ["\xA3\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x97"],
        ["\xA4\x43",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA3"],
        ["\xA4\x45",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA8"],
        ["\xA4\x46",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA9"],
        ["\x9D\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAB"],
        ["\xA4\x85",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB7"],
        ["\xA4\x89",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB9"],
        ["\xA4\x99",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x81"],
        ["\xA4\xFB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xBB"],
        ["\xA5\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x87"],
        ["\xA6\xB4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x8B"],
        ["\xA6\xCD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x93"],
        ["\xA8\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x9D"],
        ["\x86\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA5"],
        ["\xA8\x88",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xAD"],
        ["\xA8\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x90"],
        ["\xA8\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x98"],
        ["\x93\x58",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9B"],
        ["\xA9\xBA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAA"],
        ["\xA9\xB3",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB8"],
        ["\xA9\xB7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBC"],
        ["\xA9\xDA",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x88"],
        ["\xA9\xFC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x90"],
        ["\xAA\x41",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x93"],
        ["\xAA\x54",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x98"],
        ["\xAA\x49",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x99"],
        ["\xAA\x81",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9D"],
        ["\xAA\x84",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA8"],
        ["\xAA\x86",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA9"],
        ["\xAA\x87",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAB"],
        ["\xAA\x8D",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB9"],
        ["\xAA\x8E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBD"],
        ["\xAA\x8F",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBE"],
        ["\xAA\x93",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x84"],
        ["\xAA\x98",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x89"],
        ["\xAA\xA4",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x92"],
        ["\xAA\xA6",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x99"],
        ["\xAA\xA7",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9C"],
        ["\xAA\xAC",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9E"],
        ["\xA8\x9E",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA0"],
        ["\xAA\xAE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA3"],
        ["\xAA\xBD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB1"],
        ["\xAA\xDD",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x84"],
        ["\xAA\xDE",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x86"],
        ["\xAA\xEB",'utf8jp','jipse',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x89"],
    );
    eval 'use Test::Simply tests => ' . scalar(@test);
}

require 'jacode4e.pl';

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
