#############################################################
# This file was automatically generated on 2024-02-27.      #
#                                                           #
# Perl Bindings Version 2.1.32                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletServoV2 - Drives up to 10 RC Servos

=cut

package Tinkerforge::BrickletServoV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Servo Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2157;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Servo Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'Servo Bricklet 2.0';

=item CALLBACK_POSITION_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_POSITION_REACHED callback.

=cut

use constant CALLBACK_POSITION_REACHED => 27;

=item FUNCTION_GET_STATUS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS => 1;

=item FUNCTION_SET_ENABLE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ENABLE => 2;

=item FUNCTION_GET_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ENABLED => 3;

=item FUNCTION_SET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_POSITION => 4;

=item FUNCTION_GET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_POSITION => 5;

=item FUNCTION_GET_CURRENT_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_POSITION => 6;

=item FUNCTION_GET_CURRENT_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_VELOCITY => 7;

=item FUNCTION_SET_MOTION_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MOTION_CONFIGURATION => 8;

=item FUNCTION_GET_MOTION_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MOTION_CONFIGURATION => 9;

=item FUNCTION_SET_PULSE_WIDTH

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_PULSE_WIDTH => 10;

=item FUNCTION_GET_PULSE_WIDTH

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PULSE_WIDTH => 11;

=item FUNCTION_SET_DEGREE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEGREE => 12;

=item FUNCTION_GET_DEGREE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEGREE => 13;

=item FUNCTION_SET_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_PERIOD => 14;

=item FUNCTION_GET_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_PERIOD => 15;

=item FUNCTION_GET_SERVO_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SERVO_CURRENT => 16;

=item FUNCTION_SET_SERVO_CURRENT_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SERVO_CURRENT_CONFIGURATION => 17;

=item FUNCTION_GET_SERVO_CURRENT_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SERVO_CURRENT_CONFIGURATION => 18;

=item FUNCTION_SET_INPUT_VOLTAGE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_INPUT_VOLTAGE_CONFIGURATION => 19;

=item FUNCTION_GET_INPUT_VOLTAGE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_INPUT_VOLTAGE_CONFIGURATION => 20;

=item FUNCTION_GET_OVERALL_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_OVERALL_CURRENT => 21;

=item FUNCTION_GET_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_INPUT_VOLTAGE => 22;

=item FUNCTION_SET_CURRENT_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CURRENT_CALIBRATION => 23;

=item FUNCTION_GET_CURRENT_CALIBRATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_CALIBRATION => 24;

=item FUNCTION_SET_POSITION_REACHED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_POSITION_REACHED_CALLBACK_CONFIGURATION => 25;

=item FUNCTION_GET_POSITION_REACHED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_POSITION_REACHED_CALLBACK_CONFIGURATION => 26;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_STATUS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ENABLE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MOTION_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MOTION_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_PULSE_WIDTH} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_PULSE_WIDTH} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEGREE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DEGREE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SERVO_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SERVO_CURRENT_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SERVO_CURRENT_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_INPUT_VOLTAGE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_INPUT_VOLTAGE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_OVERALL_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_CURRENT_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_CALIBRATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_POSITION_REACHED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_POSITION_REACHED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_POSITION_REACHED} = shared_clone([12, 'S s']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_status()

Returns the status information of the Servo Bricklet 2.0.

The status includes

* for each channel if it is enabled or disabled,
* for each channel the current position,
* for each channel the current velocity,
* for each channel the current usage and
* the input voltage.

Please note that the position and the velocity is a snapshot of the
current position and velocity of the servo in motion.

=cut

sub get_status
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS, [], '', 72, '?10 s10 s10 S10 S');
}

=item set_enable()

Enables a servo channel (0 to 9). If a servo is enabled, the configured position,
velocity, acceleration, etc. are applied immediately.

=cut

sub set_enable
{
	my ($self, $servo_channel, $enable) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ENABLE, [$servo_channel, $enable], 'S ?', 0, '');
}

=item get_enabled()

Returns *true* if the specified servo channel is enabled, *false* otherwise.

=cut

sub get_enabled
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ENABLED, [$servo_channel], 'S', 9, '?');
}

=item set_position()

Sets the position in °/100 for the specified servo channel.

The default range of the position is -9000 to 9000, but it can be specified
according to your servo with :func:`Set Degree`.

If you want to control a linear servo or RC brushless motor controller or
similar with the Servo Brick, you can also define lengths or speeds with
:func:`Set Degree`.

=cut

sub set_position
{
	my ($self, $servo_channel, $position) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_POSITION, [$servo_channel, $position], 'S s', 0, '');
}

=item get_position()

Returns the position of the specified servo channel as set by :func:`Set Position`.

=cut

sub get_position
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_POSITION, [$servo_channel], 'S', 10, 's');
}

=item get_current_position()

Returns the *current* position of the specified servo channel. This may not be the
value of :func:`Set Position` if the servo is currently approaching a
position goal.

=cut

sub get_current_position
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_POSITION, [$servo_channel], 'S', 10, 's');
}

=item get_current_velocity()

Returns the *current* velocity of the specified servo channel. This may not be the
velocity specified by :func:`Set Motion Configuration`. if the servo is
currently approaching a velocity goal.

=cut

sub get_current_velocity
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_VELOCITY, [$servo_channel], 'S', 10, 'S');
}

=item set_motion_configuration()

Sets the maximum velocity of the specified servo channel in °/100s as well as
the acceleration and deceleration in °/100s²

With a velocity of 0 °/100s the position will be set immediately (no velocity).

With an acc-/deceleration of 0 °/100s² the velocity will be set immediately
(no acc-/deceleration).

=cut

sub set_motion_configuration
{
	my ($self, $servo_channel, $velocity, $acceleration, $deceleration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MOTION_CONFIGURATION, [$servo_channel, $velocity, $acceleration, $deceleration], 'S L L L', 0, '');
}

=item get_motion_configuration()

Returns the motion configuration as set by :func:`Set Motion Configuration`.

=cut

sub get_motion_configuration
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MOTION_CONFIGURATION, [$servo_channel], 'S', 20, 'L L L');
}

=item set_pulse_width()

Sets the minimum and maximum pulse width of the specified servo channel in µs.

Usually, servos are controlled with a
`PWM <https://en.wikipedia.org/wiki/Pulse-width_modulation>`__, whereby the
length of the pulse controls the position of the servo. Every servo has
different minimum and maximum pulse widths, these can be specified with
this function.

If you have a datasheet for your servo that specifies the minimum and
maximum pulse width, you should set the values accordingly. If your servo
comes without any datasheet you have to find the values via trial and error.

Both values have a range from 1 to 65535 (unsigned 16-bit integer). The
minimum must be smaller than the maximum.

The default values are 1000µs (1ms) and 2000µs (2ms) for minimum and
maximum pulse width.

=cut

sub set_pulse_width
{
	my ($self, $servo_channel, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_PULSE_WIDTH, [$servo_channel, $min, $max], 'S L L', 0, '');
}

=item get_pulse_width()

Returns the minimum and maximum pulse width for the specified servo channel as set by
:func:`Set Pulse Width`.

=cut

sub get_pulse_width
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PULSE_WIDTH, [$servo_channel], 'S', 16, 'L L');
}

=item set_degree()

Sets the minimum and maximum degree for the specified servo channel (by default
given as °/100).

This only specifies the abstract values between which the minimum and maximum
pulse width is scaled. For example: If you specify a pulse width of 1000µs
to 2000µs and a degree range of -90° to 90°, a call of :func:`Set Position`
with 0 will result in a pulse width of 1500µs
(-90° = 1000µs, 90° = 2000µs, etc.).

Possible usage:

* The datasheet of your servo specifies a range of 200° with the middle position
  at 110°. In this case you can set the minimum to -9000 and the maximum to 11000.
* You measure a range of 220° on your servo and you don't have or need a middle
  position. In this case you can set the minimum to 0 and the maximum to 22000.
* You have a linear servo with a drive length of 20cm, In this case you could
  set the minimum to 0 and the maximum to 20000. Now you can set the Position
  with :func:`Set Position` with a resolution of cm/100. Also the velocity will
  have a resolution of cm/100s and the acceleration will have a resolution of
  cm/100s².
* You don't care about units and just want the highest possible resolution. In
  this case you should set the minimum to -32767 and the maximum to 32767.
* You have a brushless motor with a maximum speed of 10000 rpm and want to
  control it with a RC brushless motor controller. In this case you can set the
  minimum to 0 and the maximum to 10000. :func:`Set Position` now controls the rpm.

Both values have a possible range from -32767 to 32767
(signed 16-bit integer). The minimum must be smaller than the maximum.

The default values are -9000 and 9000 for the minimum and maximum degree.

=cut

sub set_degree
{
	my ($self, $servo_channel, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEGREE, [$servo_channel, $min, $max], 'S s s', 0, '');
}

=item get_degree()

Returns the minimum and maximum degree for the specified servo channel as set by
:func:`Set Degree`.

=cut

sub get_degree
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEGREE, [$servo_channel], 'S', 12, 's s');
}

=item set_period()

Sets the period of the specified servo channel in µs.

Usually, servos are controlled with a
`PWM <https://en.wikipedia.org/wiki/Pulse-width_modulation>`__. Different
servos expect PWMs with different periods. Most servos run well with a
period of about 20ms.

If your servo comes with a datasheet that specifies a period, you should
set it accordingly. If you don't have a datasheet and you have no idea
what the correct period is, the default value (19.5ms) will most likely
work fine.

The minimum possible period is 1µs and the maximum is 1000000µs.

The default value is 19.5ms (19500µs).

=cut

sub set_period
{
	my ($self, $servo_channel, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_PERIOD, [$servo_channel, $period], 'S L', 0, '');
}

=item get_period()

Returns the period for the specified servo channel as set by :func:`Set Period`.

=cut

sub get_period
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_PERIOD, [$servo_channel], 'S', 12, 'L');
}

=item get_servo_current()

Returns the current consumption of the specified servo channel in mA.

=cut

sub get_servo_current
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SERVO_CURRENT, [$servo_channel], 'S', 10, 'S');
}

=item set_servo_current_configuration()

Sets the averaging duration of the current measurement for the specified servo channel in ms.

=cut

sub set_servo_current_configuration
{
	my ($self, $servo_channel, $averaging_duration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SERVO_CURRENT_CONFIGURATION, [$servo_channel, $averaging_duration], 'S C', 0, '');
}

=item get_servo_current_configuration()

Returns the servo current configuration for the specified servo channel as set
by :func:`Set Servo Current Configuration`.

=cut

sub get_servo_current_configuration
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SERVO_CURRENT_CONFIGURATION, [$servo_channel], 'S', 9, 'C');
}

=item set_input_voltage_configuration()

Sets the averaging duration of the input voltage measurement for the specified servo channel in ms.

=cut

sub set_input_voltage_configuration
{
	my ($self, $averaging_duration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_INPUT_VOLTAGE_CONFIGURATION, [$averaging_duration], 'C', 0, '');
}

=item get_input_voltage_configuration()

Returns the input voltage configuration as set by :func:`Set Input Voltage Configuration`.

=cut

sub get_input_voltage_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_INPUT_VOLTAGE_CONFIGURATION, [], '', 9, 'C');
}

=item get_overall_current()

Returns the current consumption of all servos together in mA.

=cut

sub get_overall_current
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_OVERALL_CURRENT, [], '', 10, 'S');
}

=item get_input_voltage()

Returns the input voltage in mV. The input voltage is
given via the black power input connector on the Servo Brick.

=cut

sub get_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item set_current_calibration()

Sets an offset value (in mA) for each channel.

Note: On delivery the Servo Bricklet 2.0 is already calibrated.

=cut

sub set_current_calibration
{
	my ($self, $offset) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CURRENT_CALIBRATION, [$offset], 's10', 0, '');
}

=item get_current_calibration()

Returns the current calibration as set by :func:`Set Current Calibration`.

=cut

sub get_current_calibration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_CALIBRATION, [], '', 28, 's10');
}

=item set_position_reached_callback_configuration()

Enable/Disable :cb:`Position Reached` callback.

=cut

sub set_position_reached_callback_configuration
{
	my ($self, $servo_channel, $enabled) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_POSITION_REACHED_CALLBACK_CONFIGURATION, [$servo_channel, $enabled], 'S ?', 0, '');
}

=item get_position_reached_callback_configuration()

Returns the callback configuration as set by
:func:`Set Position Reached Callback Configuration`.

=cut

sub get_position_reached_callback_configuration
{
	my ($self, $servo_channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_POSITION_REACHED_CALLBACK_CONFIGURATION, [$servo_channel], 'S', 9, '?');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
