# Generated by default/object.tt
package Paws::Batch::Secret;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has ValueFrom => (is => 'ro', isa => 'Str', request_name => 'valueFrom', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::Secret

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::Secret object:

  $service_obj->Method(Att1 => { Name => $value, ..., ValueFrom => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::Secret object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

An object representing the secret to expose to your container. Secrets
can be exposed to a container in the following ways:

=over

=item *

To inject sensitive data into your containers as environment variables,
use the C<secrets> container definition parameter.

=item *

To reference sensitive information in the log configuration of a
container, use the C<secretOptions> container definition parameter.

=back

For more information, see Specifying sensitive data
(https://docs.aws.amazon.com/batch/latest/userguide/specifying-sensitive-data.html)
in the I<AWS Batch User Guide>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the secret.


=head2 B<REQUIRED> ValueFrom => Str

The secret to expose to the container. The supported values are either
the full ARN of the AWS Secrets Manager secret or the full ARN of the
parameter in the AWS Systems Manager Parameter Store.

If the AWS Systems Manager Parameter Store parameter exists in the same
Region as the job you're launching, then you can use either the full
ARN or name of the parameter. If the parameter exists in a different
Region, then the full ARN must be specified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

