# Generated by default/object.tt
package Paws::Glue::ColumnImportance;
  use Moose;
  has ColumnName => (is => 'ro', isa => 'Str');
  has Importance => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::ColumnImportance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::ColumnImportance object:

  $service_obj->Method(Att1 => { ColumnName => $value, ..., Importance => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::ColumnImportance object:

  $result = $service_obj->Method(...);
  $result->Att1->ColumnName

=head1 DESCRIPTION

A structure containing the column name and column importance score for
a column.

Column importance helps you understand how columns contribute to your
model, by identifying which columns in your records are more important
than others.

=head1 ATTRIBUTES


=head2 ColumnName => Str

The name of a column.


=head2 Importance => Num

The column importance score for the column, as a decimal.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

