# Do not edit!!! This test suite generated by t/Policy/ControlStructures/prohibit_negative_expressions_in_unless_and_until_conditions.PL.

use strict;
use warnings;
use Perl::Lint::Policy::ControlStructures::ProhibitNegativeExpressionsInUnlessAndUntilConditions;
use t::Policy::Util qw/fetch_violations/;
use Test::Base::Less;

my $class_name = 'ControlStructures::ProhibitNegativeExpressionsInUnlessAndUntilConditions';

filters {
    params => [qw/eval/],
};

for my $block (blocks) {
    my $violations = fetch_violations($class_name, $block->input, $block->params);
    is scalar @$violations, $block->failures, $block->dscr;
}

done_testing;

__DATA__


===
--- dscr: "!" within positive control structures
--- failures: 0
--- params:
--- input
if (! $foo) {
    blah();
}

if ($foo) {
    blah($foo);
}
elsif (! $bar) {
    blah($bar);
}
else {
    blah(undef);
}

while (! $foo) {
    blah();
}

foreach my $bar ( grep { ! $_ } @foo ) {
    blah($bar);
}

for (my $bar = 0; ! $bar; $bar++) {
    blah($bar);
}

===
--- dscr: "!" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if ! $foo;

blah() while ! $foo;

blah($_) for grep { ! $_ } @foo;

===
--- dscr: "!" within negative control structures
--- failures: 2
--- params:
--- input
unless (! $foo) {
    blah();
}

until (! $foo) {
    blah();
}

===
--- dscr: "!" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless ! $foo;

blah() until ! $foo;

===
--- dscr: "not" within positive control structures
--- failures: 0
--- params:
--- input
if (not $foo) {
    blah();
}

if ($foo) {
    blah($foo);
}
elsif (not $bar) {
    blah($bar);
}
else {
    blah(undef);
}

while (not $foo) {
    blah();
}

foreach my $bar ( grep { not $_ } @foo ) {
    blah($bar);
}

for (my $bar = 0; not $bar; $bar++) {
    blah($bar);
}

===
--- dscr: "not" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if not $foo;

blah() while not $foo;

blah($_) for grep { not $_ } @foo;

===
--- dscr: "not" within negative control structures
--- failures: 2
--- params:
--- input
unless (not $foo) {
    blah();
}

until (not $foo) {
    blah();
}

===
--- dscr: "not" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless not $foo;

blah() until not $foo;
===
--- dscr: "ne" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo ne $bar) {
    blah();
}

if ($foo ne $bar) {
    blah($foo);
}
elsif ($bar ne $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo ne $bar) {
    blah();
}

foreach my $bar ( grep { $_ ne $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar ne $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "ne" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo ne $bar;

blah() while $foo ne $bar;

blah($_) for grep { $_ ne $bar } @foo;

===
--- dscr: "ne" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo ne $bar) {
    blah();
}

until ($foo ne $bar) {
    blah();
}

===
--- dscr: "ne" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo ne $bar;

blah() until $foo ne $bar;

===
--- dscr: "!=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo != $bar) {
    blah();
}

if ($foo != $bar) {
    blah($foo);
}
elsif ($bar != $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo != $bar) {
    blah();
}

foreach my $bar ( grep { $_ != $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar != $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "!=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo != $bar;

blah() while $foo != $bar;

blah($_) for grep { $_ != $bar } @foo;

===
--- dscr: "!=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo != $bar) {
    blah();
}

until ($foo != $bar) {
    blah();
}

===
--- dscr: "!=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo != $bar;

blah() until $foo != $bar;

===
--- dscr: "<" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo < $bar) {
    blah();
}

if ($foo < $bar) {
    blah($foo);
}
elsif ($bar < $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo < $bar) {
    blah();
}

foreach my $bar ( grep { $_ < $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar < $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo < $bar;

blah() while $foo < $bar;

blah($_) for grep { $_ < $bar } @foo;

===
--- dscr: "<" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo < $bar) {
    blah();
}

until ($foo < $bar) {
    blah();
}

===
--- dscr: "<" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo < $bar;

blah() until $foo < $bar;

===
--- dscr: ">" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo > $bar) {
    blah();
}

if ($foo > $bar) {
    blah($foo);
}
elsif ($bar > $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo > $bar) {
    blah();
}

foreach my $bar ( grep { $_ > $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar > $baz; $bar++) {
    blah($bar);
}

===
--- dscr: ">" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo > $bar;

blah() while $foo > $bar;

blah($_) for grep { $_ > $bar } @foo;

===
--- dscr: ">" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo > $bar) {
    blah();
}

until ($foo > $bar) {
    blah();
}

===
--- dscr: ">" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo > $bar;

blah() until $foo > $bar;

===
--- dscr: "<=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo <= $bar) {
    blah();
}

if ($foo <= $bar) {
    blah($foo);
}
elsif ($bar <= $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo <= $bar) {
    blah();
}

foreach my $bar ( grep { $_ <= $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar <= $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo <= $bar;

blah() while $foo <= $bar;

blah($_) for grep { $_ <= $bar } @foo;

===
--- dscr: "<=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo <= $bar) {
    blah();
}

until ($foo <= $bar) {
    blah();
}

===
--- dscr: "<=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo <= $bar;

blah() until $foo <= $bar;

===
--- dscr: ">=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo >= $bar) {
    blah();
}

if ($foo >= $bar) {
    blah($foo);
}
elsif ($bar >= $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo >= $bar) {
    blah();
}

foreach my $bar ( grep { $_ >= $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar >= $baz; $bar++) {
    blah($bar);
}

===
--- dscr: ">=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo >= $bar;

blah() while $foo >= $bar;

blah($_) for grep { $_ >= $bar } @foo;

===
--- dscr: ">=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo >= $bar) {
    blah();
}

until ($foo >= $bar) {
    blah();
}

===
--- dscr: ">=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo >= $bar;

blah() until $foo >= $bar;

===
--- dscr: "<=>" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo <=> $bar) {
    blah();
}

if ($foo <=> $bar) {
    blah($foo);
}
elsif ($bar <=> $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo <=> $bar) {
    blah();
}

foreach my $bar ( grep { $_ <=> $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar <=> $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<=>" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo <=> $bar;

blah() while $foo <=> $bar;

blah($_) for grep { $_ <=> $bar } @foo;

===
--- dscr: "<=>" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo <=> $bar) {
    blah();
}

until ($foo <=> $bar) {
    blah();
}

===
--- dscr: "<=>" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo <=> $bar;

blah() until $foo <=> $bar;

===
--- dscr: "lt" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo lt $bar) {
    blah();
}

if ($foo lt $bar) {
    blah($foo);
}
elsif ($bar lt $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo lt $bar) {
    blah();
}

foreach my $bar ( grep { $_ lt $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar lt $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "lt" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo lt $bar;

blah() while $foo lt $bar;

blah($_) for grep { $_ lt $bar } @foo;

===
--- dscr: "lt" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo lt $bar) {
    blah();
}

until ($foo lt $bar) {
    blah();
}

===
--- dscr: "lt" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo lt $bar;

blah() until $foo lt $bar;

===
--- dscr: "gt" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo gt $bar) {
    blah();
}

if ($foo gt $bar) {
    blah($foo);
}
elsif ($bar gt $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo gt $bar) {
    blah();
}

foreach my $bar ( grep { $_ gt $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar gt $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "gt" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo gt $bar;

blah() while $foo gt $bar;

blah($_) for grep { $_ gt $bar } @foo;

===
--- dscr: "gt" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo gt $bar) {
    blah();
}

until ($foo gt $bar) {
    blah();
}

===
--- dscr: "gt" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo gt $bar;

blah() until $foo gt $bar;

===
--- dscr: "le" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo le $bar) {
    blah();
}

if ($foo le $bar) {
    blah($foo);
}
elsif ($bar le $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo le $bar) {
    blah();
}

foreach my $bar ( grep { $_ le $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar le $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "le" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo le $bar;

blah() while $foo le $bar;

blah($_) for grep { $_ le $bar } @foo;

===
--- dscr: "le" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo le $bar) {
    blah();
}

until ($foo le $bar) {
    blah();
}

===
--- dscr: "le" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo le $bar;

blah() until $foo le $bar;

===
--- dscr: "ge" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo ge $bar) {
    blah();
}

if ($foo ge $bar) {
    blah($foo);
}
elsif ($bar ge $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo ge $bar) {
    blah();
}

foreach my $bar ( grep { $_ ge $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar ge $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "ge" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo ge $bar;

blah() while $foo ge $bar;

blah($_) for grep { $_ ge $bar } @foo;

===
--- dscr: "ge" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo ge $bar) {
    blah();
}

until ($foo ge $bar) {
    blah();
}

===
--- dscr: "ge" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo ge $bar;

blah() until $foo ge $bar;

===
--- dscr: "cmp" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo cmp $bar) {
    blah();
}

if ($foo cmp $bar) {
    blah($foo);
}
elsif ($bar cmp $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo cmp $bar) {
    blah();
}

foreach my $bar ( grep { $_ cmp $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar cmp $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "cmp" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo cmp $bar;

blah() while $foo cmp $bar;

blah($_) for grep { $_ cmp $bar } @foo;

===
--- dscr: "cmp" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo cmp $bar) {
    blah();
}

until ($foo cmp $bar) {
    blah();
}

===
--- dscr: "cmp" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo cmp $bar;

blah() until $foo cmp $bar;


===
--- dscr: "!~" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo !~ m/bar/) {
    blah();
}

if ($foo) {
    blah($foo);
}
elsif ($bar !~ m/bar/) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo !~ m/bar/) {
    blah();
}

foreach my $bar ( grep { $_ !~ m/baz/ } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar =~ m/baz/; $bar++) {
    blah($bar);
}

===
--- dscr: "!~" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo !~ m/bar/;

blah() while $foo !~ m/bar/;

blah($_) for grep { $_ !~ m/bar/ } @foo;

===
--- dscr: "!~" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo !~ m/bar/) {
    blah();
}

until ($foo !~ m/bar/) {
    blah();
}

===
--- dscr: "!~" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo !~ m/bar/;

blah() until $foo !~ m/bar/;

===
--- dscr: no lint
--- failures: 0
--- params:
--- input
unless ($foo !~ m/bar/) { ## no lint
    blah();
}

until ($foo !~ m/bar/) { ## no lint
    blah();
}

===
--- dscr: "ne" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo ne $bar) {
    blah();
}

if ($foo ne $bar) {
    blah($foo);
}
elsif ($bar ne $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo ne $bar) {
    blah();
}

foreach my $bar ( grep { $_ ne $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar ne $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "ne" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo ne $bar;

blah() while $foo ne $bar;

blah($_) for grep { $_ ne $bar } @foo;

===
--- dscr: "ne" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo ne $bar) {
    blah();
}

until ($foo ne $bar) {
    blah();
}

===
--- dscr: "ne" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo ne $bar;

blah() until $foo ne $bar;

===
--- dscr: "!=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo != $bar) {
    blah();
}

if ($foo != $bar) {
    blah($foo);
}
elsif ($bar != $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo != $bar) {
    blah();
}

foreach my $bar ( grep { $_ != $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar != $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "!=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo != $bar;

blah() while $foo != $bar;

blah($_) for grep { $_ != $bar } @foo;

===
--- dscr: "!=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo != $bar) {
    blah();
}

until ($foo != $bar) {
    blah();
}

===
--- dscr: "!=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo != $bar;

blah() until $foo != $bar;

===
--- dscr: "<" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo < $bar) {
    blah();
}

if ($foo < $bar) {
    blah($foo);
}
elsif ($bar < $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo < $bar) {
    blah();
}

foreach my $bar ( grep { $_ < $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar < $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo < $bar;

blah() while $foo < $bar;

blah($_) for grep { $_ < $bar } @foo;

===
--- dscr: "<" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo < $bar) {
    blah();
}

until ($foo < $bar) {
    blah();
}

===
--- dscr: "<" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo < $bar;

blah() until $foo < $bar;

===
--- dscr: ">" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo > $bar) {
    blah();
}

if ($foo > $bar) {
    blah($foo);
}
elsif ($bar > $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo > $bar) {
    blah();
}

foreach my $bar ( grep { $_ > $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar > $baz; $bar++) {
    blah($bar);
}

===
--- dscr: ">" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo > $bar;

blah() while $foo > $bar;

blah($_) for grep { $_ > $bar } @foo;

===
--- dscr: ">" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo > $bar) {
    blah();
}

until ($foo > $bar) {
    blah();
}

===
--- dscr: ">" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo > $bar;

blah() until $foo > $bar;

===
--- dscr: "<=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo <= $bar) {
    blah();
}

if ($foo <= $bar) {
    blah($foo);
}
elsif ($bar <= $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo <= $bar) {
    blah();
}

foreach my $bar ( grep { $_ <= $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar <= $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo <= $bar;

blah() while $foo <= $bar;

blah($_) for grep { $_ <= $bar } @foo;

===
--- dscr: "<=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo <= $bar) {
    blah();
}

until ($foo <= $bar) {
    blah();
}

===
--- dscr: "<=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo <= $bar;

blah() until $foo <= $bar;

===
--- dscr: ">=" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo >= $bar) {
    blah();
}

if ($foo >= $bar) {
    blah($foo);
}
elsif ($bar >= $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo >= $bar) {
    blah();
}

foreach my $bar ( grep { $_ >= $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar >= $baz; $bar++) {
    blah($bar);
}

===
--- dscr: ">=" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo >= $bar;

blah() while $foo >= $bar;

blah($_) for grep { $_ >= $bar } @foo;

===
--- dscr: ">=" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo >= $bar) {
    blah();
}

until ($foo >= $bar) {
    blah();
}

===
--- dscr: ">=" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo >= $bar;

blah() until $foo >= $bar;

===
--- dscr: "<=>" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo <=> $bar) {
    blah();
}

if ($foo <=> $bar) {
    blah($foo);
}
elsif ($bar <=> $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo <=> $bar) {
    blah();
}

foreach my $bar ( grep { $_ <=> $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar <=> $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "<=>" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo <=> $bar;

blah() while $foo <=> $bar;

blah($_) for grep { $_ <=> $bar } @foo;

===
--- dscr: "<=>" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo <=> $bar) {
    blah();
}

until ($foo <=> $bar) {
    blah();
}

===
--- dscr: "<=>" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo <=> $bar;

blah() until $foo <=> $bar;

===
--- dscr: "lt" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo lt $bar) {
    blah();
}

if ($foo lt $bar) {
    blah($foo);
}
elsif ($bar lt $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo lt $bar) {
    blah();
}

foreach my $bar ( grep { $_ lt $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar lt $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "lt" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo lt $bar;

blah() while $foo lt $bar;

blah($_) for grep { $_ lt $bar } @foo;

===
--- dscr: "lt" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo lt $bar) {
    blah();
}

until ($foo lt $bar) {
    blah();
}

===
--- dscr: "lt" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo lt $bar;

blah() until $foo lt $bar;

===
--- dscr: "gt" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo gt $bar) {
    blah();
}

if ($foo gt $bar) {
    blah($foo);
}
elsif ($bar gt $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo gt $bar) {
    blah();
}

foreach my $bar ( grep { $_ gt $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar gt $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "gt" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo gt $bar;

blah() while $foo gt $bar;

blah($_) for grep { $_ gt $bar } @foo;

===
--- dscr: "gt" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo gt $bar) {
    blah();
}

until ($foo gt $bar) {
    blah();
}

===
--- dscr: "gt" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo gt $bar;

blah() until $foo gt $bar;

===
--- dscr: "le" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo le $bar) {
    blah();
}

if ($foo le $bar) {
    blah($foo);
}
elsif ($bar le $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo le $bar) {
    blah();
}

foreach my $bar ( grep { $_ le $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar le $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "le" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo le $bar;

blah() while $foo le $bar;

blah($_) for grep { $_ le $bar } @foo;

===
--- dscr: "le" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo le $bar) {
    blah();
}

until ($foo le $bar) {
    blah();
}

===
--- dscr: "le" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo le $bar;

blah() until $foo le $bar;

===
--- dscr: "ge" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo ge $bar) {
    blah();
}

if ($foo ge $bar) {
    blah($foo);
}
elsif ($bar ge $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo ge $bar) {
    blah();
}

foreach my $bar ( grep { $_ ge $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar ge $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "ge" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo ge $bar;

blah() while $foo ge $bar;

blah($_) for grep { $_ ge $bar } @foo;

===
--- dscr: "ge" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo ge $bar) {
    blah();
}

until ($foo ge $bar) {
    blah();
}

===
--- dscr: "ge" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo ge $bar;

blah() until $foo ge $bar;

===
--- dscr: "cmp" within positive control structures
--- failures: 0
--- params:
--- input
if ($foo cmp $bar) {
    blah();
}

if ($foo cmp $bar) {
    blah($foo);
}
elsif ($bar cmp $baz) {
    blah($bar);
}
else {
    blah(undef);
}

while ($foo cmp $bar) {
    blah();
}

foreach my $bar ( grep { $_ cmp $baz } @foo ) {
    blah($bar);
}

for (my $bar = 0; $bar cmp $baz; $bar++) {
    blah($bar);
}

===
--- dscr: "cmp" within positive postfix statement modifiers
--- failures: 0
--- params:
--- input
blah() if $foo cmp $bar;

blah() while $foo cmp $bar;

blah($_) for grep { $_ cmp $bar } @foo;

===
--- dscr: "cmp" within negative control structures
--- failures: 2
--- params:
--- input
unless ($foo cmp $bar) {
    blah();
}

until ($foo cmp $bar) {
    blah();
}

===
--- dscr: "cmp" within negative postfix statement modifiers
--- failures: 2
--- params:
--- input
blah() unless $foo cmp $bar;

blah() until $foo cmp $bar;

