use strict;
use warnings;

package POE::Filter::MessagePack;

# ABSTRACT: A dead-simple POE::Filter for MessagePack

use Data::MessagePack;
use Data::MessagePack::Stream;
use POE::Filter;

use vars qw($VERSION @ISA);
$VERSION = '1.001';
@ISA     = qw(POE::Filter);

sub MP ()     { 0 }
sub STREAM () { 1 }

my $mp = Data::MessagePack->new;

sub new {
    my $type = shift;
    my $self =
      bless [ Data::MessagePack->new(), Data::MessagePack::Stream->new(), ],
      $type;
    $self;
}

sub get {
    my ( $self, $chunks ) = @_;
    my @ret;
    push @ret, $self->[STREAM]->data while $self->[STREAM]->next;
    return \@ret;
}

sub get_one_start {
    my ( $self, $stream ) = @_;
    $self->[STREAM]->feed( join '', @$stream );
}

sub get_one {
    my $self = shift;
    my $obj  = $self->[STREAM]->next;
    return $obj ? [ $self->[STREAM]->data ] : [];
}

sub put {
    my ( $self, $chunks ) = @_;
    [ map { $mp->pack($_) } @$chunks ];
}

1;
