#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 505_Slurm-SAAssoc-parse.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);
#use Data::Dumper;

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::Association;

my $testDir = dirname(abs_path($0));
my $num_tests_run = 0; 

#Set up expected results
my @fakedata =
(	
	{ testname=>'root assoc',
		account=>'root', parentid=>0, parentname=>undef,
	},
	{ testname=>'root assoc (root)',
		account=>'root', user=>'root',
	},
		
	{ testname=>'abc124 main',
		account=>'abc124', 
		maxcpumins=>60000, maxcpus=>100, maxjobs=>1000, 
		maxnodes=>5,  maxsubmitjobs=>2000, maxwall=>4000,
		grpcpumins=>90000, grpcpus=>150, grpjobs=>1500,
		grpnodes => 7, grpsubmitjobs=>3000, grpwall=>6000,
		qos=>'high,normal',
	},
	{ testname=>'abc124 payerle',
		account=>'abc124', 
		parentid => 3, parentname=>'abc124',
		user=>'payerle',
		maxcpumins=>40000,
	},
);
my @fake_data = ();
my $tmpid = 0;
foreach my $fakedatum (@fakedata)
{	my $tstname = delete $fakedatum->{testname};
	$tmpid++;
	my $tmplft = 100000 + 1000 * $tmpid;
	my $tmprgt = 100999 + 1000 * $tmpid;
	#Some defaults
	$fakedatum->{cluster} = 'yottascale' unless exists $fakedatum->{cluster};
	$fakedatum->{fairshare} = 1 unless exists $fakedatum->{fairshare};
	$fakedatum->{id} = $tmpid unless exists $fakedatum->{id};
	$fakedatum->{lft} = $tmplft unless exists $fakedatum->{lft};
	$fakedatum->{rgt} = $tmprgt unless exists $fakedatum->{rgt};
	$fakedatum->{parentid} = 1 unless exists $fakedatum->{parentid};
	$fakedatum->{parentname} = 'root' unless exists $fakedatum->{parentname};
	$fakedatum->{defaultqos} = 'normal' unless exists $fakedatum->{defaultqos};
	$fakedatum->{partition} = 'gpus' unless exists $fakedatum->{partition};
	
	my $obj = new_ok('Slurm::Sacctmgr::Association' => 
		[ %$fakedatum ],
		"$tstname" );
	$num_tests_run++;

	push @fake_data, $obj;
}
#Make sure @fake_data is alphabetically by username
#@fake_data = sort { $a->association cmp $b->association } @fake_data;

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/fake_sacctmgr_assoc");
my $saassoc = 'Slurm::Sacctmgr::Association';

my $results;
my $args;
my $temp;
my $val;
my @temp;

#Test various commands with echo sacctmgr
#$sa->verbose(1);

$results = $saassoc->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all assocs');
$num_tests_run++;

$val = 'root';
@temp = ( account => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
push @temp, ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @$temp ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by account/user (root)');
$num_tests_run++;

$val = 'root';
@temp = ( account => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by account (root)');
$num_tests_run++;

$val = 'root';
@temp = ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @fake_data ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by user (root)');
$num_tests_run++;

$val = 'abc124';
@temp = ( account => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
$val = 'payerle';
push @temp, ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @$temp ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by account/user (abc124/payerle)');
$num_tests_run++;

$val = 'abc124';
@temp = ( account => $val );
$temp = [ grep { $_->account eq $val } @fake_data ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by account (abc124)');
$num_tests_run++;

$val = 'payerle';
@temp = ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @fake_data ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by user (payerle)');
$num_tests_run++;

#Test for match failing
$val = 'zzz';
@temp = ( user => $val );
$temp = [ grep { $_->user && $_->user eq $val } @fake_data ];
$results = $saassoc->sacctmgr_list($sa, @temp );
is_deeply($results, $temp, 'list assoc by user (no match)');
$num_tests_run++;

#Test that still works when in dryrun mode
$sa->dryrun(1);
$results = $saassoc->sacctmgr_list($sa);
$temp = [ @fake_data ];
is_deeply($results, $temp, 'list all assocs (dryrun)');
$num_tests_run++;

done_testing($num_tests_run);

