/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.18_02 from the
 * contents of SmbClient.xs. Do not edit this file, edit SmbClient.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "SmbClient.xs"
#include "config.h"
/* AIX requires this to be the first thing in the file.  */
#ifndef __GNUC__
# if HAVE_ALLOCA_H
#  include <alloca.h>
# else
#  ifdef _AIX
 #pragma alloca
#  else
#   ifndef alloca /* predefined by HP cc +Olibcalls */
char *alloca ();
#   endif
#  endif
# endif
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "libsmbclient.h"
#include "libauthSamba.h"
#include "config.h"

/* 
 * This file defines the functions interfacing with libsmbclient.so
 */

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#line 42 "SmbClient.c"

XS(XS_Filesys__SmbClient__init); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__init)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_init", "user, password, workgroup, debug");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	char *	user = (char *)SvPV_nolen(ST(0));
	char *	password = (char *)SvPV_nolen(ST(1));
	char*	workgroup = (char *)SvPV_nolen(ST(2));
	int	debug = (int)SvIV(ST(3));
	SMBCCTX *	RETVAL;
#line 38 "SmbClient.xs"
/* 
 * Initialize things ... 
 */	
  SMBCCTX *context;
  context = smbc_new_context();
  if (!context) {
    XSRETURN_UNDEF;
  }
  smbc_setDebug(context, 0); // 4 gives a good level of trace
  set_fn(workgroup, user, password);
  smbc_setFunctionAuthData(context, auth_fn);
  smbc_setDebug(context, debug);
  if (smbc_init_context(context) == 0) {
    smbc_free_context(context, 1); 
    XSRETURN_UNDEF;
  }
  RETVAL = context; 
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient : "
	          "init %d context\n", context); 
#endif
#line 83 "SmbClient.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "SMBCCTXPtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__set_flags); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__set_flags)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_set_flags", "context, flag");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	int	flag = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_set_flags",
			"context", "SMBCCTXPtr");
#line 68 "SmbClient.xs"
/* 
 * Create directory fname
 *
 */
#ifdef HAVE_SMBCTXX_FLAG
    context->flags = flag;
#endif
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient : "
                  "_set_flags value %d\n", flag); 
#endif
  RETVAL = 1;
#line 129 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__mkdir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__mkdir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_mkdir", "context, fname, mode");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	int	mode = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_mkdir",
			"context", "SMBCCTXPtr");
#line 90 "SmbClient.xs"
  smbc_mkdir_fn mkdir_fn = smbc_getFunctionMkdir(context);
/* 
 * Create directory fname
 *
 */
  int returnValue = mkdir_fn(context, fname, mode);
  if (returnValue < 0) {
#ifdef VERBOSE
    fprintf(stderr, "*** Error Filesys::SmbClient : "
	            "mkdir %s directory : %s\n", fname, strerror(errno)); 
#endif
  }
  RETVAL = returnValue;
#line 176 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__rmdir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__rmdir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_rmdir", "context, fname");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_rmdir",
			"context", "SMBCCTXPtr");
#line 112 "SmbClient.xs"
/* 
 * Remove directory fname
 *
 */
  smbc_rmdir_fn rmdir_fn = smbc_getFunctionRmdir(context);
  int returnValue = rmdir_fn(context, fname);
  if (returnValue < 0) {
#ifdef VERBOSE
    fprintf(stderr, "*** Error Filesys::SmbClient : "
      	            "rmdir %s directory : %s\n", fname,strerror(errno));
#endif
  }
  RETVAL = returnValue;
#line 222 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__opendir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__opendir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_opendir", "context, fname");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	SMBCFILE *	RETVAL;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_opendir",
			"context", "SMBCCTXPtr");
#line 134 "SmbClient.xs"
/* 
 * Open directory fname
 *
 */
  smbc_opendir_fn opendir_fn = smbc_getFunctionOpendir(context);
  SMBCFILE *file = opendir_fn(context, fname);
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient : _opendir: %#p\n", file); 
#endif
  if (!file) { 
#ifdef VERBOSE
    fprintf(stderr, "*** Error Filesys::SmbClient : "
                      "Error opendir %s : %s\n", fname, strerror(errno));
#endif
    XSRETURN_UNDEF;
  }
  RETVAL = file;
#line 271 "SmbClient.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "SMBCFILEPtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__closedir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__closedir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_closedir", "context, fd");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_closedir",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_closedir",
			"fd", "SMBCFILEPtr");
#line 160 "SmbClient.xs"
/* 
 * Close file descriptor for directory fd
 *
 */
  smbc_closedir_fn closedir_fn = smbc_getFunctionClosedir(context);
  int returnValue = closedir_fn(context, fd);
#ifdef VERBOSE
  if (returnValue < 0) { 
    fprintf(stderr, "*** Error Filesys::SmbClient : "
                    "Closedir : %s\n", strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 327 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__readdir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__readdir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_readdir", "context, fd");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
#line 182 "SmbClient.xs"
/* 
 * Read file descriptor for directory fd and return file type, name and comment
 *
 */
  smbc_readdir_fn readdir_fn;
  struct smbc_dirent *dirp;
#line 357 "SmbClient.c"

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_readdir",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_readdir",
			"fd", "SMBCFILEPtr");
#line 189 "SmbClient.xs"
  readdir_fn = smbc_getFunctionReaddir(context);
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient : _readdir: %d\n", fd); 
#endif
  dirp = readdir_fn(context, fd);
  if (! dirp) {
    XSRETURN_EMPTY;
  }
  XPUSHs(sv_2mortal(newSViv(dirp->smbc_type)));
  XPUSHs(sv_2mortal(newSVpvn(dirp->name, dirp->namelen)));
  XPUSHs(sv_2mortal(newSVpvn(dirp->comment, dirp->commentlen)));
#line 388 "SmbClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Filesys__SmbClient__telldir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__telldir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_telldir", "context, fd");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_telldir",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_telldir",
			"fd", "SMBCFILEPtr");
#line 207 "SmbClient.xs"
/* 
 * Get the curreent directory offset for directory fd
 *
 */
  smbc_telldir_fn telldir_fn = smbc_getFunctionTelldir(context);
  int returnValue = telldir_fn(context, fd);
#ifdef VERBOSE
  if (returnValue == -1) { 
    fprintf(stderr, "*** Error Filesys::SmbClient : "
                    "Telldir : %s\n", strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 443 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__lseekdir); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__lseekdir)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_lseekdir", "context, fd, offset");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	offset = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_lseekdir",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_lseekdir",
			"fd", "SMBCFILEPtr");
#line 230 "SmbClient.xs"
/* 
 * Lseek on directory for directory fd
 *
 */
  smbc_lseekdir_fn lseekdir_fn = smbc_getFunctionLseekdir(context);
  int returnValue = lseekdir_fn(context, fd, offset);
#ifdef VERBOSE
  if (returnValue == -1) { 
    fprintf(stderr, "*** Error Filesys::SmbClient : "
                    "Lseekdir : %s\n", strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 499 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__stat); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__stat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_stat", "context, fname");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
#line 252 "SmbClient.xs"
/* 
 * _stat(fname) : Get information about a file or directory.
 *
 */
  struct stat buf;
  smbc_stat_fn stat_fn;
  int returnValue;
#line 530 "SmbClient.c"

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_stat",
			"context", "SMBCCTXPtr");
#line 260 "SmbClient.xs"
  stat_fn = smbc_getFunctionStat(context);
  returnValue = stat_fn(context, fname, &buf);
  if (returnValue != 0) {
#ifdef VERBOSE
    fprintf(stderr, "! Filesys::SmbClient : Stat: %s returns %s\n", fname, strerror(errno)); 
#endif
    XSRETURN_EMPTY;
  } else {
    XPUSHs(sv_2mortal(newSVuv(buf.st_dev)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_ino)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_mode)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_nlink)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_uid)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_gid)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_rdev)));
    XPUSHs(sv_2mortal(newSViv(buf.st_size)));
    XPUSHs(sv_2mortal(newSViv(buf.st_blksize)));
    XPUSHs(sv_2mortal(newSViv(buf.st_blocks)));
    XPUSHs(sv_2mortal(newSViv(buf.st_atime)));
    XPUSHs(sv_2mortal(newSViv(buf.st_mtime)));
    XPUSHs(sv_2mortal(newSViv(buf.st_ctime)));
  }
#line 563 "SmbClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Filesys__SmbClient__fstat); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__fstat)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_fstat", "context, fd");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
#line 289 "SmbClient.xs"
/* 
 * Get information about a file or directory via a file descriptor.
 *
 */
  struct stat buf;
  smbc_fstat_fn fstat_fn;
  int returnValue;
#line 594 "SmbClient.c"

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_fstat",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_fstat",
			"fd", "SMBCFILEPtr");
#line 297 "SmbClient.xs"
  fstat_fn = smbc_getFunctionFstat(context);
  returnValue = fstat_fn(context, fd, &buf);
  if (returnValue != 0) {
#ifdef VERBOSE
    fprintf(stderr, "! Filesys::SmbClient : Fstat: %#p returns %s\n", fd, strerror(errno)); 
#endif
    XSRETURN_EMPTY;
  } else {
    XPUSHs(sv_2mortal(newSVuv(buf.st_dev)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_ino)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_mode)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_nlink)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_uid)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_gid)));
    XPUSHs(sv_2mortal(newSVuv(buf.st_rdev)));
    XPUSHs(sv_2mortal(newSViv(buf.st_size)));
    XPUSHs(sv_2mortal(newSViv(buf.st_blksize)));
    XPUSHs(sv_2mortal(newSViv(buf.st_blocks)));
    XPUSHs(sv_2mortal(newSViv(buf.st_atime)));
    XPUSHs(sv_2mortal(newSViv(buf.st_mtime)));
    XPUSHs(sv_2mortal(newSViv(buf.st_ctime)));
  }
#line 636 "SmbClient.c"
	PUTBACK;
	return;
    }
}


XS(XS_Filesys__SmbClient__rename); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__rename)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_rename", "context, oname, nname");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	oname = (char *)SvPV_nolen(ST(1));
	char *	nname = (char *)SvPV_nolen(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_rename",
			"context", "SMBCCTXPtr");
#line 327 "SmbClient.xs"
/* 
 * Rename old file oname in nname
 *
 */
  smbc_rename_fn rename_fn = smbc_getFunctionRename(context);
  int returnValue = rename_fn(context, oname, context, nname);
  if (returnValue < 0) { 
#ifdef VERBOSE	
    fprintf(stderr, "*** Error Filesys::SmbClient : "
 		    "Rename %s in %s : %s\n", oname, nname, strerror(errno)); 
#endif
  }
  RETVAL = returnValue;
#line 683 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__open); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__open)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_open", "context, fname, mode");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	int	mode = (int)SvIV(ST(2));
	SMBCFILE *	RETVAL;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_open",
			"context", "SMBCCTXPtr");
#line 350 "SmbClient.xs"
/* 
 * Open file fname with perm mode
 *
 */	
  int flags; 
  int seek_end = 0;
  smbc_open_fn open_fn = smbc_getFunctionOpen(context);
  SMBCFILE *file;

  /* Mode >> */
  if ( (*fname != '\0') && (*(fname+1) != '\0') &&
     (*fname == '>') && (*(fname+1) == '>')) { 
    flags = O_WRONLY | O_CREAT | O_APPEND; 
    fname += 2; 
    seek_end = 1;
#ifdef VERBOSE
    fprintf(stderr, "! Filesys::SmbClient :"
	            "Open append %s : %s\n", fname); 
#endif
  /* Mode > */
  } else if ( (*fname != '\0') && (*fname == '>')) {
    flags = O_WRONLY | O_CREAT | O_TRUNC; fname++; 
  /* Mode < */
  } else if ( (*fname != '\0') && (*fname == '<')) {
    flags = O_RDONLY; fname++; 
  /* Mod < */
  } else {
    flags =  O_RDONLY;
  }

  file = open_fn(context, fname, flags, mode);	
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient :"
	          "Open %s return %#p\n", fname, file); 
#endif
  if (!file) {
#ifdef VERBOSE
     fprintf(stderr, "*** Error Filesys::SmbClient :"
                     "Open %s : %s\n", fname, strerror(errno)); 
#endif
    XSRETURN_UNDEF;
  } else {
    RETVAL = file;
  }
#line 760 "SmbClient.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "SMBCFILEPtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__read); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__read)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_read", "context, fd, bufsv, count, offset");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	SV *	bufsv = ST(2);
	unsigned	count = (unsigned)SvUV(ST(3));
	unsigned	offset = (unsigned)SvUV(ST(4));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_read",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_read",
			"fd", "SMBCFILEPtr");
#line 406 "SmbClient.xs"
/* 
 * Read count bytes on file descriptor fd
 *
 */
  smbc_read_fn read_fn = smbc_getFunctionRead(context);
  char *buf;
  STRLEN blen;

  if (! SvOK(bufsv))
    sv_setpvn(bufsv, "", 0);
  (void)SvPV_force(bufsv, blen);

  if (offset > SvCUR(bufsv))
    offset = SvCUR(bufsv);
  buf = SvGROW(bufsv, count + offset) + offset;
  int returnValue = read_fn(context, fd, buf, count);
#ifdef VERBOSE
  if (returnValue <= 0) {
    fprintf(stderr, "*** Error Filesys::SmbClient: "
                    "Read %#p : %s\n", bufsv, strerror(errno)); 
  }
#endif
  if (returnValue > 0) {
    SvCUR_set(bufsv, offset + returnValue);
    (void)SvPOK_only(bufsv);
  }
  RETVAL = returnValue;
#line 833 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__write); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__write)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_write", "context, fd, buf, count");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	char *	buf = (char *)SvPV_nolen(ST(2));
	int	count = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_write",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_write",
			"fd", "SMBCFILEPtr");
#line 443 "SmbClient.xs"
/* 
 * Write buf on file descriptor fd
 *
 */
  smbc_write_fn write_fn = smbc_getFunctionWrite(context);
  int returnValue = write_fn(context, fd, buf, count);
#ifdef VERBOSE
  fprintf(stderr, "! Filesys::SmbClient :"
	          "write %d bytes: %s\n", count, buf);	
  if (returnValue < 0) { 
    if (errno == EBADF) 
      fprintf(stderr, "*** Error Filesys::SmbClient: "
		      "write fd invalid\n");
    else if (errno == EINVAL) 
      fprintf(stderr, "*** Error Filesys::SmbClient: "
	              "write param invalid\n");
    else 
      fprintf(stderr, "*** Error Filesys::SmbClient: "
	               "write %d : %s\n", fd, strerror(errno)); 
  }
#endif
  RETVAL = returnValue;
#line 899 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__lseek); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__lseek)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_lseek", "context, fd, offset, whence");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	offset = (int)SvIV(ST(2));
	int	whence = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_lseek",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_lseek",
			"fd", "SMBCFILEPtr");
#line 475 "SmbClient.xs"
  smbc_lseek_fn lseek_fn = smbc_getFunctionLseek(context);
  int returnValue = lseek_fn(context, fd, offset, whence);
#ifdef VERBOSE
  if (returnValue == -1) { 
    if (errno == EBADF) 
       fprintf(stderr, "*** Error Filesys::SmbClient: "
                       "lseek fd not open\n");
    else if (errno == EINVAL) 
       fprintf(stderr, "*** Error Filesys::SmbClient: "
	   	      "smbc_init not called or fd not a filehandle\n");
    else 
       fprintf(stderr, "*** Error Filesys::SmbClient: "
	               "write %#p : %s\n", fd, strerror(errno)); 
  }
#endif
  RETVAL = returnValue;
#line 959 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__ftruncate); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__ftruncate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_ftruncate", "context, fd, size");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	size = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_ftruncate",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_ftruncate",
			"fd", "SMBCFILEPtr");
#line 500 "SmbClient.xs"
  smbc_ftruncate_fn ftruncate_fn = smbc_getFunctionFtruncate(context);
  int returnValue = ftruncate_fn(context, fd, size);
#ifdef VERBOSE
  if (returnValue < 0) {
    if (returnValue == EBADF)
      fprintf(stderr, "*** Error Filesys::SmbClient: "
                      "ftruncate fd not open\n");
    else if (returnValue == EINVAL)
      fprintf(stderr, "*** Error Filesys::SmbClient: "
                      "smbc_init not called or fd not a filehandle\n");
    else
      fprintf(stderr, "*** Error Filesys::SmbClient: "
                      "ftruncate %#p : %s\n", fd, strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 1018 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__close); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_close", "context, fd");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	SMBCFILE *	fd;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_close",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(1), "SMBCFILEPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    fd = INT2PTR(SMBCFILE *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_close",
			"fd", "SMBCFILEPtr");
#line 524 "SmbClient.xs"
/* 
 * Close file desriptor fd
 *
 */
  smbc_close_fn close_fn = smbc_getFunctionClose(context);
  int returnValue = close_fn(context, fd);
#ifdef VERBOSE
  if (returnValue) {
    fprintf(stderr, "*** Error Filesys::SmbClient: Close %s\n",
                    stderror(errno));
  }
#endif
  RETVAL = returnValue;
#line 1073 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__unlink); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__unlink)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_unlink", "context, fname");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_unlink",
			"context", "SMBCCTXPtr");
#line 546 "SmbClient.xs"
/* 
 * Remove file fname
 *
 */
  smbc_unlink_fn unlink_fn = smbc_getFunctionUnlink(context);
  int returnValue = unlink_fn(context, fname);
  if (returnValue < 0) { 
#ifdef VERBOSE	
  fprintf(stderr, "*** Error Filesys::SmbClient: Failed to unlink %s : %s\n", 
          fname, strerror(errno)); 
#endif
  }
  RETVAL = returnValue;
#line 1119 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__unlink_print_job); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__unlink_print_job)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_unlink_print_job", "context, purl, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	purl = (char *)SvPV_nolen(ST(1));
	int	id = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_unlink_print_job",
			"context", "SMBCCTXPtr");
#line 569 "SmbClient.xs"
  smbc_unlink_print_job_fn unlink_pj_fn = smbc_getFunctionUnlinkPrintJob(context);
  int returnValue = unlink_pj_fn(context, purl, id);
#ifdef VERBOSE
  if (returnValue < 0) {
    fprintf(stderr, "*** Error Filesys::SmbClient: "
	            "Failed to unlink job id %u on %s, %s\n",
                    id, purl, strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 1163 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Filesys__SmbClient__print_file); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__print_file)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_print_file", "context, fname, c_print, printq");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
	SMBCCTX *	c_print;
	char *	printq = (char *)SvPV_nolen(ST(3));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_print_file",
			"context", "SMBCCTXPtr");

	if (sv_derived_from(ST(2), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    c_print = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_print_file",
			"c_print", "SMBCCTXPtr");
#line 590 "SmbClient.xs"
  smbc_print_file_fn print_file_fn = smbc_getFunctionPrintFile(context);
  int returnValue = print_file_fn(context, fname, c_print, printq);
#ifdef VERBOSE
  if (returnValue < 0) {
    fprintf(stderr, "*** Error Filesys::SmbClient *** "
		    "Failed to print file %s on %s, %s\n", 
	            fname, printq, strerror(errno));
  }
#endif
  RETVAL = returnValue;
#line 1217 "SmbClient.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if 0
#define XSubPPtmpAAAA 1


XS(XS_Filesys__SmbClient__utimes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Filesys__SmbClient__utimes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "Filesys::SmbClient::_utimes", "context, fname");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SMBCCTX *	context;
	char *	fname = (char *)SvPV_nolen(ST(1));
#line 611 "SmbClient.xs"
/* 
 * Get the access and modification times on a file
 *
 */
  struct timeval tbuf[2];
  smbc_utimes_fn utimes_fn;
  int returnValue;
#line 1251 "SmbClient.c"

	if (sv_derived_from(ST(0), "SMBCCTXPtr")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    context = INT2PTR(SMBCCTX *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Filesys::SmbClient::_utimes",
			"context", "SMBCCTXPtr");
#line 619 "SmbClient.xs"
  bzero(tbuf, sizeof(tbuf));
  utimes_fn = smbc_getFunctionUtimes(context);
  returnValue = utimes_fn(context, fname, tbuf);
  if (returnValue != 0) {
#ifdef VERBOSE
    fprintf(stderr, "! Filesys::SmbClient : Utimes : %#p returns %s\n", fd, strerror(errno)); 
#endif
    XSRETURN_EMPTY;
  } else {
    XPUSHs(sv_2mortal(newSVuv(tbuf[0].tv_sec)));
    XPUSHs(sv_2mortal(newSVuv(tbuf[1].tv_sec)));
  }
#line 1274 "SmbClient.c"
	PUTBACK;
	return;
    }
}

#endif
#ifdef __cplusplus
extern "C"
#endif
XS(boot_Filesys__SmbClient); /* prototype to pass -Wmissing-prototypes */
XS(boot_Filesys__SmbClient)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    char* file = __FILE__;

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

        newXSproto("Filesys::SmbClient::_init", XS_Filesys__SmbClient__init, file, "$$$$");
        newXSproto("Filesys::SmbClient::_set_flags", XS_Filesys__SmbClient__set_flags, file, "$$");
        newXSproto("Filesys::SmbClient::_mkdir", XS_Filesys__SmbClient__mkdir, file, "$$$");
        newXSproto("Filesys::SmbClient::_rmdir", XS_Filesys__SmbClient__rmdir, file, "$$");
        newXSproto("Filesys::SmbClient::_opendir", XS_Filesys__SmbClient__opendir, file, "$$");
        newXSproto("Filesys::SmbClient::_closedir", XS_Filesys__SmbClient__closedir, file, "$$");
        newXSproto("Filesys::SmbClient::_readdir", XS_Filesys__SmbClient__readdir, file, "$$");
        newXSproto("Filesys::SmbClient::_telldir", XS_Filesys__SmbClient__telldir, file, "$$");
        newXSproto("Filesys::SmbClient::_lseekdir", XS_Filesys__SmbClient__lseekdir, file, "$$$");
        newXSproto("Filesys::SmbClient::_stat", XS_Filesys__SmbClient__stat, file, "$$");
        newXSproto("Filesys::SmbClient::_fstat", XS_Filesys__SmbClient__fstat, file, "$$");
        newXSproto("Filesys::SmbClient::_rename", XS_Filesys__SmbClient__rename, file, "$$$");
        newXSproto("Filesys::SmbClient::_open", XS_Filesys__SmbClient__open, file, "$$$");
        newXSproto("Filesys::SmbClient::_read", XS_Filesys__SmbClient__read, file, "$$$$$");
        newXSproto("Filesys::SmbClient::_write", XS_Filesys__SmbClient__write, file, "$$$$");
        newXSproto("Filesys::SmbClient::_lseek", XS_Filesys__SmbClient__lseek, file, "$$$$");
        newXSproto("Filesys::SmbClient::_ftruncate", XS_Filesys__SmbClient__ftruncate, file, "$$$");
        newXSproto("Filesys::SmbClient::_close", XS_Filesys__SmbClient__close, file, "$$");
        newXSproto("Filesys::SmbClient::_unlink", XS_Filesys__SmbClient__unlink, file, "$$");
        newXSproto("Filesys::SmbClient::_unlink_print_job", XS_Filesys__SmbClient__unlink_print_job, file, "$$$");
        newXSproto("Filesys::SmbClient::_print_file", XS_Filesys__SmbClient__print_file, file, "$$$$");
#if XSubPPtmpAAAA
        newXSproto("Filesys::SmbClient::_utimes", XS_Filesys__SmbClient__utimes, file, "$$");
#endif

    /* Initialisation Section */

#if XSubPPtmpAAAA
#endif
#line 1327 "SmbClient.c"

    /* End of Initialisation Section */

    if (PL_unitcheckav)
         call_list(PL_scopestack_ix, PL_unitcheckav);
    XSRETURN_YES;
}

