#!/usr/bin/env perl
use strict;
use warnings;

use Test::More tests => 1;
use Test::Deep;
use Test::MockModule;

use Git::Wrapper::More;

my @dum_ret = (
    qw!
        idev-cover
        lib/IdevCover.pm
        lib/IdevCover/Git::Wrapper::More.pm
        t/unit/lib-IdevCover-Git::Wrapper::More/01-new.t
        t/unit/lib-IdevCover-Git::Wrapper::More/02-canstatus.t
        t/unit/lib-IdevCover-Git::Wrapper::More/cwdbranch.t
        t/unit/lib-IdevCover-Git::Wrapper::More/lsfiles.t
        t/unit/lib-IdevCover-Git::Wrapper::More/toplevel.t
        t/unit/lib-IdevCover/01-get_git.t
        !
);

my $mgwm = Test::MockModule->new('Git::Wrapper');
$mgwm->mock(
    'RUN',
    sub {
        my $self = shift;
        return @dum_ret;
    },
);

my $gwm = Git::Wrapper::More->new( dir => '/dummy/dir' );

my @ret = $gwm->logfiles('10');
cmp_deeply( \@ret, \@dum_ret, 'logfiles returns list of files from Git::Wrapper RUN log command' );

exit;

__END__
