class Panda::Tester {
use Panda::Common;

method test($where, :$bone, :$prove-command = $*DISTRO.name eq 'mswin32' ?? 'prove.bat' !! 'prove', :@deps) {
    indir $where, {
        my Bool $run-default = True;
        if "Build.pm".IO.f {
            GLOBAL::<Build>:delete;
            require "$where/Build.pm";
            if ::('Build').isa(Panda::Tester) {
                $run-default = False;
                ::('Build').new.test($where, :$prove-command);
            }
        }

        if $run-default && 't'.IO ~~ :d {
            withp6lib {
                my $libs = '';
                for @deps -> $lib {
                    $libs ~= ' -M' ~ $lib;
                }

                my @opts = $prove-command, '-e', "$*EXECUTABLE $libs -Ilib", "--norc", '-r', 't/';

                if $prove-command ~~ /prove6/ {
                    @opts = $prove-command, '-l', 't/';
                }

                my ( :$output, :$stdout, :$stderr, :$passed ) := run-and-gather-output(@opts);

                if $bone {
                    $bone.test-output = $output;
                    $bone.test-stdout = $stdout;
                    $bone.test-stderr = $stderr;
                    $bone.test-passed = $passed;
                }

                fail "Tests failed" unless $passed;
            }
        }
    };
    return True;
}

}

# vim: ft=perl6
