
=begin comment

Smartcat Integration API

No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)

OpenAPI spec version: v1

Generated by: https://github.com/swagger-api/swagger-codegen.git

=end comment

=cut

#
# NOTE: This class is auto generated by the swagger code generator program.
# Do not edit the class manually.
# Ref: https://github.com/swagger-api/swagger-codegen
#
package Smartcat::Client::ProjectApi;

require 5.6.0;
use strict;
use warnings;
use utf8;
use Exporter;
use JSON;
use Carp qw( croak );
use Log::Any qw($log);

use Smartcat::Client::ApiClient;

use base "Class::Data::Inheritable";

__PACKAGE__->mk_classdata( 'method_documentation' => {} );

sub new {
    my $class = shift;
    my $api_client;

    if ( $_[0] && ref $_[0] && ref $_[0] eq 'Smartcat::Client::ApiClient' ) {
        $api_client = $_[0];
    }
    else {
        $api_client = Smartcat::Client::ApiClient->new(@_);
    }

    bless { api_client => $api_client }, $class;

}

#
# project_add_document
#
#
#
# @param string $project_id  (required)
# @param ARRAY[CreateDocumentPropertyModel] $document_model  (required)
# @param  $file  (required)
# @param string $disassemble_algorithm_name  (optional)
# @param string $external_id  (optional)
# @param string $meta_info  (optional)
# @param string $target_languages  (optional)
# @param string $preset_disassemble_algorithm  (optional)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'document_model' => {
            data_type   => 'ARRAY[CreateDocumentPropertyModel]',
            description => '',
            required    => '1',
        },
        'file' => {
            data_type   => '',
            description => '',
            required    => '1',
        },
        'disassemble_algorithm_name' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'external_id' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'meta_info' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'target_languages' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'preset_disassemble_algorithm' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{'project_add_document'} = {
        summary => '',
        params  => $params,
        returns => 'ARRAY[DocumentModel]',
    };
}

# @return ARRAY[DocumentModel]
#
sub project_add_document {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_add_document"
        );
    }

    # verify the required parameter 'document_model' is set
    unless ( exists $args{'document_model'} ) {
        croak(
"Missing the required parameter 'document_model' when calling project_add_document"
        );
    }

    # verify the required parameter 'file' is set
    unless ( exists $args{'file'} ) {
        croak(
"Missing the required parameter 'file' when calling project_add_document"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/document';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type('multipart/form-data');

    # query params
    if ( exists $args{'project_id'} ) {
        $query_params->{'projectId'} =
          $self->{api_client}->to_query_value( $args{'project_id'} );
    }

    # query params
    if ( exists $args{'disassemble_algorithm_name'} ) {
        $query_params->{'disassembleAlgorithmName'} = $self->{api_client}
          ->to_query_value( $args{'disassemble_algorithm_name'} );
    }

    # query params
    if ( exists $args{'external_id'} ) {
        $query_params->{'externalId'} =
          $self->{api_client}->to_query_value( $args{'external_id'} );
    }

    # query params
    if ( exists $args{'meta_info'} ) {
        $query_params->{'metaInfo'} =
          $self->{api_client}->to_query_value( $args{'meta_info'} );
    }

    # query params
    if ( exists $args{'target_languages'} ) {
        $query_params->{'targetLanguages'} =
          $self->{api_client}->to_query_value( $args{'target_languages'} );
    }

    # query params
    if ( exists $args{'preset_disassemble_algorithm'} ) {
        $query_params->{'presetDisassembleAlgorithm'} =
          $self->{api_client}->to_query_value( $args{'preset_disassemble_algorithm'} );
    }

    my $_body_data = [];

    # body params
    if ( exists $args{'document_model'} ) {
        push(
            @$_body_data,
            documentModel => [
                undef,
                undef,
                Content_Type => 'application/json',
                Content      => to_json( [ $args{'document_model'}->to_hash ] )
            ]
        );
    }
    if ( exists $args{'file'} && ref $args{'file'} eq 'HASH' ) {
        push(
            @$_body_data,
            file => [
                $args{'file'}->{path},
                $args{'file'}->{filename},
                Content_Type => 'application/octetstream'
            ]
        );
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ARRAY[DocumentModel]', $response );
    return $_response_object;
}

#
# project_add_language
#
# Add a new target language to the project
#
# @param string $project_id Project ID (required)
# @param string $target_language Target language (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
        'target_language' => {
            data_type   => 'string',
            description => 'Target language',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_add_language'} = {
        summary => 'Add a new target language to the project',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_add_language {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_add_language"
        );
    }

    # verify the required parameter 'target_language' is set
    unless ( exists $args{'target_language'} ) {
        croak(
"Missing the required parameter 'target_language' when calling project_add_language"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/language';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'project_id'} ) {
        $query_params->{'projectId'} =
          $self->{api_client}->to_query_value( $args{'project_id'} );
    }

    # query params
    if ( exists $args{'target_language'} ) {
        $query_params->{'targetLanguage'} =
          $self->{api_client}->to_query_value( $args{'target_language'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_build_statistics
#
#
#
# @param string $project_id  (required)
# @param boolean $only_exact_matches  (optional)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'only_exact_matches' => {
            data_type   => 'boolean',
            description => '',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{'project_build_statistics'} = {
        summary => '',
        params  => $params,
        returns => 'string',
    };
}

# @return string
#
sub project_build_statistics {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_build_statistics"
        );
    }

    # parse inputs
    my $_resource_path =
      '/api/integration/v1/project/{projectId}/statistics/build';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'only_exact_matches'} ) {
        $query_params->{'onlyExactMatches'} =
          $self->{api_client}->to_query_value( $args{'only_exact_matches'} );
    }

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'string', $response );
    return $_response_object;
}

#
# project_cancel_project
#
# Cancel the project
#
# @param string $project_id Project ID (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_cancel_project'} = {
        summary => 'Cancel the project',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_cancel_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_cancel_project"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/cancel';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'project_id'} ) {
        $query_params->{'projectId'} =
          $self->{api_client}->to_query_value( $args{'project_id'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_complete_project
#
#
#
# @param string $project_id  (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_complete_project'} = {
        summary => '',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_complete_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_complete_project"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/complete';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'project_id'} ) {
        $query_params->{'projectId'} =
          $self->{api_client}->to_query_value( $args{'project_id'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_create_project
#
#
#
# @param CreateProjectModel $project  (required)
{
    my $params = {
        'project' => {
            data_type   => 'CreateProjectModel',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_create_project'} = {
        summary => '',
        params  => $params,
        returns => 'ProjectModel',
    };
}

# @return ProjectModel
#
sub project_create_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project' is set
    unless ( exists $args{'project'} ) {
        croak(
"Missing the required parameter 'project' when calling project_create_project"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/create';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type('multipart/form-data');

    my $_body_data;

    # body params
    if ( exists $args{'project'} ) {
        $_body_data = $args{'project'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ProjectModel', $response );
    return $_response_object;
}

#
# project_delete
#
# Delete the project
#
# @param string $project_id Project ID (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_delete'} = {
        summary => 'Delete the project',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_delete {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_delete"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}';

    my $_method       = 'DELETE';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_get
#
# Receive the project model
#
# @param string $project_id Project ID (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_get'} = {
        summary => 'Receive the project model',
        params  => $params,
        returns => 'ProjectModel',
    };
}

# @return ProjectModel
#
sub project_get {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ProjectModel', $response );
    return $_response_object;
}

#
# project_get_all
#
#
#
# @param string $created_by_user_id  (optional)
# @param string $project_name  (optional)
# @param string $external_tag  (optional)
# @param ARRAY[string] $client_ids  (optional)
{
    my $params = {
        'created_by_user_id' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'project_name' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'external_tag' => {
            data_type   => 'string',
            description => '',
            required    => '0',
        },
        'client_ids' => {
            data_type   => 'ARRAY[string]',
            description => '',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{'project_get_all'} = {
        summary => '',
        params  => $params,
        returns => 'ARRAY[ProjectModel]',
    };
}

# @return ARRAY[ProjectModel]
#
sub project_get_all {
    my ( $self, %args ) = @_;

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/list';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'created_by_user_id'} ) {
        $query_params->{'createdByUserId'} =
          $self->{api_client}->to_query_value( $args{'created_by_user_id'} );
    }

    # query params
    if ( exists $args{'project_name'} ) {
        $query_params->{'projectName'} =
          $self->{api_client}->to_query_value( $args{'project_name'} );
    }

    # query params
    if ( exists $args{'external_tag'} ) {
        $query_params->{'externalTag'} =
          $self->{api_client}->to_query_value( $args{'external_tag'} );
    }

    # query params
    if ( exists $args{'client_ids'} ) {
        $query_params->{'clientIds'} =
          $self->{api_client}->to_query_value( $args{'client_ids'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ARRAY[ProjectModel]', $response );
    return $_response_object;
}

#
# project_get_completed_work_statistics
#
# Receiving statistics for the completed parts of the project
#
# @param string $project_id project id (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'project id',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_get_completed_work_statistics'}
      = {
        summary =>
          'Receiving statistics for the completed parts of the project',
        params  => $params,
        returns => 'ARRAY[ExecutiveStatisticsModel]',
      };
}

# @return ARRAY[ExecutiveStatisticsModel]
#
sub project_get_completed_work_statistics {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get_completed_work_statistics"
        );
    }

    # parse inputs
    my $_resource_path =
      '/api/integration/v1/project/{projectId}/completedWorkStatistics';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object = $self->{api_client}
      ->deserialize( 'ARRAY[ExecutiveStatisticsModel]', $response );
    return $_response_object;
}

#
# project_get_glossaries
#
#
#
# @param string $project_id  (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_get_glossaries'} = {
        summary => '',
        params  => $params,
        returns => 'ARRAY[GlossaryModel]',
    };
}

# @return ARRAY[GlossaryModel]
#
sub project_get_glossaries {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get_glossaries"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}/glossaries';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'ARRAY[GlossaryModel]', $response );
    return $_response_object;
}

#
# project_get_project_statistics
#
# Receive statistics
#
# @param string $project_id Project ID (required)
# @param boolean $only_exact_matches 100 or more matches requirement (optional)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
        'only_exact_matches' => {
            data_type   => 'boolean',
            description => '100 or more matches requirement',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{'project_get_project_statistics'} = {
        summary => 'Receive statistics',
        params  => $params,
        returns => 'ARRAY[ProjectStatisticsModel]',
    };
}

# @return ARRAY[ProjectStatisticsModel]
#
sub project_get_project_statistics {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get_project_statistics"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v2/project/{projectId}/statistics';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'only_exact_matches'} ) {
        $query_params->{'onlyExactMatches'} =
          $self->{api_client}->to_query_value( $args{'only_exact_matches'} );
    }

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object = $self->{api_client}
      ->deserialize( 'ARRAY[ProjectStatisticsModel]', $response );
    return $_response_object;
}

#
# project_get_project_statistics_obsolete
#
# (This method is obsolete. Newer version can be found here:  /api/integrationv2/project/{projectId}/statistics)              Receive statistics
#
# @param string $project_id Project ID (required)
# @param boolean $only_exact_matches 100 or more matches requirement (optional)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
        'only_exact_matches' => {
            data_type   => 'boolean',
            description => '100 or more matches requirement',
            required    => '0',
        },
    };
    __PACKAGE__->method_documentation->{
        'project_get_project_statistics_obsolete'} = {
        summary =>
'(This method is obsolete. Newer version can be found here:  /api/integrationv2/project/{projectId}/statistics)              Receive statistics',
        params  => $params,
        returns => 'HASH[string,ProjectStatisticsObsoleteModel]',
        };
}

# @return HASH[string,ProjectStatisticsObsoleteModel]
#
sub project_get_project_statistics_obsolete {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get_project_statistics_obsolete"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}/statistics';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'only_exact_matches'} ) {
        $query_params->{'onlyExactMatches'} =
          $self->{api_client}->to_query_value( $args{'only_exact_matches'} );
    }

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object = $self->{api_client}
      ->deserialize( 'HASH[string,ProjectStatisticsObsoleteModel]', $response );
    return $_response_object;
}

#
# project_get_project_translation_memories
#
# Receiving a list of the TMs plugged into the project
#
# @param string $project_id Project ID (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'project_get_project_translation_memories'} = {
        summary => 'Receiving a list of the TMs plugged into the project',
        params  => $params,
        returns => 'ARRAY[ProjectTranslationMemoryModel]',
        };
}

# @return ARRAY[ProjectTranslationMemoryModel]
#
sub project_get_project_translation_memories {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_get_project_translation_memories"
        );
    }

    # parse inputs
    my $_resource_path =
      '/api/integration/v1/project/{projectId}/translationmemories';

    my $_method       = 'GET';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object = $self->{api_client}
      ->deserialize( 'ARRAY[ProjectTranslationMemoryModel]', $response );
    return $_response_object;
}

#
# project_restore_project
#
# Restore the project
#
# @param string $project_id Project ID (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => 'Project ID',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_restore_project'} = {
        summary => 'Restore the project',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_restore_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_restore_project"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/restore';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} =
      $self->{api_client}->select_header_content_type();

    # query params
    if ( exists $args{'project_id'} ) {
        $query_params->{'projectId'} =
          $self->{api_client}->to_query_value( $args{'project_id'} );
    }

    my $_body_data;

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_set_glossaries
#
#
#
# @param string $project_id  (required)
# @param ARRAY[string] $glossary_ids  (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'glossary_ids' => {
            data_type   => 'ARRAY[string]',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_set_glossaries'} = {
        summary => '',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_set_glossaries {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_set_glossaries"
        );
    }

    # verify the required parameter 'glossary_ids' is set
    unless ( exists $args{'glossary_ids'} ) {
        croak(
"Missing the required parameter 'glossary_ids' when calling project_set_glossaries"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}/glossaries';

    my $_method       = 'PUT';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # body params
    if ( exists $args{'glossary_ids'} ) {
        $_body_data = $args{'glossary_ids'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

#
# project_set_project_translation_memories_by_languages
#
#
#
# @param ARRAY[TranslationMemoriesForLanguageModel] $tm_for_languages_models  (required)
# @param string $project_id  (required)
{
    my $params = {
        'tm_for_languages_models' => {
            data_type   => 'ARRAY[TranslationMemoriesForLanguageModel]',
            description => '',
            required    => '1',
        },
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'project_set_project_translation_memories_by_languages'} = {
        summary => '',
        params  => $params,
        returns => 'string',
        };
}

# @return string
#
sub project_set_project_translation_memories_by_languages {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_for_languages_models' is set
    unless ( exists $args{'tm_for_languages_models'} ) {
        croak(
"Missing the required parameter 'tm_for_languages_models' when calling project_set_project_translation_memories_by_languages"
        );
    }

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_set_project_translation_memories_by_languages"
        );
    }

    # parse inputs
    my $_resource_path =
      '/api/integration/v1/project/{projectId}/translationmemories/bylanguages';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # body params
    if ( exists $args{'tm_for_languages_models'} ) {
        $_body_data = $args{'tm_for_languages_models'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'string', $response );
    return $_response_object;
}

#
# project_set_translation_memories_for_whole_project
#
#
#
# @param ARRAY[TranslationMemoryForProjectModel] $tm_models  (required)
# @param string $project_id  (required)
{
    my $params = {
        'tm_models' => {
            data_type   => 'ARRAY[TranslationMemoryForProjectModel]',
            description => '',
            required    => '1',
        },
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{
        'project_set_translation_memories_for_whole_project'} = {
        summary => '',
        params  => $params,
        returns => 'string',
        };
}

# @return string
#
sub project_set_translation_memories_for_whole_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'tm_models' is set
    unless ( exists $args{'tm_models'} ) {
        croak(
"Missing the required parameter 'tm_models' when calling project_set_translation_memories_for_whole_project"
        );
    }

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_set_translation_memories_for_whole_project"
        );
    }

    # parse inputs
    my $_resource_path =
      '/api/integration/v1/project/{projectId}/translationmemories';

    my $_method       = 'POST';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}
      ->select_header_accept( 'application/json', 'text/json' );
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # body params
    if ( exists $args{'tm_models'} ) {
        $_body_data = $args{'tm_models'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    my $response = $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    if ( !$response ) {
        return;
    }
    my $_response_object =
      $self->{api_client}->deserialize( 'string', $response );
    return $_response_object;
}

#
# project_update_project
#
#
#
# @param string $project_id  (required)
# @param ProjectChangesModel $model  (required)
{
    my $params = {
        'project_id' => {
            data_type   => 'string',
            description => '',
            required    => '1',
        },
        'model' => {
            data_type   => 'ProjectChangesModel',
            description => '',
            required    => '1',
        },
    };
    __PACKAGE__->method_documentation->{'project_update_project'} = {
        summary => '',
        params  => $params,
        returns => undef,
    };
}

# @return void
#
sub project_update_project {
    my ( $self, %args ) = @_;

    # verify the required parameter 'project_id' is set
    unless ( exists $args{'project_id'} ) {
        croak(
"Missing the required parameter 'project_id' when calling project_update_project"
        );
    }

    # verify the required parameter 'model' is set
    unless ( exists $args{'model'} ) {
        croak(
"Missing the required parameter 'model' when calling project_update_project"
        );
    }

    # parse inputs
    my $_resource_path = '/api/integration/v1/project/{projectId}';

    my $_method       = 'PUT';
    my $query_params  = {};
    my $header_params = {};
    my $form_params   = {};

    # 'Accept' and 'Content-Type' header
    my $_header_accept = $self->{api_client}->select_header_accept();
    if ($_header_accept) {
        $header_params->{'Accept'} = $_header_accept;
    }
    $header_params->{'Content-Type'} = $self->{api_client}
      ->select_header_content_type( 'application/json', 'text/json' );

    # path params
    if ( exists $args{'project_id'} ) {
        my $_base_variable = "{" . "projectId" . "}";
        my $_base_value =
          $self->{api_client}->to_path_value( $args{'project_id'} );
        $_resource_path =~ s/$_base_variable/$_base_value/g;
    }

    my $_body_data;

    # body params
    if ( exists $args{'model'} ) {
        $_body_data = $args{'model'};
    }

    # authentication setting, if any
    my $auth_settings = [qw()];

    # make the API Call
    $self->{api_client}->call_api(
        $_resource_path, $_method,    $query_params, $form_params,
        $header_params,  $_body_data, $auth_settings
    );
    return;
}

1;
