/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import ucar.unidata.geoloc.Earth;

public final class EarthEllipsoid
extends Earth {
    public static final EarthEllipsoid WGS84 = new EarthEllipsoid("WGS84", 7030, 6378137.0, 298.257223563);
    public static final EarthEllipsoid Airy1830 = new EarthEllipsoid("Airy 1830", 7001, 6377563.396, 299.3249646);
    private static Map<String, EarthEllipsoid> hash;
    private String name;
    private int epsgId;

    public static Collection<EarthEllipsoid> getAll() {
        if (hash == null) {
            hash = new LinkedHashMap<String, EarthEllipsoid>(10);
        }
        return hash.values();
    }

    public static EarthEllipsoid getType(String name) {
        if (name == null) {
            return null;
        }
        if (hash == null) {
            hash = new LinkedHashMap<String, EarthEllipsoid>(10);
        }
        return hash.get(name);
    }

    public static EarthEllipsoid getType(int epsgId) {
        Collection<EarthEllipsoid> all = EarthEllipsoid.getAll();
        for (EarthEllipsoid ellipsoid : all) {
            if (ellipsoid.epsgId != epsgId) continue;
            return ellipsoid;
        }
        return null;
    }

    private EarthEllipsoid(String name, int epsgId, double a, double invF) {
        super(a, 0.0, invF);
        this.name = name;
        this.epsgId = epsgId;
        if (hash == null) {
            hash = new LinkedHashMap<String, EarthEllipsoid>(10);
        }
        hash.put(name, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getEpsgId() {
        return this.epsgId;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarthEllipsoid)) {
            return false;
        }
        EarthEllipsoid oe = (EarthEllipsoid)o;
        return oe.name.equals(this.name);
    }
}

