/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group {
    protected NetcdfFile ncfile;
    protected Group parent;
    protected String shortName;
    protected List<Variable> variables = new ArrayList<Variable>();
    protected List<Dimension> dimensions = new ArrayList<Dimension>();
    protected List<Group> groups = new ArrayList<Group>();
    protected List<Attribute> attributes = new ArrayList<Attribute>();
    protected List<EnumTypedef> enumTypedefs = new ArrayList<EnumTypedef>();
    private boolean immutable = false;
    private int hashCode = 0;

    public String getName() {
        return this.parent == null || this.parent == this.ncfile.getRootGroup() ? this.shortName : this.parent.getName() + "/" + this.shortName;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Group getParentGroup() {
        return this.parent;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable findVariable(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        for (Variable v : this.variables) {
            if (!varShortName.equals(v.getShortName())) continue;
            return v;
        }
        return null;
    }

    public Variable findVariableOrInParent(String varShortName) {
        if (varShortName == null) {
            return null;
        }
        Variable v = this.findVariable(varShortName);
        if (v == null && this.parent != null) {
            v = this.parent.findVariableOrInParent(varShortName);
        }
        return v;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public NetcdfFile getNetcdfFile() {
        return this.ncfile;
    }

    public Group findGroup(String groupShortName) {
        if (groupShortName == null) {
            return null;
        }
        groupShortName = NetcdfFile.unescapeName(groupShortName);
        for (Group group : this.groups) {
            if (!groupShortName.equals(group.getShortName())) continue;
            return group;
        }
        return null;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<EnumTypedef> getEnumTypedefs() {
        return this.enumTypedefs;
    }

    public Dimension findDimension(String name) {
        if (name == null) {
            return null;
        }
        Dimension d = this.findDimensionLocal(name = NetcdfFile.unescapeName(name));
        if (d != null) {
            return d;
        }
        if (this.parent != null) {
            return this.parent.findDimension(name);
        }
        return null;
    }

    public Dimension findDimensionLocal(String name) {
        if (name == null) {
            return null;
        }
        name = NetcdfFile.unescapeName(name);
        for (Dimension d : this.dimensions) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute findAttribute(String name) {
        if (name == null) {
            return null;
        }
        name = NetcdfFile.unescapeName(name);
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute findAttributeIgnoreCase(String name) {
        if (name == null) {
            return null;
        }
        name = NetcdfFile.unescapeName(name);
        for (Attribute a : this.attributes) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public EnumTypedef findEnumeration(String name) {
        if (name == null) {
            return null;
        }
        name = NetcdfFile.unescapeName(name);
        for (EnumTypedef d : this.enumTypedefs) {
            if (!name.equals(d.getName())) continue;
            return d;
        }
        if (this.parent != null) {
            return this.parent.findEnumeration(name);
        }
        return null;
    }

    public Group commonParent(Group other) {
        if (this.isParent(other)) {
            return this;
        }
        if (other.isParent(this)) {
            return other;
        }
        while (!other.isParent(this)) {
            other = other.getParentGroup();
        }
        return other;
    }

    public boolean isParent(Group other) {
        while (other != this && other.getParentGroup() != null) {
            other = other.getParentGroup();
        }
        return other == this;
    }

    public String getNameAndAttributes() {
        StringBuilder sbuff = new StringBuilder();
        sbuff.append("Group ");
        sbuff.append(this.getShortName());
        sbuff.append("\n");
        for (Attribute att : this.attributes) {
            sbuff.append("  ").append(this.getShortName()).append(":");
            sbuff.append(att.toString());
            sbuff.append(";");
            sbuff.append("\n");
        }
        return sbuff.toString();
    }

    protected void writeCDL(PrintWriter out, String indent, boolean strict) {
        boolean hasA;
        boolean hasE = this.enumTypedefs.size() > 0;
        boolean hasD = this.dimensions.size() > 0;
        boolean hasV = this.variables.size() > 0;
        boolean hasG = this.groups.size() > 0;
        boolean bl = hasA = this.attributes.size() > 0;
        if (hasE) {
            out.print(indent + " types:\n");
            for (EnumTypedef e : this.enumTypedefs) {
                out.print(indent + e.writeCDL(strict));
                out.print(indent + "\n");
            }
            out.print(indent + "\n");
        }
        if (hasD) {
            out.print(indent + " dimensions:\n");
        }
        for (Dimension myd : this.dimensions) {
            out.print(indent + myd.writeCDL(strict));
            out.print(indent + "\n");
        }
        if (hasV) {
            out.print(indent + " variables:\n");
        }
        for (Variable v : this.variables) {
            out.print(v.writeCDL(indent + "   ", false, strict));
        }
        for (Group g : this.groups) {
            String gname = strict ? NetcdfFile.escapeName(g.getShortName()) : g.getShortName();
            out.print("\n " + indent + "Group " + gname + " {\n");
            g.writeCDL(out, indent + "  ", strict);
            out.print(indent + " }\n");
        }
        if (hasA && (hasE || hasD || hasV || hasG)) {
            out.print("\n");
        }
        if (hasA && strict) {
            out.print(indent + " // global attributes:\n");
        }
        for (Attribute att : this.attributes) {
            String name = strict ? NetcdfFile.escapeName(this.getShortName()) : this.getShortName();
            out.print(indent + " " + name + ":");
            out.print(att.toString(strict));
            out.print(";");
            if (!strict && att.getDataType() != DataType.STRING) {
                out.print(" // " + (Object)((Object)att.getDataType()));
            }
            out.print("\n");
        }
    }

    public Group(NetcdfFile ncfile, Group parent, String shortName) {
        this.ncfile = ncfile;
        this.parent = parent == null ? ncfile.getRootGroup() : parent;
        this.shortName = shortName;
    }

    public void setParentGroup(Group parent) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.parent = parent == null ? this.ncfile.getRootGroup() : parent;
    }

    public void setName(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.shortName = shortName;
    }

    public void addAttribute(Attribute att) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute a = this.attributes.get(i);
            if (!att.getName().equals(a.getName())) continue;
            this.attributes.set(i, att);
            return;
        }
        this.attributes.add(att);
    }

    public void addDimension(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findDimensionLocal(d.getName()) != null) {
            throw new IllegalArgumentException("Variable name (" + d.getName() + ") must be unique within Group " + this.getName());
        }
        this.dimensions.add(d);
        d.setGroup(this);
    }

    public void addGroup(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (this.findGroup(g.getShortName()) != null) {
            throw new IllegalArgumentException("Variable name (" + g.getShortName() + ") must be unique within Group " + this.getName());
        }
        this.groups.add(g);
        g.parent = this;
    }

    public void addEnumeration(EnumTypedef e) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (e == null) {
            return;
        }
        this.enumTypedefs.add(e);
    }

    public void addVariable(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return;
        }
        if (this.findVariable(v.getShortName()) != null) {
            throw new IllegalArgumentException("Variable name (" + v.getShortName() + ") must be unique within Group " + this.getName());
        }
        this.variables.add(v);
        v.setParentGroup(this);
    }

    public boolean remove(Attribute a) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return a != null && this.attributes.remove(a);
    }

    public boolean remove(Dimension d) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return d != null && this.dimensions.remove(d);
    }

    public boolean remove(Group g) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return g != null && this.groups.remove(g);
    }

    public boolean remove(Variable v) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        return v != null && this.variables.remove(v);
    }

    public boolean removeDimension(String dimName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.dimensions.size(); ++i) {
            Dimension d = this.dimensions.get(i);
            if (!dimName.equals(d.getName())) continue;
            this.dimensions.remove(d);
            return true;
        }
        return false;
    }

    public boolean removeVariable(String shortName) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Variable v = this.variables.get(i);
            if (!shortName.equals(v.getShortName())) continue;
            this.variables.remove(v);
            return true;
        }
        return false;
    }

    public Group setImmutable() {
        this.immutable = true;
        this.variables = Collections.unmodifiableList(this.variables);
        this.dimensions = Collections.unmodifiableList(this.dimensions);
        this.groups = Collections.unmodifiableList(this.groups);
        this.attributes = Collections.unmodifiableList(this.attributes);
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof Group)) {
            return false;
        }
        Group og = (Group)oo;
        if (!this.getShortName().equals(og.getShortName())) {
            return false;
        }
        return this.getParentGroup() == null || this.getParentGroup().equals(og.getParentGroup());
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getShortName().hashCode();
            if (this.getParentGroup() != null) {
                result = 37 * result + this.getParentGroup().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }
}

