/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;

public class TempRunner {
    static void testAllInDir(File dir, MClosure closure) throws IOException, InvalidRangeException {
        File[] fa = dir.listFiles();
        if (fa == null || fa.length == 0) {
            return;
        }
        List<File> list = Arrays.asList(fa);
        Collections.sort(list);
        for (File f : list) {
            if (f.isDirectory()) {
                TempRunner.testAllInDir(f, closure);
                continue;
            }
            closure.run(f.getPath());
        }
    }

    public void testWriteNcml() throws IOException, InvalidRangeException {
        Average fileAvg = new Average();
        final NcMLWriter writer = new NcMLWriter();
        TempRunner.testAllInDir(new File("C:/data/grib/"), new MClosure(){

            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith("grib1")) {
                    return;
                }
                NetcdfFile ncfile = NetcdfDataset.openFile(filename, null);
                File fileout = new File(filename + ".ncml");
                if (fileout.exists()) {
                    fileout.delete();
                }
                writer.writeXMLexplicit(ncfile, new FileOutputStream(fileout), null);
                System.out.println(" wrote ncml file  =" + fileout);
            }
        });
    }

    public void testOpenFile() throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TempRunner.testAllInDir(new File("C:/data/grib/"), new MClosure(){

            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith("ncml")) {
                    return;
                }
                System.out.println(" open ncml file  =" + filename);
                TempRunner.openFile(filename, fileAvg, true);
            }
        });
        System.out.println(" open ncml file  =" + fileAvg);
    }

    static void openFile(String filename, Average avg, boolean enhance) throws IOException, InvalidRangeException {
        try {
            long start = System.nanoTime();
            NetcdfFile ncfile = enhance ? NetcdfDataset.openDataset(filename) : NetcdfDataset.openFile(filename, null);
            long end = System.nanoTime();
            double took = (double)(end - start) / 1000.0 / 1000.0 / 1000.0;
            ncfile.close();
            if (avg != null) {
                avg.add(took);
            }
        }
        catch (Exception e) {
            System.out.println("BAD " + filename);
            e.printStackTrace();
        }
    }

    static void testOpenFile(String dir, final String suffix) throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TempRunner.testAllInDir(new File(dir), new MClosure(){

            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith(suffix)) {
                    return;
                }
                TempRunner.openFile(filename, fileAvg, false);
            }
        });
        System.out.println("*** open " + suffix + " files  =" + fileAvg);
    }

    static void testOpenDataset(String dir, final String suffix) throws IOException, InvalidRangeException {
        final Average fileAvg = new Average();
        TempRunner.testAllInDir(new File(dir), new MClosure(){

            public void run(String filename) throws IOException, InvalidRangeException {
                if (!filename.endsWith(suffix)) {
                    return;
                }
                TempRunner.openFile(filename, fileAvg, true);
            }
        });
        System.out.println("*** open " + suffix + " datasets  =" + fileAvg);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException {
        String dir = args[0];
        String suffix = args[1];
        TempRunner.testOpenFile(dir, suffix);
        TempRunner.testOpenDataset(dir, suffix);
    }

    static interface MClosure {
        public void run(String var1) throws IOException, InvalidRangeException;
    }

    private static class Average {
        private ArrayList values = new ArrayList();

        private Average() {
        }

        public void add(double value) {
            this.values.add(new Double(value));
        }

        public double mean() {
            int elements = this.values.size();
            if (elements == 0) {
                throw new IllegalStateException("No values");
            }
            double sum = 0.0;
            for (int i = 0; i < this.values.size(); ++i) {
                Double valo = (Double)this.values.get(i);
                sum += valo.doubleValue();
            }
            return sum / (double)elements;
        }

        public double stddev() {
            double mean = this.mean();
            double stddevtotal = 0.0;
            for (int i = 0; i < this.values.size(); ++i) {
                Double valo = (Double)this.values.get(i);
                double dev = valo - mean;
                stddevtotal += dev * dev;
            }
            return Math.sqrt(stddevtotal / (double)this.values.size());
        }

        public String toString() {
            return " avg= " + this.mean() + " stdev= " + this.stddev() + " count= " + this.values.size();
        }
    }
}

