#!/usr/bin/perl

package eBay::API::XML::Call::SetCart;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetCart.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 07/07/2008 17:42
# API Release Number: ... 571
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetCart

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetCart inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::SetCart::SetCartRequestType;
use eBay::API::XML::Call::SetCart::SetCartResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'SetCart';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetCart::SetCartRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::SetCart::SetCartResponseType';
}

#
# input properties
#

=head2 setAffiliateTrackingDetails()

Container for affiliate tags.
If you use affiliate tags, it is possible to get affiliate commissions
based on calls made by your application.
(See the <a href="https://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a>
for information about commissions.)
Affiliate tags enable the tracking of user activity.
You can use child tags of AffiliateTrackingDetails if you want
call output to include a string, in
Item.ListingDetails.ViewItemURL, that includes
affiliate tracking information.
Affiliate details that you provide appear in the CheckoutURL that is returned by SetCart.
Child elements of this element that are marked as conditionally required are required
only if this container is present.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AffiliateTrackingConcepts
Title: Affiliate Tracking Concepts

  RequiredInput: No
#    Argument: 'ns:AffiliateTrackingDetailsType'

=cut
       
sub setAffiliateTrackingDetails {
   my $self   = shift;
   my $pAffiliateTrackingDetails = shift;
   $self->getRequestDataType()->setAffiliateTrackingDetails($pAffiliateTrackingDetails);
}

=head2 setCartID()

The ID of an existing cart whose contents you wish to modify.
To create a new cart, omit this tag altogether and preserve
the CartID that is returned for subsequent calls to SetCart for that cart.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut
       
sub setCartID {
   my $self   = shift;
   my $sCartID = shift;
   $self->getRequestDataType()->setCartID($sCartID);
}

=head2 setCartItemArray()

Array of CartItem (details about items and what is to be done with each,
such as add, delete, update).

  RequiredInput: No
#    Argument: 'ns:CartItemArrayType'

=cut
       
sub setCartItemArray {
   my $self   = shift;
   my $pCartItemArray = shift;
   $self->getRequestDataType()->setCartItemArray($pCartItemArray);
}

=head2 setCheckoutCompleteRedirect()

When the user has completed eBay Express checkout with the shopping cart, the
user is shown a link to your website. This element enables you to define the
properties of that link--its URL and its visible name.

  RequiredInput: No
#    Argument: 'ns:CheckoutCompleteRedirectType'

=cut
       
sub setCheckoutCompleteRedirect {
   my $self   = shift;
   my $pCheckoutCompleteRedirect = shift;
   $self->getRequestDataType()->setCheckoutCompleteRedirect($pCheckoutCompleteRedirect);
}

=head2 setShippingAddress()

The country and postal code to which the items in the cart are to be shipped. Required only
if you want shipping costs calculated for those items for which calculated
shipping applies. Of no value if there are no items in the cart with calculated shipping.

  RequiredInput: No
#    Argument: 'ns:AddressType'

=cut
       
sub setShippingAddress {
   my $self   = shift;
   my $pShippingAddress = shift;
   $self->getRequestDataType()->setShippingAddress($pShippingAddress);
}



#
# output properties
#

=head2 getCart()

Details about the cart.

  Returned: Always
#    Returns: 'ns:CartType'

=cut
       
sub getCart {
   my $self = shift;
   return $self->getResponseDataType()->getCart();
}





1;   
