### sub xdg-config-dirs

```perl6
sub xdg-config-dirs(
    Bool:D :$home = Bool::True
) returns Iterable
```

Retrieve the value of XDG_CONFIG_DIRS as a sequence of IO::Path objects. If this variable is not set, it will use the default value of /etc/xdg. These directories should be read in order to retrieve configuration files.

class Bool:D :$home = Bool::True
--------------------------------

When set to true, this sequence will start with the XDG_CONFIG_HOME value (or its default).

### sub xdg-config-home

```perl6
sub xdg-config-home() returns IO::Path
```

Returns an IO::Path for $XDG_CONFIG_HOME, if it exists as environment variable. Otherwise, return the default value, $HOME/.config. This directory should contain user-specific configuration files.

### sub xdg-cache-home

```perl6
sub xdg-cache-home() returns IO::Path
```

Returns an IO::Path for $XDG_CACHE_HOME, if it exists as environment variable. Otherwise, return the default value, $HOME/.cache. This directory should contain user-specific, non-essential (cached) data.

### sub xdg-data-dirs

```perl6
sub xdg-data-dirs(
    Bool:D :$home = Bool::True
) returns Iterable
```

Retrieve the value of XDG_DATA_DIRS as a sequence of IO::Path objects. If this variable is not set, it will use the default values of /usr/local/share and /usr/share. These directories should be read in order to retrieve user specific data files.

class Bool:D :$home = Bool::True
--------------------------------

When set to true, this sequence will start with the XDG_DATA_HOME value (or its default).

### sub xdg-data-home

```perl6
sub xdg-data-home() returns IO::Path
```

Returns an IO::Path for $XDG_DATA_HOME, if it exists as environment variable. Otherwise, return the default value, $HOME/.local/share. This directory should contain user-specific data files.

### sub xdg-runtime-dir

```perl6
sub xdg-runtime-dir() returns IO::Path
```

Returns an IO::Path for $XDG_RUNTIME_DIR, if it exists as environment variable. Otherwise, return an IO::Path to a temporary directory. This directory should contain user-specific runtime files and other file objects.

NAME
====

IO::Path::XDG

AUTHOR
======

Patrick Spek <p.spek@tyil.work>

VERSION
=======

0.2.0

Synopsis
========

Description
===========

Examples
========

See also
========

