#!/usr/bin/env perl

use v5.14;
use strict;
use warnings;

use utf8;
use open IO => ':utf8', ':std';

use Data::Dumper;
{
    no warnings 'redefine';
    *Data::Dumper::qquote = sub { qq["${\(shift)}"] };
    $Data::Dumper::Useperl = 1;
}

use Pod::Usage;
use Getopt::Long;
Getopt::Long::Configure("bundling");
GetOptions(
    my $opt = {
	monomania => 0,
	ignore    => { map {$_ => 1} qw(時 とき 他 外 ほか) },
    },
    "debug!",
    "reorder!",
    "monomania!",
    "skipfixed!",
    "ignore=s%",
    ) || usage({status => 1});

use Data::Section -setup;
sub section {
    my $ref;
    ($ref = __PACKAGE__->section_data(+shift)) and $$ref;
};

my $header = section "HEAD";

my $data = do {
    local $_ = section "DICT" or die "No dictionary";
    s/^\s*(?:#.*)?\n//mg;
    tr[〜～][]d;
    $_;
};

use App::Greple::subst::Dict;

my @data = grep length, split qr/ ^ (.*)\n ◯.*\n ✕.*\n /mx, $data;
@data % 2 and die;

use Regexp::Assemble;

my $dict = App::Greple::subst::Dict->new;

while (my($a, $b) = splice @data, 0, 2) {
    for my $comment ( "#", "# $a", "#" ) {
	$dict->add_comment($comment);
    }
    my @b = $b =~ /.+/g;
    if (@b % 2) {
	warn "Wrong number: ", Dumper \@b;
    }
    while (@b) {
	my($ok, $ng) = splice @b, 0, 2;
	my $first = $ok =~ s/、.*//r;
	my $re = Regexp::Assemble
	    ->new->add(split(/、/, $ok), split(/、/, $ng))
	    ->as_string;
	for ($first) {
	    s/^\(\?<=.*?\)//;
	}
	next if $opt->{ignore}->{$first};
	$dict->add($re, $first);
    }
}

print $header if $header;

$dict->print;

exit;

__DATA__

__[ HEAD ]__
#
# JTF日本語標準スタイルガイド（翻訳用）
# 第3.0版
# 2019年8月20日
# 一般社団法人 日本翻訳連盟（JTF）
# 翻訳品質委員会
# https://www.jtf.jp/jp/style_guide/pdf/jtf_style_guide.pdf
#

__[ DICT ]__
活用のある語は、活用語尾を送る

◯ 使用する
✕ 使用しない

行う
行なう

表す
表わす

現れる
現われる

浮かぶ
浮ぶ

終わる
終る

# 名詞の送りがな
# 
# 答え、答
# 
# 曇り、曇
# 
# 届け、届
# 
# 願い、願

原則として、活用のある複合語（動詞）では送りがなを省略しない

◯ 使用する
✕ 使用しない

書き込む
書込む

取り扱う
取扱う

引き換える
引換える

申し込む
申込む

請け負う
請負う

組み立てる
組立てる

# ・活用のある複合語（動詞）から派生した名詞では送りがなを省略できる
# 
# ◯ 使用する
# 
# 取り扱い、取扱い、取扱
# 
# 繰り上げ、繰上げ、繰上
# 
# 引き換え、引換え、引換
# 
# 組み立て、組立て、組立
# 
# 申し込み、申込み、申込
# 
# 置き場、置場

送りがなの省略が慣用として定着している名詞は、送りがなを省略する

◯ 使用する
✕ 使用しない

取締役
取り締役、取締り役、取り締り役、取り締役、取締まり役、取り締まり役

請負
請け負、請負い、請け負い

繰入率
繰り入率、繰入れ率、繰り入れ率

申込書
申し込書、申込み書、申し込み書

売上金
売上げ金、売り上金、売り上げ金

カタカナ語の末尾の長音は原則として省略しない

◯ 使用する
✕ 使用しない

コンピューター
コンピュータ

ドライバー
ドライバ

メーカー
メーカ

プリンター
プリンタ

タイマー
タイマ

ユーザー
ユーザ

エレベーター
エレベータ

モーター
モータ

カレンダー
カレンダ

レーダー
レーダ

モジュラー
モジュラ

アクセサリー
アクセサリ

エネルギー
エネルギ

アイデンティティー
アイデンティティ

メロディー
メロディ

メモリー
メモリ

パーティー
パーティ

エディター
エディタ

# 中黒または半角スペースを用いてカタカナ語を区切って表記する
# 
# ◯ 使用する
# ✕ 使用しない
# 
# カー・ナビゲーション・システム
# カー ナビゲーション システム
# 
# カーナビゲーションシステム

ひらがなで書く

◯ 使用する
✕ 使用しない

あらかじめ
予め

いずれ
何れ

いつ
何時

およそ
凡そ

おもむろに
徐に

かえって
却って

かつ
且つ

〜かもしれない
〜かも知れない

〜ください
〜下さい

これほど
これ程

# ご〜
# 御〜

～(?<=する)こと
～(?<=する)事

子ども
子供、こども

さらに
更に

しかし
然し

しばらく
暫く

すなわち
即ち

〜すべき
〜可き

せっかく
折角

たびたび
度々

ただし
但し

〜たち
〜達

ため
為

できる
出来る

どこ
何処

ないし
乃至

なお
尚

なかなか
中々

ほど
程

または
又は

むしろ
寧ろ

めったに
滅多に

もはや
最早

もしくは
若しくは

もって
以て、以って

〜ように
〜様に

よほど
余程

漢字で書く

◯ 使用する
✕ 使用しない

一切
いっさい

必ず
かならず

大いに
おおいに

強いて
しいて

〜中
〜じゅう

何しろ
なにしろ

何も
なにも

何らかの
なんらかの

何とも
なんとも


漢字を使い分ける

◯ 使用する
✕ 使用しない

箇所
個所

箇条書き
個条書き

付属する
附属する

摩耗、摩滅
磨耗、磨滅

品詞・意味で使い分ける

◯ 使用する
✕ 使用しない

および
及び

及ぶ
およぶ

いたします
致します

致す
いたす

したがって
従って

従う
したがう

〜だす
〜出す

〜出す
〜だす

付く
つく

〜つく
〜付く

〜つき
〜付き

〜とおり
〜通り

～とき
～時

時
とき

ほしい
欲しい

欲しい
ほしい

あまりに
余りに

〜うえで
〜上で

複数の表記方法が一般的で、実務文書で頻出する語

◯ 使用する
✕ 使用しない

きわめて
極めて

さまざま
様々

すでに
既に

すべて
全て

ともに
共に

たとえば
例えば

ただちに
直ちに

とうてい
到底

はたして
果たして

ひときわ
一際

ひとたび
一度

ほか
他、外

ほかならぬ
他ならぬ、外ならぬ

まったく
全く

もともと
元々

わかる
分かる、解る、判る

ひとつひとつ
一つ一つ

わたし
私

われわれ
我々

わが
我が

# # 算用数字を使う
# 
# ◯ 使用する
# 
# 1億2805万人
# 
# 1番目、2番目
# 
# 3つのボタン
# 
# 2進法
# 
# 第3回大会
# 
# 3次元
# 
# 4か月

# # 漢数字を使う
# 
# ◯ 使用する
# 
# 世界一
# 
# 一番に
# 
# 一時的
# 
# 数百倍
# 
# 一部分
# 
# 二次関数
# 
# 第三者
# 
# 四捨五入
# 
# 一種の
# 
# 四角い
# 
# 一部の
# 
# 五大陸

# # 助数詞に伴う「ヵ」、「か」、「カ」、「ヶ」、「ケ」、「箇」、「個」の表記は、原則として、ひらがなの「か」を使います。
# 
# ◯ 使用する
# 
# 〜か月、〜か所
# 
# 3か月未満。数か月。10か所。
# 
# 〜か国
# 
# 3か国会議。
# 
# 〜か年
# 
# 5か年計画。
