/*
 Copyright (C) 2016-2017 Alexander Borisov

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

 Author: lex.borisov@gmail.com (Alexander Borisov)
*/

#ifndef MyCSS_VALUES_COLOR_RESOURCES_H
#define MyCSS_VALUES_COLOR_RESOURCES_H
#pragma once

#define MyCSS_COLOR_NAME_STATIC_INDEX_FOR_SEARCH_SIZE 247
#define MyCSS_COLOR_FUNCTION_STATIC_INDEX_FOR_SEARCH_SIZE 133

static const mycss_values_color_index_static_entry_t mycss_values_color_name_index_static_for_search[] = 
{
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"rebeccapurple", 13, MyCSS_VALUES_COLOR_ID_REBECCAPURPLE, 6697881, 0, 1},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"slategray", 9, MyCSS_VALUES_COLOR_ID_SLATEGRAY, 7372944, 248, 7},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"thistle", 7, MyCSS_VALUES_COLOR_ID_THISTLE, 14204888, 0, 9},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"lightpink", 9, MyCSS_VALUES_COLOR_ID_LIGHTPINK, 16758465, 249, 18},
	{"pink", 4, MyCSS_VALUES_COLOR_ID_PINK, 16761035, 0, 19},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"burlywood", 9, MyCSS_VALUES_COLOR_ID_BURLYWOOD, 14596231, 0, 22},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"cornsilk", 8, MyCSS_VALUES_COLOR_ID_CORNSILK, 16775388, 0, 24},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"indigo", 6, MyCSS_VALUES_COLOR_ID_INDIGO, 4915330, 0, 30},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkblue", 8, MyCSS_VALUES_COLOR_ID_DARKBLUE, 139, 0, 32},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"mediumaquamarine", 16, MyCSS_VALUES_COLOR_ID_MEDIUMAQUAMARINE, 6737322, 0, 34},
	{"mistyrose", 9, MyCSS_VALUES_COLOR_ID_MISTYROSE, 16770273, 0, 35},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"sandybrown", 10, MyCSS_VALUES_COLOR_ID_SANDYBROWN, 16032864, 0, 37},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"lavenderblush", 13, MyCSS_VALUES_COLOR_ID_LAVENDERBLUSH, 16773365, 0, 40},
	{"lightgray", 9, MyCSS_VALUES_COLOR_ID_LIGHTGRAY, 13882323, 250, 41},
	{"lemonchiffon", 12, MyCSS_VALUES_COLOR_ID_LEMONCHIFFON, 16775885, 0, 42},
	{"skyblue", 7, MyCSS_VALUES_COLOR_ID_SKYBLUE, 8900331, 0, 43},
	{"ghostwhite", 10, MyCSS_VALUES_COLOR_ID_GHOSTWHITE, 16316671, 0, 44},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"ivory", 5, MyCSS_VALUES_COLOR_ID_IVORY, 16777200, 0, 47},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"peru", 4, MyCSS_VALUES_COLOR_ID_PERU, 13468991, 0, 53},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"brown", 5, MyCSS_VALUES_COLOR_ID_BROWN, 10824234, 251, 55},
	{"mediumspringgreen", 17, MyCSS_VALUES_COLOR_ID_MEDIUMSPRINGGREEN, 64154, 0, 56},
	{"lightcoral", 10, MyCSS_VALUES_COLOR_ID_LIGHTCORAL, 15761536, 0, 57},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"blueviolet", 10, MyCSS_VALUES_COLOR_ID_BLUEVIOLET, 9055202, 0, 61},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"maroon", 6, MyCSS_VALUES_COLOR_ID_MAROON, 8388608, 253, 64},
	{"peachpuff", 9, MyCSS_VALUES_COLOR_ID_PEACHPUFF, 16767673, 0, 65},
	{"lightseagreen", 13, MyCSS_VALUES_COLOR_ID_LIGHTSEAGREEN, 2142890, 0, 66},
	{"black", 5, MyCSS_VALUES_COLOR_ID_BLACK, 0, 254, 67},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkcyan", 8, MyCSS_VALUES_COLOR_ID_DARKCYAN, 35723, 0, 69},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"salmon", 6, MyCSS_VALUES_COLOR_ID_SALMON, 16416882, 0, 72},
	{"blue", 4, MyCSS_VALUES_COLOR_ID_BLUE, 255, 0, 73},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"white", 5, MyCSS_VALUES_COLOR_ID_WHITE, 16777215, 0, 75},
	{"goldenrod", 9, MyCSS_VALUES_COLOR_ID_GOLDENROD, 14329120, 0, 76},
	{"currentcolor", 12, MyCSS_VALUES_COLOR_ID_CURRENTCOLOR, 0, 0, 77},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkgoldenrod", 13, MyCSS_VALUES_COLOR_ID_DARKGOLDENROD, 12092939, 0, 79},
	{"azure", 5, MyCSS_VALUES_COLOR_ID_AZURE, 15794175, 0, 80},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"orange", 6, MyCSS_VALUES_COLOR_ID_ORANGE, 16753920, 0, 83},
	{"chocolate", 9, MyCSS_VALUES_COLOR_ID_CHOCOLATE, 13789470, 256, 84},
	{"moccasin", 8, MyCSS_VALUES_COLOR_ID_MOCCASIN, 16770229, 0, 85},
	{"darksalmon", 10, MyCSS_VALUES_COLOR_ID_DARKSALMON, 15308410, 0, 86},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"green", 5, MyCSS_VALUES_COLOR_ID_GREEN, 32768, 0, 88},
	{"cyan", 4, MyCSS_VALUES_COLOR_ID_CYAN, 65535, 257, 89},
	{"springgreen", 11, MyCSS_VALUES_COLOR_ID_SPRINGGREEN, 65407, 258, 90},
	{"beige", 5, MyCSS_VALUES_COLOR_ID_BEIGE, 16119260, 259, 91},
	{"hotpink", 7, MyCSS_VALUES_COLOR_ID_HOTPINK, 16738740, 260, 92},
	{"aqua", 4, MyCSS_VALUES_COLOR_ID_AQUA, 65535, 0, 93},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"fuchsia", 7, MyCSS_VALUES_COLOR_ID_FUCHSIA, 16711935, 0, 99},
	{"darkred", 7, MyCSS_VALUES_COLOR_ID_DARKRED, 9109504, 0, 100},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkseagreen", 12, MyCSS_VALUES_COLOR_ID_DARKSEAGREEN, 9419919, 0, 103},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"khaki", 5, MyCSS_VALUES_COLOR_ID_KHAKI, 15787660, 0, 107},
	{"wheat", 5, MyCSS_VALUES_COLOR_ID_WHEAT, 16113331, 0, 108},
	{"coral", 5, MyCSS_VALUES_COLOR_ID_CORAL, 16744272, 261, 109},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"orangered", 9, MyCSS_VALUES_COLOR_ID_ORANGERED, 16729344, 0, 113},
	{"lightblue", 9, MyCSS_VALUES_COLOR_ID_LIGHTBLUE, 11393254, 0, 114},
	{"red", 3, MyCSS_VALUES_COLOR_ID_RED, 16711680, 262, 115},
	{"blanchedalmond", 14, MyCSS_VALUES_COLOR_ID_BLANCHEDALMOND, 16772045, 0, 116},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"palevioletred", 13, MyCSS_VALUES_COLOR_ID_PALEVIOLETRED, 14381203, 263, 118},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkolivegreen", 14, MyCSS_VALUES_COLOR_ID_DARKOLIVEGREEN, 5597999, 0, 120},
	{"linen", 5, MyCSS_VALUES_COLOR_ID_LINEN, 16445670, 0, 121},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"violet", 6, MyCSS_VALUES_COLOR_ID_VIOLET, 15631086, 0, 125},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"royalblue", 9, MyCSS_VALUES_COLOR_ID_ROYALBLUE, 4286945, 0, 134},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"navy", 4, MyCSS_VALUES_COLOR_ID_NAVY, 128, 0, 136},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"mediumorchid", 12, MyCSS_VALUES_COLOR_ID_MEDIUMORCHID, 12211667, 0, 138},
	{"deeppink", 8, MyCSS_VALUES_COLOR_ID_DEEPPINK, 16716947, 0, 139},
	{"mediumslateblue", 15, MyCSS_VALUES_COLOR_ID_MEDIUMSLATEBLUE, 8087790, 264, 140},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkturquoise", 13, MyCSS_VALUES_COLOR_ID_DARKTURQUOISE, 52945, 265, 144},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"gainsboro", 9, MyCSS_VALUES_COLOR_ID_GAINSBORO, 14474460, 0, 146},
	{"darkkhaki", 9, MyCSS_VALUES_COLOR_ID_DARKKHAKI, 12433259, 266, 147},
	{"mediumseagreen", 14, MyCSS_VALUES_COLOR_ID_MEDIUMSEAGREEN, 3978097, 0, 148},
	{"whitesmoke", 10, MyCSS_VALUES_COLOR_ID_WHITESMOKE, 16119285, 0, 149},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"snow", 4, MyCSS_VALUES_COLOR_ID_SNOW, 16775930, 0, 154},
	{"crimson", 7, MyCSS_VALUES_COLOR_ID_CRIMSON, 14423100, 0, 155},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"orchid", 6, MyCSS_VALUES_COLOR_ID_ORCHID, 14315734, 267, 158},
	{"magenta", 7, MyCSS_VALUES_COLOR_ID_MAGENTA, 16711935, 268, 159},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"lime", 4, MyCSS_VALUES_COLOR_ID_LIME, 65280, 269, 161},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"firebrick", 9, MyCSS_VALUES_COLOR_ID_FIREBRICK, 11674146, 270, 168},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"lightslategray", 14, MyCSS_VALUES_COLOR_ID_LIGHTSLATEGRAY, 7833753, 271, 173},
	{"plum", 4, MyCSS_VALUES_COLOR_ID_PLUM, 14524637, 0, 174},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"mediumblue", 10, MyCSS_VALUES_COLOR_ID_MEDIUMBLUE, 205, 0, 176},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"seagreen", 8, MyCSS_VALUES_COLOR_ID_SEAGREEN, 3050327, 0, 178},
	{"oldlace", 7, MyCSS_VALUES_COLOR_ID_OLDLACE, 16643558, 0, 179},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"cornflowerblue", 14, MyCSS_VALUES_COLOR_ID_CORNFLOWERBLUE, 6591981, 0, 185},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"yellowgreen", 11, MyCSS_VALUES_COLOR_ID_YELLOWGREEN, 10145074, 0, 187},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"lavender", 8, MyCSS_VALUES_COLOR_ID_LAVENDER, 15132410, 0, 191},
	{"yellow", 6, MyCSS_VALUES_COLOR_ID_YELLOW, 16776960, 0, 192},
	{"tomato", 6, MyCSS_VALUES_COLOR_ID_TOMATO, 16737095, 272, 193},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"purple", 6, MyCSS_VALUES_COLOR_ID_PURPLE, 8388736, 0, 195},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"floralwhite", 11, MyCSS_VALUES_COLOR_ID_FLORALWHITE, 16775920, 0, 197},
	{"deepskyblue", 11, MyCSS_VALUES_COLOR_ID_DEEPSKYBLUE, 49151, 0, 198},
	{"gold", 4, MyCSS_VALUES_COLOR_ID_GOLD, 16766720, 0, 199},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"darkgreen", 9, MyCSS_VALUES_COLOR_ID_DARKGREEN, 25600, 0, 201},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"chartreuse", 10, MyCSS_VALUES_COLOR_ID_CHARTREUSE, 8388352, 0, 203},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"grey", 4, MyCSS_VALUES_COLOR_ID_GREY, 8421504, 273, 206},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"honeydew", 8, MyCSS_VALUES_COLOR_ID_HONEYDEW, 15794160, 274, 209},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"midnightblue", 12, MyCSS_VALUES_COLOR_ID_MIDNIGHTBLUE, 1644912, 276, 211},
	{"papayawhip", 10, MyCSS_VALUES_COLOR_ID_PAPAYAWHIP, 16773077, 0, 212},
	{"darkorchid", 10, MyCSS_VALUES_COLOR_ID_DARKORCHID, 10040012, 277, 213},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"limegreen", 9, MyCSS_VALUES_COLOR_ID_LIMEGREEN, 3329330, 278, 217},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"teal", 4, MyCSS_VALUES_COLOR_ID_TEAL, 32896, 0, 219},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"turquoise", 9, MyCSS_VALUES_COLOR_ID_TURQUOISE, 4251856, 0, 223},
	{"darkgrey", 8, MyCSS_VALUES_COLOR_ID_DARKGREY, 11119017, 280, 224},
	{"palegreen", 9, MyCSS_VALUES_COLOR_ID_PALEGREEN, 10025880, 281, 225},
	{"mintcream", 9, MyCSS_VALUES_COLOR_ID_MINTCREAM, 16121850, 0, 226},
	{"dimgrey", 7, MyCSS_VALUES_COLOR_ID_DIMGREY, 6908265, 283, 227},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"rosybrown", 9, MyCSS_VALUES_COLOR_ID_ROSYBROWN, 12357519, 0, 229},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"olive", 5, MyCSS_VALUES_COLOR_ID_OLIVE, 8421376, 284, 234},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"antiquewhite", 12, MyCSS_VALUES_COLOR_ID_ANTIQUEWHITE, 16444375, 0, 240},
	{"sienna", 6, MyCSS_VALUES_COLOR_ID_SIENNA, 10506797, 286, 241},
	{"aliceblue", 9, MyCSS_VALUES_COLOR_ID_ALICEBLUE, 15792383, 287, 242},
	{"tan", 3, MyCSS_VALUES_COLOR_ID_TAN, 13808780, 0, 243},
	{"darkmagenta", 11, MyCSS_VALUES_COLOR_ID_DARKMAGENTA, 9109643, 0, 244},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_ID_UNDEF, 0, 0, 0},
	{"slategrey", 9, MyCSS_VALUES_COLOR_ID_SLATEGREY, 7372944, 0, 248},
	{"lightsalmon", 11, MyCSS_VALUES_COLOR_ID_LIGHTSALMON, 16752762, 0, 249},
	{"lightgrey", 9, MyCSS_VALUES_COLOR_ID_LIGHTGREY, 13882323, 0, 250},
	{"slateblue", 9, MyCSS_VALUES_COLOR_ID_SLATEBLUE, 6970061, 252, 251},
	{"steelblue", 9, MyCSS_VALUES_COLOR_ID_STEELBLUE, 4620980, 0, 252},
	{"transparent", 11, MyCSS_VALUES_COLOR_ID_TRANSPARENT, 0, 0, 253},
	{"seashell", 8, MyCSS_VALUES_COLOR_ID_SEASHELL, 16774638, 255, 254},
	{"lightsteelblue", 14, MyCSS_VALUES_COLOR_ID_LIGHTSTEELBLUE, 11584734, 0, 255},
	{"cadetblue", 9, MyCSS_VALUES_COLOR_ID_CADETBLUE, 6266528, 0, 256},
	{"lightyellow", 11, MyCSS_VALUES_COLOR_ID_LIGHTYELLOW, 16777184, 0, 257},
	{"saddlebrown", 11, MyCSS_VALUES_COLOR_ID_SADDLEBROWN, 9127187, 0, 258},
	{"olivedrab", 9, MyCSS_VALUES_COLOR_ID_OLIVEDRAB, 7048739, 0, 259},
	{"paleturquoise", 13, MyCSS_VALUES_COLOR_ID_PALETURQUOISE, 11529966, 0, 260},
	{"bisque", 6, MyCSS_VALUES_COLOR_ID_BISQUE, 16770244, 0, 261},
	{"silver", 6, MyCSS_VALUES_COLOR_ID_SILVER, 12632256, 0, 262},
	{"palegoldenrod", 13, MyCSS_VALUES_COLOR_ID_PALEGOLDENROD, 15657130, 0, 263},
	{"mediumturquoise", 15, MyCSS_VALUES_COLOR_ID_MEDIUMTURQUOISE, 4772300, 0, 264},
	{"darkslateblue", 13, MyCSS_VALUES_COLOR_ID_DARKSLATEBLUE, 4734347, 0, 265},
	{"indianred", 9, MyCSS_VALUES_COLOR_ID_INDIANRED, 13458524, 0, 266},
	{"darkviolet", 10, MyCSS_VALUES_COLOR_ID_DARKVIOLET, 9699539, 0, 267},
	{"aquamarine", 10, MyCSS_VALUES_COLOR_ID_AQUAMARINE, 8388564, 0, 268},
	{"lightgoldenrodyellow", 20, MyCSS_VALUES_COLOR_ID_LIGHTGOLDENRODYELLOW, 16448210, 0, 269},
	{"forestgreen", 11, MyCSS_VALUES_COLOR_ID_FORESTGREEN, 2263842, 0, 270},
	{"lightslategrey", 14, MyCSS_VALUES_COLOR_ID_LIGHTSLATEGREY, 7833753, 0, 271},
	{"navajowhite", 11, MyCSS_VALUES_COLOR_ID_NAVAJOWHITE, 16768685, 0, 272},
	{"gray", 4, MyCSS_VALUES_COLOR_ID_GRAY, 8421504, 0, 273},
	{"darkslategray", 13, MyCSS_VALUES_COLOR_ID_DARKSLATEGRAY, 3100495, 275, 274},
	{"darkslategrey", 13, MyCSS_VALUES_COLOR_ID_DARKSLATEGREY, 3100495, 0, 275},
	{"mediumpurple", 12, MyCSS_VALUES_COLOR_ID_MEDIUMPURPLE, 9662683, 0, 276},
	{"greenyellow", 11, MyCSS_VALUES_COLOR_ID_GREENYELLOW, 11403055, 0, 277},
	{"lawngreen", 9, MyCSS_VALUES_COLOR_ID_LAWNGREEN, 8190976, 279, 278},
	{"lightcyan", 9, MyCSS_VALUES_COLOR_ID_LIGHTCYAN, 14745599, 0, 279},
	{"darkgray", 8, MyCSS_VALUES_COLOR_ID_DARKGRAY, 11119017, 0, 280},
	{"dodgerblue", 10, MyCSS_VALUES_COLOR_ID_DODGERBLUE, 2003199, 282, 281},
	{"darkorange", 10, MyCSS_VALUES_COLOR_ID_DARKORANGE, 16747520, 0, 282},
	{"dimgray", 7, MyCSS_VALUES_COLOR_ID_DIMGRAY, 6908265, 0, 283},
	{"lightskyblue", 12, MyCSS_VALUES_COLOR_ID_LIGHTSKYBLUE, 8900346, 285, 284},
	{"mediumvioletred", 15, MyCSS_VALUES_COLOR_ID_MEDIUMVIOLETRED, 13047173, 0, 285},
	{"lightgreen", 10, MyCSS_VALUES_COLOR_ID_LIGHTGREEN, 9498256, 0, 286},
	{"powderblue", 10, MyCSS_VALUES_COLOR_ID_POWDERBLUE, 11591910, 0, 287},
};

static const char * mycss_values_color_name_index[152] = {
	"",
	"aliceblue",
	"antiquewhite",
	"aqua",
	"aquamarine",
	"azure",
	"beige",
	"bisque",
	"black",
	"blanchedalmond",
	"blue",
	"blueviolet",
	"brown",
	"burlywood",
	"cadetblue",
	"chartreuse",
	"chocolate",
	"coral",
	"cornflowerblue",
	"cornsilk",
	"crimson",
	"currentcolor",
	"cyan",
	"darkblue",
	"darkcyan",
	"darkgoldenrod",
	"darkgray",
	"darkgreen",
	"darkgrey",
	"darkkhaki",
	"darkmagenta",
	"darkolivegreen",
	"darkorange",
	"darkorchid",
	"darkred",
	"darksalmon",
	"darkseagreen",
	"darkslateblue",
	"darkslategray",
	"darkslategrey",
	"darkturquoise",
	"darkviolet",
	"deeppink",
	"deepskyblue",
	"dimgray",
	"dimgrey",
	"dodgerblue",
	"firebrick",
	"floralwhite",
	"forestgreen",
	"fuchsia",
	"gainsboro",
	"ghostwhite",
	"gold",
	"goldenrod",
	"gray",
	"green",
	"greenyellow",
	"grey",
	"honeydew",
	"hotpink",
	"indianred",
	"indigo",
	"ivory",
	"khaki",
	"lavender",
	"lavenderblush",
	"lawngreen",
	"lemonchiffon",
	"lightblue",
	"lightcoral",
	"lightcyan",
	"lightgoldenrodyellow",
	"lightgray",
	"lightgreen",
	"lightgrey",
	"lightpink",
	"lightsalmon",
	"lightseagreen",
	"lightskyblue",
	"lightslategray",
	"lightslategrey",
	"lightsteelblue",
	"lightyellow",
	"lime",
	"limegreen",
	"linen",
	"magenta",
	"maroon",
	"mediumaquamarine",
	"mediumblue",
	"mediumorchid",
	"mediumpurple",
	"mediumseagreen",
	"mediumslateblue",
	"mediumspringgreen",
	"mediumturquoise",
	"mediumvioletred",
	"midnightblue",
	"mintcream",
	"mistyrose",
	"moccasin",
	"navajowhite",
	"navy",
	"oldlace",
	"olive",
	"olivedrab",
	"orange",
	"orangered",
	"orchid",
	"palegoldenrod",
	"palegreen",
	"paleturquoise",
	"palevioletred",
	"papayawhip",
	"peachpuff",
	"peru",
	"pink",
	"plum",
	"powderblue",
	"purple",
	"rebeccapurple",
	"red",
	"rosybrown",
	"royalblue",
	"saddlebrown",
	"salmon",
	"sandybrown",
	"seagreen",
	"seashell",
	"sienna",
	"silver",
	"skyblue",
	"slateblue",
	"slategray",
	"slategrey",
	"snow",
	"springgreen",
	"steelblue",
	"tan",
	"teal",
	"thistle",
	"tomato",
	"transparent",
	"turquoise",
	"violet",
	"wheat",
	"white",
	"whitesmoke",
	"yellow",
	"yellowgreen",
	NULL
};

static const mycss_values_color_function_index_static_entry_t mycss_values_color_function_index_static_for_search[] = 
{
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"rgb", 3, MyCSS_VALUES_COLOR_FUNCTION_ID_RGB, mycss_values_color_parser_rgb, 0, 1},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"whiteness", 9, MyCSS_VALUES_COLOR_FUNCTION_ID_WHITENESS, mycss_values_color_parser_undef, 0, 8},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"saturation", 10, MyCSS_VALUES_COLOR_FUNCTION_ID_SATURATION, mycss_values_color_parser_undef, 0, 18},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"red", 3, MyCSS_VALUES_COLOR_FUNCTION_ID_RED, mycss_values_color_parser_undef, 0, 20},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"color", 5, MyCSS_VALUES_COLOR_FUNCTION_ID_COLOR, mycss_values_color_parser_undef, 0, 39},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"hsl", 3, MyCSS_VALUES_COLOR_FUNCTION_ID_HSL, mycss_values_color_parser_hsl, 0, 48},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"hsla", 4, MyCSS_VALUES_COLOR_FUNCTION_ID_HSLA, mycss_values_color_parser_hsla, 0, 54},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"blend", 5, MyCSS_VALUES_COLOR_FUNCTION_ID_BLEND, mycss_values_color_parser_undef, 0, 57},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"lightness", 9, MyCSS_VALUES_COLOR_FUNCTION_ID_LIGHTNESS, mycss_values_color_parser_undef, 0, 61},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"rgba", 4, MyCSS_VALUES_COLOR_FUNCTION_ID_RGBA, mycss_values_color_parser_rgba, 0, 77},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"blackness", 9, MyCSS_VALUES_COLOR_FUNCTION_ID_BLACKNESS, mycss_values_color_parser_undef, 0, 85},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"shade", 5, MyCSS_VALUES_COLOR_FUNCTION_ID_SHADE, mycss_values_color_parser_undef, 0, 88},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"blue", 4, MyCSS_VALUES_COLOR_FUNCTION_ID_BLUE, mycss_values_color_parser_undef, 0, 92},
	{"tint", 4, MyCSS_VALUES_COLOR_FUNCTION_ID_TINT, mycss_values_color_parser_undef, 0, 93},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"alpha", 5, MyCSS_VALUES_COLOR_FUNCTION_ID_ALPHA, mycss_values_color_parser_undef, 0, 97},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"a", 1, MyCSS_VALUES_COLOR_FUNCTION_ID_A, mycss_values_color_parser_undef, 0, 100},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"contrast", 8, MyCSS_VALUES_COLOR_FUNCTION_ID_CONTRAST, mycss_values_color_parser_undef, 0, 103},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"gray", 4, MyCSS_VALUES_COLOR_FUNCTION_ID_GRAY, mycss_values_color_parser_gray, 0, 111},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"blenda", 6, MyCSS_VALUES_COLOR_FUNCTION_ID_BLENDA, mycss_values_color_parser_undef, 0, 113},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"hwb", 3, MyCSS_VALUES_COLOR_FUNCTION_ID_HWB, mycss_values_color_parser_hwb, 0, 120},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"color-mod", 9, MyCSS_VALUES_COLOR_FUNCTION_ID_COLOR_MOD, mycss_values_color_parser_undef, 0, 124},
	{"hue", 3, MyCSS_VALUES_COLOR_FUNCTION_ID_HUE, mycss_values_color_parser_undef, 0, 125},
	{"green", 5, MyCSS_VALUES_COLOR_FUNCTION_ID_GREEN, mycss_values_color_parser_undef, 0, 126},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{"device-cmyk", 11, MyCSS_VALUES_COLOR_FUNCTION_ID_DEVICE_CMYK, mycss_values_color_parser_undef, 0, 129},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
	{NULL, 0, MyCSS_VALUES_COLOR_FUNCTION_ID_UNDEF, mycss_values_color_parser_undef, 0, 0},
};

static const char * mycss_values_color_function_name_index[26] = {
	"",
	"a",
	"alpha",
	"blackness",
	"blend",
	"blenda",
	"blue",
	"color",
	"color-mod",
	"contrast",
	"device-cmyk",
	"gray",
	"green",
	"hsl",
	"hsla",
	"hue",
	"hwb",
	"lightness",
	"red",
	"rgb",
	"rgba",
	"saturation",
	"shade",
	"tint",
	"whiteness",
	NULL
};

#endif /* MyCSS_VALUES_COLOR_RESOURCES_H */
