# Generated by default/object.tt
package Paws::GameLift::GameSessionConnectionInfo;
  use Moose;
  has DnsName => (is => 'ro', isa => 'Str');
  has GameSessionArn => (is => 'ro', isa => 'Str');
  has IpAddress => (is => 'ro', isa => 'Str');
  has MatchedPlayerSessions => (is => 'ro', isa => 'ArrayRef[Paws::GameLift::MatchedPlayerSession]');
  has Port => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::GameSessionConnectionInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::GameSessionConnectionInfo object:

  $service_obj->Method(Att1 => { DnsName => $value, ..., Port => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::GameSessionConnectionInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->DnsName

=head1 DESCRIPTION

Connection information for a new game session that is created in
response to a StartMatchmaking request. Once a match is made, the
FlexMatch engine creates a new game session for it. This information,
including the game session endpoint and player sessions for each player
in the original matchmaking request, is added to the MatchmakingTicket,
which can be retrieved by calling DescribeMatchmaking.

=head1 ATTRIBUTES


=head2 DnsName => Str

The DNS identifier assigned to the instance that is running the game
session. Values have the following format:

=over

=item *

TLS-enabled fleets: C<E<lt>unique identifierE<gt>.E<lt>region
identifierE<gt>.amazongamelift.com>.

=item *

Non-TLS-enabled fleets: C<ec2-E<lt>unique
identifierE<gt>.compute.amazonaws.com>. (See Amazon EC2 Instance IP
Addressing
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-instance-addressing.html#concepts-public-addresses).)

=back

When connecting to a game session that is running on a TLS-enabled
fleet, you must use the DNS name, not the IP address.


=head2 GameSessionArn => Str

A unique identifier for the game session. Use the game session ID.


=head2 IpAddress => Str

The IP address of the game session. To connect to a GameLift game
server, an app needs both the IP address and port number.


=head2 MatchedPlayerSessions => ArrayRef[L<Paws::GameLift::MatchedPlayerSession>]

A collection of player session IDs, one for each player ID that was
included in the original matchmaking request.


=head2 Port => Int

The port number for the game session. To connect to a GameLift game
server, an app needs both the IP address and port number.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

