# Generated by default/object.tt
package Paws::WorkMail::MailboxExportJob;
  use Moose;
  has Description => (is => 'ro', isa => 'Str');
  has EndTime => (is => 'ro', isa => 'Str');
  has EntityId => (is => 'ro', isa => 'Str');
  has EstimatedProgress => (is => 'ro', isa => 'Int');
  has JobId => (is => 'ro', isa => 'Str');
  has S3BucketName => (is => 'ro', isa => 'Str');
  has S3Path => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has State => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WorkMail::MailboxExportJob

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WorkMail::MailboxExportJob object:

  $service_obj->Method(Att1 => { Description => $value, ..., State => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WorkMail::MailboxExportJob object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

The details of a mailbox export job, including the user or resource ID
associated with the mailbox and the S3 bucket that the mailbox contents
are exported to.

=head1 ATTRIBUTES


=head2 Description => Str

The mailbox export job description.


=head2 EndTime => Str

The mailbox export job end timestamp.


=head2 EntityId => Str

The identifier of the user or resource associated with the mailbox.


=head2 EstimatedProgress => Int

The estimated progress of the mailbox export job, in percentage points.


=head2 JobId => Str

The identifier of the mailbox export job.


=head2 S3BucketName => Str

The name of the S3 bucket.


=head2 S3Path => Str

The path to the S3 bucket and file that the mailbox export job exports
to.


=head2 StartTime => Str

The mailbox export job start timestamp.


=head2 State => Str

The state of the mailbox export job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WorkMail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

