/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.apache.sis.measure.Scalar;

final class ScalarFallback<Q extends Quantity<Q>>
extends Scalar<Q>
implements InvocationHandler {
    private final Constructor<? extends Q> constructor;

    private ScalarFallback(double d, Unit<Q> unit, Constructor<? extends Q> constructor) {
        super(d, unit);
        this.constructor = constructor;
    }

    @Override
    Quantity<Q> create(double d, Unit<Q> unit) {
        try {
            return (Quantity)this.constructor.newInstance(new ScalarFallback<Q>(d, unit, this.constructor));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new UnsupportedOperationException(reflectiveOperationException);
        }
    }

    static <Q extends Quantity<Q>> Q factory(double d, Unit<Q> unit, Class<Q> clazz) {
        Class<?> clazz2 = Proxy.getProxyClass(Scalar.class.getClassLoader(), clazz);
        try {
            Constructor<?> constructor = clazz2.getConstructor(InvocationHandler.class);
            return (Q)((Quantity)constructor.newInstance(new ScalarFallback<Q>(d, unit, constructor)));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new UnsupportedOperationException(reflectiveOperationException);
        }
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws ReflectiveOperationException {
        return method.invoke((Object)this, objectArray);
    }
}

