package Pod::Elemental::Element::Generic::Nonpod 0.103006;
# ABSTRACT: a non-pod element in a Pod document

use Moose;
with 'Pod::Elemental::Flat';

use namespace::autoclean;

#pod =head1 OVERVIEW
#pod
#pod Generic::Nonpod elements are just like Generic::Text elements, but represent
#pod non-pod content found in the Pod stream.
#pod
#pod =cut

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Pod::Elemental::Element::Generic::Nonpod - a non-pod element in a Pod document

=head1 VERSION

version 0.103006

=head1 OVERVIEW

Generic::Nonpod elements are just like Generic::Text elements, but represent
non-pod content found in the Pod stream.

=head1 PERL VERSION

This library should run on perls released even a long time ago.  It should work
on any version of perl released in the last five years.

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to lower
the minimum required perl.

=head1 AUTHOR

Ricardo SIGNES <cpan@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by Ricardo SIGNES.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
