#!/usr/bin/perl

package eBay::API::XML::DataType::BidApprovalArrayType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidApprovalArrayType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BidApprovalArrayType

=head1 DESCRIPTION

Mulitple bidders can be approved with one call.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BidApprovalArrayType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::BidApprovalType;


my @gaProperties = ( [ 'LiveAuctionBid', 'ns:BidApprovalType', '1'
	     ,'eBay::API::XML::DataType::BidApprovalType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setLiveAuctionBid()

The settings the seller specifies about one user when approving or denying 
that user's request to bid on items in the seller's Live Auctions catalog.

  Calls: ApproveLiveAuctionBidders
  RequiredInput: No

#    Argument: reference to an array  
                      of 'ns:BidApprovalType'

=cut

sub setLiveAuctionBid {
  my $self = shift;
  $self->{'LiveAuctionBid'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getLiveAuctionBid()

#    Returns: reference to an array  
                      of 'ns:BidApprovalType'

=cut

sub getLiveAuctionBid {
  my $self = shift;
  return $self->_getDataTypeArray('LiveAuctionBid');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
