use strict;
use FileHandle;
use Crypt::SHAVS;
use Digest::SHA qw(sha224);

my ($vectors, $check) = ("vec$$.tmp", "chk$$.tmp");
END { 1 while unlink ($vectors, $check) }

my $numtests = 0;
my $fh = FileHandle->new($vectors, "w");
while (<DATA>) { print $fh $_; $numtests++ if /^MD\s*=/ }  close($fh);

$fh = FileHandle->new($check, "w+");
my $stdout = select($fh);
Crypt::SHAVS->new(\&sha224)->check($vectors);
select($stdout);

my $testnum = 1;
print "1..$numtests\n";
$fh->seek(0, 0);
while (<$fh>) {
	print "not " unless /OK\s*$/;
	print "ok ", $testnum++, "\n";
}
close($fh);

__DATA__
#  CAVS 11.0
#  "SHA-224 LongMsg" information 
#  SHA-224 tests are configured for BYTE oriented implementations
#  Generated on Tue Mar 15 08:23:37 2011

[L = 28]

Len = 1304
Msg = f149e41d848f59276cfddd743bafa9a90e1ee4a263a118142b33e3702176ef0a59f8237a1cb51b42f3ded6b202d9af0997898fdd03cf60bda951c514547a0850cec25444ae2f24cb711bfbafcc3956c941d3de69f155e3f8b10f06db5f37359b772ddd43e1035a0a0d3db33242d5843033833b0dd43b870c6bf60e8deab55f317cc3273f5e3ba747f0cb65050cb7228796210d9254873643008d45f29cfd6c5b060c9a
MD = 9db6dc3a23abd7b6c3d72c38f4843c7de48a71d0ba91a86b18393e5f

Len = 2096
Msg = c39147fad02c6ed5876eb3257837c3f456008694fac94932aa521bae9c8e77abb65524e298595abbdc5b261e9c9f0f86359dfa584bf94b740eb54d09bba6d4ad652421adf50605a170ce4a4478204e831679f1d4b61db1c9735114e595cb47ae58670403f01bb8b0c92de64013a3c6137efc33b0421dc45b638e38eb33e617d61884968e8f80bb1071e1c3b97611c15cf78e8793f8e1c95265d480c29ce08d4c2ce59ff3dc1e56e8f053a958a75085890897b625de520bd6028bb512d89ff1391cf0e7dddfdbd160ccea5fc5b04a5ac03a7f890fff56d10dc01b9f85f00d8bc4710f35f29fa073a28f0dafa798e58a2913aec5f960d662222aed06c1eb11a216b2a952da2456
MD = 2b05b170d4976409f23ce885a0a2c0a943226688d4f5bbaf35fabb46

Len = 2888
Msg = d488bdda400932de56a9f105f0e74ee79c2ed869faaadc31665c2b5dd7691d7407b8d69cd5bbc80ee78d79c8933e8781006be9e2881177f361a2add47d59acadaecb81e70ec0aa9d9e40d64d2df1edd47ca050999f1d6208a64c47427d79ec1211ec4724b4bde071c3ea90fe86a788c657f596f40776a4567d80820fa070e58c7841afb98f5d70749eb22d4265096140db93425d87c545c72e66e4a3aee79f012af2410f6745648c76c1378094be7f2b4ea2dc3be9b24e420028f7666f85235b7028858e0420c3a3953f3622d96feb6df949edf6f3e4c6ae3deb43c1abf37880920b049e2e9496a04153b08ffdc4abf024b1fcf66e04b5f52bda4f1a29d8a65ad8c245a8ac49e46bc3252f2fc864c99a170291a221b924fe121aa3dab2ddb6cf8976d01247e9b5ec63de3a6a01f84c5519633464d6ac19b13cd6c76a0eaaafc9ef4e2e46c719120b68a65aa872273d0873fc6ea353859ff6f034443005e6992f5073e6aaf48301b01c
MD = e12c2c07628185fcc930d02b5fff6408e8eb1aad2bb0032830e04ff2

Len = 3680
Msg = a67e008f13a29021d1493c7ddb0e7f4126a786f9e01991eff52c9b45d81d3d408094d0e7b1d5d2cd7c3a8a2b09e1ef3194a2c79eb6440c8fe6f093943fe5f009846e94a46111384af30a7f278bf8d6fdafd59fbc622b9054a68555c73e247d82b8f493edabbf8b413e9f619ae9b9fc4d8028587b6d38e4e63cd529045e43ad52260f17eb1845935963e378abac8e29c70d8439025ed2d2eeb3c7577325a84822d6a566c52f0c183b6cbd0e835bde241660cf897abd6020141042263e1dbc1699ce9fc9a4787ce28e601469497e10b6e081f3910a134c97ff5d30e08acee7de6018e688b07cfdb8fb48d2d2269e8ea7ce76d699dbe6fdff58a278cb82bf926a1ebc61eb10c2f8642a2bde914242bfbf874962e815c1db20c6e5022f4b7823807cc0f73aedd3d3acc21120eec4f20bc5b4027dc8df294ec1f230b656108104e9222e92bc6e35f8596c038031d436da83fca7117f61a8beac838a7c87f7639b6db70d19babc72cd33cf07e6a19c9794bf08420556c4c593a722fc3c0928a552d3e466737cfe12bc0194283a87419ca1427fda41953009357b778cde25cccf90e550408a4a5d9b2c8d626b642beece6ad40a78ad84ccfa0df029444a230b69bc69a3a3456c0197859de2da4cd5c9
MD = f6430298cd0e80d919f22cf1094988241f84b8753838afead0156940
