use lib 'blib', 'lib';
use Test::More;

use Digest::xxHash qw[xxhash xxhash_hex];

is xxhash('this is a test', 0xCAFEBABE), 2811818255, 'Demo';

my $b1 = join '', map {chr} 0xB8, 0x1E, 0x85, 0xEB, 0x51, 0xB8, 0x9E, 0x3F, 0xB8, 0x1E, 0x85, 0xEB, 0x51, 0xB8, 0x9E, 0x3F,
                   0xB8, 0x1E, 0x85, 0xEB, 0x51, 0xB8, 0x9E, 0x3F, 0xB8, 0x1E, 0x85, 0xEB, 0x51, 0xB8, 0x9E, 0x3F,
                   0xB8, 0x1E, 0x85, 0xEB, 0x51, 0xB8, 0x9E, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0x50, 0xC3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x13, 0x08, 0x12, 0x65, 0xE3, 0x6A, 0xC0;
my $b2 = join '', map {chr}   0xD7, 0xA3, 0x70, 0x3D, 0x0A, 0x57, 0x21, 0x40, 0x9A, 0x99, 0x99, 0x99, 0x99, 0x99, 0x21, 0x40,
                   0xA4, 0x70, 0x3D, 0x0A, 0xD7, 0x23, 0x21, 0x40, 0x14, 0xAE, 0x47, 0xE1, 0x7A, 0x94, 0x21, 0x40,
                   0x14, 0xAE, 0x47, 0xE1, 0x7A, 0x94, 0x21, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                   0xD8, 0x3C, 0x09, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x13, 0x08, 0x13, 0xA9, 0xF1, 0xE2, 0x2A;                   
is xxhash($b1, 0x5262), xxhash($b2, 0x5262), 'Known collision';

is xxhash('test', 123), 2758658570;
is xxhash('test', 12345), 3834992036;

is xxhash_hex('test', 12345), 'e49555a4', 'xxhash_hex';

done_testing;