### base matrix class

sub new {
    my ($class, $rows, $columns) = @_;

    ### $rows, $columns is a number of each
    $self = { base => (), rows => $rows, columns => $columns, };

    for (my $i = 0; $i < $rows; $i++) {
	push ($self->{base}, ());
	for (my $j = 0; $j < $columns; $j++) {

	    push ($self->{base}[$i], rand);
	    
	}
    }
    
    bless $self, $class;
};

sub getRowsNumber {
  $self = shift;

  return $self->{rows};
}

sub getColumnsNumber {
  $self = shift;

  return $self->{columns};
}

sub indexOf {
    my ($self, $r, $c) = @_;

    return $self->{base}[$r][$c];
};

sub setAtIndex {
  my ($self, $r, $c, $value) = @_;

  $self->{base}[$r][$c] = $value;
}

### by vector
sub multiply {
    my ($self, $vector) = @_;

    my $sum;
    my $resultv = vector->new;
    
    for (my $i = 0; $i < $self->{rows}; $i++) {
	$sum = 0;
	for (my $j = 0; $j < $self->{columns}; $j++) {
	    $sum += $self->{base}[$i][$j] * $vector->{base}[$j];
	}
	$resultv->add($sum);
    }

    return $resultv;
}

### multiply by matrix
sub multiplyMatrix {
    my ($self, $matrix) = @_;

    my $sum;
    my $v;
    my $returnm = matrix->new($rows, $columns);
    
    for (my $k = 0; $k < $matrix->{rows}; $k++) {
	$v = vector->new;
	for (my $i = 0; $i < $self->{rows}; $i++) {
	    $sum = 0;
	    for (my $j = 0; $j < $self->{columns}; $j++) {
		$sum = $self->{base}[$i][$j] * $matrix->{base}[$j][$i];
	    }
	    $v->add($sum);
	}
	$returnm->{base}[$k] = $v;
    }

    return $returnm;
}
1;
