# Generated by default/object.tt
package Paws::CloudWatch::Dimension;
  use Moose;
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatch::Dimension

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatch::Dimension object:

  $service_obj->Method(Att1 => { Name => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatch::Dimension object:

  $result = $service_obj->Method(...);
  $result->Att1->Name

=head1 DESCRIPTION

A dimension is a name/value pair that is part of the identity of a
metric. You can assign up to 10 dimensions to a metric. Because
dimensions are part of the unique identifier for a metric, whenever you
add a unique name/value pair to one of your metrics, you are creating a
new variation of that metric.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Name => Str

The name of the dimension. Dimension names cannot contain blank spaces
or non-ASCII characters.


=head2 B<REQUIRED> Value => Str

The value of the dimension. Dimension values cannot contain blank
spaces or non-ASCII characters.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

