
package Paws::Transcribe::DeleteMedicalTranscriptionJob;
  use Moose;
  has MedicalTranscriptionJobName => (is => 'ro', isa => 'Str', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'DeleteMedicalTranscriptionJob');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::API::Response');
  class_has _result_key => (isa => 'Str', is => 'ro');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Transcribe::DeleteMedicalTranscriptionJob - Arguments for method DeleteMedicalTranscriptionJob on L<Paws::Transcribe>

=head1 DESCRIPTION

This class represents the parameters used for calling the method DeleteMedicalTranscriptionJob on the
L<Amazon Transcribe Service|Paws::Transcribe> service. Use the attributes of this class
as arguments to method DeleteMedicalTranscriptionJob.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to DeleteMedicalTranscriptionJob.

=head1 SYNOPSIS

    my $transcribe = Paws->service('Transcribe');
    $transcribe->DeleteMedicalTranscriptionJob(
      MedicalTranscriptionJobName => 'MyTranscriptionJobName',

    );

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/transcribe/DeleteMedicalTranscriptionJob>

=head1 ATTRIBUTES


=head2 B<REQUIRED> MedicalTranscriptionJobName => Str

The name you provide to the C<DeleteMedicalTranscriptionJob> object to
delete a transcription job.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method DeleteMedicalTranscriptionJob in L<Paws::Transcribe>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

