# Generated by default/object.tt
package Paws::IoTEvents::SMSConfiguration;
  use Moose;
  has AdditionalMessage => (is => 'ro', isa => 'Str', request_name => 'additionalMessage', traits => ['NameInRequest']);
  has Recipients => (is => 'ro', isa => 'ArrayRef[Paws::IoTEvents::RecipientDetail]', request_name => 'recipients', traits => ['NameInRequest'], required => 1);
  has SenderId => (is => 'ro', isa => 'Str', request_name => 'senderId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::SMSConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::SMSConfiguration object:

  $service_obj->Method(Att1 => { AdditionalMessage => $value, ..., SenderId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::SMSConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AdditionalMessage

=head1 DESCRIPTION

Contains the configuration information of SMS notifications.

=head1 ATTRIBUTES


=head2 AdditionalMessage => Str

The message that you want to send. The message can be up to 200
characters.


=head2 B<REQUIRED> Recipients => ArrayRef[L<Paws::IoTEvents::RecipientDetail>]

Specifies one or more recipients who receive the message.

You must add the users that receive SMS messages to your AWS SSO store
(https://docs.aws.amazon.com/singlesignon/latest/userguide/addusers.html).


=head2 SenderId => Str

The sender ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

