/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.dbd.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

class StatementHolder {
    PreparedStatement mStatement;
    ResultSet mResultSet;
    ResultSetMetaData mResultSetMetaData;
    Hashtable<String, Object> mStatementProperties;

    StatementHolder(PreparedStatement aStatement) {
        this.mStatement = aStatement;
        this.mStatementProperties = new Hashtable();
        this.mResultSet = null;
        this.mResultSetMetaData = null;
    }

    void close() {
        if (this.mStatement != null) {
            try {
                this.mStatement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mStatementProperties = null;
        this.mResultSetMetaData = null;
        this.mResultSet = null;
        this.mStatement = null;
    }

    void finish() {
        if (this.mResultSet != null) {
            try {
                this.mResultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mResultSet = null;
        this.mResultSetMetaData = null;
    }

    PreparedStatement getStatement() {
        return this.mStatement;
    }

    ResultSet getResultSet() {
        return this.mResultSet;
    }

    void setResultSet(ResultSet aResultSet) throws SQLException {
        this.mResultSet = aResultSet;
        this.mResultSetMetaData = aResultSet == null ? null : aResultSet.getMetaData();
    }

    ResultSetMetaData getResultSetMetaData() {
        return this.mResultSetMetaData;
    }

    Hashtable<String, Object> getProperties() {
        return this.mStatementProperties;
    }
}

