package Google::Ads::AdWords::v201406::PercentCpaBid;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201406' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201406::Bids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Bids__Type_of :ATTR(:get<Bids__Type>);
my %bid_of :ATTR(:get<bid>);
my %percentCpaBidSource_of :ATTR(:get<percentCpaBidSource>);

__PACKAGE__->_factory(
    [ qw(        Bids__Type
        bid
        percentCpaBidSource

    ) ],
    {
        'Bids__Type' => \%Bids__Type_of,
        'bid' => \%bid_of,
        'percentCpaBidSource' => \%percentCpaBidSource_of,
    },
    {
        'Bids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'bid' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'percentCpaBidSource' => 'Google::Ads::AdWords::v201406::BidSource',
    },
    {

        'Bids__Type' => 'Bids.Type',
        'bid' => 'bid',
        'percentCpaBidSource' => 'percentCpaBidSource',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201406::PercentCpaBid

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PercentCpaBid from the namespace https://adwords.google.com/api/adwords/cm/v201406.

Percentage CPA based bidding where user pays a percent of conversions. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * bid


=item * percentCpaBidSource




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

