package Acme::MetaSyntactic::crypto;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::crypto - The crypto theme

=head1 DESCRIPTION

The classic characters from crypto and protocol
communications texts.

The list in 0.04 was based on:
L<http://www.cacr.math.uwaterloo.ca/~dstinson/CS_758/2003/lec23.ps>.

The list has been updated with information from:
L<http://www.disappearing-inc.com/A/alice.html>
L<http://en.wikipedia.org/wiki/Alice_and_Bob>

=head1 CONTRIBUTORS

Anonymous, Guy Widloecher.

=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2005-06-27

Updated in Acme-MetaSyntactic version 0.28.

=item *

2005-06-23

Guy Widloecher provided some more items and links.
See ticket #9725 on L<http://rt.cpan.org/>.

=item *

2005-01-15

Introduced in Acme-MetaSyntactic version 0.04.

=item *

2005-01-14

Idea by Anonymous C<< <nobody@nowhere.org> >>.
See ticket #9725 on L<http://rt.cpan.org/>.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
alice
bob
charlie
doris dave
eve ellen
fred frank
ginger
harry
irene isaac ivan
janet justin
mallory mallet matilda
pat peggy plod
oscar
sam
trudy trent
vanna victor
walter
