#!/usr/bin/perl

package eBay::API::XML::DataType::CategoryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CategoryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CategoryType

=head1 DESCRIPTION

Container for data on one listing category.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CategoryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::CharacteristicsSetType;
use eBay::API::XML::DataType::ExtendedProductFinderIDType;


my @gaProperties = ( [ 'AutoPayEnabled', 'xs:boolean', '', '', '' ]
	, [ 'B2BVATEnabled', 'xs:boolean', '', '', '' ]
	, [ 'BestOfferEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CatalogEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'CategoryLevel', 'xs:int', '', '', '' ]
	, [ 'CategoryName', 'xs:string', '', '', '' ]
	, [ 'CategoryParentID', 'xs:string', '1', '', '' ]
	, [ 'CategoryParentName', 'xs:string', '1', '', '' ]
	, [ 'CharacteristicsSets', 'ns:CharacteristicsSetType', '1'
	     ,'eBay::API::XML::DataType::CharacteristicsSetType', '1' ]
	, [ 'Expired', 'xs:boolean', '', '', '' ]
	, [ 'IntlAutosFixedCat', 'xs:boolean', '', '', '' ]
	, [ 'Keywords', 'xs:string', '', '', '' ]
	, [ 'LSD', 'xs:boolean', '', '', '' ]
	, [ 'LeafCategory', 'xs:boolean', '', '', '' ]
	, [ 'NumOfItems', 'xs:int', '', '', '' ]
	, [ 'ORPA', 'xs:boolean', '', '', '' ]
	, [ 'ORRA', 'xs:boolean', '', '', '' ]
	, [ 'ProductFinderIDs', 'ns:ExtendedProductFinderIDType', '1'
	     ,'eBay::API::XML::DataType::ExtendedProductFinderIDType', '1' ]
	, [ 'ProductSearchPageAvailable', 'xs:boolean', '', '', '' ]
	, [ 'SellerGuaranteeEligible', 'xs:boolean', '', '', '' ]
	, [ 'Virtual', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAutoPayEnabled()

If true, indicates that the category supports immediate payment.
If not present, the category does not support
immediate payment. Will not be returned if false.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=AutoPay
Title: Requiring Immediate Payment

#    Argument: 'xs:boolean'

=cut

sub setAutoPayEnabled {
  my $self = shift;
  $self->{'AutoPayEnabled'} = shift
}

=head2 isAutoPayEnabled()

  Calls: GetCategories
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isAutoPayEnabled {
  my $self = shift;
  return $self->{'AutoPayEnabled'};
}


=head2 setB2BVATEnabled()

If true, the category supports business-to-business (B2B) VAT
listings. Applicable to the eBay Germany (DE), Austria (AT),
and Switzerland CH) sites only. If not present,
the category does not support this feature. Will not be returned if false.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=B2BVAT
Title: Working with Business Features and VAT

#    Argument: 'xs:boolean'

=cut

sub setB2BVATEnabled {
  my $self = shift;
  $self->{'B2BVATEnabled'} = shift
}

=head2 isB2BVATEnabled()

  Calls: GetCategories
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isB2BVATEnabled {
  my $self = shift;
  return $self->{'B2BVATEnabled'};
}


=head2 setBestOfferEnabled()

If true, the category supports best offers.
If not present, the category does not support best offers.
Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setBestOfferEnabled {
  my $self = shift;
  $self->{'BestOfferEnabled'} = shift
}

=head2 isBestOfferEnabled()

  Calls: GetCategories
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isBestOfferEnabled {
  my $self = shift;
  return $self->{'BestOfferEnabled'};
}


=head2 setCatalogEnabled()

If true, the category is associated with catalog content
and the corresponding catalog is identified by the
characteristic set ID. See CharacteristicsSets.
As the Pre-filled Item Information feature uses the
Item Specifics feature, the set of catalog-enabled categories
is a subset of the categories that are mapped
to characteristic sets. Not returned if false.

#    Argument: 'xs:boolean'

=cut

sub setCatalogEnabled {
  my $self = shift;
  $self->{'CatalogEnabled'} = shift
}

=head2 isCatalogEnabled()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: MappedCategoryArray

#    Returns: 'xs:boolean'

=cut

sub isCatalogEnabled {
  my $self = shift;
  return $self->{'CatalogEnabled'};
}


=head2 setCategoryID()

Distinct numeric ID for a category on eBay.
In GetItem and related calls, see CategoryName for the text name of
the category. Use GetCategories to look up the category parent ID.<br>
<br>
For GetPopularKeywords, -1 represents the root
category.<br>
<br>
For GetItem, Half.com items return the Half.com category ID
in PrimaryCategory. This ID is not necessarily returned in
GetCategories. If a Half.com listing is eligible for Express,
you can use SecondaryCategory to determine the eBay category ID.

MaxLength: 10

  Calls: AddItem
         GetItemRecommendations
         AddLiveAuctionItem
         VerifyAddItem
  RequiredInput: Yes

  Calls: RelistItem
         ReviseItem
         ReviseLiveAuctionItem
  RequiredInput: No

#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

  Calls: GetBidderList
  Returned: Always
  Context: PrimaryCategory

  Calls: GetBidderList
  Returned: Conditionally
  Context: FreeAddedCategory
           SecondaryCategory

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetCategoryListings
         GetContextualKeywords
         GetPopularKeywords
  Returned: Always

  Calls: GetCategory2CS
  Returned: Always
  Details: DetailLevel: ReturnAll
  Context: MappedCategoryArray

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: UnmappedCategoryArray

  Calls: GetItem
  Returned: Always
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: PrimaryCategory

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: FreeAddedCategory
           SecondaryCategory

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetItemTransactions
         GetSellerTransactions
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

  Calls: GetSuggestedCategories
         GetProducts
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnCategories

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
  Context: FreeAddedCategory
           SecondaryCategory

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll
  Context: PrimaryCategory
           SecondaryCategory

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setCategoryLevel()

The level where the category fits in the site's category hierarchy.
For example, if this field has a value of 2, then the category is two
levels below the root category in the site's category hierarchy.
For the GetSearchResults response, NumOfItems indicates the total
quantity of matching items in a category. Matching categories at the
same level (i.e., in sibling categories) are sorted by NumOfItems,
descending order.

#    Argument: 'xs:int'

=cut

sub setCategoryLevel {
  my $self = shift;
  $self->{'CategoryLevel'} = shift
}

=head2 getCategoryLevel()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
  Context: CategoryArray

#    Returns: 'xs:int'

=cut

sub getCategoryLevel {
  my $self = shift;
  return $self->{'CategoryLevel'};
}


=head2 setCategoryName()

Display name of the category as it would appear on
the eBay Web site.
In GetItem, this is a fully qualified category name
(e.g., Collectibles:Decorative Collectibles:Hummel, Goebel).<br>
<br>
In GetItem, always returned for eBay.com listings.
Not returned in PrimaryCategory for Half.com listings. If a Half.com
listing is eligible for Express, you can use SecondaryCategory
to determine the eBay category name.

MaxLength: 30

#    Argument: 'xs:string'

=cut

sub setCategoryName {
  my $self = shift;
  $self->{'CategoryName'} = shift
}

=head2 getCategoryName()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetCategoryListings
         GetContextualKeywords
  Returned: Always

  Calls: GetBidderList
  Returned: Always
  Context: PrimaryCategory

  Calls: GetBidderList
  Returned: Conditionally
  Context: FreeAddedCategory
           SecondaryCategory

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: PrimaryCategory

  Calls: GetItem
  Returned: Conditionally
  Details: DetailLevel: none, ItemReturnDescription, ItemReturnAttributes, ReturnAll
  Context: FreeAddedCategory
           SecondaryCategory

  Calls: GetSuggestedCategories
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
  Context: CategoryArray

  Calls: GetSellerList
  Returned: Conditionally
  Details: DetailLevel: ItemReturnDescription, ReturnAll

#    Returns: 'xs:string'

=cut

sub getCategoryName {
  my $self = shift;
  return $self->{'CategoryName'};
}


=head2 setCategoryParentID()

Category ID identifying a category that is an ancestor of
the category indicated in CategoryID.
For GetCategories, returns the same value as CategoryID
if the CategoryLevel is 1.
For GetSuggestedCategories, multiple CategoryParentID fields
can be returned in sequence, starting with the root category
and ending with the category that is the direct parent of
the category specified in CategoryID.
Use these parent fields and the CategoryID field to build
the fully qualified category browse path or "breadcrumbs"
(e.g., 58058:3516:3517).
For GetPopularKeywords, -1 represents the root category.

MaxLength: 10

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCategoryParentID {
  my $self = shift;
  $self->{'CategoryParentID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryParentID()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
  Context: CategoryArray

  Calls: GetSuggestedCategories
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCategoryParentID {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryParentID');
}


=head2 setCategoryParentName()

Display name of the category indicated in CategoryParentID.
For GetSuggestedCategories, multiple CategoryParentName fields
can be returned in sequence, starting with the root category
and ending with the category that
is the direct parent of the category specified in CategoryName.
Use these parent fields and the CategoryName field to build the
fully qualified category browse path or "breadcrumbs"
(e.g., Computers & Networking > Technology Books > Certification).

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setCategoryParentName {
  my $self = shift;
  $self->{'CategoryParentName'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCategoryParentName()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
  Context: CategoryArray

  Calls: GetSuggestedCategories
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getCategoryParentName {
  my $self = shift;
  return $self->_getDataTypeArray('CategoryParentName');
}


=head2 setCharacteristicsSets()

Returned from GetCategory2CS calls.
A list of one or more characteristics sets mapped to the category. Use this
information when working with Item Specifics (Attributes) and Pre-filled Item
Information (Catalogs) functionality. Output only.

#    Argument: reference to an array  
                      of 'ns:CharacteristicsSetType'

=cut

sub setCharacteristicsSets {
  my $self = shift;
  $self->{'CharacteristicsSets'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getCharacteristicsSets()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: MappedCategoryArray
           SiteWideCharacteristicSets

#    Returns: reference to an array  
                      of 'ns:CharacteristicsSetType'

=cut

sub getCharacteristicsSets {
  my $self = shift;
  return $self->_getDataTypeArray('CharacteristicsSets');
}


=head2 setExpired()

If true, indicates a category that has expired and
to which items may not be listed. Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setExpired {
  my $self = shift;
  $self->{'Expired'} = shift
}

=head2 isExpired()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isExpired {
  my $self = shift;
  return $self->{'Expired'};
}


=head2 setIntlAutosFixedCat()

If true, indicates that the category is a fixed-fee category. Use this
information to identify categories are not eligible for eBay Stores Inventory
format listings. You cannot list eBay Store Inventory format listings in
fixed-fee categories on international sites. Output only. Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setIntlAutosFixedCat {
  my $self = shift;
  $self->{'IntlAutosFixedCat'} = shift
}

=head2 isIntlAutosFixedCat()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isIntlAutosFixedCat {
  my $self = shift;
  return $self->{'IntlAutosFixedCat'};
}


=head2 setKeywords()

The list of keywords returned by GetPopularKeywords.

#    Argument: 'xs:string'

=cut

sub setKeywords {
  my $self = shift;
  $self->{'Keywords'} = shift
}

=head2 getKeywords()

  Calls: GetPopularKeywords
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getKeywords {
  my $self = shift;
  return $self->{'Keywords'};
}


=head2 setLSD()

Item.LotSize is not permitted when you list in this category.
If true, indicates that lot sizes are disabled in the specified category. Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setLSD {
  my $self = shift;
  $self->{'LSD'} = shift
}

=head2 isLSD()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLSD {
  my $self = shift;
  return $self->{'LSD'};
}


=head2 setLeafCategory()

If true, indicates that the category indicated in CategoryID is a leaf category,
in which items may be listed (if the category is not also expired or virtual). Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setLeafCategory {
  my $self = shift;
  $self->{'LeafCategory'} = shift
}

=head2 isLeafCategory()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isLeafCategory {
  my $self = shift;
  return $self->{'LeafCategory'};
}


=head2 setNumOfItems()

The total quantity of matching items in the category.
In the GetSearchResults response, matching categories at the same level
(i.e., sibling categories) are sorted by this value. That is, if the request
specifies that fewer categories or subcategories should be returned,
the ones with the most matching items are returned first.
See the Developer's guide for more information.

#    Argument: 'xs:int'

=cut

sub setNumOfItems {
  my $self = shift;
  $self->{'NumOfItems'} = shift
}

=head2 getNumOfItems()

  Calls: GetCategoryListings
  Returned: Conditionally
  Context: CategoryArray

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
  Context: CategoryArray

  Calls: GetCategoryListings
  Returned: Conditionally
  Context: CategoryArray

#    Returns: 'xs:int'

=cut

sub getNumOfItems {
  my $self = shift;
  return $self->{'NumOfItems'};
}


=head2 setORPA()

Indicates whether the category (and its subcategories)
allows or disallows listing with a reserve price,
depending on the prevailing site configuration indicated by
ReservePriceAllowed.
ORPA (override reserve price allowed) indicates when the category
is an exception to the site's ReservePriceAllowed policy.<br>
<br>
If ORPA is true, the category overrides (toggles or reverses) the
site's ReservePriceAllowed setting. In other words:<br>
- If ReservePriceAllowed is true, reserve price is not allowed in this category.<br>
- If ReservePriceAllowed is false, reserve price is allowed in this category.<br><br>
If ORPA is not present, there is no override.
That is, the category's setting is the same as the site's ReservePriceAllowed setting.<br>
<br> This field will not be returned in the response if false.
This toggling logic is designed to reduce the size of the GetCategories
response by only returning ORPA when the category's policy is different
from the site's policy. (If ORPA is true for a category, you can assume
its subcategories inherit the same setting unless otherwise specified.)

#    Argument: 'xs:boolean'

=cut

sub setORPA {
  my $self = shift;
  $self->{'ORPA'} = shift
}

=head2 isORPA()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isORPA {
  my $self = shift;
  return $self->{'ORPA'};
}


=head2 setORRA()

Indicates whether the category (and its subcategories) allows
or disallows reducing a listing's reserve price,
depending on the prevailing site configuration indicated by ReduceReserveAllowed.
ORRA (override reduce reserve allowed) indicates when the category is an exception
to the site's ReduceReserveAllowed policy.<br><br>
If ORRA is true, the category overrides (toggles or reverses) the
site's ReduceReserveAllowed setting. In other words:<br>
- If ReduceReserveAllowed is true, reserve price reduction is not allowed in this category.<br>
- If ReduceReserveAllowed is false (because it is not present in the response), reserve price reduction is allowed in this category.<br><br>
If ORRA is not present, there is no override. Will not be returned in the response if false.
That is, the category's setting is the same as the site's ReduceReserveAllowed setting.<br>
<br>
This toggling logic is designed to reduce the size of the GetCategories
response by only returning ORRA when the category's policy is different
from the site's policy.  (If ORRA is true for a category, you can assume
its subcategories inherit the same setting unless otherwise specified.)

#    Argument: 'xs:boolean'

=cut

sub setORRA {
  my $self = shift;
  $self->{'ORRA'} = shift
}

=head2 isORRA()

  Calls: GetCategories
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isORRA {
  my $self = shift;
  return $self->{'ORRA'};
}


=head2 setProductFinderIDs()

The category supports listing with Pre-filled Item Information.
Specifies the buy-side and/or sell-side product finder IDs associated with this category, if any.

#    Argument: reference to an array  
                      of 'ns:ExtendedProductFinderIDType'

=cut

sub setProductFinderIDs {
  my $self = shift;
  $self->{'ProductFinderIDs'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getProductFinderIDs()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: MappedCategoryArray

#    Returns: reference to an array  
                      of 'ns:ExtendedProductFinderIDType'

=cut

sub getProductFinderIDs {
  my $self = shift;
  return $self->_getDataTypeArray('ProductFinderIDs');
}


=head2 setProductSearchPageAvailable()

Returned from GetCategory2CS calls. Supports listing with Pre-filled Item Information.
If the category supports single-attribute search, this field returns a value of
true. Otherwise this field not returned or returned as false.

#    Argument: 'xs:boolean'

=cut

sub setProductSearchPageAvailable {
  my $self = shift;
  $self->{'ProductSearchPageAvailable'} = shift
}

=head2 isProductSearchPageAvailable()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll
  Context: MappedCategoryArray

#    Returns: 'xs:boolean'

=cut

sub isProductSearchPageAvailable {
  my $self = shift;
  return $self->{'ProductSearchPageAvailable'};
}


=head2 setSellerGuaranteeEligible()

Indicates whether this category is eligible for Motors Seller Guarantee program.
This tag is emitted for eligible categories only on the eBay Motors site. Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setSellerGuaranteeEligible {
  my $self = shift;
  $self->{'SellerGuaranteeEligible'} = shift
}

=head2 isSellerGuaranteeEligible()

  Calls: GetCategories
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isSellerGuaranteeEligible {
  my $self = shift;
  return $self->{'SellerGuaranteeEligible'};
}


=head2 setVirtual()

If true, indicates the category indicated in CategoryID is a
virtual category, to which items may not be listed. Will not be returned if false.

#    Argument: 'xs:boolean'

=cut

sub setVirtual {
  my $self = shift;
  $self->{'Virtual'} = shift
}

=head2 isVirtual()

  Calls: GetCategories
  Returned: Always
  Details: DetailLevel: ReturnAll

#    Returns: 'xs:boolean'

=cut

sub isVirtual {
  my $self = shift;
  return $self->{'Virtual'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
