/**
 * socket.io-node-client
 * Copyright(c) 2011 LearnBoost <dev@learnboost.com>
 * MIT Licensed
 */

(function(){
  var io = this.io,
  
  /**
   * The XHR-Multipart transport uses the a multipart XHR connection to
   * stream in the data from the Socket.IO server
   *
   * @constructor
   * @extends {io.Transport.XHR}
   * @api public
   */
  XHRMultipart = io.Transport['xhr-multipart'] = function(){
    io.Transport.XHR.apply(this, arguments);
  };
  
  io.util.inherit(XHRMultipart, io.Transport.XHR);
  
   /**
   * The transport type, you use this to identify which transport was chosen.
   *
   * @type {String}
   * @api public
   */
  XHRMultipart.prototype.type = 'xhr-multipart';
  
  /**
   * Starts the multipart stream for incomming messages.
   *
   * @api private
   */
  XHRMultipart.prototype.get = function(){
    var self = this;
    this.xhr = this.request('', 'GET', true);
    this.xhr.onreadystatechange = function(){
      if (self.xhr.readyState == 4) self.onData(self.xhr.responseText);
    };
    this.xhr.send(null);
  };
  
  /**
   * Checks if browser supports this transport.
   *
   * @return {Boolean}
   * @api public
   */
  XHRMultipart.check = function(){
    return 'XMLHttpRequest' in window && 'prototype' in XMLHttpRequest && 'multipart' in XMLHttpRequest.prototype;
  };
  
  /**
   * Check if cross domain requests are supported.
   *
   * @returns {Boolean}
   * @api public
   */
  XHRMultipart.xdomainCheck = function(){
    return true;
  };
  
})();