# Generated by default/object.tt
package Paws::SSM::CreateAssociationBatchRequestEntry;
  use Moose;
  has ApplyOnlyAtCronInterval => (is => 'ro', isa => 'Bool');
  has AssociationName => (is => 'ro', isa => 'Str');
  has AutomationTargetParameterName => (is => 'ro', isa => 'Str');
  has CalendarNames => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has ComplianceSeverity => (is => 'ro', isa => 'Str');
  has DocumentVersion => (is => 'ro', isa => 'Str');
  has InstanceId => (is => 'ro', isa => 'Str');
  has MaxConcurrency => (is => 'ro', isa => 'Str');
  has MaxErrors => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has OutputLocation => (is => 'ro', isa => 'Paws::SSM::InstanceAssociationOutputLocation');
  has Parameters => (is => 'ro', isa => 'Paws::SSM::Parameters');
  has ScheduleExpression => (is => 'ro', isa => 'Str');
  has SyncCompliance => (is => 'ro', isa => 'Str');
  has TargetLocations => (is => 'ro', isa => 'ArrayRef[Paws::SSM::TargetLocation]');
  has Targets => (is => 'ro', isa => 'ArrayRef[Paws::SSM::Target]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSM::CreateAssociationBatchRequestEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSM::CreateAssociationBatchRequestEntry object:

  $service_obj->Method(Att1 => { ApplyOnlyAtCronInterval => $value, ..., Targets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSM::CreateAssociationBatchRequestEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->ApplyOnlyAtCronInterval

=head1 DESCRIPTION

Describes the association of a Systems Manager SSM document and an
instance.

=head1 ATTRIBUTES


=head2 ApplyOnlyAtCronInterval => Bool

By default, when you create a new associations, the system runs it
immediately after it is created and then according to the schedule you
specified. Specify this option if you don't want an association to run
immediately after you create it. This parameter is not supported for
rate expressions.


=head2 AssociationName => Str

Specify a descriptive name for the association.


=head2 AutomationTargetParameterName => Str

Specify the target for the association. This target is required for
associations that use an Automation document and target resources by
using rate controls.


=head2 CalendarNames => ArrayRef[Str|Undef]

The names or Amazon Resource Names (ARNs) of the Systems Manager Change
Calendar type documents your associations are gated under. The
associations only run when that Change Calendar is open. For more
information, see AWS Systems Manager Change Calendar
(https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar).


=head2 ComplianceSeverity => Str

The severity level to assign to the association.


=head2 DocumentVersion => Str

The document version.


=head2 InstanceId => Str

The ID of the instance.


=head2 MaxConcurrency => Str

The maximum number of targets allowed to run the association at the
same time. You can specify a number, for example 10, or a percentage of
the target set, for example 10%. The default value is 100%, which means
all targets run the association at the same time.

If a new instance starts and attempts to run an association while
Systems Manager is running MaxConcurrency associations, the association
is allowed to run. During the next association interval, the new
instance will process its association within the limit specified for
MaxConcurrency.


=head2 MaxErrors => Str

The number of errors that are allowed before the system stops sending
requests to run the association on additional targets. You can specify
either an absolute number of errors, for example 10, or a percentage of
the target set, for example 10%. If you specify 3, for example, the
system stops sending requests when the fourth error is received. If you
specify 0, then the system stops sending requests after the first error
is returned. If you run an association on 50 instances and set MaxError
to 10%, then the system stops sending the request when the sixth error
is received.

Executions that are already running an association when MaxErrors is
reached are allowed to complete, but some of these executions may fail
as well. If you need to ensure that there won't be more than max-errors
failed executions, set MaxConcurrency to 1 so that executions proceed
one at a time.


=head2 B<REQUIRED> Name => Str

The name of the SSM document that contains the configuration
information for the instance. You can specify Command or Automation
documents.

You can specify AWS-predefined documents, documents you created, or a
document that is shared with you from another account.

For SSM documents that are shared with you from other AWS accounts, you
must specify the complete SSM document ARN, in the following format:

C<arn:aws:ssm:I<region>:I<account-id>:document/I<document-name>>

For example:

C<arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document>

For AWS-predefined documents and SSM documents you created in your
account, you only need to specify the document name. For example,
C<AWS-ApplyPatchBaseline> or C<My-Document>.


=head2 OutputLocation => L<Paws::SSM::InstanceAssociationOutputLocation>

An S3 bucket where you want to store the results of this request.


=head2 Parameters => L<Paws::SSM::Parameters>

A description of the parameters for a document.


=head2 ScheduleExpression => Str

A cron expression that specifies a schedule when the association runs.


=head2 SyncCompliance => Str

The mode for generating association compliance. You can specify C<AUTO>
or C<MANUAL>. In C<AUTO> mode, the system uses the status of the
association execution to determine the compliance status. If the
association execution runs successfully, then the association is
C<COMPLIANT>. If the association execution doesn't run successfully,
the association is C<NON-COMPLIANT>.

In C<MANUAL> mode, you must specify the C<AssociationId> as a parameter
for the PutComplianceItems API action. In this case, compliance data is
not managed by State Manager. It is managed by your direct call to the
PutComplianceItems API action.

By default, all associations use C<AUTO> mode.


=head2 TargetLocations => ArrayRef[L<Paws::SSM::TargetLocation>]

Use this action to create an association in multiple Regions and
multiple accounts.


=head2 Targets => ArrayRef[L<Paws::SSM::Target>]

The instances targeted by the request.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSM>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

