# Generated by default/object.tt
package Paws::Macie2::UsageByAccount;
  use Moose;
  has Currency => (is => 'ro', isa => 'Str', request_name => 'currency', traits => ['NameInRequest']);
  has EstimatedCost => (is => 'ro', isa => 'Str', request_name => 'estimatedCost', traits => ['NameInRequest']);
  has ServiceLimit => (is => 'ro', isa => 'Paws::Macie2::ServiceLimit', request_name => 'serviceLimit', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::UsageByAccount

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::UsageByAccount object:

  $service_obj->Method(Att1 => { Currency => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::UsageByAccount object:

  $result = $service_obj->Method(...);
  $result->Att1->Currency

=head1 DESCRIPTION

Provides data for a specific usage metric and the corresponding quota
for an Amazon Macie account.

=head1 ATTRIBUTES


=head2 Currency => Str

The type of currency that the value for the metric (estimatedCost) is
reported in.


=head2 EstimatedCost => Str

The estimated value for the metric.


=head2 ServiceLimit => L<Paws::Macie2::ServiceLimit>

The current value for the quota that corresponds to the metric
specified by the type field.


=head2 Type => Str

The name of the metric. Possible values are: DATA_INVENTORY_EVALUATION,
for monitoring S3 buckets; and, SENSITIVE_DATA_DISCOVERY, for analyzing
S3 objects to detect sensitive data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

