package AWS::CDK;

use strict;
use warnings;

our $VERSION = '0.001_01';

1;

__END__

=pod

=encoding utf-8

=head1 NAME

AWS::CDK - The AWS Cloud Development Kit 

=head1 VERSION

0.001

=head1 DESCRIPTION

The AWS Cloud Development Kit (AWS CDK) is a software development framework for defining your cloud infrastructure in code and provisioning it through AWS CloudFormation.

The future home of AWS::CDK perl modules, for use in Infrastructure as Code; built with L<JSII>.



=head1 SEE ALSO

=over

=item * L<JSII>

=item * L<< AWS CDK Docmentation|https://docs.aws.amazon.com/cdk/index.html >>

=item * L<< AWS CDK Repository|https://github.com/aws/aws-cdk >>

=back

=head1 AUTHOR

James Wright <jwright@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by James Wright.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.


