
package Paws::IAM::ListPoliciesGrantingServiceAccessResponse;
  use Moose;
  has IsTruncated => (is => 'ro', isa => 'Bool');
  has Marker => (is => 'ro', isa => 'Str');
  has PoliciesGrantingServiceAccess => (is => 'ro', isa => 'ArrayRef[Paws::IAM::ListPoliciesGrantingServiceAccessEntry]', required => 1);

  has _request_id => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::IAM::ListPoliciesGrantingServiceAccessResponse

=head1 ATTRIBUTES


=head2 IsTruncated => Bool

A flag that indicates whether there are more items to return. If your
results were truncated, you can make a subsequent pagination request
using the C<Marker> request parameter to retrieve more items. We
recommend that you check C<IsTruncated> after every call to ensure that
you receive all your results.


=head2 Marker => Str

When C<IsTruncated> is C<true>, this element is present and contains
the value to use for the C<Marker> parameter in a subsequent pagination
request.


=head2 B<REQUIRED> PoliciesGrantingServiceAccess => ArrayRef[L<Paws::IAM::ListPoliciesGrantingServiceAccessEntry>]

A C<ListPoliciesGrantingServiceAccess> object that contains details
about the permissions policies attached to the specified identity
(user, group, or role).


=head2 _request_id => Str


=cut

