######################################################################
#
# 0303_add_mapping-jef-2.13.6.18.t
#
# Copyright (c) 2021 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ['𠀋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xA6"],
        ['𠂉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFC"],
        ['𠆢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFA"],
        ['𠦝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x73\xFC"],
        ['𠮟', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['𡉴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xE5"],
        ['𡌛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xC6"],
        ['𡗗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x73\xFA"],
        ['𢌞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xD7"],
        ['𣗄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xC2"],
        ['𣳾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xC5"],
        ['𣵀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xAA"],
        ['㐬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xD7"],
        ['㐮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xD9"],
        ['㑨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xE5"],
        ['㓛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xB7"],
        ['㟢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xFE"],
        ['㟽', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xD5"],
        ['㠀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xB6"],
        ['㤚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xFB"],
        ['㫖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xAF"],
        ['㬚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xF0"],
        ['㬢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xF6"],
        ['㭭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xD4"],
        ['㮈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE3"],
        ['㮶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xF9"],
        ['㯰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xB2"],
        ['㴞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xD6"],
        ['㵤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xAC"],
        ['㹦', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xE0"],
        ['㹨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xE4"],
        ['䂓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xEB"],
        ['䄅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD2"],
        ['䅏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xAA"],
        ['䅣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xB5"],
        ['䉤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xBA"],
        ['䋖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xA2"],
        ['䏮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xC1"],
        ['䑓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xEA"],
        ['䑛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xF4"],
        ['䑺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xAC"],
        ['䒑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xBA"],
        ['䒳', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xDF"],
        ['䒾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xED"],
        ['䔈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xC0"],
        ['䔥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCC"],
        ['䕃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xDB"],
        ['䚯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xE1"],
        ['䨩', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAA"],
        ['䪼', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xE6"],
        ['䯂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xD9"],
        ['䯨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xA5"],
        ['䰗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB8"],
        ['䰠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC5"],
        ['丒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xA8"],
        ['亹', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xDB"],
        ['亻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFB"],
        ['伃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF0"],
        ['伋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF2"],
        ['你', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF8"],
        ['佺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xAE"],
        ['佽', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xAF"],
        ['佾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xB0"],
        ['侠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xCB"],
        ['俦', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xCD"],
        ['俱', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xCF"],
        ['僙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB3"],
        ['僡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB5"],
        ['凊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xFB"],
        ['刓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xBC"],
        ['刕', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xB4"],
        ['剝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xED"],
        ['剥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xD0"],
        ['勊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xE8"],
        ['勖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xEC"],
        ['勻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xA2"],
        ['匾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xBB"],
        ['卺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xF2"],
        ['卽', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xD4"],
        ['吒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xAA"],
        ['吞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['唖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xB9"],
        ['喝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xB8"],
        ['嘘', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xBA"],
        ['嘰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xFD"],
        ['噓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB1\xB3"],
        ['噛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xBC"],
        ['噱', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xAE"],
        ['嚙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xFA"],
        ['嚢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xBA"],
        ['圡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xCC"],
        ['垝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xF4"],
        ['埇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xF6"],
        ['埞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xFC"],
        ['填', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xCA"],
        ['增', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xBB"],
        ['壠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xC3"],
        ['夅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xCE"],
        ['奆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xE1"],
        ['姍', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xAC"],
        ['姣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xB0"],
        ['姸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xB5"],
        ['婾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xCA"],
        ['媄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xCB"],
        ['嫰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xDE"],
        ['嬴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xEB"],
        ['寬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xC6"],
        ['尒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xE1"],
        ['屏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE7"],
        ['屛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xA2"],
        ['屡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE5"],
        ['岈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xBA"],
        ['岧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xF2"],
        ['崐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xC9"],
        ['崝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xCA"],
        ['崠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xCB"],
        ['嵇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xAE"],
        ['嵭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xD3"],
        ['巗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xE3"],
        ['巢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF1"],
        ['幭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xAC"],
        ['幷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xB2"],
        ['庬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xC2"],
        ['徵', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xBF"],
        ['德', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xC0"],
        ['懕', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xE6"],
        ['戾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xFB"],
        ['扚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xAC"],
        ['抅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xB3"],
        ['掴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xBB"],
        ['掻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xB9"],
        ['揭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xEA"],
        ['揷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xE3"],
        ['擊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xA6"],
        ['攅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xB1"],
        ['攲', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xC0"],
        ['敄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xC6"],
        ['斁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xD2"],
        ['斅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xF8"],
        ['斵', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xE5"],
        ['旉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xE9"],
        ['旼', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xBB"],
        ['昺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xFD"],
        ['晈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD0"],
        ['晚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD5"],
        ['晣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD8"],
        ['曆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xB6"],
        ['杻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xA7"],
        ['柀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xB4"],
        ['桅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xC8"],
        ['桉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xC9"],
        ['棃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF2"],
        ['椵', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE4"],
        ['楗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE9"],
        ['榀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xEE"],
        ['榒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xEF"],
        ['榺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xFB"],
        ['槀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF5"],
        ['槩', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF7"],
        ['槪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xFA"],
        ['槶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xFB"],
        ['橉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xA6"],
        ['橫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xAD"],
        ['檞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xB5"],
        ['櫜', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF9"],
        ['步', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xDC"],
        ['歷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xDF"],
        ['每', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xF4"],
        ['毗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xF9"],
        ['氎', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xA1"],
        ['汛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xBC"],
        ['汶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xC0"],
        ['沗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xB3"],
        ['洯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xB4"],
        ['涁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xA1"],
        ['涉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xA5"],
        ['涊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xAC"],
        ['涜', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xD7"],
        ['淚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xB4"],
        ['渚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xAF"],
        ['渴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xC0"],
        ['湗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xCE"],
        ['溌', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xDA"],
        ['溫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xDB"],
        ['溿', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xDF"],
        ['滙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xE5"],
        ['漥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xF1"],
        ['潑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xAE"],
        ['潾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xFD"],
        ['澍', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xA3"],
        ['瀨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xBC"],
        ['焏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xA6"],
        ['焔', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xE0"],
        ['焮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xE8"],
        ['煑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xD3"],
        ['熖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xF3"],
        ['爕', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xCF"],
        ['爸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xB3"],
        ['爹', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xB4"],
        ['犾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD6"],
        ['狀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD7"],
        ['獒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD4"],
        ['玟', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xB1"],
        ['玨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA4"],
        ['琢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA1"],
        ['瑋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xE5"],
        ['璣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xFD"],
        ['璩', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xA2"],
        ['甁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xB8"],
        ['畬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xCB"],
        ['畾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xC7"],
        ['痩', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xF5"],
        ['瘀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xE5"],
        ['皡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xA7"],
        ['硏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA8"],
        ['硑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA9"],
        ['礮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xCA"],
        ['祘', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD1"],
        ['祷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xEC"],
        ['秌', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xF5"],
        ['穝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xBF"],
        ['窐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xD0"],
        ['笻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xF2"],
        ['箪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xC2"],
        ['簞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xBD"],
        ['籅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xBB"],
        ['粠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xCE"],
        ['糙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xD8"],
        ['絚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xA7"],
        ['綆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xB0"],
        ['綠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xB6"],
        ['緀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xBA"],
        ['緖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xBE"],
        ['緣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC1"],
        ['繋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xDF"],
        ['繍', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xE0"],
        ['耂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x72\xFC"],
        ['腠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xD1"],
        ['膄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xD7"],
        ['臬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF0"],
        ['艹', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x72\xFA"],
        ['芎', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xBF"],
        ['茰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xE3"],
        ['莱', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xA2"],
        ['菡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xA6"],
        ['葚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB4"],
        ['葟', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB5"],
        ['蒋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xB9"],
        ['蔾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCD"],
        ['薭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xE3"],
        ['薰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xE5"],
        ['虓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAD"],
        ['虛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAA"],
        ['蝉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB3"],
        ['蝋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB5"],
        ['蟬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE6"],
        ['蠋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xDC"],
        ['褐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xEE"],
        ['褧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xF2"],
        ['覉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xBC"],
        ['覐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xCB"],
        ['賴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF9"],
        ['贎', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB0"],
        ['躯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xEA"],
        ['躶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xE8"],
        ['軀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xED"],
        ['迓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xAE"],
        ['邈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF1"],
        ['郞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA6"],
        ['鄕', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xDF"],
        ['鄷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xB3"],
        ['酆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xB5"],
        ['醗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xA2"],
        ['醤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xA1"],
        ['鉂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xE5"],
        ['鉖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xED"],
        ['鋆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xB0"],
        ['鋓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xBA"],
        ['錄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCD"],
        ['鍊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xDB"],
        ['鍫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xB4"],
        ['鎺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xF5"],
        ['鑭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCE"],
        ['鑱', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCF"],
        ['閍', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xDE"],
        ['闐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xED"],
        ['雯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xA4"],
        ['霳', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAC"],
        ['霻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAD"],
        ['靏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAE"],
        ['韑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xCF"],
        ['韙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xD0"],
        ['頬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFD"],
        ['頲', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xEA"],
        ['頻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFB"],
        ['顛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFC"],
        ['飱', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xAF"],
        ['馣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xD3"],
        ['騨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xF8"],
        ['驒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xCD"],
        ['驘', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xDF"],
        ['魦', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCE"],
        ['魵', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xD0"],
        ['鯁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDD"],
        ['鯎', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDE"],
        ['鰀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xE3"],
        ['鰧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCB"],
        ['鱣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xEA"],
        ['鴎', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xB0"],
        ['鴞', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF9"],
        ['鵇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFB"],
        ['鵢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFD"],
        ['鵰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xA3"],
        ['鶖', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF1"],
        ['鹸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xB5"],
        ['麹', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xC3"],
        ['麺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xC4"],
        ['黃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xCC"],
        ['黑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xD6"],
        ['欄', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xC0"],
        ['廊', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xCA"],
        ['朗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xAD"],
        ['虜', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAB"],
        ['殺', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xED"],
        ['類', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xF5"],
        ['隆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xCC"],
        ['塚', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xCD"],
        ['猪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xEF"],
        ['神', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xDA"],
        ['祥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xDC"],
        ['福', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xE4"],
        ['諸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xB7"],
        ['都', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA8"],
        ['侮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xBB"],
        ['僧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB7"],
        ['免', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xD5"],
        ['勉', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xE7"],
        ['勤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xEF"],
        ['卑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xC3"],
        ['喝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xE5"],
        ['嘆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xF7"],
        ['器', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xF4"],
        ['塀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xB9"],
        ['墨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xDC"],
        ['層', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE0"],
        ['悔', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xAD"],
        ['慨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xD6"],
        ['懲', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xE8"],
        ['敏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xCA"],
        ['既', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xF4"],
        ['暑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xAA"],
        ['梅', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xD3"],
        ['琢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xF6"],
        ['碑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xB3"],
        ['練', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC8"],
        ['繁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE3"],
        ['著', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB3"],
        ['褐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xEC"],
        ['視', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xC4"],
        ['謁', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xBB"],
        ['謹', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xC4"],
        ['賓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF4"],
        ['贈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xAF"],
        ['逸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xD5"],
        ['難', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xFD"],
        ['響', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xD9"],
        ['頻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xD1"],
        ['¶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEF"],
        ['†', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xED"],
        ['‡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEE"],
        ['‰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xD3"],
        ['Å', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xD1"],
        ['⇒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDA"],
        ['⇔', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDB"],
        ['∀', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDC"],
        ['∂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE1"],
        ['∃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDD"],
        ['∇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE2"],
        ['∈', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD0"],
        ['∋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD1"],
        ['∑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['√', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE5"],
        ['∝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE7"],
        ['∟', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDE"],
        ['∧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD8"],
        ['∨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD9"],
        ['∩', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD7"],
        ['∪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD6"],
        ['∫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE8"],
        ['∬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE9"],
        ['∮', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∵', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA8"],
        ['∽', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE6"],
        ['≒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA9"],
        ['≡', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xAA"],
        ['≪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE3"],
        ['≫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE4"],
        ['⊂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD4"],
        ['⊃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD5"],
        ['⊆', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD2"],
        ['⊇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD3"],
        ['⊥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDF"],
        ['⊿', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['⌒', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE0"],
        ['─', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xD1"],
        ['━', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF6"],
        ['│', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xD2"],
        ['┃', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF7"],
        ['┌', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC1"],
        ['┏', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE6"],
        ['┐', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC2"],
        ['┓', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE7"],
        ['└', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC4"],
        ['┗', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE9"],
        ['┘', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC3"],
        ['┛', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE8"],
        ['├', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC7"],
        ['┝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA2"],
        ['┠', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCA"],
        ['┣', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF3"],
        ['┤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC8"],
        ['┥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA4"],
        ['┨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCC"],
        ['┫', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF4"],
        ['┬', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC5"],
        ['┯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCB"],
        ['┰', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA3"],
        ['┳', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF1"],
        ['┴', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC6"],
        ['┷', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC0"],
        ['┸', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA1"],
        ['┻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF2"],
        ['┼', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC9"],
        ['┿', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCE"],
        ['╂', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCD"],
        ['╋', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF5"],
        ['◯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xF0"],
        ['♪', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEC"],
        ['♭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEB"],
        ['♯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEA"],
        ['〝', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['〟', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊦', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊧', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊨', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍑', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍻', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍼', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍽', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍾', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['凜', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xA4"],
        ['堯', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC6"],
        ['尭', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xC8"],
        ['槇', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xEA"],
        ['槙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xC4"],
        ['熙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xA8"],
        ['瑤', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xE0\xF6"],
        ['瑶', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA2"],
        ['遙', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDA"],
        ['遥', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xEB"],
        ['～', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['￢', 'jef', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA7"],
        ['𠀋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xA6"],
        ['𠂉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFC"],
        ['𠆢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFA"],
        ['𠦝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x73\xFC"],
        ['𠮟', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['𡉴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xE5"],
        ['𡌛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xC6"],
        ['𡗗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x73\xFA"],
        ['𢌞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xD7"],
        ['𣗄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xC2"],
        ['𣳾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xC5"],
        ['𣵀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xAA"],
        ['㐬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xD7"],
        ['㐮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xD9"],
        ['㑨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xE5"],
        ['㓛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xB7"],
        ['㟢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xFE"],
        ['㟽', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xD5"],
        ['㠀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xB6"],
        ['㤚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xFB"],
        ['㫖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xAF"],
        ['㬚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xF0"],
        ['㬢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xF6"],
        ['㭭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xD4"],
        ['㮈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE3"],
        ['㮶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xF9"],
        ['㯰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xB2"],
        ['㴞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xD6"],
        ['㵤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xAC"],
        ['㹦', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xE0"],
        ['㹨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xE4"],
        ['䂓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xEB"],
        ['䄅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD2"],
        ['䅏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xAA"],
        ['䅣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xB5"],
        ['䉤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xBA"],
        ['䋖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xA2"],
        ['䏮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xC1"],
        ['䑓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xEA"],
        ['䑛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x60\xF4"],
        ['䑺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xAC"],
        ['䒑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xBA"],
        ['䒳', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xDF"],
        ['䒾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xED"],
        ['䔈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xC0"],
        ['䔥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCC"],
        ['䕃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xDB"],
        ['䚯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xE1"],
        ['䨩', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAA"],
        ['䪼', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xE6"],
        ['䯂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xD9"],
        ['䯨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xA5"],
        ['䰗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xB8"],
        ['䰠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xC5"],
        ['丒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xA8"],
        ['亹', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xDB"],
        ['亻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x71\xFB"],
        ['伃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF0"],
        ['伋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF2"],
        ['你', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xF8"],
        ['佺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xAE"],
        ['佽', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xAF"],
        ['佾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xB0"],
        ['侠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xCB"],
        ['俦', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xCD"],
        ['俱', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xCF"],
        ['僙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB3"],
        ['僡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB5"],
        ['凊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xFB"],
        ['刓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xBC"],
        ['刕', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xB4"],
        ['剝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC7\xED"],
        ['剥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xD0"],
        ['勊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xE8"],
        ['勖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xEC"],
        ['勻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xA2"],
        ['匾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xBB"],
        ['卺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xF2"],
        ['卽', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xD4"],
        ['吒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xAA"],
        ['吞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['唖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xB9"],
        ['喝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xB8"],
        ['嘘', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xBA"],
        ['嘰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xFD"],
        ['噓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB1\xB3"],
        ['噛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xBC"],
        ['噱', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xAE"],
        ['嚙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xFA"],
        ['嚢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xBA"],
        ['圡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xCC"],
        ['垝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xF4"],
        ['埇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xF6"],
        ['埞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xFC"],
        ['填', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xCA"],
        ['增', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xBB"],
        ['壠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xC3"],
        ['夅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xCE"],
        ['奆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xE1"],
        ['姍', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xAC"],
        ['姣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xB0"],
        ['姸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xB5"],
        ['婾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xCA"],
        ['媄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xCB"],
        ['嫰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xDE"],
        ['嬴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xEB"],
        ['寬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xC6"],
        ['尒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x41\xE1"],
        ['屏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE7"],
        ['屛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xD6\xA2"],
        ['屡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE5"],
        ['岈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xBA"],
        ['岧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xF2"],
        ['崐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xC9"],
        ['崝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xCA"],
        ['崠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xCB"],
        ['嵇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xAE"],
        ['嵭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xD3"],
        ['巗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4B\xE3"],
        ['巢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF1"],
        ['幭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xAC"],
        ['幷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xB2"],
        ['庬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xC2"],
        ['徵', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xBF"],
        ['德', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xC0"],
        ['懕', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xE6"],
        ['戾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xFB"],
        ['扚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xAC"],
        ['抅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xB3"],
        ['掴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xBB"],
        ['掻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xB9"],
        ['揭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xEA"],
        ['揷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xE3"],
        ['擊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4F\xA6"],
        ['攅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xB1"],
        ['攲', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xC0"],
        ['敄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xC6"],
        ['斁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xD2"],
        ['斅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x49\xF8"],
        ['斵', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xE5"],
        ['旉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xE9"],
        ['旼', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xBB"],
        ['昺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xFD"],
        ['晈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD0"],
        ['晚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD5"],
        ['晣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xD8"],
        ['曆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xB6"],
        ['杻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xA7"],
        ['柀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xB4"],
        ['桅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xC8"],
        ['桉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xC9"],
        ['棃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF2"],
        ['椵', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE4"],
        ['楗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xE9"],
        ['榀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xEE"],
        ['榒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xEF"],
        ['榺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xFB"],
        ['槀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF5"],
        ['槩', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF7"],
        ['槪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xFA"],
        ['槶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xFB"],
        ['橉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xA6"],
        ['橫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xAD"],
        ['檞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xB5"],
        ['櫜', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF9"],
        ['步', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xDC"],
        ['歷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xDF"],
        ['每', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xF4"],
        ['毗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xF9"],
        ['氎', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xA1"],
        ['汛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xBC"],
        ['汶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xC0"],
        ['沗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xB3"],
        ['洯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xB4"],
        ['涁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xA1"],
        ['涉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xA5"],
        ['涊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xAC"],
        ['涜', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xD7"],
        ['淚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xB4"],
        ['渚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x55\xAF"],
        ['渴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xC0"],
        ['湗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xCE"],
        ['溌', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xDA"],
        ['溫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xDB"],
        ['溿', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xDF"],
        ['滙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xE5"],
        ['漥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xF1"],
        ['潑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC8\xAE"],
        ['潾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x56\xFD"],
        ['澍', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xA3"],
        ['瀨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xBC"],
        ['焏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xA6"],
        ['焔', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xE0"],
        ['焮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xE8"],
        ['煑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xD3"],
        ['熖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xF3"],
        ['爕', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x57\xCF"],
        ['爸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xB3"],
        ['爹', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xB4"],
        ['犾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD6"],
        ['狀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD7"],
        ['獒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xD4"],
        ['玟', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xB1"],
        ['玨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA4"],
        ['琢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA1"],
        ['瑋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xE5"],
        ['璣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xFD"],
        ['璩', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xA2"],
        ['甁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xB8"],
        ['畬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xCB"],
        ['畾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xC7"],
        ['痩', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xF5"],
        ['瘀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5A\xE5"],
        ['皡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5B\xA7"],
        ['硏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA8"],
        ['硑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xA9"],
        ['礮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xCA"],
        ['祘', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xD1"],
        ['祷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xEC"],
        ['秌', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xF5"],
        ['穝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xBF"],
        ['窐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xD0"],
        ['笻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5D\xF2"],
        ['箪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xC2"],
        ['簞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC3\xBD"],
        ['籅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xBB"],
        ['粠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xCE"],
        ['糙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xD8"],
        ['絚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xA7"],
        ['綆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xB0"],
        ['綠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xB6"],
        ['緀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xBA"],
        ['緖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xBE"],
        ['緣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC1"],
        ['繋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xDF"],
        ['繍', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xE0"],
        ['耂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x72\xFC"],
        ['腠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xD1"],
        ['膄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xD7"],
        ['臬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xF0"],
        ['艹', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x72\xFA"],
        ['芎', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xBF"],
        ['茰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xE3"],
        ['莱', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xA2"],
        ['菡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xA6"],
        ['葚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB4"],
        ['葟', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB5"],
        ['蒋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x61\xB9"],
        ['蔾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xCD"],
        ['薭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xE3"],
        ['薰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xE5"],
        ['虓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAD"],
        ['虛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAA"],
        ['蝉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB3"],
        ['蝋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xB5"],
        ['蟬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC0\xE6"],
        ['蠋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xDC"],
        ['褐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xEE"],
        ['褧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xF2"],
        ['覉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xBC"],
        ['覐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xCB"],
        ['賴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF9"],
        ['贎', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xB0"],
        ['躯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xEA"],
        ['躶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xE8"],
        ['軀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xED"],
        ['迓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xAE"],
        ['邈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xF1"],
        ['郞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA6"],
        ['鄕', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xDF"],
        ['鄷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xB3"],
        ['酆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xB5"],
        ['醗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xA2"],
        ['醤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xA1"],
        ['鉂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xE5"],
        ['鉖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xED"],
        ['鋆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xB0"],
        ['鋓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xBA"],
        ['錄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xCD"],
        ['鍊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xDB"],
        ['鍫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x69\xB4"],
        ['鎺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6A\xF5"],
        ['鑭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCE"],
        ['鑱', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xCF"],
        ['閍', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xDE"],
        ['闐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xED"],
        ['雯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xA4"],
        ['霳', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAC"],
        ['霻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAD"],
        ['靏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xAE"],
        ['韑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xCF"],
        ['韙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xD0"],
        ['頬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFD"],
        ['頲', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xEA"],
        ['頻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFB"],
        ['顛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xFC"],
        ['飱', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xAF"],
        ['馣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xD3"],
        ['騨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xF8"],
        ['驒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xCD"],
        ['驘', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6D\xDF"],
        ['魦', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCE"],
        ['魵', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xD0"],
        ['鯁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDD"],
        ['鯎', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xDE"],
        ['鰀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xE3"],
        ['鰧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xCB"],
        ['鱣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xEA"],
        ['鴎', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xB0"],
        ['鴞', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF9"],
        ['鵇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFB"],
        ['鵢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xFD"],
        ['鵰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xA3"],
        ['鶖', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6E\xF1"],
        ['鹸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xB5"],
        ['麹', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xC3"],
        ['麺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xC4"],
        ['黃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xCC"],
        ['黑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6F\xD6"],
        ['欄', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xC0"],
        ['廊', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4C\xCA"],
        ['朗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x52\xAD"],
        ['虜', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x63\xAB"],
        ['殺', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xED"],
        ['類', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xF5"],
        ['隆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xCC"],
        ['塚', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC4\xCD"],
        ['猪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xEF"],
        ['神', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xDA"],
        ['祥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xDC"],
        ['福', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xE4"],
        ['諸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xB7"],
        ['都', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x68\xA8"],
        ['侮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x42\xBB"],
        ['僧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xB7"],
        ['免', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x43\xD5"],
        ['勉', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xE7"],
        ['勤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xEF"],
        ['卑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xC3"],
        ['喝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xE5"],
        ['嘆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x46\xF7"],
        ['器', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x45\xF4"],
        ['塀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x48\xB9"],
        ['墨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xDC"],
        ['層', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4A\xE0"],
        ['悔', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xAD"],
        ['慨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4E\xD6"],
        ['懲', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x4D\xE8"],
        ['敏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xCA"],
        ['既', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x50\xF4"],
        ['暑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x51\xAA"],
        ['梅', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x53\xD3"],
        ['琢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC2\xF6"],
        ['碑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5C\xB3"],
        ['練', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5F\xC8"],
        ['繁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x5E\xE3"],
        ['著', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x62\xB3"],
        ['褐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB3\xEC"],
        ['視', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x64\xC4"],
        ['謁', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xBB"],
        ['謹', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xC4"],
        ['賓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x65\xF4"],
        ['贈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x66\xAF"],
        ['逸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x67\xD5"],
        ['難', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6B\xFD"],
        ['響', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x6C\xD9"],
        ['頻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xC9\xD1"],
        ['¶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEF"],
        ['†', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xED"],
        ['‡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEE"],
        ['‰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xD3"],
        ['Å', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xD1"],
        ['⇒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDA"],
        ['⇔', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDB"],
        ['∀', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDC"],
        ['∂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE1"],
        ['∃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDD"],
        ['∇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE2"],
        ['∈', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD0"],
        ['∋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD1"],
        ['∑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['√', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE5"],
        ['∝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE7"],
        ['∟', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDE"],
        ['∧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD8"],
        ['∨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD9"],
        ['∩', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD7"],
        ['∪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD6"],
        ['∫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE8"],
        ['∬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE9"],
        ['∮', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['∵', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA8"],
        ['∽', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE6"],
        ['≒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA9"],
        ['≡', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xAA"],
        ['≪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE3"],
        ['≫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE4"],
        ['⊂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD4"],
        ['⊃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD5"],
        ['⊆', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD2"],
        ['⊇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xD3"],
        ['⊥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xDF"],
        ['⊿', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['⌒', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xE0"],
        ['─', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xD1"],
        ['━', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF6"],
        ['│', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xD2"],
        ['┃', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF7"],
        ['┌', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC1"],
        ['┏', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE6"],
        ['┐', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC2"],
        ['┓', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE7"],
        ['└', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC4"],
        ['┗', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE9"],
        ['┘', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC3"],
        ['┛', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xE8"],
        ['├', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC7"],
        ['┝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA2"],
        ['┠', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCA"],
        ['┣', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF3"],
        ['┤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC8"],
        ['┥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA4"],
        ['┨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCC"],
        ['┫', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF4"],
        ['┬', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC5"],
        ['┯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCB"],
        ['┰', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA3"],
        ['┳', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF1"],
        ['┴', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC6"],
        ['┷', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC0"],
        ['┸', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xA1"],
        ['┻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF2"],
        ['┼', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xC9"],
        ['┿', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCE"],
        ['╂', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xCD"],
        ['╋', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7C\xF5"],
        ['◯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xF0"],
        ['♪', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEC"],
        ['♭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEB"],
        ['♯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x7F\xEA"],
        ['〝', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['〟', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊦', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊧', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㊨', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍑', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍻', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍼', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍽', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['㍾', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x00\x00"],
        ['凜', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x44\xA4"],
        ['堯', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xB6\xC6"],
        ['尭', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x47\xC8"],
        ['槇', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCB\xEA"],
        ['槙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x54\xC4"],
        ['熙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x58\xA8"],
        ['瑤', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xE0\xF6"],
        ['瑶', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x59\xA2"],
        ['遙', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\xCD\xDA"],
        ['遥', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x70\xEB"],
        ['￢', 'jef9p', 'utf8', {'INPUT_LAYOUT'=>'D'}, "\x76\xA7"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    $option->{'GETA'} = "\x00\x00";
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'},}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'},}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]},} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]},}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$give $INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__DATA__
