#!/usr/bin/perl

use strict;
use lib 't/lib';

use Test::More;
use Test::Deep qw(cmp_deeply);

use FusionInventory::Agent::SNMP::Mock;
use FusionInventory::Agent::Tools::Hardware;

my %tests = (
    'hewlett-packard/c0302a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311977,FN:MB14HZB,SVCID:20055,PID:HP Color LaserJet CP2025dn',

            SNMPHOSTNAME => 'c0302a',
            LOCATION     => 'HP Color LaserJet CP2025dn',
            SERIAL       => 'CNHS311977',
            UPTIME       => '(3731317) 10:21:53.17',
            MEMORY       => '64',
            MAC          => '00:25:b3:fa:8f:83',
            IPS          => {
                IP => [
                    '128.93.22.19',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311977,FN:MB14HZB,SVCID:20055,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c0302a',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS311977',
                UPTIME       => '(3731317) 10:21:53.17',
                MEMORY       => '64',
                MAC          => '00:25:b3:fa:8f:83',
                IPS          => {
                    IP => [
                        '128.93.22.19',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '57',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15135176',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15211522',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.19',
                        MAC              => '00:25:b3:fa:8f:83',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '468693900',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2643170',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c202a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311991,FN:MB14HYJ,SVCID:20048,PID:HP Color LaserJet CP2025dn',

            SNMPHOSTNAME => 'c1C202a',
            LOCATION     => 'HP Color LaserJet CP2025dn',
            SERIAL       => 'CNHS311991',
            UPTIME       => '(127613450) 14 days, 18:28:54.50',
            MEMORY       => '64',
            MAC          => '00:25:b3:fa:8f:69',
            IPS          => {
                IP => [
                    '128.93.22.236',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311991,FN:MB14HYJ,SVCID:20048,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C202a',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS311991',
                UPTIME       => '(127613450) 14 days, 18:28:54.50',
                MEMORY       => '64',
                MAC          => '00:25:b3:fa:8f:69',
                IPS          => {
                    IP => [
                        '128.93.22.236',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '2026',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '461172803',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '459898940',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.236',
                        MAC              => '00:25:b3:fa:8f:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '472915891',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '26628688',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c203a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311990,FN:MB14J1J,SVCID:20034,PID:c1c203a',

            SNMPHOSTNAME => 'c1c203a',
            LOCATION     => 'c1c203a',
            SERIAL       => 'CNHS311990',
            UPTIME       => '(79171032) 9 days, 3:55:10.32',
            MEMORY       => '64',
            MAC          => '00:25:b3:fa:8f:cc',
            IPS          => {
                IP => [
                    '128.93.22.87',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311990,FN:MB14J1J,SVCID:20034,PID:c1c203a',
                NAME         => 'c1c203a',
                LOCATION     => 'c1c203a',
                SERIAL       => 'CNHS311990',
                UPTIME       => '(79171032) 9 days, 3:55:10.32',
                MEMORY       => '64',
                MAC          => '00:25:b3:fa:8f:cc',
                IPS          => {
                    IP => [
                        '128.93.22.87',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '1019',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '286476140',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '321945244',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.87',
                        MAC              => '00:25:b3:fa:8f:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '3617972664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10805204',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c205a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311979,FN:MB14J3Z,SVCID:20045,PID:c1c205a',

            SNMPHOSTNAME => 'NPIFA9F1C',
            LOCATION     => 'c1c205a',
            SERIAL       => 'CNHS311979',
            UPTIME       => '(3023313454) 349 days, 22:05:34.54',
            MEMORY       => '64',
            MAC          => '00:25:b3:fa:9f:1c',
            IPS          => {
                IP => [
                    '128.93.22.225',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS311979,FN:MB14J3Z,SVCID:20045,PID:c1c205a',
                NAME         => 'NPIFA9F1C',
                LOCATION     => 'c1c205a',
                SERIAL       => 'CNHS311979',
                UPTIME       => '(3023313454) 349 days, 22:05:34.54',
                MEMORY       => '64',
                MAC          => '00:25:b3:fa:9f:1c',
                IPS          => {
                    IP => [
                        '128.93.22.225',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '1016',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2236119563',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2235897962',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.225',
                        MAC              => '00:25:b3:fa:9f:1c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(286315045) 33 days, 3:19:10.45',
                        IFINOCTETS       => '1769857822',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1974950967',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c1c206a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS312016,FN:MB14JA3,SVCID:20045,PID:HP Color LaserJet CP2025dn',

            SNMPHOSTNAME => 'c1C206a',
            LOCATION     => 'HP Color LaserJet CP2025dn',
            SERIAL       => 'CNHS312016',
            UPTIME       => '(2665726) 7:24:17.26',
            MEMORY       => '64',
            MAC          => '00:25:b3:fa:9f:e6',
            IPS          => {
                IP => [
                    '128.93.22.224',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS312016,FN:MB14JA3,SVCID:20045,PID:HP Color LaserJet CP2025dn',
                NAME         => 'c1C206a',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS312016',
                UPTIME       => '(2665726) 7:24:17.26',
                MEMORY       => '64',
                MAC          => '00:25:b3:fa:9f:e6',
                IPS          => {
                    IP => [
                        '128.93.22.224',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '0',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9602930',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9591687',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.224',
                        MAC              => '00:25:b3:fa:9f:e6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '419831787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1072100',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c2406a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Business Inkjet 2800',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',

            SNMPHOSTNAME => 'NPIE6C1AF',
            UPTIME       => '(315536000) 36 days, 12:29:20.00',
            MEMORY       => '96',
            MAC          => '00:1b:78:e6:c1:af',
            IPS          => {
                IP => [
                    '128.93.22.214',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C1AF',
                UPTIME       => '(315536000) 36 days, 12:29:20.00',
                MEMORY       => '96',
                MAC          => '00:1b:78:e6:c1:af',
                IPS          => {
                    IP => [
                        '128.93.22.214',
                    ],
                },
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '35',
                CARTRIDGEMAGENTA => '35',
                CARTRIDGEYELLOW  => '35',
            },
            PAGECOUNTERS => {
                TOTAL      => '2978',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.214',
                        MAC              => '00:1b:78:e6:c1:af',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '3188012392',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '157851660',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '670842604',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '36631382',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/c2407a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Business Inkjet 2800',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',

            SNMPHOSTNAME => 'NPIE6C19A',
            UPTIME       => '(15951321) 1 day, 20:18:33.21',
            MEMORY       => '96',
            MAC          => '00:1b:78:e6:c1:9a',
            IPS          => {
                IP => [
                    '128.93.22.129',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'NPIE6C19A',
                UPTIME       => '(15951321) 1 day, 20:18:33.21',
                MEMORY       => '96',
                MAC          => '00:1b:78:e6:c1:9a',
                IPS          => {
                    IP => [
                        '128.93.22.129',
                    ],
                },
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '13',
                CARTRIDGECYAN    => '27',
                CARTRIDGEMAGENTA => '34',
                CARTRIDGEYELLOW  => '34',
            },
            PAGECOUNTERS => {
                TOTAL      => '360',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.129',
                        MAC              => '00:1b:78:e6:c1:9a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008614593) 463 days, 23:02:25.93',
                        IFINOCTETS       => '2901678960',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284193866',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/Inkjet_2800.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Business Inkjet 2800',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',

            SNMPHOSTNAME => 'HPIJ2800-02',
            UPTIME       => '(45821440) 5 days, 7:16:54.40',
            MEMORY       => '96',
            MAC          => '00:11:0a:f5:cc:dc',
            IPS          => {
                IP => [
                    '10.104.102.194',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-02',
                UPTIME       => '(45821440) 5 days, 7:16:54.40',
                MEMORY       => '96',
                MAC          => '00:11:0a:f5:cc:dc',
                IPS          => {
                    IP => [
                        '10.104.102.194',
                    ],
                },
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '12',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '29',
                CARTRIDGEYELLOW  => '33',
            },
            PAGECOUNTERS => {
                TOTAL      => '24724',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.102.194',
                        MAC              => '00:11:0a:f5:cc:dc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3338251014',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14894593',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3337864481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14683822',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/Inkjet_2800.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Business Inkjet 2800',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',

            SNMPHOSTNAME => 'HPIJ2800-01',
            UPTIME       => '(85884840) 9 days, 22:34:08.40',
            MEMORY       => '96',
            MAC          => '00:11:0a:f5:1a:cc',
            IPS          => {
                IP => [
                    '10.104.109.230',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Business Inkjet 2800',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'HPIJ2800-01',
                UPTIME       => '(85884840) 9 days, 22:34:08.40',
                MEMORY       => '96',
                MAC          => '00:11:0a:f5:1a:cc',
                IPS          => {
                    IP => [
                        '10.104.109.230',
                    ],
                },
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '10',
                CARTRIDGECYAN    => '32',
                CARTRIDGEMAGENTA => '32',
                CARTRIDGEYELLOW  => '27',
            },
            PAGECOUNTERS => {
                TOTAL      => '24304',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.104.109.230',
                        MAC              => '00:11:0a:f5:1a:cc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(52250) 0:08:42.50',
                        IFINOCTETS       => '47343424',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '685530',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '10000000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l0214a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'l0214a',
            UPTIME       => '(27930670) 3 days, 5:35:06.70',
            MAC          => '00:17:08:91:95:e4',
            IPS          => {
                IP => [
                    '128.93.22.125',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l0214a',
                UPTIME       => '(27930670) 3 days, 5:35:06.70',
                MAC          => '00:17:08:91:95:e4',
                IPS          => {
                    IP => [
                        '128.93.22.125',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.125',
                        MAC              => '00:17:08:91:95:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4231070113',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '358458889',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l0700a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI934D66',
            UPTIME       => '(40406032) 4 days, 16:14:20.32',
            MAC          => '00:17:a4:93:4d:66',
            IPS          => {
                IP => [
                    '128.93.22.1',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D66',
                UPTIME       => '(40406032) 4 days, 16:14:20.32',
                MAC          => '00:17:a4:93:4d:66',
                IPS          => {
                    IP => [
                        '128.93.22.1',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.1',
                        MAC              => '00:17:a4:93:4d:66',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2697548956',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2323517464',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l1803a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI9195E8',
            UPTIME       => '(4016837) 11:09:28.37',
            MAC          => '00:17:08:91:95:e8',
            IPS          => {
                IP => [
                    '128.93.22.78',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI9195E8',
                UPTIME       => '(4016837) 11:09:28.37',
                MAC          => '00:17:08:91:95:e8',
                IPS          => {
                    IP => [
                        '128.93.22.78',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.78',
                        MAC              => '00:17:08:91:95:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '518877292',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '326948288',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l1b110a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI810884',
            UPTIME       => '(13141846) 1 day, 12:30:18.46',
            MAC          => '00:1b:78:21:ef:df',
            IPS          => {
                IP => [
                    '128.93.22.101',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI810884',
                UPTIME       => '(13141846) 1 day, 12:30:18.46',
                MAC          => '00:1b:78:21:ef:df',
                IPS          => {
                    IP => [
                        '128.93.22.101',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.101',
                        MAC              => '00:1b:78:21:ef:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2493348234',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '107189645',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/l2520a.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI934D6D',
            UPTIME       => '(3561333) 9:53:33.33',
            MAC          => '00:17:a4:93:4d:6d',
            IPS          => {
                IP => [
                    '128.93.10.40',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D6D',
                UPTIME       => '(3561333) 9:53:33.33',
                MAC          => '00:17:a4:93:4d:6d',
                IPS          => {
                    IP => [
                        '128.93.10.40',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.10.40',
                        MAC              => '00:17:a4:93:4d:6d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2266764957',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '119345262',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_100_colorMFP_M175nw.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 100 colorMFP M175nw',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNC9D8R0DX,FN:RN32CK3,SVCID:22288,PID:HP LaserJet 100 colorMFP M175nw',

            SNMPHOSTNAME => 'NPIF6FA4A',
            SERIAL       => 'CNC9D8R0DX',
            MAC          => 'b4:b5:2f:f6:fa:4a',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 100 colorMFP M175nw',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNC9D8R0DX,FN:RN32CK3,SVCID:22288,PID:HP LaserJet 100 colorMFP M175nw',
                NAME         => 'NPIF6FA4A',
                SERIAL       => 'CNC9D8R0DX',
                MAC          => 'b4:b5:2f:f6:fa:4a',
            },
            PAGECOUNTERS => {
                TOTAL      => '367',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '569120555',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '568555646',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(227607) 0:37:56.07',
                        IFINOCTETS       => '376926321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10253796',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'wifi0',
                        IFDESCR          => 'wifi0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:fa:4a',
                        IFLASTCHANGE     => '(290) 0:00:02.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'wifiUAP',
                        IFDESCR          => 'wifiUAP',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1300n.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 1300n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14,CIDATE 09/24/2003',

            SNMPHOSTNAME => 'impbe94',
            SERIAL       => 'CNCD118906',
            MAC          => '00:0e:7f:33:34:ba',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 1300n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14,CIDATE 09/24/2003',
                NAME         => 'impbe94',
                SERIAL       => 'CNCD118906',
                MAC          => '00:0e:7f:33:34:ba',
            },
            PAGECOUNTERS => {
                TOTAL      => '49530',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:0e:7f:33:34:ba',
                        IFLASTCHANGE     => '(2147640540) 248 days, 13:40:05.40',
                        IFINOCTETS       => '138463765',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1669632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM P.22.01,JETDIRECT,JD86,EEPROM P.25.14',
                        IFTYPE           => '24',
                        IFSPEED          => '2149807168',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(256) 0:00:02.56',
                        IFINOCTETS       => '2154227664',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2422572804',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 1320 series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',

            SNMPHOSTNAME => 'NPI61044B',
            SERIAL       => 'CNHW59NG6N',
            MAC          => '00:14:38:61:04:4b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI61044B',
                SERIAL       => 'CNHW59NG6N',
                MAC          => '00:14:38:61:04:4b',
            },
            PAGECOUNTERS => {
                TOTAL      => '33545',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:61:04:4b',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '1398049413',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5988998',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154273388) 249 days, 8:05:33.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 1320 series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',

            SNMPHOSTNAME => 'NPI9A3FC7',
            SERIAL       => 'CNHW625K6Z',
            MAC          => '00:14:38:9a:3f:c7',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPI9A3FC7',
                SERIAL       => 'CNHW625K6Z',
                MAC          => '00:14:38:9a:3f:c7',
            },
            PAGECOUNTERS => {
                TOTAL      => '45790',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:14:38:9a:3f:c7',
                        IFLASTCHANGE     => '(15) 0:00:00.15',
                        IFINOCTETS       => '64787538',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '304811',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '4',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2154316712) 249 days, 8:12:47.12',
                        IFINOCTETS       => '2148589888',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2423914616',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_1320.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 1320 series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',

            SNMPHOSTNAME => 'NPIC68F5E',
            SERIAL       => 'CNBW49FHC4',
            MAC          => '00:11:85:c6:8f:5e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 1320 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05,CIDATE 04/22/2004',
                NAME         => 'NPIC68F5E',
                SERIAL       => 'CNBW49FHC4',
                MAC          => '00:11:85:c6:8f:5e',
            },
            PAGECOUNTERS => {
                TOTAL      => '5868',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:c6:8f:5e',
                        IFLASTCHANGE     => '(4) 0:00:00.04',
                        IFINOCTETS       => '1057001886',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9279619',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM B.25.01,JETDIRECT,JD119,EEPROM V.28.05',
                        IFTYPE           => '24',
                        IFSPEED          => '60',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2422553824) 280 days, 9:18:58.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2148697580',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',

            LOCATION     => 'impbe92',
            SERIAL       => 'FRGW108125',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
                SERIAL       => 'FRGW108125',
                MAC          => '00:30:c1:8a:6e:5b',
            },
            PAGECOUNTERS => {
                TOTAL      => '65436',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '940032733',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8567174',
                        IFOUTERRORS      => '16',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',

            LOCATION     => 'impbe92',
            SERIAL       => 'FRGW108125',
            MAC          => '00:30:c1:8a:6e:5b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                LOCATION     => 'impbe92',
                SERIAL       => 'FRGW108125',
                MAC          => '00:30:c1:8a:6e:5b',
            },
            PAGECOUNTERS => {
                TOTAL      => '65516',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8a:6e:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '929364745',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6619438',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',

            SERIAL       => 'FRGW022412',
            UPTIME       => '(319831420) 37 days, 0:25:14.20',
            MEMORY       => '8',
            MAC          => '00:30:c1:0d:aa:c6',
            IPS          => {
                IP => [
                    '128.93.22.63',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                SERIAL       => 'FRGW022412',
                UPTIME       => '(319831420) 37 days, 0:25:14.20',
                MEMORY       => '8',
                MAC          => '00:30:c1:0d:aa:c6',
                IPS          => {
                    IP => [
                        '128.93.22.63',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '27649',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.63',
                        MAC              => '00:30:c1:0d:aa:c6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3098738609',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6907034',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',

            SERIAL       => 'XXXXXXXXXX',
            UPTIME       => '(165740930) 19 days, 4:23:29.30',
            MEMORY       => '8',
            MAC          => '00:10:83:54:d6:08',
            IPS          => {
                IP => [
                    '128.93.22.61',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                SERIAL       => 'XXXXXXXXXX',
                UPTIME       => '(165740930) 19 days, 4:23:29.30',
                MEMORY       => '8',
                MAC          => '00:10:83:54:d6:08',
                IPS          => {
                    IP => [
                        '128.93.22.61',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '46041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.61',
                        MAC              => '00:10:83:54:d6:08',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2570180872',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1315699',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06,CIDATE 04/27/2004',

            SNMPHOSTNAME => 'l1618a',
            SERIAL       => 'FRGW102302',
            UPTIME       => '(13841080) 1 day, 14:26:50.80',
            MEMORY       => '8',
            MAC          => '00:0e:7f:ea:e1:b7',
            IPS          => {
                IP => [
                    '128.93.22.29',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06,CIDATE 04/27/2004',
                NAME         => 'l1618a',
                SERIAL       => 'FRGW102302',
                UPTIME       => '(13841080) 1 day, 14:26:50.80',
                MEMORY       => '8',
                MAC          => '00:0e:7f:ea:e1:b7',
                IPS          => {
                    IP => [
                        '128.93.22.29',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '3846',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.29',
                        MAC              => '00:0e:7f:ea:e1:b7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3003827766',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '155057491',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM C.25.80,JETDIRECT,JD115,EEPROM V.28.06',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '78520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2100.06.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2100 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',

            SERIAL       => 'NLBB001719',
            UPTIME       => '(20422550) 2 days, 8:43:45.50',
            MEMORY       => '8',
            MAC          => '00:30:c1:c3:be:cf',
            IPS          => {
                IP => [
                    '128.93.22.144',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2100 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                SERIAL       => 'NLBB001719',
                UPTIME       => '(20422550) 2 days, 8:43:45.50',
                MEMORY       => '8',
                MAC          => '00:30:c1:c3:be:cf',
                IPS          => {
                    IP => [
                        '128.93.22.144',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '15352',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD30,EEPROM G.08.20',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.144',
                        MAC              => '00:30:c1:c3:be:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1489429781',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '239316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2200.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 2200',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',

            SERIAL       => 'FRFRH43314',
            UPTIME       => '(745729650) 86 days, 7:28:16.50',
            MEMORY       => '16',
            MAC          => '00:30:c1:01:1e:68',
            IPS          => {
                IP => [
                    '128.93.22.20',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 2200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                SERIAL       => 'FRFRH43314',
                UPTIME       => '(745729650) 86 days, 7:28:16.50',
                MEMORY       => '16',
                MAC          => '00:30:c1:01:1e:68',
                IPS          => {
                    IP => [
                        '128.93.22.20',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '38972',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.49',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.20',
                        MAC              => '00:30:c1:01:1e:68',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3553593205',
                        IFINERRORS       => '942585',
                        IFOUTOCTETS      => '17502829',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2300.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 2300 series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08,CIDATE 02/26/2003',

            SNMPHOSTNAME => 'NPIA1D034',
            SERIAL       => 'CNCDF57941',
            UPTIME       => '(313714810) 36 days, 7:25:48.10',
            MEMORY       => '48',
            MAC          => '00:01:e6:a1:d0:34',
            IPS          => {
                IP => [
                    '128.93.22.126',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08,CIDATE 02/26/2003',
                NAME         => 'NPIA1D034',
                SERIAL       => 'CNCDF57941',
                UPTIME       => '(313714810) 36 days, 7:25:48.10',
                MEMORY       => '48',
                MAC          => '00:01:e6:a1:d0:34',
                IPS          => {
                    IP => [
                        '128.93.22.126',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '23551',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.126',
                        MAC              => '00:01:e6:a1:d0:34',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008588496) 463 days, 22:58:04.96',
                        IFINOCTETS       => '2184590033',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '313870484',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.24.08',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2300.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 2300 series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',

            SERIAL       => 'CNCHM24955',
            UPTIME       => '(3052880) 8:28:48.80',
            MEMORY       => '48',
            MAC          => '00:30:c1:60:c8:5b',
            IPS          => {
                IP => [
                    '128.93.22.66',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 2300 series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                SERIAL       => 'CNCHM24955',
                UPTIME       => '(3052880) 8:28:48.80',
                MEMORY       => '48',
                MAC          => '00:30:c1:60:c8:5b',
                IPS          => {
                    IP => [
                        '128.93.22.66',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '17090',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.02,JETDIRECT,JD30,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.66',
                        MAC              => '00:30:c1:60:c8:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '260181495',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '522299',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_2600n.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet 2600n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT',

            SNMPHOSTNAME => 'NPI1864A0',
            MAC          => '00:1a:4b:18:64:a0',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet 2600n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'NPI1864A0',
                MAC          => '00:1a:4b:18:64:a0',
            },
            CARTRIDGES => {
                TONERBLACK       => '72',
                TONERCYAN        => '82',
                TONERMAGENTA     => '87',
                TONERYELLOW      => '65',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1a:4b:18:64:a0',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '323501189',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1322669',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_3600.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet 3600',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31,CIDATE 06/17/2005',

            SNMPHOSTNAME => 'NPI6F72C5',
            SERIAL       => 'CNXJD65169',
            MAC          => '00:1b:78:6f:72:c5',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet 3600',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31,CIDATE 06/17/2005',
                NAME         => 'NPI6F72C5',
                SERIAL       => 'CNXJD65169',
                MAC          => '00:1b:78:6f:72:c5',
            },
            PAGECOUNTERS => {
                TOTAL      => '11012',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:6f:72:c5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '127624321',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '612088',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD121,EEPROM V.30.31',
                        IFTYPE           => '24',
                        IFSPEED          => '1',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(5917) 0:00:59.17',
                        IFINOCTETS       => '611022',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4000.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 4000 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',

            SNMPHOSTNAME => 'inspiron8',
            LOCATION     => 'lwcompta',
            SERIAL       => 'NLEW064384',
            MAC          => '00:60:b0:91:3d:9d',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 4000 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                NAME         => 'inspiron8',
                LOCATION     => 'lwcompta',
                SERIAL       => 'NLEW064384',
                MAC          => '00:60:b0:91:3d:9d',
            },
            PAGECOUNTERS => {
                TOTAL      => '20653',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.05.35,JETDIRECT,JD30,EEPROM G.05.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:60:b0:91:3d:9d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2393162823',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75803829',
                        IFOUTERRORS      => '321',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_400_color_M451dn.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 400 color M451dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCF300725,FN:Q5132YG,SVCID:22330,PID:HP LaserJet 400 color M451dn',

            SNMPHOSTNAME => 'NPIF67498',
            SERIAL       => 'CNCF300725',
            MAC          => 'b4:b5:2f:f6:74:98',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 400 color M451dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCF300725,FN:Q5132YG,SVCID:22330,PID:HP LaserJet 400 color M451dn',
                NAME         => 'NPIF67498',
                SERIAL       => 'CNCF300725',
                MAC          => 'b4:b5:2f:f6:74:98',
            },
            PAGECOUNTERS => {
                TOTAL      => '541',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1544097',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1544097',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:b5:2f:f6:74:98',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '407432',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '128595',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4050.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 4050 Series ',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',

            SNMPHOSTNAME => 'imprimanteBR',
            LOCATION     => 'impbe93',
            SERIAL       => 'NL7N093250',
            MAC          => '00:30:c1:8c:d5:6c',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                NAME         => 'imprimanteBR',
                LOCATION     => 'impbe93',
                SERIAL       => 'NL7N093250',
                MAC          => '00:30:c1:8c:d5:6c',
            },
            PAGECOUNTERS => {
                TOTAL      => '252311',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.08.08,JETDIRECT,JD33,EEPROM G.08.04',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:30:c1:8c:d5:6c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '343388846',
                        IFINERRORS       => '10',
                        IFOUTOCTETS      => '7245532',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4050.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 4050 Series ',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',

            SERIAL       => 'NL7V061384',
            UPTIME       => '(130640030) 15 days, 2:53:20.30',
            MEMORY       => '16',
            MAC          => '00:10:83:ba:17:ce',
            IPS          => {
                IP => [
                    '128.93.22.64',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 4050 Series ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                SERIAL       => 'NL7V061384',
                UPTIME       => '(130640030) 15 days, 2:53:20.30',
                MEMORY       => '16',
                MAC          => '00:10:83:ba:17:ce',
                IPS          => {
                    IP => [
                        '128.93.22.64',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '243041',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM G.07.19,JETDIRECT,JD33,EEPROM G.08.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.64',
                        MAC              => '00:10:83:ba:17:ce',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '15339819',
                        IFINERRORS       => '124290',
                        IFOUTOCTETS      => '5833586',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4200.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4200',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09,CIDATE 07/24/2003',

            SNMPHOSTNAME => 'IMP41200n0',
            SERIAL       => 'CNFX305387',
            MAC          => '00:01:e6:a1:a7:81',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4200',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09,CIDATE 07/24/2003',
                NAME         => 'IMP41200n0',
                SERIAL       => 'CNFX305387',
                MAC          => '00:01:e6:a1:a7:81',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '71',
            },
            PAGECOUNTERS => {
                TOTAL      => '60803',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:01:e6:a1:a7:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '17795405',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2549445',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM R.22.01,JETDIRECT,JD95,EEPROM R.25.09',
                        IFTYPE           => '24',
                        IFSPEED          => '4008636142',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(4008636142) 463 days, 23:06:01.42',
                        IFINOCTETS       => '4008636142',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4008636142',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43,CIDATE 06/23/2004',

            SNMPHOSTNAME => 'impKirat',
            SERIAL       => 'CNCXG01622',
            MAC          => '00:11:85:d9:f6:c7',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43,CIDATE 06/23/2004',
                NAME         => 'impKirat',
                SERIAL       => 'CNCXG01622',
                MAC          => '00:11:85:d9:f6:c7',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '56',
            },
            PAGECOUNTERS => {
                TOTAL      => '99802',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:11:85:d9:f6:c7',
                        IFLASTCHANGE     => '(1384596280) 160 days, 6:06:02.80',
                        IFINOCTETS       => '3616354',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '244332',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.43',
                        IFTYPE           => '24',
                        IFSPEED          => '1384596280',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376930680',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381269328',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',

            SNMPHOSTNAME => 'l0812a',
            SERIAL       => 'CNHXH84872',
            UPTIME       => '(22322645) 2 days, 14:00:26.45',
            MEMORY       => '256',
            MAC          => '00:14:38:df:a5:30',
            IPS          => {
                IP => [
                    '128.93.22.88',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l0812a',
                SERIAL       => 'CNHXH84872',
                UPTIME       => '(22322645) 2 days, 14:00:26.45',
                MEMORY       => '256',
                MAC          => '00:14:38:df:a5:30',
                IPS          => {
                    IP => [
                        '128.93.22.88',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '73',
            },
            PAGECOUNTERS => {
                TOTAL      => '60480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.88',
                        MAC              => '00:14:38:df:a5:30',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384198996) 160 days, 4:59:49.96',
                        IFINOCTETS       => '2049027686',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '81883590',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384198996',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',

            SNMPHOSTNAME => 'NPIEA2B02',
            SERIAL       => 'CNHXG83836',
            UPTIME       => '(22683627) 2 days, 15:00:36.27',
            MEMORY       => '208',
            MAC          => '00:23:7d:7e:a1:31',
            IPS          => {
                IP => [
                    '128.93.8.82',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'NPIEA2B02',
                SERIAL       => 'CNHXG83836',
                UPTIME       => '(22683627) 2 days, 15:00:36.27',
                MEMORY       => '208',
                MAC          => '00:23:7d:7e:a1:31',
                IPS          => {
                    IP => [
                        '128.93.8.82',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '25',
            },
            PAGECOUNTERS => {
                TOTAL      => '167089',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.8.82',
                        MAC              => '00:23:7d:7e:a1:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384190036) 160 days, 4:58:20.36',
                        IFINOCTETS       => '2308962248',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '34234855',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384190036',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',

            SNMPHOSTNAME => 'NPIEA3BFC',
            SERIAL       => 'CNHXB71032',
            UPTIME       => '(23418928) 2 days, 17:03:09.28',
            MEMORY       => '208',
            MAC          => '00:14:38:ea:3b:fc',
            IPS          => {
                IP => [
                    '128.93.22.90',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEA3BFC',
                SERIAL       => 'CNHXB71032',
                UPTIME       => '(23418928) 2 days, 17:03:09.28',
                MEMORY       => '208',
                MAC          => '00:14:38:ea:3b:fc',
                IPS          => {
                    IP => [
                        '128.93.22.90',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '41',
            },
            PAGECOUNTERS => {
                TOTAL      => '131919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.90',
                        MAC              => '00:14:38:ea:3b:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384200904) 160 days, 5:00:09.04',
                        IFINOCTETS       => '1437804814',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65704274',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384200904',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',

            SNMPHOSTNAME => 'l1310a',
            SERIAL       => 'CNHXC68053',
            UPTIME       => '(23191049) 2 days, 16:25:10.49',
            MEMORY       => '208',
            MAC          => '00:14:38:ea:2b:c4',
            IPS          => {
                IP => [
                    '128.93.13.25',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1310a',
                SERIAL       => 'CNHXC68053',
                UPTIME       => '(23191049) 2 days, 16:25:10.49',
                MEMORY       => '208',
                MAC          => '00:14:38:ea:2b:c4',
                IPS          => {
                    IP => [
                        '128.93.13.25',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '55',
            },
            PAGECOUNTERS => {
                TOTAL      => '101394',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.13.25',
                        MAC              => '00:14:38:ea:2b:c4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384213080) 160 days, 5:02:10.80',
                        IFINOCTETS       => '650567085',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5895937',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384213080',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.06.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',

            SNMPHOSTNAME => 'l1439a',
            SERIAL       => 'CNHXH84870',
            UPTIME       => '(22810882) 2 days, 15:21:48.82',
            MEMORY       => '208',
            MAC          => '00:14:38:e2:12:d8',
            IPS          => {
                IP => [
                    '128.93.22.59',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'l1439a',
                SERIAL       => 'CNHXH84870',
                UPTIME       => '(22810882) 2 days, 15:21:48.82',
                MEMORY       => '208',
                MAC          => '00:14:38:e2:12:d8',
                IPS          => {
                    IP => [
                        '128.93.22.59',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                TOTAL      => '27635',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.59',
                        MAC              => '00:14:38:e2:12:d8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384218412) 160 days, 5:03:04.12',
                        IFINOCTETS       => '1621092006',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '24563627',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384218412',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.07.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',

            SNMPHOSTNAME => 'l2007a',
            SERIAL       => 'CNHXB68748',
            UPTIME       => '(23402944) 2 days, 17:00:29.44',
            MEMORY       => '208',
            MAC          => '00:1b:78:28:26:cb',
            IPS          => {
                IP => [
                    '128.93.22.41',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63,CIDATE 04/07/2006',
                NAME         => 'l2007a',
                SERIAL       => 'CNHXB68748',
                UPTIME       => '(23402944) 2 days, 17:00:29.44',
                MEMORY       => '208',
                MAC          => '00:1b:78:28:26:cb',
                IPS          => {
                    IP => [
                        '128.93.22.41',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '57',
            },
            PAGECOUNTERS => {
                TOTAL      => '95148',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.41',
                        MAC              => '00:1b:78:28:26:cb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384192000) 160 days, 4:58:40.00',
                        IFINOCTETS       => '2265964061',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5440024',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.63',
                        IFTYPE           => '24',
                        IFSPEED          => '1384192000',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376939592',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381281136',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.08.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',

            SNMPHOSTNAME => 'NPIEAFA59',
            SERIAL       => 'CNHXB71050',
            UPTIME       => '(22641038) 2 days, 14:53:30.38',
            MEMORY       => '208',
            MAC          => '00:14:38:ea:fa:59',
            IPS          => {
                IP => [
                    '128.93.22.123',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59,CIDATE 05/10/2005',
                NAME         => 'NPIEAFA59',
                SERIAL       => 'CNHXB71050',
                UPTIME       => '(22641038) 2 days, 14:53:30.38',
                MEMORY       => '208',
                MAC          => '00:14:38:ea:fa:59',
                IPS          => {
                    IP => [
                        '128.93.22.123',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '53',
            },
            PAGECOUNTERS => {
                TOTAL      => '104887',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.123',
                        MAC              => '00:14:38:ea:fa:59',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1384170484) 160 days, 4:55:04.84',
                        IFINOCTETS       => '1860424481',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '87024832',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.28.59',
                        IFTYPE           => '24',
                        IFSPEED          => '1384170124',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1) 0:00:00.01',
                        IFINOCTETS       => '1376931336',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1381271536',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250.09.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19,CIDATE 12/17/2008',

            SNMPHOSTNAME => 'NPIEA8E82',
            SERIAL       => 'CNHXJ45092',
            UPTIME       => '(1097769844) 127 days, 1:21:38.44',
            MEMORY       => '208',
            MAC          => '00:23:7d:81:22:f7',
            IPS          => {
                IP => [
                    '128.93.10.59',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19,CIDATE 12/17/2008',
                NAME         => 'NPIEA8E82',
                SERIAL       => 'CNHXJ45092',
                UPTIME       => '(1097769844) 127 days, 1:21:38.44',
                MEMORY       => '208',
                MAC          => '00:23:7d:81:22:f7',
                IPS          => {
                    IP => [
                        '128.93.10.59',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '81',
            },
            PAGECOUNTERS => {
                TOTAL      => '41756',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.19',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.10.59',
                        MAC              => '00:23:7d:81:22:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2163459797',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232877851',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_4250dtn.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp LaserJet 4250',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25,CIDATE 01/09/2012',

            SNMPHOSTNAME => 'L3000A',
            SERIAL       => 'CNHXC65951',
            UPTIME       => '(2286542) 6:21:05.42',
            MEMORY       => '208',
            MAC          => '00:14:38:e2:12:5f',
            IPS          => {
                IP => [
                    '128.93.22.79',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp LaserJet 4250',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25,CIDATE 01/09/2012',
                NAME         => 'L3000A',
                SERIAL       => 'CNHXC65951',
                UPTIME       => '(2286542) 6:21:05.42',
                MEMORY       => '208',
                MAC          => '00:14:38:e2:12:5f',
                IPS          => {
                    IP => [
                        '128.93.22.79',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '86',
            },
            PAGECOUNTERS => {
                TOTAL      => '30844',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD128,EEPROM V.33.25',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '128.93.22.79',
                        MAC              => '00:14:38:e2:12:5f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '680237212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2461952',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_500.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 500 color M551',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114,CIDATE 11/17/2011',

            SNMPHOSTNAME => 'NPI419F6E',
            SERIAL       => 'SE00V4T',
            MAC          => '2c:76:8a:41:9f:6e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 500 color M551',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114,CIDATE 11/17/2011',
                NAME         => 'NPI419F6E',
                SERIAL       => 'SE00V4T',
                MAC          => '2c:76:8a:41:9f:6e',
            },
            PAGECOUNTERS => {
                TOTAL      => '8514',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251103114',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '2c:76:8a:41:9f:6e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143357783',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9194670',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_5550.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'hp color LaserJet 5550 ',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',

            SNMPHOSTNAME => 'IDD116',
            SERIAL       => 'JPSV9B0GCX',
            MAC          => '00:1b:78:f0:f4:47',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'hp color LaserJet 5550 ',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13,CIDATE 08/11/2005',
                NAME         => 'IDD116',
                SERIAL       => 'JPSV9B0GCX',
                MAC          => '00:1b:78:f0:f4:47',
            },
            PAGECOUNTERS => {
                TOTAL      => '194821',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:f0:f4:47',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '188114366',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3722494',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM V.29.11,JETDIRECT,JD115,EEPROM V.29.13',
                        IFTYPE           => '24',
                        IFSPEED          => '2149727364',
                        IFMTU            => '32768',
                        IFLASTCHANGE     => '(2148908512) 248 days, 17:11:25.12',
                        IFINOCTETS       => '8',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_600.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 600 M603',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',

            SNMPHOSTNAME => 'lj1',
            SERIAL       => 'CNBVD3D0HH',
            MAC          => 'e8:39:35:90:92:1f',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj1',
                SERIAL       => 'CNBVD3D0HH',
                MAC          => 'e8:39:35:90:92:1f',
            },
            PAGECOUNTERS => {
                TOTAL      => '26784',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:92:1f',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2054925461',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '15908767',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_600.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet 600 M603',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',

            SNMPHOSTNAME => 'lj2',
            SERIAL       => 'TD031GM',
            MAC          => 'e8:39:35:90:22:ac',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet 600 M603',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008,CIDATE 11/30/2011',
                NAME         => 'lj2',
                SERIAL       => 'TD031GM',
                MAC          => 'e8:39:35:90:22:ac',
            },
            PAGECOUNTERS => {
                TOTAL      => '51894',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD149,EEPROM V50251131008',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => 'e8:39:35:90:22:ac',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '421318194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3953117',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM1312nfi_MFP.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CM1312nfi MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNB885QNXP,FN:NL106CH,SVCID:18334,PID:HP Color LaserJet CM1312nfi MFP',

            SNMPHOSTNAME => 'NPI271E90',
            LOCATION     => 'HP Color LaserJet CM1312nfi MFP',
            SERIAL       => 'CNB885QNXP',
            MAC          => '00:1f:29:27:1e:90',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CM1312nfi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNB885QNXP,FN:NL106CH,SVCID:18334,PID:HP Color LaserJet CM1312nfi MFP',
                NAME         => 'NPI271E90',
                LOCATION     => 'HP Color LaserJet CM1312nfi MFP',
                SERIAL       => 'CNB885QNXP',
                MAC          => '00:1f:29:27:1e:90',
            },
            PAGECOUNTERS => {
                TOTAL      => '20179',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9886098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '9684604',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:27:1e:90',
                        IFLASTCHANGE     => '(517) 0:00:05.17',
                        IFINOCTETS       => '16842599',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '849706',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM1415fn.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet CM1415fn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNF8BC11FK,FN:QD30T49,SVCID:21055,PID:HP LaserJet CM1415fn',

            SNMPHOSTNAME => 'B536-lwc237-Fax',
            SERIAL       => 'CNF8BC11FK',
            MAC          => '68:b5:99:ad:61:8e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet CM1415fn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNF8BC11FK,FN:QD30T49,SVCID:21055,PID:HP LaserJet CM1415fn',
                NAME         => 'B536-lwc237-Fax',
                SERIAL       => 'CNF8BC11FK',
                MAC          => '68:b5:99:ad:61:8e',
            },
            PAGECOUNTERS => {
                TOTAL      => '5480',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '143008520',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142942976',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '68:b5:99:ad:61:8e',
                        IFLASTCHANGE     => '(364754) 1:00:47.54',
                        IFINOCTETS       => '71548687',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '356768881',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CM2320fxi MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',

            SNMPHOSTNAME => 'NPI7F5D71',
            LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            SERIAL       => 'CNFN9BYG41',
            MAC          => '00:23:7d:7f:5d:71',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNFN9BYG41',
                MAC          => '00:23:7d:7f:5d:71',
            },
            PAGECOUNTERS => {
                TOTAL      => '25632',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '368171197',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '366212613',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(512) 0:00:05.12',
                        IFINOCTETS       => '293534493',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '39257355',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CM2320fxi MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',

            SNMPHOSTNAME => 'NPI7F5D71',
            LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            SERIAL       => 'CNFN9BYG41',
            MAC          => '00:23:7d:7f:5d:71',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFN9BYG41,FN:NN407PC,SVCID:19339,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI7F5D71',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNFN9BYG41',
                MAC          => '00:23:7d:7f:5d:71',
            },
            PAGECOUNTERS => {
                TOTAL      => '21862',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '784368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '742026',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:7f:5d:71',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '454091',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '175629',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320fxi_MFP.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CM2320fxi MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNDN99YG0D,FN:NN40AH0,SVCID:19312,PID:HP Color LaserJet CM2320fxi MFP',

            SNMPHOSTNAME => 'NPI828833',
            LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
            SERIAL       => 'CNDN99YG0D',
            MAC          => '00:23:7d:82:88:33',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CM2320fxi MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNDN99YG0D,FN:NN40AH0,SVCID:19312,PID:HP Color LaserJet CM2320fxi MFP',
                NAME         => 'NPI828833',
                LOCATION     => 'HP Color LaserJet CM2320fxi MFP',
                SERIAL       => 'CNDN99YG0D',
                MAC          => '00:23:7d:82:88:33',
            },
            PAGECOUNTERS => {
                TOTAL      => '7308',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '254579996',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '254171744',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:82:88:33',
                        IFLASTCHANGE     => '(511) 0:00:05.11',
                        IFINOCTETS       => '342647146',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '73067033',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CM2320nf_MFP.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CM2320nf MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFTBDZ0FN,FN:PT60J59,SVCID:21046,PID:HP Color LaserJet CM2320nf MFP',

            SNMPHOSTNAME => 'NPIB302A7',
            LOCATION     => 'HP Color LaserJet CM2320nf MFP',
            SERIAL       => 'CNFTBDZ0FN',
            MAC          => '3c:4a:92:b3:02:a7',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CM2320nf MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNFTBDZ0FN,FN:PT60J59,SVCID:21046,PID:HP Color LaserJet CM2320nf MFP',
                NAME         => 'NPIB302A7',
                LOCATION     => 'HP Color LaserJet CM2320nf MFP',
                SERIAL       => 'CNFTBDZ0FN',
                MAC          => '3c:4a:92:b3:02:a7',
            },
            PAGECOUNTERS => {
                TOTAL      => '930',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '447698759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '447698281',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:b3:02:a7',
                        IFLASTCHANGE     => '(609) 0:00:06.09',
                        IFINOCTETS       => '66621082',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2067624',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP1025nw.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet CP1025nw',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT',

            SNMPHOSTNAME => 'NPIA6032E',
            LOCATION     => ' ',
            CONTACT      => ' ',
            MAC          => '78:e7:d1:a6:03:2e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet CP1025nw',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'NPIA6032E',
                LOCATION     => ' ',
                CONTACT      => ' ',
                MAC          => '78:e7:d1:a6:03:2e',
            },
            PAGECOUNTERS => {
                TOTAL      => '402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:e7:d1:a6:03:2e',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '33595273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1357116',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025dn.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCSF01053,FN:MB01ZGH,SVCID:18347,PID:HP Color LaserJet CP2025dn',

            SNMPHOSTNAME => 'NPI2AD743',
            LOCATION     => 'HP Color LaserJet CP2025dn',
            SERIAL       => 'CNCSF01053',
            MAC          => '00:1f:29:2a:d7:43',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCSF01053,FN:MB01ZGH,SVCID:18347,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPI2AD743',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNCSF01053',
                MAC          => '00:1f:29:2a:d7:43',
            },
            PAGECOUNTERS => {
                TOTAL      => '31747',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '803165203',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '801066149',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:2a:d7:43',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '575687995',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8880062',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025dn.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS437790,FN:MB27295,SVCID:22039,PID:HP Color LaserJet CP2025dn',

            SNMPHOSTNAME => 'NPIC3D5FF',
            LOCATION     => 'HP Color LaserJet CP2025dn',
            SERIAL       => 'CNHS437790',
            MAC          => 'b4:99:ba:c3:d5:ff',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHS437790,FN:MB27295,SVCID:22039,PID:HP Color LaserJet CP2025dn',
                NAME         => 'NPIC3D5FF',
                LOCATION     => 'HP Color LaserJet CP2025dn',
                SERIAL       => 'CNHS437790',
                MAC          => 'b4:99:ba:c3:d5:ff',
            },
            PAGECOUNTERS => {
                TOTAL      => '8699',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '392477023',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '416180804',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'b4:99:ba:c3:d5:ff',
                        IFLASTCHANGE     => '(706) 0:00:07.06',
                        IFINOCTETS       => '247854787',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '17527357',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSP65440,FN:MB303HX,SVCID:21236,PID:HP Color LaserJet CP2025n',

            SNMPHOSTNAME => 'NPI117008',
            LOCATION     => 'HP Color LaserJet CP2025n',
            SERIAL       => 'CNHSP65440',
            MAC          => '2c:27:d7:11:70:08',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSP65440,FN:MB303HX,SVCID:21236,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI117008',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNHSP65440',
                MAC          => '2c:27:d7:11:70:08',
            },
            PAGECOUNTERS => {
                TOTAL      => '3454',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3229787810',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3228564584',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:11:70:08',
                        IFLASTCHANGE     => '(278502387) 32 days, 5:37:03.87',
                        IFINOCTETS       => '3962571861',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '80583527',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',

            SNMPHOSTNAME => 'NPI84C481',
            LOCATION     => 'HP Color LaserJet CP2025n',
            SERIAL       => 'CNCS404796',
            MAC          => '00:21:5a:84:c4:81',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS404796',
                MAC          => '00:21:5a:84:c4:81',
            },
            PAGECOUNTERS => {
                TOTAL      => '14722',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3603654689',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3603294840',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '1951645626',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42454155',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',

            SNMPHOSTNAME => 'NPI84C481',
            LOCATION     => 'HP Color LaserJet CP2025n',
            SERIAL       => 'CNCS404796',
            MAC          => '00:21:5a:84:c4:81',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS404796,FN:MB04VB0,SVCID:19316,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI84C481',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS404796',
                MAC          => '00:21:5a:84:c4:81',
            },
            PAGECOUNTERS => {
                TOTAL      => '16627',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3616912763',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3616622374',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:84:c4:81',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '2925586477',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '50103223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS212370,FN:MB03SY2,SVCID:19127,PID:HP Color LaserJet CP2025n',

            SNMPHOSTNAME => 'NPI81E3A7',
            LOCATION     => 'HP Color LaserJet CP2025n',
            SERIAL       => 'CNCS212370',
            MAC          => '00:21:5a:81:e3:a7',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNCS212370,FN:MB03SY2,SVCID:19127,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI81E3A7',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNCS212370',
                MAC          => '00:21:5a:81:e3:a7',
            },
            PAGECOUNTERS => {
                TOTAL      => '21956',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '380316273',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380139218',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:81:e3:a7',
                        IFLASTCHANGE     => '(605) 0:00:06.05',
                        IFINOCTETS       => '112601870',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3560969',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP2025n.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP2025n',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSN58554,FN:MB258FW,SVCID:21095,PID:HP Color LaserJet CP2025n',

            SNMPHOSTNAME => 'NPI8FA1DD',
            LOCATION     => 'HP Color LaserJet CP2025n',
            SERIAL       => 'CNHSN58554',
            MAC          => '78:ac:c0:8f:a1:dd',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP2025n',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNHSN58554,FN:MB258FW,SVCID:21095,PID:HP Color LaserJet CP2025n',
                NAME         => 'NPI8FA1DD',
                LOCATION     => 'HP Color LaserJet CP2025n',
                SERIAL       => 'CNHSN58554',
                MAC          => '78:ac:c0:8f:a1:dd',
            },
            PAGECOUNTERS => {
                TOTAL      => '9601',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8463955',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8809286',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '78:ac:c0:8f:a1:dd',
                        IFLASTCHANGE     => '(505) 0:00:05.05',
                        IFINOCTETS       => '4563808',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '529251',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP3525',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67,CIDATE 06/17/2008',

            SNMPHOSTNAME => 'NPI85A57D',
            SERIAL       => 'CNCT98DGJY',
            MAC          => '00:23:7d:85:a5:7d',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67,CIDATE 06/17/2008',
                NAME         => 'NPI85A57D',
                SERIAL       => 'CNCT98DGJY',
                MAC          => '00:23:7d:85:a5:7d',
            },
            PAGECOUNTERS => {
                TOTAL      => '16740',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.67',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:85:a5:7d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '695289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '535873',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP3525',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',

            SNMPHOSTNAME => 'Corinne',
            SERIAL       => 'CNCTB9PHWG',
            MAC          => 'd4:85:64:3d:ac:2e',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'Corinne',
                SERIAL       => 'CNCTB9PHWG',
                MAC          => 'd4:85:64:3d:ac:2e',
            },
            PAGECOUNTERS => {
                TOTAL      => '19183',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'd4:85:64:3d:ac:2e',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '9335102',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '762709',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP3525.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP3525',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',

            SNMPHOSTNAME => 'nerium',
            SERIAL       => 'CBAFTBDG66',
            UPTIME       => '(457735283) 52 days, 23:29:12.83',
            MEMORY       => '384',
            MAC          => 'd4:85:64:40:4d:93',
            IPS          => {
                IP => [
                    '192.168.1.41',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP3525',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80,CIDATE 11/03/2009',
                NAME         => 'nerium',
                SERIAL       => 'CBAFTBDG66',
                UPTIME       => '(457735283) 52 days, 23:29:12.83',
                MEMORY       => '384',
                MAC          => 'd4:85:64:40:4d:93',
                IPS          => {
                    IP => [
                        '192.168.1.41',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '16808',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD146,EEPROM V.38.80',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.1.41',
                        MAC              => 'd4:85:64:40:4d:93',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3638074715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '167843585',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_CP4520.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP Color LaserJet CP4520 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99,CIDATE 11/26/2010',

            SNMPHOSTNAME => 'NPI10DB2C',
            SERIAL       => 'JPCTC8M0LJ',
            MAC          => '2c:27:d7:10:db:2c',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP Color LaserJet CP4520 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99,CIDATE 11/26/2010',
                NAME         => 'NPI10DB2C',
                SERIAL       => 'JPCTC8M0LJ',
                MAC          => '2c:27:d7:10:db:2c',
            },
            PAGECOUNTERS => {
                TOTAL      => '14604',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD145,EEPROM V.38.99',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '2c:27:d7:10:db:2c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2342375615',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '43069516',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_M1217nfw.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet Professional M1217nfw MFP',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT',

            SNMPHOSTNAME => 'l2407a',
            CONTACT      => ' ',
            UPTIME       => '(261657629) 30 days, 6:49:36.29',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '128.93.22.58',
                    '192.168.223.1',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet Professional M1217nfw MFP',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'l2407a',
                CONTACT      => ' ',
                UPTIME       => '(261657629) 30 days, 6:49:36.29',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '128.93.22.58',
                        '192.168.223.1',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '919',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'NetDrvr',
                        IFDESCR          => 'NetDrvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.58',
                        MAC              => '10:60:4b:19:a6:51',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(380) 0:00:03.80',
                        IFINOCTETS       => '1332770858',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '59043597',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'uAP_drvr',
                        IFDESCR          => 'uAP_drvr',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '192.168.223.1',
                        MAC              => '84:4b:f5:84:07:a2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(28) 0:00:00.28',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '1',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI83EC85',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW898043',
            MAC          => '00:21:5a:83:ec:85',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW898043',
                MAC          => '00:21:5a:83:ec:85',
            },
            PAGECOUNTERS => {
                TOTAL      => '36596',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1081446700',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1081457348',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '2857680319',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '398641223',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7BQ7BS,FN:JK44SRD,SVCID:18021,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI13EE63',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW7BQ7BS',
            MAC          => '00:1b:78:13:ee:63',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7BQ7BS,FN:JK44SRD,SVCID:18021,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI13EE63',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW7BQ7BS',
                MAC          => '00:1b:78:13:ee:63',
            },
            PAGECOUNTERS => {
                TOTAL      => '25333',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '31512183',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '31512183',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1b:78:13:ee:63',
                        IFLASTCHANGE     => '(699) 0:00:06.99',
                        IFINOCTETS       => '91830571',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1268509',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI83EC85',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW898043',
            MAC          => '00:21:5a:83:ec:85',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW898043,FN:JK5FJN3,SVCID:18327,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI83EC85',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW898043',
                MAC          => '00:21:5a:83:ec:85',
            },
            PAGECOUNTERS => {
                TOTAL      => '36301',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '340834617',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '340834617',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:83:ec:85',
                        IFLASTCHANGE     => '(799) 0:00:07.99',
                        IFINOCTETS       => '141025151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1679896',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW87R2XX,FN:JK5BJMX,SVCID:00000,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI2BAB3D',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW87R2XX',
            UPTIME       => '(200046302) 23 days, 3:41:03.02',
            MEMORY       => '95',
            MAC          => '00:1f:29:2b:ab:3d',
            IPS          => {
                IP => [
                    '128.93.22.213',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW87R2XX,FN:JK5BJMX,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI2BAB3D',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW87R2XX',
                UPTIME       => '(200046302) 23 days, 3:41:03.02',
                MEMORY       => '95',
                MAC          => '00:1f:29:2b:ab:3d',
                IPS          => {
                    IP => [
                        '128.93.22.213',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '129336',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '578298200',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '578302190',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.213',
                        MAC              => '00:1f:29:2b:ab:3d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '1659255782',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '33116153',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW3R8,FN:JK151HQ,SVCID:00000,PID:l0713a',

            SNMPHOSTNAME => 'NPI8CA86F',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW6DW3R8',
            UPTIME       => '(180819074) 20 days, 22:16:30.74',
            MEMORY       => '159',
            MAC          => '00:17:08:8c:a8:6f',
            IPS          => {
                IP => [
                    '128.93.22.14',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW3R8,FN:JK151HQ,SVCID:00000,PID:l0713a',
                NAME         => 'NPI8CA86F',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW6DW3R8',
                UPTIME       => '(180819074) 20 days, 22:16:30.74',
                MEMORY       => '159',
                MAC          => '00:17:08:8c:a8:6f',
                IPS          => {
                    IP => [
                        '128.93.22.14',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '45078',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '513466755',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '513471955',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.14',
                        MAC              => '00:17:08:8c:a8:6f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1603) 0:00:16.03',
                        IFINOCTETS       => '4284098790',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '42529924',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.06.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7171V8,FN:JK15ESY,SVCID:00000,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI8E6910',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW7171V8',
            UPTIME       => '(138093688) 15 days, 23:35:36.88',
            MEMORY       => '159',
            MAC          => '00:17:08:8e:69:10',
            IPS          => {
                IP => [
                    '128.93.22.22',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW7171V8,FN:JK15ESY,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI8E6910',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW7171V8',
                UPTIME       => '(138093688) 15 days, 23:35:36.88',
                MEMORY       => '159',
                MAC          => '00:17:08:8e:69:10',
                IPS          => {
                    IP => [
                        '128.93.22.22',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '16610',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '387932396',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '387939313',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.22',
                        MAC              => '00:17:08:8e:69:10',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1601) 0:00:16.01',
                        IFINOCTETS       => '84810818',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '18961108',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.07.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW37G,FN:JK15170,SVCID:00000,PID:l2405a',

            SNMPHOSTNAME => 'NPI8C980D',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW6DW37G',
            UPTIME       => '(71190989) 8 days, 5:45:09.89',
            MEMORY       => '159',
            MAC          => '00:17:08:8c:98:0d',
            IPS          => {
                IP => [
                    '128.93.22.122',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW6DW37G,FN:JK15170,SVCID:00000,PID:l2405a',
                NAME         => 'NPI8C980D',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW6DW37G',
                UPTIME       => '(71190989) 8 days, 5:45:09.89',
                MEMORY       => '159',
                MAC          => '00:17:08:8c:98:0d',
                IPS          => {
                    IP => [
                        '128.93.22.122',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '5943',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '199794226',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '199797652',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.122',
                        MAC              => '00:17:08:8c:98:0d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1702) 0:00:17.02',
                        IFINOCTETS       => '1621136760',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4321189',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.08.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW76W0B8,FN:JK62250,SVCID:00000,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI7954CF',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW76W0B8',
            UPTIME       => '(59927764) 6 days, 22:27:57.64',
            MEMORY       => '95',
            MAC          => '00:23:7d:79:54:cf',
            IPS          => {
                IP => [
                    '128.93.22.220',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW76W0B8,FN:JK62250,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI7954CF',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW76W0B8',
                UPTIME       => '(59927764) 6 days, 22:27:57.64',
                MEMORY       => '95',
                MAC          => '00:23:7d:79:54:cf',
                IPS          => {
                    IP => [
                        '128.93.22.220',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '96192',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '170980525',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '170990271',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.220',
                        MAC              => '00:23:7d:79:54:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '593649816',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5505762',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.09.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW74K7GP,FN:JK306JC,SVCID:00000,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI156F54',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW74K7GP',
            UPTIME       => '(2901531) 8:03:35.31',
            MEMORY       => '95',
            MAC          => '00:1a:4b:15:6f:54',
            IPS          => {
                IP => [
                    '128.93.22.197',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW74K7GP,FN:JK306JC,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI156F54',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW74K7GP',
                UPTIME       => '(2901531) 8:03:35.31',
                MEMORY       => '95',
                MAC          => '00:1a:4b:15:6f:54',
                IPS          => {
                    IP => [
                        '128.93.22.197',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '30412',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8480431',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8482160',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.197',
                        MAC              => '00:1a:4b:15:6f:54',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '371591459',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '581750',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2015.10.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2015 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW84P402,FN:JK54RBG,SVCID:00000,PID:HP LaserJet P2015 Series',

            SNMPHOSTNAME => 'NPI166E31',
            LOCATION     => 'Boise, ID, USA',
            SERIAL       => 'CNBW84P402',
            UPTIME       => '(2821021) 7:50:10.21',
            MEMORY       => '95',
            MAC          => '00:1f:29:16:6e:31',
            IPS          => {
                IP => [
                    '128.93.22.233',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2015 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,SN:CNBW84P402,FN:JK54RBG,SVCID:00000,PID:HP LaserJet P2015 Series',
                NAME         => 'NPI166E31',
                LOCATION     => 'Boise, ID, USA',
                SERIAL       => 'CNBW84P402',
                UPTIME       => '(2821021) 7:50:10.21',
                MEMORY       => '95',
                MAC          => '00:1f:29:16:6e:31',
                IPS          => {
                    IP => [
                        '128.93.22.233',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '8880',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'LOOPBACK',
                        IFDESCR          => 'LOOPBACK',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '8515210',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '8523142',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Ethernet',
                        IFDESCR          => 'Ethernet',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.233',
                        MAC              => '00:1f:29:16:6e:31',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1600) 0:00:16.00',
                        IFINOCTETS       => '339332088',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '497134',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',

            SNMPHOSTNAME => 'NPI7E0932',
            SERIAL       => 'CNCKF02617',
            MAC          => '00:21:5a:7e:09:32',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',
                NAME         => 'NPI7E0932',
                SERIAL       => 'CNCKF02617',
                MAC          => '00:21:5a:7e:09:32',
            },
            PAGECOUNTERS => {
                TOTAL      => '30965',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7e:09:32',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2219679339',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '123773898',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',

            SNMPHOSTNAME => 'NPI8DDF43',
            SERIAL       => 'CNCKG11705',
            MAC          => '00:21:5a:8d:df:43',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07,CIDATE 06/11/2008',
                NAME         => 'NPI8DDF43',
                SERIAL       => 'CNCKG11705',
                MAC          => '00:21:5a:8d:df:43',
            },
            PAGECOUNTERS => {
                TOTAL      => '36105',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.07',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:df:43',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '200058917',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1869715',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPI830993',
            SERIAL       => 'CNCKC22953',
            MAC          => '00:23:7d:83:09:93',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI830993',
                SERIAL       => 'CNCKC22953',
                MAC          => '00:23:7d:83:09:93',
            },
            PAGECOUNTERS => {
                TOTAL      => '3837',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:09:93',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '683787528',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4718265',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPI83E8D5',
            SERIAL       => 'CNCKC22950',
            MAC          => '00:23:7d:83:e8:d5',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI83E8D5',
                SERIAL       => 'CNCKC22950',
                MAC          => '00:23:7d:83:e8:d5',
            },
            PAGECOUNTERS => {
                TOTAL      => '11057',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:83:e8:d5',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3240054009',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '6629940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPI886B5B',
            SERIAL       => 'CNCKC40132',
            MAC          => '00:23:7d:88:6b:5b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI886B5B',
                SERIAL       => 'CNCKC40132',
                MAC          => '00:23:7d:88:6b:5b',
            },
            PAGECOUNTERS => {
                TOTAL      => '19402',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '226525511',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5925070',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.06.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPI886B5B',
            SERIAL       => 'CNCKC40132',
            MAC          => '00:23:7d:88:6b:5b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPI886B5B',
                SERIAL       => 'CNCKC40132',
                MAC          => '00:23:7d:88:6b:5b',
            },
            PAGECOUNTERS => {
                TOTAL      => '17861',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:23:7d:88:6b:5b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '561048360',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '14426521',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.07.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',

            SNMPHOSTNAME => 'NPI80BDD9',
            SERIAL       => 'CNC1712027',
            MAC          => '1c:c1:de:80:bd:d9',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPI80BDD9',
                SERIAL       => 'CNC1712027',
                MAC          => '1c:c1:de:80:bd:d9',
            },
            PAGECOUNTERS => {
                TOTAL      => '5696',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:80:bd:d9',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1574260753',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '44021940',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.08.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',

            SNMPHOSTNAME => 'NPICB3982',
            SERIAL       => 'CNCGC12715',
            MAC          => '1c:c1:de:cb:39:82',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPICB3982',
                SERIAL       => 'CNCGC12715',
                MAC          => '1c:c1:de:cb:39:82',
            },
            PAGECOUNTERS => {
                TOTAL      => '26922',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:39:82',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '37368958',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '218905',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.09.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',

            SNMPHOSTNAME => 'NPIC08394',
            SERIAL       => 'CNCGB63494',
            MAC          => '3c:4a:92:c0:83:94',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPIC08394',
                SERIAL       => 'CNCGB63494',
                MAC          => '3c:4a:92:c0:83:94',
            },
            PAGECOUNTERS => {
                TOTAL      => '4047',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '3c:4a:92:c0:83:94',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1911576981',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '48854545',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.10.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',

            SNMPHOSTNAME => 'NPICBD8B1',
            SERIAL       => 'CNCGC10444',
            MAC          => '1c:c1:de:cb:d8:b1',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPICBD8B1',
                SERIAL       => 'CNCGC10444',
                MAC          => '1c:c1:de:cb:d8:b1',
            },
            PAGECOUNTERS => {
                TOTAL      => '4944',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:cb:d8:b1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2220813285',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '51880468',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.11.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 07/12/2010',

            SNMPHOSTNAME => 'NPIB979A2',
            SERIAL       => 'CNC1C04989',
            MAC          => '08:2e:5f:b9:79:a2',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 07/12/2010',
                NAME         => 'NPIB979A2',
                SERIAL       => 'CNC1C04989',
                MAC          => '08:2e:5f:b9:79:a2',
            },
            PAGECOUNTERS => {
                TOTAL      => '4339',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '08:2e:5f:b9:79:a2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '861281403',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4972936',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.12.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',

            SNMPHOSTNAME => 'NPIC93D6D',
            SERIAL       => 'CNC1822002',
            MAC          => '1c:c1:de:c9:3d:6d',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12,CIDATE 02/07/2010',
                NAME         => 'NPIC93D6D',
                SERIAL       => 'CNC1822002',
                MAC          => '1c:c1:de:c9:3d:6d',
            },
            PAGECOUNTERS => {
                TOTAL      => '89242',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.12',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '1c:c1:de:c9:3d:6d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '20375229',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '380785',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.13.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'l1019a',
            SERIAL       => 'CNCKH91101',
            UPTIME       => '(20267234) 2 days, 8:17:52.34',
            MEMORY       => '128',
            MAC          => '00:25:b3:eb:ea:20',
            IPS          => {
                IP => [
                    '128.93.22.7',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'l1019a',
                SERIAL       => 'CNCKH91101',
                UPTIME       => '(20267234) 2 days, 8:17:52.34',
                MEMORY       => '128',
                MAC          => '00:25:b3:eb:ea:20',
                IPS          => {
                    IP => [
                        '128.93.22.7',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '3515',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.7',
                        MAC              => '00:25:b3:eb:ea:20',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1045360896',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '66590530',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.14.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPIEB8A8F',
            SERIAL       => 'CNCKH91104',
            UPTIME       => '(3967795) 11:01:17.95',
            MEMORY       => '128',
            MAC          => '00:25:b3:eb:8a:8f',
            IPS          => {
                IP => [
                    '128.93.22.238',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPIEB8A8F',
                SERIAL       => 'CNCKH91104',
                UPTIME       => '(3967795) 11:01:17.95',
                MEMORY       => '128',
                MAC          => '00:25:b3:eb:8a:8f',
                IPS          => {
                    IP => [
                        '128.93.22.238',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '11344',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.238',
                        MAC              => '00:25:b3:eb:8a:8f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2831933549',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92564533',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.15.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'l1a220a',
            SERIAL       => 'CNCKH91109',
            UPTIME       => '(19326743) 2 days, 5:41:07.43',
            MEMORY       => '128',
            MAC          => '00:25:b3:eb:7a:c7',
            IPS          => {
                IP => [
                    '128.93.22.113',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'l1a220a',
                SERIAL       => 'CNCKH91109',
                UPTIME       => '(19326743) 2 days, 5:41:07.43',
                MEMORY       => '128',
                MAC          => '00:25:b3:eb:7a:c7',
                IPS          => {
                    IP => [
                        '128.93.22.113',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '22937',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.113',
                        MAC              => '00:25:b3:eb:7a:c7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2309963329',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '21666979',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P2055dn.16.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P2055dn',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',

            SNMPHOSTNAME => 'NPIEB4B44',
            SERIAL       => 'CNCKH91103',
            UPTIME       => '(22020083) 2 days, 13:10:00.83',
            MEMORY       => '128',
            MAC          => '00:25:b3:eb:4b:44',
            IPS          => {
                IP => [
                    '128.93.22.57',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P2055dn',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11,CIDATE 04/17/2009',
                NAME         => 'NPIEB4B44',
                SERIAL       => 'CNCKH91103',
                UPTIME       => '(22020083) 2 days, 13:10:00.83',
                MEMORY       => '128',
                MAC          => '00:25:b3:eb:4b:44',
                IPS          => {
                    IP => [
                        '128.93.22.57',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '4878',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD137,EEPROM V.37.11',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.57',
                        MAC              => '00:25:b3:eb:4b:44',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3419623381',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '65027106',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI7A5E2D',
            SERIAL       => 'CNH1R06635',
            MAC          => '00:21:5a:7a:5e:2d',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI7A5E2D',
                SERIAL       => 'CNH1R06635',
                MAC          => '00:21:5a:7a:5e:2d',
            },
            PAGECOUNTERS => {
                TOTAL      => '20979',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:7a:5e:2d',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '145086685',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2444081',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI91B509',
            SERIAL       => 'CNFW6DG38S',
            UPTIME       => '(22362085) 2 days, 14:07:00.85',
            MEMORY       => '320',
            MAC          => '00:17:08:91:b5:09',
            IPS          => {
                IP => [
                    '128.93.22.92',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI91B509',
                SERIAL       => 'CNFW6DG38S',
                UPTIME       => '(22362085) 2 days, 14:07:00.85',
                MEMORY       => '320',
                MAC          => '00:17:08:91:b5:09',
                IPS          => {
                    IP => [
                        '128.93.22.92',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '150',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.92',
                        MAC              => '00:17:08:91:b5:09',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4178582359',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '115945591',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI947D4C',
            SERIAL       => 'CNFW6DF0WL',
            UPTIME       => '(21658724) 2 days, 12:09:47.24',
            MEMORY       => '320',
            MAC          => '00:17:a4:94:7d:4c',
            IPS          => {
                IP => [
                    '128.93.5.49',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI947D4C',
                SERIAL       => 'CNFW6DF0WL',
                UPTIME       => '(21658724) 2 days, 12:09:47.24',
                MEMORY       => '320',
                MAC          => '00:17:a4:94:7d:4c',
                IPS          => {
                    IP => [
                        '128.93.5.49',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '13322',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.5.49',
                        MAC              => '00:17:a4:94:7d:4c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3089015758',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '75450885',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'L0420a',
            SERIAL       => 'CNFW6DG39Q',
            UPTIME       => '(37718618) 4 days, 8:46:26.18',
            MEMORY       => '320',
            MAC          => '00:17:a4:93:4d:9f',
            IPS          => {
                IP => [
                    '128.93.4.22',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'L0420a',
                SERIAL       => 'CNFW6DG39Q',
                UPTIME       => '(37718618) 4 days, 8:46:26.18',
                MEMORY       => '320',
                MAC          => '00:17:a4:93:4d:9f',
                IPS          => {
                    IP => [
                        '128.93.4.22',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '13193',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.4.22',
                        MAC              => '00:17:a4:93:4d:9f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2307684777',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '108781795',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'l0500a',
            SERIAL       => 'CNFW6DG38L',
            UPTIME       => '(11522734) 1 day, 8:00:27.34',
            MEMORY       => '320',
            MAC          => '00:17:08:91:95:dd',
            IPS          => {
                IP => [
                    '128.93.22.198',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l0500a',
                SERIAL       => 'CNFW6DG38L',
                UPTIME       => '(11522734) 1 day, 8:00:27.34',
                MEMORY       => '320',
                MAC          => '00:17:08:91:95:dd',
                IPS          => {
                    IP => [
                        '128.93.22.198',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '15802',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.198',
                        MAC              => '00:17:08:91:95:dd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '496490610',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7579572',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.06.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI934D69',
            SERIAL       => 'CNFW6DG3DP',
            UPTIME       => '(29663349) 3 days, 10:23:53.49',
            MEMORY       => '320',
            MAC          => '00:17:a4:93:4d:69',
            IPS          => {
                IP => [
                    '128.93.31.3',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D69',
                SERIAL       => 'CNFW6DG3DP',
                UPTIME       => '(29663349) 3 days, 10:23:53.49',
                MEMORY       => '320',
                MAC          => '00:17:a4:93:4d:69',
                IPS          => {
                    IP => [
                        '128.93.31.3',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '53058',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.31.3',
                        MAC              => '00:17:a4:93:4d:69',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2931305839',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '92945383',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.07.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI934D9C',
            SERIAL       => 'CNFW6DG37P',
            UPTIME       => '(30521576) 3 days, 12:46:55.76',
            MEMORY       => '320',
            MAC          => '00:17:a4:93:4d:9c',
            IPS          => {
                IP => [
                    '128.93.17.16',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D9C',
                SERIAL       => 'CNFW6DG37P',
                UPTIME       => '(30521576) 3 days, 12:46:55.76',
                MEMORY       => '320',
                MAC          => '00:17:a4:93:4d:9c',
                IPS          => {
                    IP => [
                        '128.93.17.16',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '130481',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.17.16',
                        MAC              => '00:17:a4:93:4d:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2225730103',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '154536764',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.08.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI917343',
            SERIAL       => 'CNFW6DG1MH',
            UPTIME       => '(33056147) 3 days, 19:49:21.47',
            MEMORY       => '320',
            MAC          => '00:17:08:91:73:43',
            IPS          => {
                IP => [
                    '128.93.18.47',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI917343',
                SERIAL       => 'CNFW6DG1MH',
                UPTIME       => '(33056147) 3 days, 19:49:21.47',
                MEMORY       => '320',
                MAC          => '00:17:08:91:73:43',
                IPS          => {
                    IP => [
                        '128.93.18.47',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '45068',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.18.47',
                        MAC              => '00:17:08:91:73:43',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4294835122',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '232767636',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.09.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'l1B220a',
            SERIAL       => 'CNFW6DG1LP',
            UPTIME       => '(31793654) 3 days, 16:18:56.54',
            MEMORY       => '320',
            MAC          => '00:17:a4:93:df:9c',
            IPS          => {
                IP => [
                    '128.93.22.102',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l1B220a',
                SERIAL       => 'CNFW6DG1LP',
                UPTIME       => '(31793654) 3 days, 16:18:56.54',
                MEMORY       => '320',
                MAC          => '00:17:a4:93:df:9c',
                IPS          => {
                    IP => [
                        '128.93.22.102',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '11075',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.102',
                        MAC              => '00:17:a4:93:df:9c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '3954235628',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '118033695',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.10.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI824876',
            SERIAL       => 'CNFW6DF0XF',
            UPTIME       => '(15263036) 1 day, 18:23:50.36',
            MEMORY       => '320',
            MAC          => '00:17:08:82:48:76',
            IPS          => {
                IP => [
                    '128.93.9.35',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI824876',
                SERIAL       => 'CNFW6DF0XF',
                UPTIME       => '(15263036) 1 day, 18:23:50.36',
                MEMORY       => '320',
                MAC          => '00:17:08:82:48:76',
                IPS          => {
                    IP => [
                        '128.93.9.35',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '17190',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.9.35',
                        MAC              => '00:17:08:82:48:76',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1478912108',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2882335238',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.11.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'NPI934D5B',
            SERIAL       => 'CNFW6DG394',
            UPTIME       => '(11824269) 1 day, 8:50:42.69',
            MEMORY       => '192',
            MAC          => '00:17:a4:93:4d:5b',
            IPS          => {
                IP => [
                    '128.93.22.13',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'NPI934D5B',
                SERIAL       => 'CNFW6DG394',
                UPTIME       => '(11824269) 1 day, 8:50:42.69',
                MEMORY       => '192',
                MAC          => '00:17:a4:93:4d:5b',
                IPS          => {
                    IP => [
                        '128.93.22.13',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '100795',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.13',
                        MAC              => '00:17:a4:93:4d:5b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1379448828',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '41043399',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.12.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60,CIDATE 03/04/2012',

            SNMPHOSTNAME => 'NPI939CBD',
            SERIAL       => 'CNFW6DG1NP',
            UPTIME       => '(745416056) 86 days, 6:36:00.56',
            MEMORY       => '320',
            MAC          => '00:17:a4:93:a7:56',
            IPS          => {
                IP => [
                    '128.93.22.111',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60,CIDATE 03/04/2012',
                NAME         => 'NPI939CBD',
                SERIAL       => 'CNFW6DG1NP',
                UPTIME       => '(745416056) 86 days, 6:36:00.56',
                MEMORY       => '320',
                MAC          => '00:17:a4:93:a7:56',
                IPS          => {
                    IP => [
                        '128.93.22.111',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '65082',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.60',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.111',
                        MAC              => '00:17:a4:93:a7:56',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '507317169',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '165546197',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3005.13.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3005',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',

            SNMPHOSTNAME => 'l2427a',
            SERIAL       => 'CNFW6DG1M8',
            UPTIME       => '(35620617) 4 days, 2:56:46.17',
            MEMORY       => '320',
            MAC          => '00:17:a4:94:a6:1f',
            IPS          => {
                IP => [
                    '128.93.22.132',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3005',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57,CIDATE 10/24/2006',
                NAME         => 'l2427a',
                SERIAL       => 'CNFW6DG1M8',
                UPTIME       => '(35620617) 4 days, 2:56:46.17',
                MEMORY       => '320',
                MAC          => '00:17:a4:94:a6:1f',
                IPS          => {
                    IP => [
                        '128.93.22.132',
                    ],
                },
            },
            PAGECOUNTERS => {
                TOTAL      => '5385',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD135,EEPROM V.33.57',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '128.93.22.132',
                        MAC              => '00:17:a4:94:a6:1f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '2818547819',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '302246316',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3010.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3010 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',

            SNMPHOSTNAME => 'NPI013B81',
            SERIAL       => 'VNBQD3C0BF',
            MAC          => '00:9c:02:01:3b:81',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',
                NAME         => 'NPI013B81',
                SERIAL       => 'VNBQD3C0BF',
                MAC          => '00:9c:02:01:3b:81',
            },
            PAGECOUNTERS => {
                TOTAL      => '15265',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '66753796',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1745120',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P3010.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P3010 Series',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',

            SNMPHOSTNAME => 'NPI013B81',
            SERIAL       => 'VNBQD3C0BF',
            MAC          => '00:9c:02:01:3b:81',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P3010 Series',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10,CIDATE 01/12/2012',
                NAME         => 'NPI013B81',
                SERIAL       => 'VNBQD3C0BF',
                MAC          => '00:9c:02:01:3b:81',
            },
            PAGECOUNTERS => {
                TOTAL      => '6386',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD148,EEPROM V.43.10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:9c:02:01:3b:81',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '985600239',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '22750126',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4014.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4014',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',

            SNMPHOSTNAME => 'NPIFFF0F2',
            SERIAL       => 'CNFX409800',
            UPTIME       => '(705273859) 81 days, 15:05:38.59',
            MEMORY       => '384',
            MAC          => '18:a9:05:ff:f0:f2',
            IPS          => {
                IP => [
                    '10.75.13.175',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4014',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIFFF0F2',
                SERIAL       => 'CNFX409800',
                UPTIME       => '(705273859) 81 days, 15:05:38.59',
                MEMORY       => '384',
                MAC          => '18:a9:05:ff:f0:f2',
                IPS          => {
                    IP => [
                        '10.75.13.175',
                    ],
                },
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '32',
            },
            PAGECOUNTERS => {
                TOTAL      => '151735',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        IP               => '10.75.13.175',
                        MAC              => '18:a9:05:ff:f0:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '1102701832',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '142816478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.01.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4015',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',

            SNMPHOSTNAME => 'LJ30000000000000000000----------',
            SERIAL       => 'CNFY417951',
            MAC          => '00:21:5a:8f:ea:2b',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'LJ30000000000000000000----------',
                SERIAL       => 'CNFY417951',
                MAC          => '00:21:5a:8f:ea:2b',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '87',
            },
            PAGECOUNTERS => {
                TOTAL      => '27320',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8f:ea:2b',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '42955297',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1263745',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.02.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4015',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',

            SNMPHOSTNAME => 'NPI8D9896',
            SERIAL       => 'CNFY409032',
            MAC          => '00:21:5a:8d:98:96',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36,CIDATE 04/10/2008',
                NAME         => 'NPI8D9896',
                SERIAL       => 'CNFY409032',
                MAC          => '00:21:5a:8d:98:96',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '61',
            },
            PAGECOUNTERS => {
                TOTAL      => '86390',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:8d:98:96',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '197354717',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '10744976',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.03.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4015',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35,CIDATE 09/18/2007',

            SNMPHOSTNAME => 'NPI22C87C',
            SERIAL       => 'CNFY213364',
            MAC          => '00:1f:29:22:c8:7c',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35,CIDATE 09/18/2007',
                NAME         => 'NPI22C87C',
                SERIAL       => 'CNFY213364',
                MAC          => '00:1f:29:22:c8:7c',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '79',
            },
            PAGECOUNTERS => {
                TOTAL      => '47319',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.35',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:1f:29:22:c8:7c',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '316207723',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '11488728',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.04.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4015',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40,CIDATE 02/24/2009',

            SNMPHOSTNAME => 'NPI9706DE',
            SERIAL       => 'CNFY183496',
            MAC          => '00:21:5a:97:06:de',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40,CIDATE 02/24/2009',
                NAME         => 'NPI9706DE',
                SERIAL       => 'CNFY183496',
                MAC          => '00:21:5a:97:06:de',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '5',
            },
            PAGECOUNTERS => {
                TOTAL      => '212761',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.40',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:97:06:de',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '267130694',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '5406422',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/LaserJet_P4015.05.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'HP LaserJet P4015',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',

            SNMPHOSTNAME => 'NPIEADBFB',
            SERIAL       => 'CNFY349204',
            MAC          => '00:25:b3:ea:db:fb',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'HP LaserJet P4015',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41,CIDATE 06/12/2009',
                NAME         => 'NPIEADBFB',
                SERIAL       => 'CNFY349204',
                MAC          => '00:25:b3:ea:db:fb',
            },
            CARTRIDGES => {
                MAINTENANCEKIT   => '0',
            },
            PAGECOUNTERS => {
                TOTAL      => '266350',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '1536',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFDESCR          => 'HP ETHERNET MULTI-ENVIRONMENT,ROM none,JETDIRECT,JD143,EEPROM V.36.41',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:25:b3:ea:db:fb',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '4240914294',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '37809478',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/OfficeJet_Pro_8600.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'Officejet Pro 8600 N911g',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT',

            SNMPHOSTNAME => 'HP8C0C51',
            MAC          => 'ec:9a:74:8c:0c:51',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'Officejet Pro 8600 N911g',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP8C0C51',
                MAC          => 'ec:9a:74:8c:0c:51',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => 'ec:9a:74:8c:0c:51',
                        IFLASTCHANGE     => '(655) 0:00:06.55',
                        IFINOCTETS       => '22514039',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4313921',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/OfficeJet_Pro_K5400.walk' => [
        {
            TYPE         => 'PRINTER',
            MANUFACTURER => 'Hewlett-Packard',
            DESCRIPTION  => 'HP ETHERNET MULTI-ENVIRONMENT',

            SNMPHOSTNAME => 'HP560332',
            MAC          => '00:21:5a:56:03:32',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'PRINTER',
                MANUFACTURER => 'Hewlett-Packard',
                COMMENTS     => 'HP ETHERNET MULTI-ENVIRONMENT',
                NAME         => 'HP560332',
                MAC          => '00:21:5a:56:03:32',
            },
            CARTRIDGES => {
                CARTRIDGEBLACK   => '9',
                CARTRIDGECYAN    => '290',
                CARTRIDGEMAGENTA => '20',
                CARTRIDGEYELLOW  => '6',
            },
            PAGECOUNTERS => {
                TOTAL      => '10947',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'Eth0',
                        IFDESCR          => 'Eth0',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:5a:56:03:32',
                        IFLASTCHANGE     => '(18259) 0:03:02.59',
                        IFINOCTETS       => '201446672',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2340353',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J4899B.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'ProCurve 2650 (J4899B)',
            DESCRIPTION  => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',

            LOCATION     => 'GN1 NORD',
            SERIAL       => 'CN638SD146',
            FIRMWARE     => 'H.08.02',
            UPTIME       => '(326711768) 37 days, 19:31:57.68',
            MAC          => '00:18:fe:aa:a9:80',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'ProCurve 2650 (J4899B)',
                COMMENTS     => 'ProCurve J4899B Switch 2650, revision H.10.108, ROM H.08.02 (/sw/code/build/fish)',
                LOCATION     => 'GN1 NORD',
                SERIAL       => 'CN638SD146',
                FIRMWARE     => 'H.08.02',
                UPTIME       => '(326711768) 37 days, 19:31:57.68',
                MAC          => '00:18:fe:aa:a9:80',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325708419) 37 days, 16:44:44.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '123393802',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1178060406',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'f0:1f:af:11:ad:05',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307) 0:00:03.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310) 0:00:03.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(313) 0:00:03.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(233221046) 26 days, 23:50:10.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4162377762',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2897936844',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:27:08',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(309118271) 35 days, 18:39:42.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '189910214',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2494689870',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:d2:e1:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326114651) 37 days, 17:52:26.51',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '711865552',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1398064590',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:87',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320003709) 37 days, 0:53:57.09',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2137496082',
                        IFINERRORS       => '8',
                        IFOUTOCTETS      => '1773076632',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '9',
                        IFDESCR          => '9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(266412504) 30 days, 20:02:05.04',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '298804026',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '2951433643',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f1:a9:19',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '10',
                        IFDESCR          => '10',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326055436) 37 days, 17:42:34.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1922613693',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '3623722166',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'b8:ca:3a:9e:0e:ba',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '11',
                        IFDESCR          => '11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(330) 0:00:03.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '12',
                        IFDESCR          => '12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326090196) 37 days, 17:48:21.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1851063579',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1608324661',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:90:8f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '13',
                        IFDESCR          => '13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267562859) 30 days, 23:13:48.59',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '62240934',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '156103471',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '14',
                        IFDESCR          => '14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325838476) 37 days, 17:06:24.76',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1467418408',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3058761840',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:e4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '15',
                        IFDESCR          => '15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325742991) 37 days, 16:50:29.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1133183098',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '337480167',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:24:e8:1d:9e:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '16',
                        IFDESCR          => '16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(342) 0:00:03.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '17',
                        IFDESCR          => '17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345) 0:00:03.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '18',
                        IFDESCR          => '18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ee',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324003639) 37 days, 12:00:36.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '620306769',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1818680410',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '19',
                        IFDESCR          => '19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326076719) 37 days, 17:46:07.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2099298807',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3614765732',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:89:90',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '20',
                        IFDESCR          => '20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(352) 0:00:03.52',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '21',
                        IFDESCR          => '21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320728619) 37 days, 2:54:46.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1408247717',
                        IFINERRORS       => '1',
                        IFOUTOCTETS      => '3537276662',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '22',
                        IFDESCR          => '22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ea',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(357) 0:00:03.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '23',
                        IFDESCR          => '23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(957) 0:00:09.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '8380738',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2602806252',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:29:2b:70:ee',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '24',
                        IFDESCR          => '24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(363) 0:00:03.63',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '25',
                        IFDESCR          => '25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326687479) 37 days, 19:27:54.79',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '504181874',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1396148995',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:20:66:0e:41:10',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '26',
                        IFDESCR          => '26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(367) 0:00:03.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '27',
                        IFDESCR          => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(370) 0:00:03.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '28',
                        IFDESCR          => '28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(682) 0:00:06.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '133988139',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2866297811',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f0:b8:ab',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '29',
                        IFDESCR          => '29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(375) 0:00:03.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '30',
                        IFDESCR          => '30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326034919) 37 days, 17:39:09.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1474386320',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2662357185',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:22:19:1a:f0:bf',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '31',
                        IFDESCR          => '31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(136795971) 15 days, 19:59:19.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '68207546',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3624571169',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:f2:17:d4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '32',
                        IFDESCR          => '32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(382) 0:00:03.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '33',
                        IFDESCR          => '33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(385) 0:00:03.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '34',
                        IFDESCR          => '34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(387) 0:00:03.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '35',
                        IFDESCR          => '35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(390) 0:00:03.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '36',
                        IFDESCR          => '36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(392) 0:00:03.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '37',
                        IFDESCR          => '37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(395) 0:00:03.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '38',
                        IFDESCR          => '38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(397) 0:00:03.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '39',
                        IFDESCR          => '39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(400) 0:00:04.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '40',
                        IFDESCR          => '40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(402) 0:00:04.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '41',
                        IFDESCR          => '41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325675884) 37 days, 16:39:18.84',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '657077543',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1846663321',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'd4:be:d9:91:26:61',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '42',
                        IFDESCR          => '42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(407) 0:00:04.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '43',
                        IFDESCR          => '43',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320674639) 37 days, 2:45:46.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3993249638',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1189581752',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '44',
                        IFDESCR          => '44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(412) 0:00:04.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '45',
                        IFDESCR          => '45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(306732846) 35 days, 12:02:08.46',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1401591598',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1719040774',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:e8:93:48',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '46',
                        IFDESCR          => '46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(418) 0:00:04.18',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '47',
                        IFDESCR          => '47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(420) 0:00:04.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '48',
                        IFDESCR          => '48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(422) 0:00:04.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '49',
                        IFDESCR          => '49',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(960) 0:00:09.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '496630524',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1792848570',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:b7:91:c9',
                                    '00:00:74:b7:3c:bb',
                                    '00:00:74:b7:3e:9b',
                                    '00:00:74:cc:5e:5c',
                                    '00:00:74:d2:9b:3a',
                                    '00:00:74:ee:c7:ee',
                                    '00:00:74:ee:c8:3f',
                                    '00:00:74:ee:d3:7d',
                                    '00:00:74:ee:d3:51',
                                    '00:00:74:f1:1c:3b',
                                    '00:00:74:f2:36:4c',
                                    '00:00:85:8b:a7:3d',
                                    '00:00:85:95:5f:85',
                                    '00:00:85:dc:86:7a',
                                    '00:00:85:dc:04:91',
                                    '00:00:85:de:04:93',
                                    '00:00:aa:fa:18:d1',
                                    '00:01:96:38:a8:40',
                                    '00:0a:b0:03:36:9d',
                                    '00:64:40:0b:65:82',
                                    '00:0d:54:a9:3f:06',
                                    '00:0d:54:f7:85:c6',
                                    '00:0d:54:f7:85:18',
                                    '00:0d:54:f7:86:0b',
                                    '00:0d:54:f7:86:34',
                                    '00:0d:54:f7:88:20',
                                    '00:0d:54:3c:db:72',
                                    '00:88:65:a9:62:0c',
                                    '00:88:65:c0:73:f6',
                                    '00:88:65:35:2e:68',
                                    '00:88:65:3a:bf:72',
                                    '00:0e:6a:d1:51:ae',
                                    '00:0e:6a:d1:56:0f',
                                    '00:0e:6a:d3:18:72',
                                    '00:0e:6a:d5:b9:b2',
                                    '00:0e:6a:d5:b9:e5',
                                    '00:0e:6a:d5:b9:54',
                                    '00:0e:6a:d5:ba:53',
                                    '00:0e:6a:d5:bb:ef',
                                    '00:0e:6a:d5:bc:13',
                                    '00:90:27:dc:55:2d',
                                    '00:0f:cb:a6:ee:dd',
                                    '00:0f:cb:a6:ee:f8',
                                    '00:10:18:96:9e:76',
                                    '00:10:18:9d:82:30',
                                    '00:11:24:bf:c9:63',
                                    '00:12:79:e0:fb:4c',
                                    '00:12:a9:07:0d:bd',
                                    '00:12:a9:07:0d:c9',
                                    '00:12:a9:07:0d:cb',
                                    '00:12:a9:07:0d:cf',
                                    '00:12:a9:07:0d:de',
                                    '00:12:f2:7e:89:40',
                                    '00:bd:3a:ee:2a:aa',
                                    '00:13:72:12:52:92',
                                    '00:13:02:6b:a5:a5',
                                    '00:13:02:7d:a1:ab',
                                    '00:13:ce:f1:a3:6d',
                                    '00:c6:10:c5:1e:cc',
                                    '00:c6:10:36:59:63',
                                    '00:14:7c:46:65:be',
                                    '00:14:7c:46:66:86',
                                    '00:14:7c:46:66:0f',
                                    '00:14:7c:46:66:63',
                                    '00:14:f1:b6:ee:00',
                                    '00:14:38:a1:6f:15',
                                    '00:14:38:e5:de:fd',
                                    '00:15:99:5d:fa:14',
                                    '00:15:c5:5f:c7:0e',
                                    '00:15:17:48:78:8e',
                                    '00:db:df:21:e1:25',
                                    '00:16:b6:a0:4d:1b',
                                    '00:16:3e:01:00:01',
                                    '00:16:3e:74:af:0a',
                                    '00:16:3e:77:23:ab',
                                    '00:16:3e:11:9f:23',
                                    '00:16:3e:d0:24:62',
                                    '00:16:3e:1f:98:f8',
                                    '00:16:3e:25:14:e1',
                                    '00:16:3e:44:9f:e7',
                                    '00:16:3e:53:3f:51',
                                    '00:16:3e:5e:eb:74',
                                    '00:16:44:84:17:25',
                                    '00:e0:d8:16:96:a7',
                                    '00:17:c4:99:66:a7',
                                    '00:17:c4:23:03:09',
                                    '00:17:c4:41:83:f5',
                                    '00:17:08:89:8d:fe',
                                    '00:18:8b:6e:42:0a',
                                    '00:18:8b:71:dd:45',
                                    '00:18:8b:71:dd:52',
                                    '00:18:8b:71:df:1d',
                                    '00:18:8b:cf:87:6a',
                                    '00:18:8b:17:4f:8a',
                                    '00:18:8b:f7:b5:a3',
                                    '00:18:8b:f7:dd:4c',
                                    '00:18:f3:ed:a2:46',
                                    '00:18:fe:a3:2e:d5',
                                    '00:18:fe:a8:28:00',
                                    '00:18:fe:aa:67:00',
                                    '00:18:fe:aa:68:80',
                                    '00:18:fe:aa:69:00',
                                    '00:18:fe:aa:69:80',
                                    '00:18:fe:aa:72:00',
                                    '00:18:fe:aa:77:00',
                                    '00:18:fe:aa:77:80',
                                    '00:18:fe:aa:79:80',
                                    '00:18:fe:aa:a8:80',
                                    '00:18:fe:aa:a9:00',
                                    '00:18:fe:aa:c2:80',
                                    '00:18:fe:aa:c8:80',
                                    '00:18:fe:aa:d8:00',
                                    '00:18:fe:aa:d8:4e',
                                    '00:18:fe:aa:e8:80',
                                    '00:18:fe:aa:e9:00',
                                    '00:18:fe:aa:27:00',
                                    '00:18:fe:aa:49:80',
                                    '00:18:fe:aa:51:00',
                                    '00:18:fe:aa:59:00',
                                    '00:18:fe:aa:09:00',
                                    '00:19:b9:f0:a2:43',
                                    '00:19:b9:05:b8:d8',
                                    '00:19:bb:99:c9:c0',
                                    '00:19:bb:99:2a:c0',
                                    '00:19:e3:06:f1:59',
                                    '00:1a:73:5e:aa:83',
                                    '00:1a:80:d6:fe:65',
                                    '00:1a:a0:de:41:69',
                                    '00:1a:a0:e0:fb:73',
                                    '00:1a:a0:e9:01:33',
                                    '00:1a:a0:e9:78:66',
                                    '00:1a:a0:e9:04:98',
                                    '00:1a:a0:eb:0f:1e',
                                    '00:1a:a0:3e:29:0b',
                                    '00:1a:4b:10:d8:76',
                                    '00:1a:4b:28:fa:49',
                                    '00:1b:77:3e:71:77',
                                    '00:1b:78:18:cc:80',
                                    '00:1b:8b:a3:f9:b8',
                                    '00:1b:b1:af:e0:d8',
                                    '00:1b:b1:4e:5c:9e',
                                    '00:1b:21:2c:7b:6d',
                                    '00:1b:3f:77:2a:00',
                                    '00:1c:b3:7c:67:bf',
                                    '00:1c:bf:9d:90:e4',
                                    '00:1c:2e:90:16:00',
                                    '00:1c:2e:bb:89:00',
                                    '00:1d:a1:ef:e3:f6',
                                    '00:1d:a1:ef:e4:26',
                                    '00:1d:a1:ef:e5:78',
                                    '00:1d:a2:80:b9:30',
                                    '00:1d:b3:06:47:c0',
                                    '00:1d:b3:58:8f:00',
                                    '00:1d:b3:58:cf:80',
                                    '00:1d:b3:59:b1:80',
                                    '00:1d:b3:59:f1:00',
                                    '00:1d:b3:60:bb:00',
                                    '00:1d:b3:61:71:00',
                                    '00:1d:e5:55:16:80',
                                    '00:1d:e5:55:17:ae',
                                    '00:1d:09:65:e0:37',
                                    '00:1d:09:2c:f3:07',
                                    '00:1e:68:9b:3e:d3',
                                    '00:1e:0b:12:9b:42',
                                    '00:1e:0b:17:21:01',
                                    '00:1e:0b:18:74:4f',
                                    '00:1e:7a:bd:de:fa',
                                    '00:1e:8f:da:53:d1',
                                    '00:1e:c2:b2:9a:80',
                                    '00:1e:c9:64:17:e9',
                                    '00:1e:c9:64:4e:12',
                                    '00:1e:c9:7f:94:72',
                                    '00:1e:c9:7f:19:9d',
                                    '00:1e:c9:7f:19:c8',
                                    '00:1e:c9:40:76:11',
                                    '00:1e:c9:45:14:08',
                                    '00:1e:c9:48:b4:36',
                                    '00:1e:c9:4a:b7:ac',
                                    '00:1e:c9:63:b4:d7',
                                    '00:1e:c9:63:bc:38',
                                    '00:1e:c9:63:e9:c0',
                                    '00:1e:4f:f4:e5:fe',
                                    '00:1e:4f:f4:e6:22',
                                    '00:1e:4f:35:db:a8',
                                    '00:1e:4f:35:db:aa',
                                    '00:1e:52:ac:bf:43',
                                    '00:1f:e1:89:8e:6b',
                                    '00:1f:28:4f:ee:00',
                                    '00:1f:29:1b:ab:21',
                                    '00:1f:29:1e:7f:2a',
                                    '00:1f:29:31:8f:c8',
                                    '00:1f:3c:2e:40:5e',
                                    '00:1f:5b:b7:74:e2',
                                    '00:20:85:fb:43:4e',
                                    '00:21:00:30:5b:33',
                                    '00:21:6a:8b:22:7a',
                                    '00:21:6a:c1:7e:84',
                                    '00:21:70:0d:2a:c3',
                                    '00:21:70:9f:b3:f2',
                                    '00:21:70:1c:12:47',
                                    '00:21:70:46:e1:07',
                                    '00:21:70:46:f2:09',
                                    '00:21:70:46:f5:33',
                                    '00:21:70:46:f9:26',
                                    '00:21:70:46:fc:9a',
                                    '00:21:9b:6e:69:6f',
                                    '00:21:9b:71:aa:ee',
                                    '00:21:9b:79:44:c8',
                                    '00:21:9b:79:47:91',
                                    '00:21:9b:79:4a:19',
                                    '00:21:9b:5b:5b:66',
                                    '00:21:b7:6c:79:c1',
                                    '00:21:b7:6c:49:bf',
                                    '00:21:b7:70:ac:f7',
                                    '00:21:b7:96:a7:46',
                                    '00:21:b7:a2:60:1f',
                                    '00:21:b7:aa:dc:fa',
                                    '00:21:b7:12:ff:37',
                                    '00:21:b7:ba:7d:72',
                                    '00:21:b7:02:25:ff',
                                    '00:21:b7:02:61:1d',
                                    '00:21:b7:cc:2d:de',
                                    '00:21:b7:dc:20:0d',
                                    '00:21:b7:dc:20:13',
                                    '00:21:b7:fa:44:0e',
                                    '00:21:b7:fc:c8:a4',
                                    '00:21:b7:22:9e:df',
                                    '00:21:b7:2a:89:37',
                                    '00:21:b7:2c:be:98',
                                    '00:21:b7:42:a3:26',
                                    '00:21:b7:5c:7c:d7',
                                    '00:21:b7:5c:c2:51',
                                    '00:21:b7:5c:02:90',
                                    '00:21:5a:90:d5:99',
                                    '00:21:5c:73:77:25',
                                    '00:21:5d:be:fe:94',
                                    '00:21:5d:c9:bd:64',
                                    '00:21:5d:1c:4a:52',
                                    '00:21:5d:2d:91:ba',
                                    '00:21:63:c4:6f:da',
                                    '00:22:19:8b:f7:c9',
                                    '00:22:19:11:c7:13',
                                    '00:22:19:cc:f5:2c',
                                    '00:22:19:23:d5:65',
                                    '00:22:19:23:d5:97',
                                    '00:22:19:31:b7:ad',
                                    '00:22:19:31:b7:36',
                                    '00:22:19:31:b8:be',
                                    '00:22:19:31:b8:cf',
                                    '00:22:fa:13:86:06',
                                    '00:22:fa:4a:ec:70',
                                    '00:22:fb:6d:aa:08',
                                    '00:22:fb:5f:22:1c',
                                    '00:22:41:f9:f4:38',
                                    '00:22:41:31:4a:77',
                                    '00:23:6c:91:7b:bf',
                                    '00:23:6c:9a:ea:9b',
                                    '00:23:6c:d3:a3:8c',
                                    '00:23:7d:6e:ff:53',
                                    '00:23:7d:81:ba:1c',
                                    '00:23:7d:87:2e:11',
                                    '00:23:7d:89:44:e3',
                                    '00:23:7d:8e:7f:9f',
                                    '00:23:ae:71:bf:7c',
                                    '00:23:ae:71:bf:1c',
                                    '00:23:ae:71:bf:2a',
                                    '00:23:ae:71:c0:7b',
                                    '00:23:ae:71:c0:37',
                                    '00:23:ae:71:c3:96',
                                    '00:23:ae:71:c3:07',
                                    '00:23:ae:74:6b:2c',
                                    '00:23:ae:74:72:a7',
                                    '00:23:ae:74:7b:b2',
                                    '00:23:ae:74:7c:17',
                                    '00:23:ae:74:7f:e0',
                                    '00:23:ae:74:7f:f0',
                                    '00:23:ae:74:7f:fd',
                                    '00:23:ae:74:80:a0',
                                    '00:23:ae:74:82:5f',
                                    '00:23:ae:74:aa:0f',
                                    '00:23:ae:79:fb:c5',
                                    '00:23:ae:7a:02:3c',
                                    '00:23:ae:7c:33:9c',
                                    '00:23:ae:ad:29:63',
                                    '00:23:ae:ad:32:87',
                                    '00:23:ae:f8:62:4e',
                                    '00:23:ae:fb:fb:80',
                                    '00:23:ae:fe:17:74',
                                    '00:23:12:11:2b:46',
                                    '00:23:12:22:19:6b',
                                    '00:23:12:08:18:65',
                                    '00:23:32:b4:01:5e',
                                    '00:23:4d:5c:6f:0b',
                                    '00:24:d2:69:76:91',
                                    '00:24:d2:df:af:82',
                                    '00:24:d6:2d:d8:6c',
                                    '00:24:d6:37:73:0c',
                                    '00:24:d7:71:7f:d4',
                                    '00:24:d7:71:63:14',
                                    '00:24:d7:76:f8:40',
                                    '00:24:e8:0c:22:2f',
                                    '00:24:e8:0c:23:a9',
                                    '00:24:e8:0c:23:ba',
                                    '00:24:e8:aa:e3:3e',
                                    '00:24:e8:ab:9b:0e',
                                    '00:24:e8:1b:cc:70',
                                    '00:24:e8:1b:d3:45',
                                    '00:24:e8:1d:9d:6a',
                                    '00:24:e8:1d:9e:e6',
                                    '00:24:e8:1d:9f:fc',
                                    '00:24:e8:36:20:15',
                                    '00:24:e8:46:d9:55',
                                    '00:24:e8:46:da:27',
                                    '00:24:e8:48:e5:97',
                                    '00:24:e8:48:e5:9f',
                                    '00:24:21:6d:5f:20',
                                    '00:25:00:ef:60:94',
                                    '00:25:00:42:a0:83',
                                    '00:25:64:b8:35:b6',
                                    '00:25:64:b8:35:d4',
                                    '00:25:64:e8:8c:be',
                                    '00:25:64:e8:8d:9f',
                                    '00:25:64:e8:8f:b3',
                                    '00:25:64:e8:90:4f',
                                    '00:25:64:e8:91:e7',
                                    '00:25:64:e8:91:33',
                                    '00:25:b3:f1:68:bd',
                                    '00:25:45:22:89:34',
                                    '00:25:45:22:a4:22',
                                    '00:25:4b:8b:46:e6',
                                    '00:25:4b:fc:95:cf',
                                    '00:26:0b:62:87:8c',
                                    '00:26:0b:62:87:ae',
                                    '00:26:0b:62:87:ee',
                                    '00:26:0b:62:88:14',
                                    '00:26:0b:62:88:06',
                                    '00:26:0b:62:88:08',
                                    '00:26:0b:62:8a:9a',
                                    '00:26:0b:62:8a:da',
                                    '00:26:0b:62:8b:fa',
                                    '00:26:0b:62:8b:1a',
                                    '00:26:0b:62:8b:34',
                                    '00:26:0b:62:8c:82',
                                    '00:26:0b:62:8c:a0',
                                    '00:26:0b:62:8c:a4',
                                    '00:26:0b:62:8c:c8',
                                    '00:26:0b:62:8d:78',
                                    '00:26:0b:62:8d:98',
                                    '00:26:0b:62:8d:c2',
                                    '00:26:0b:62:8d:4e',
                                    '00:26:0b:62:b1:80',
                                    '00:26:0b:62:50:7e',
                                    '00:26:0b:62:50:4e',
                                    '00:26:73:0e:e8:17',
                                    '00:26:73:12:13:52',
                                    '00:26:73:13:dc:e7',
                                    '00:26:73:13:ec:5e',
                                    '00:26:73:1e:01:98',
                                    '00:26:73:27:27:05',
                                    '00:26:73:29:4a:8e',
                                    '00:26:73:2b:79:86',
                                    '00:26:73:2b:79:9f',
                                    '00:26:73:2b:a6:a2',
                                    '00:26:73:31:74:b8',
                                    '00:26:73:31:74:cb',
                                    '00:26:73:31:74:e3',
                                    '00:26:73:33:7a:bf',
                                    '00:26:73:45:e9:76',
                                    '00:26:73:4a:0d:e4',
                                    '00:26:73:4a:22:fd',
                                    '00:26:b0:da:16:ba',
                                    '00:26:b6:3e:b5:e5',
                                    '00:26:b9:85:dd:7e',
                                    '00:26:bb:13:1d:b1',
                                    '00:26:bb:1d:83:4c',
                                    '00:26:bb:03:b5:bd',
                                    '00:26:bb:04:06:07',
                                    '00:26:bb:06:51:16',
                                    '00:26:cb:10:0c:50',
                                    '00:26:cb:10:40:30',
                                    '00:26:cb:10:41:50',
                                    '00:26:cb:10:42:80',
                                    '00:26:cb:11:1a:80',
                                    '00:26:cb:11:05:00',
                                    '00:26:cb:b8:bf:f0',
                                    '00:26:cb:1b:c0:60',
                                    '00:26:cb:1d:7a:f0',
                                    '00:26:cb:1d:7c:e0',
                                    '00:26:cb:1d:7d:c0',
                                    '00:26:cb:1d:92:30',
                                    '00:26:cb:1d:97:00',
                                    '00:26:cb:1d:9d:20',
                                    '00:26:cb:1d:a3:70',
                                    '00:26:cb:1d:ab:30',
                                    '00:26:08:e1:6b:31',
                                    '00:26:08:e4:35:06',
                                    '00:26:5e:70:43:c6',
                                    '00:27:10:e0:5e:48',
                                    '00:04:00:16:38:9f',
                                    '00:04:00:f6:22:6c',
                                    '00:30:c1:c2:49:45',
                                    '00:30:c1:02:60:bd',
                                    '00:05:1e:0d:38:23',
                                    '00:37:6d:da:f6:3a',
                                    '00:08:14:00:37:aa',
                                    '00:50:b6:5b:11:ef',
                                    '00:50:c2:d0:ff:51',
                                    '00:50:56:b2:3a:42',
                                    '00:60:9f:80:00:59',
                                    '00:60:9f:80:06:14',
                                    '68:9c:5e:2c:12:08',
                                    '68:a3:c4:43:57:70',
                                    '68:a8:6d:0b:74:e2',
                                    '68:a8:6d:23:a6:b0',
                                    '68:a8:6d:23:b5:b2',
                                    '68:a8:6d:4a:c5:b2',
                                    '68:5d:43:57:d9:9c',
                                    '6c:71:d9:6b:02:0a',
                                    '6c:71:d9:70:5f:32',
                                    '6c:71:d9:7f:fb:36',
                                    '6c:3e:6d:74:05:1e',
                                    '70:71:bc:b9:30:15',
                                    '70:aa:b2:76:bd:b6',
                                    '70:f3:95:e7:7c:65',
                                    '70:f9:27:c7:a9:a3',
                                    '70:56:81:93:45:c9',
                                    '70:56:81:ab:56:db',
                                    '74:de:2b:2b:c1:69',
                                    '74:e1:b6:7d:d2:cb',
                                    '74:f0:6d:0a:1e:cd',
                                    '74:f0:6d:51:c4:34',
                                    '74:2f:68:8c:32:8d',
                                    '74:2f:68:ed:13:f8',
                                    '74:2f:68:2e:09:19',
                                    '74:2f:68:53:0a:13',
                                    '74:45:8a:67:6d:ad',
                                    '74:45:8a:53:cf:6d',
                                    '0c:84:dc:9d:f6:4f',
                                    '0c:ee:e6:d5:ce:b4',
                                    '78:92:9c:95:38:a6',
                                    '78:92:9c:22:1e:e4',
                                    '78:92:9c:3d:6b:ba',
                                    '78:ac:c0:77:93:00',
                                    '78:ac:c0:8f:63:b9',
                                    '78:ca:39:ae:e4:58',
                                    '78:e4:00:0b:f5:4a',
                                    '78:e4:00:f4:ee:16',
                                    '78:1f:db:ac:93:66',
                                    '78:2b:cb:85:ff:81',
                                    '78:2b:cb:85:ff:9c',
                                    '78:2b:cb:86:19:d9',
                                    '78:2b:cb:86:1b:11',
                                    '78:2b:cb:86:08:26',
                                    '78:2b:cb:86:57:0b',
                                    '78:2b:cb:98:c4:88',
                                    '78:2b:cb:98:c5:e9',
                                    '78:2b:cb:98:c6:ae',
                                    '78:2b:cb:98:c6:e9',
                                    '78:2b:cb:98:c6:fd',
                                    '78:2b:cb:98:c7:80',
                                    '78:2b:cb:98:e9:31',
                                    '78:2b:cb:98:24:86',
                                    '78:2b:cb:9a:15:14',
                                    '78:2b:cb:9a:18:8c',
                                    '78:2b:cb:9e:86:a7',
                                    '78:2b:cb:9e:95:9d',
                                    '78:2b:cb:9e:cb:3c',
                                    '7c:d1:c3:97:e5:c4',
                                    '7c:d1:c3:9b:96:be',
                                    '7c:e9:d3:7e:cf:09',
                                    '7c:e9:d3:8c:07:d4',
                                    '84:7a:88:81:81:b1',
                                    '84:8f:69:d7:1b:2c',
                                    '84:a6:c8:da:1d:cb',
                                    '84:fc:fe:cd:52:43',
                                    '84:2b:2b:96:67:09',
                                    '84:2b:2b:96:73:ec',
                                    '84:2b:2b:9a:69:e0',
                                    '84:2b:2b:9b:d3:e1',
                                    '84:2b:2b:aa:4c:be',
                                    '84:2b:2b:bb:34:bb',
                                    '84:2b:2b:bb:4e:74',
                                    '84:2b:2b:bb:4e:25',
                                    '84:2b:2b:60:0e:cb',
                                    '84:3a:4b:7d:02:38',
                                    '84:4b:f5:16:e2:99',
                                    '84:4b:f5:29:b0:bb',
                                    '88:c6:63:69:1c:36',
                                    '88:c6:63:f3:55:cc',
                                    '88:1f:a1:0f:74:46',
                                    '88:1f:a1:18:dd:1a',
                                    '88:30:8a:25:a8:88',
                                    '88:53:95:d3:23:4e',
                                    '88:53:d4:27:c9:ff',
                                    '8c:2d:aa:45:3e:c7',
                                    '90:84:0d:9a:91:8f',
                                    '90:84:0d:53:b7:8b',
                                    '90:b1:1c:7d:98:0d',
                                    '90:b1:1c:7d:98:bb',
                                    '90:b1:1c:7d:98:5b',
                                    '90:b1:1c:7d:9b:8a',
                                    '90:b1:1c:7e:0d:9a',
                                    '90:b1:1c:7e:0d:aa',
                                    '90:b1:1c:82:f9:9f',
                                    '90:b1:1c:a5:18:cf',
                                    '90:b1:1c:a5:1e:37',
                                    '90:b1:1c:4f:24:5d',
                                    '90:18:7c:1b:c3:e8',
                                    '90:18:7c:37:c2:1f',
                                    '90:18:7c:5f:7d:c3',
                                    '90:21:55:63:5a:5b',
                                    '90:27:e4:fe:d9:4e',
                                    '90:4c:e5:8a:67:07',
                                    '90:4c:e5:1b:9c:05',
                                    '94:71:ac:f9:d0:8a',
                                    '98:0c:82:8c:8d:a9',
                                    '98:0c:82:56:2c:50',
                                    '98:d6:bb:cb:58:e8',
                                    '98:d6:f7:5d:fe:8b',
                                    '98:fe:94:06:52:96',
                                    '98:fe:94:3f:b9:36',
                                    '98:fe:94:41:ce:64',
                                    '98:fe:94:49:ea:04',
                                    '98:4b:e1:39:9e:a9',
                                    '9c:04:eb:1d:8f:33',
                                    '9c:2a:70:23:55:cd',
                                    '9c:2a:70:25:52:d9',
                                    '10:68:3f:85:31:4e',
                                    '10:68:3f:e7:e2:0c',
                                    '10:0b:a9:50:e2:f0',
                                    '10:0b:a9:52:72:94',
                                    '10:0b:a9:52:72:c0',
                                    '10:93:e9:0e:a4:78',
                                    '10:93:e9:04:7d:3c',
                                    '10:9a:dd:27:8d:8b',
                                    '10:9a:dd:44:a9:fe',
                                    '10:dd:b1:ee:a7:93',
                                    '10:1c:0c:28:32:91',
                                    '10:40:f3:7c:30:6a',
                                    '10:40:f3:86:62:02',
                                    '10:40:f3:98:36:56',
                                    '10:40:f3:f0:20:78',
                                    'a0:6c:ec:6f:ea:16',
                                    'a0:82:1f:6c:55:99',
                                    'a0:f3:c1:09:1c:30',
                                    'a0:f4:50:ef:81:cf',
                                    'a0:42:3f:01:97:7d',
                                    'a4:67:06:ba:8c:55',
                                    'a4:67:06:54:b2:27',
                                    'a4:ba:db:f6:ab:b8',
                                    'a4:ba:db:f6:ad:cf',
                                    'a4:ba:db:f6:ae:86',
                                    'a4:ba:db:f6:ae:9a',
                                    'a4:ba:db:f6:ae:b6',
                                    'a4:ba:db:f6:ae:f2',
                                    'a4:ba:db:f6:ae:40',
                                    'a4:ba:db:f6:af:ea',
                                    'a4:ba:db:f6:b0:82',
                                    'a4:ba:db:f6:b1:3d',
                                    'a4:ba:db:f7:bb:ce',
                                    'a4:ba:db:f7:bc:78',
                                    'a4:ba:db:f8:0f:54',
                                    'a4:ba:db:f8:10:ec',
                                    'a4:ba:db:f8:12:a8',
                                    'a4:ba:db:f8:13:e4',
                                    'a4:d1:d2:0a:da:a0',
                                    'a4:17:31:1a:fc:df',
                                    'a4:17:31:09:9c:a7',
                                    'a8:20:66:30:f6:5e',
                                    'a8:20:66:4f:de:c7',
                                    'ac:72:89:77:a9:4d',
                                    'ac:3c:0b:de:42:e0',
                                    'b0:65:bd:0b:a3:92',
                                    'b0:65:bd:72:07:1b',
                                    'b0:65:bd:54:d3:71',
                                    'b4:74:9f:ae:f1:1f',
                                    'b4:99:ba:d7:54:30',
                                    'b4:f0:ab:7e:bb:14',
                                    'b4:07:f9:d5:f8:d6',
                                    'b8:76:3f:26:05:a9',
                                    'b8:78:2e:84:9b:56',
                                    'b8:8d:12:00:2a:d6',
                                    'b8:8d:12:13:7d:80',
                                    'b8:8d:12:14:c3:26',
                                    'b8:8d:12:1b:df:e0',
                                    'b8:8d:12:1b:e0:62',
                                    'b8:8d:12:1b:e1:f0',
                                    'b8:8d:12:39:81:52',
                                    'b8:8d:12:39:56:7e',
                                    'b8:8d:12:08:0f:e0',
                                    'b8:8d:12:55:95:da',
                                    'b8:ac:6f:81:b0:c8',
                                    'b8:ac:6f:0d:4a:d9',
                                    'b8:ac:6f:91:b2:e8',
                                    'b8:ac:6f:91:b4:c3',
                                    'b8:ac:6f:91:b4:c5',
                                    'b8:ac:6f:92:91:9f',
                                    'b8:ac:6f:95:b9:4f',
                                    'b8:ac:6f:a1:a4:04',
                                    'b8:ac:6f:44:5c:b3',
                                    'b8:ca:3a:8c:71:cd',
                                    'b8:ca:3a:9e:65:2b',
                                    'b8:ca:3a:9e:0e:ab',
                                    'b8:ca:3a:9e:0e:b3',
                                    'b8:ca:3a:9e:0e:d6',
                                    'b8:ca:3a:9e:0e:04',
                                    'b8:ca:3a:9e:0e:52',
                                    'b8:ca:3a:9e:0e:53',
                                    'b8:ca:3a:9e:13:f7',
                                    'b8:ca:3a:9e:ce:6d',
                                    'b8:ca:3a:9e:44:3d',
                                    'b8:ca:3a:9e:46:89',
                                    'b8:ca:3a:9e:46:41',
                                    'b8:ca:3a:9e:49:ad',
                                    'b8:ca:3a:9e:49:4e',
                                    'b8:ca:3a:9e:4a:10',
                                    'b8:ca:3a:d3:6f:8f',
                                    'bc:72:b1:78:df:3a',
                                    'bc:cf:cc:ca:d7:a6',
                                    'bc:30:5b:e0:17:78',
                                    'bc:30:5b:e0:17:9f',
                                    'bc:30:5b:e6:a6:28',
                                    'bc:3b:af:0e:e5:a1',
                                    'c0:65:99:8d:d6:03',
                                    'c0:65:99:8e:4f:0b',
                                    'c0:18:85:bb:e1:e3',
                                    'c4:0a:cb:65:9c:30',
                                    'c4:0a:cb:65:b7:60',
                                    'c4:0a:cb:65:f0:20',
                                    'c4:0a:cb:a4:1c:c0',
                                    'c4:0a:cb:b2:2d:d0',
                                    'c4:0a:cb:24:6f:f0',
                                    'c4:0a:cb:24:70:00',
                                    'c4:0a:cb:24:73:80',
                                    'c4:0a:cb:24:43:10',
                                    'c4:0a:cb:24:47:80',
                                    'c4:0a:cb:24:47:60',
                                    'c4:0a:cb:24:4b:90',
                                    'c4:0a:cb:24:54:80',
                                    'c4:0a:cb:2c:0d:30',
                                    'c4:0a:cb:2c:03:c0',
                                    'c4:0a:cb:2c:2a:e0',
                                    'c4:0a:cb:2c:09:c0',
                                    'c4:64:13:0f:8b:03',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:96',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:c2:ce:31',
                                    'c4:64:13:2b:f2:25',
                                    'c4:6a:b7:6b:ee:fe',
                                    'c4:85:08:31:52:6d',
                                    'c4:17:fe:a6:ed:b7',
                                    'c4:46:19:1b:8f:48',
                                    '14:8f:c6:be:89:49',
                                    '14:10:9f:d0:cb:3b',
                                    '14:10:9f:dd:04:cf',
                                    '14:10:9f:e5:1c:4b',
                                    '14:10:9f:e9:eb:e2',
                                    '14:10:9f:f2:ac:e0',
                                    '14:10:9f:f4:0d:1e',
                                    '14:fe:b5:f0:9f:57',
                                    '14:fe:b5:f0:9f:5e',
                                    '14:5a:05:c9:ab:98',
                                    '14:5a:05:21:20:b6',
                                    'c8:bc:c8:d9:63:1a',
                                    'c8:bc:c8:eb:e0:ea',
                                    'c8:e0:eb:e1:ee:02',
                                    'c8:f7:33:a6:6b:e3',
                                    'c8:19:f7:ee:b7:95',
                                    'c8:2a:14:3e:9a:19',
                                    'cc:78:5f:68:90:6e',
                                    'cc:af:78:cf:c1:49',
                                    'cc:52:af:5e:a7:dc',
                                    'd0:b3:3f:68:0c:80',
                                    'd0:b3:3f:68:10:d6',
                                    'd0:b3:3f:7e:e3:7a',
                                    'd0:b3:3f:9a:c2:69',
                                    'd0:b3:3f:a6:b5:70',
                                    'd0:b3:3f:f5:ba:88',
                                    'd0:df:9a:5b:b3:55',
                                    'd0:23:db:31:af:58',
                                    'd0:57:85:57:c0:99',
                                    'd4:85:64:14:42:10',
                                    'd4:85:64:3c:ac:e5',
                                    'd4:9a:20:72:73:0d',
                                    'd4:9a:20:57:16:45',
                                    'd4:a0:2a:10:38:c0',
                                    'd4:ae:52:ba:a2:64',
                                    'd4:ae:52:ba:a2:6d',
                                    'd4:ae:52:bc:06:c0',
                                    'd4:be:d9:8f:25:83',
                                    'd4:be:d9:91:ef:17',
                                    'd4:be:d9:91:ef:36',
                                    'd4:be:d9:91:f1:6a',
                                    'd4:be:d9:91:25:c4',
                                    'd4:be:d9:91:25:fb',
                                    'd4:be:d9:91:25:fd',
                                    'd4:be:d9:91:26:01',
                                    'd4:be:d9:91:26:85',
                                    'd4:be:d9:91:26:91',
                                    'd4:be:d9:91:26:9f',
                                    'd4:be:d9:91:26:f2',
                                    'd4:be:d9:91:26:fe',
                                    'd4:be:d9:91:26:22',
                                    'd4:be:d9:91:26:04',
                                    'd4:be:d9:91:26:2d',
                                    'd4:be:d9:91:27:02',
                                    'd4:be:d9:92:00:fd',
                                    'd4:be:d9:92:02:87',
                                    'd4:be:d9:92:02:95',
                                    'd4:be:d9:97:d4:24',
                                    'd4:be:d9:18:19:98',
                                    'd4:be:d9:18:1b:5a',
                                    'd8:9e:3f:b8:4a:0a',
                                    'd8:9e:3f:36:3d:db',
                                    'd8:24:bd:d5:1c:b0',
                                    'd8:24:bd:d5:2d:c0',
                                    'd8:24:bd:d5:2e:50',
                                    'd8:24:bd:d5:33:f0',
                                    'd8:24:bd:d5:40:a0',
                                    'd8:24:bd:d5:40:50',
                                    'd8:24:bd:d5:41:80',
                                    'd8:24:bd:d5:44:d0',
                                    'd8:24:bd:d5:4a:c0',
                                    'd8:24:bd:d5:4c:10',
                                    'd8:24:bd:d5:4c:20',
                                    'd8:24:bd:d5:4f:e0',
                                    'd8:24:bd:d5:50:30',
                                    'd8:24:bd:d5:51:b0',
                                    'd8:24:bd:d5:52:c0',
                                    'd8:24:bd:d5:55:50',
                                    'd8:24:bd:d5:58:40',
                                    'd8:24:bd:d5:5f:50',
                                    'd8:24:bd:d5:60:b0',
                                    'd8:24:bd:d5:63:60',
                                    'd8:24:bd:e8:d0:b0',
                                    'd8:24:bd:e8:d4:10',
                                    'd8:24:bd:e8:e0:e0',
                                    'd8:24:bd:e8:f2:60',
                                    'd8:24:bd:e8:f5:60',
                                    'd8:24:bd:e8:f7:a0',
                                    'd8:24:bd:e8:f9:70',
                                    'd8:24:bd:e9:0a:00',
                                    'd8:24:bd:e9:0b:70',
                                    'd8:24:bd:e9:0d:30',
                                    'd8:24:bd:e9:11:50',
                                    'd8:24:bd:e9:14:b0',
                                    'd8:24:bd:e9:18:a0',
                                    'd8:24:bd:e9:f5:80',
                                    'd8:24:bd:e9:f5:b0',
                                    'd8:30:62:c4:da:ec',
                                    'd8:30:62:5e:1c:19',
                                    'd8:30:62:61:b9:18',
                                    'd8:57:ef:37:44:bb',
                                    'dc:85:de:0f:d2:25',
                                    'dc:85:de:25:37:12',
                                    'e0:b9:a5:ac:e6:6b',
                                    'e0:f8:47:10:85:1a',
                                    'e0:f8:47:a4:84:96',
                                    'e0:f8:47:19:58:32',
                                    'e0:f8:47:40:f9:de',
                                    'e0:f8:47:5f:8f:0a',
                                    'e4:ce:8f:0c:a2:96',
                                    'e4:ce:8f:0f:7c:c8',
                                    'e4:ce:8f:a7:c3:33',
                                    'e4:ce:8f:b8:af:50',
                                    'e4:ce:8f:20:49:5a',
                                    'e4:ce:8f:36:81:40',
                                    'e4:ce:8f:36:60:0c',
                                    'e4:ce:8f:3c:b3:b6',
                                    'e4:d5:3d:68:e0:02',
                                    'e4:d5:3d:96:42:3a',
                                    'e8:99:c4:b6:37:20',
                                    'e8:cb:a1:ff:5a:9d',
                                    'e8:39:df:95:9d:22',
                                    'e8:06:88:a4:22:6f',
                                    'ec:85:2f:a5:dc:13',
                                    'ec:89:f5:60:fa:e2',
                                    'ec:35:86:5f:04:a8',
                                    'ec:55:f9:36:17:22',
                                    '18:00:2d:98:e2:a8',
                                    '18:03:73:0a:88:55',
                                    '18:03:73:0a:20:57',
                                    '18:03:73:0b:57:7b',
                                    '18:03:73:b2:be:86',
                                    '18:03:73:bb:68:8f',
                                    '18:03:73:bb:6a:6c',
                                    '18:03:73:bb:6a:39',
                                    '18:03:73:bb:6b:a1',
                                    '18:03:73:bb:6b:ff',
                                    '18:03:73:bb:6b:36',
                                    '18:03:73:bb:6c:85',
                                    '18:03:73:bb:6c:9d',
                                    '18:03:73:bb:6c:b1',
                                    '18:03:73:bb:6c:c9',
                                    '18:03:73:bb:6e:c2',
                                    '18:03:73:bb:54:78',
                                    '18:03:73:cd:8c:a1',
                                    '18:03:73:cd:1b:14',
                                    '18:03:73:ce:2e:25',
                                    '18:03:73:18:e4:bb',
                                    '18:03:73:18:ec:a2',
                                    '18:03:73:18:ef:2a',
                                    '18:03:73:18:f5:57',
                                    '18:03:73:18:f6:ea',
                                    '18:03:73:18:fb:35',
                                    '18:03:73:19:46:0d',
                                    '18:03:73:3d:45:00',
                                    '18:03:73:46:87:5e',
                                    '18:03:73:09:65:56',
                                    '18:03:73:09:d0:a2',
                                    '18:03:73:09:d3:63',
                                    '18:03:73:09:31:ac',
                                    '18:03:73:09:32:88',
                                    '18:3f:47:54:e4:2c',
                                    '18:46:17:e7:4b:ea',
                                    'f0:6b:ca:1b:25:d4',
                                    'f0:b4:79:14:db:4e',
                                    'f0:b4:79:1d:7b:ad',
                                    'f0:cb:a1:6b:66:18',
                                    'f0:5a:09:e1:f0:49',
                                    'f0:62:81:75:ca:00',
                                    'f4:ce:46:33:ed:e2',
                                    'f4:ce:46:33:3a:01',
                                    'f4:ce:46:34:f5:44',
                                    'f4:ce:46:34:26:cf',
                                    'f4:ce:46:42:03:84',
                                    'f4:ce:46:43:e2:e4',
                                    'f4:ce:46:4c:20:7b',
                                    'f4:f1:5a:0c:75:af',
                                    'f4:f1:5a:92:61:1a',
                                    'f4:f1:5a:bd:41:76',
                                    'f4:f1:5a:c4:88:86',
                                    'f8:0c:f3:1b:ee:c9',
                                    'f8:a4:5f:17:bd:d6',
                                    'f8:1e:df:8b:7b:b8',
                                    'f8:1e:df:9a:fc:67',
                                    'f8:1e:df:9c:0c:43',
                                    'f8:1e:df:ad:af:1a',
                                    'f8:1e:df:dc:cb:28',
                                    'f8:1e:df:dc:da:84',
                                    'f8:1e:df:e5:f9:32',
                                    'f8:1e:df:e9:e5:b7',
                                    'f8:1e:df:ed:c7:48',
                                    '1c:65:9d:76:63:5f',
                                    '1c:b0:94:a3:4b:ea',
                                    '20:64:32:89:4c:4c',
                                    '20:10:7a:93:e3:e4',
                                    '20:10:7a:43:a8:46',
                                    '20:c9:d0:7e:a4:f7',
                                    '20:c9:d0:87:f6:77',
                                    '20:c9:d0:c2:96:3d',
                                    '20:c9:d0:c3:a2:f5',
                                    '20:c9:d0:d5:2a:6b',
                                    '20:c9:d0:d9:b6:85',
                                    '20:c9:d0:da:b1:01',
                                    '20:c9:d0:de:87:47',
                                    '20:c9:d0:e1:3f:7d',
                                    '20:c9:d0:42:c5:63',
                                    '20:c9:d0:49:16:05',
                                    '24:77:03:bb:f0:50',
                                    '24:77:03:13:1f:b8',
                                    '24:77:03:c1:ac:14',
                                    '24:77:03:15:41:a0',
                                    '24:77:03:23:c1:18',
                                    '24:77:03:2c:75:68',
                                    '24:77:03:2c:85:d8',
                                    '24:be:05:ed:96:ec',
                                    '24:fd:52:79:06:ef',
                                    '04:0c:ce:88:1b:23',
                                    '04:0c:ce:d8:a3:a2',
                                    '04:e5:36:40:91:fa',
                                    '04:f7:e4:77:b8:bd',
                                    '04:1e:64:08:e2:f7',
                                    '04:46:65:87:9a:a1',
                                    '04:54:53:a1:da:3c',
                                    '28:6a:ba:c8:45:28',
                                    '28:94:0f:db:59:1d',
                                    '28:cf:da:de:63:52',
                                    '28:cf:da:e7:ed:34',
                                    '28:cf:da:e7:4e:94',
                                    '28:cf:da:3d:93:d2',
                                    '28:cf:e9:65:17:cf',
                                    '28:cf:e9:13:4d:57',
                                    '28:cf:e9:15:25:6b',
                                    '28:cf:e9:55:b4:1d',
                                    '28:cf:e9:5c:1a:4f',
                                    '28:e0:2c:02:b8:f7',
                                    '28:37:37:19:5f:40',
                                    '28:37:37:1c:2e:3e',
                                    '2c:41:38:9a:b7:43',
                                    '30:85:a9:07:fa:4b',
                                    '30:f7:c5:eb:49:a7',
                                    '34:15:9e:8a:d8:c9',
                                    '34:15:9e:91:2f:cc',
                                    '34:51:c9:c6:a6:55',
                                    '38:aa:3c:ef:c1:1c',
                                    '38:60:77:be:eb:0b',
                                    '3c:07:54:0f:f0:bb',
                                    '3c:07:54:23:69:6a',
                                    '40:6c:8f:3b:66:a7',
                                    '40:b3:95:8d:19:cc',
                                    '40:b3:95:e7:9e:c3',
                                    '40:b3:95:4d:8e:c1',
                                    '40:f3:08:22:19:2a',
                                    '40:fc:89:8f:61:63',
                                    '40:25:c2:c9:5d:04',
                                    '40:30:04:4b:a3:ff',
                                    '44:6d:57:2a:bb:d6',
                                    '44:1e:a1:7a:43:c0',
                                    '44:2a:60:a4:4d:e0',
                                    '48:5d:60:f9:18:29',
                                    '48:60:bc:95:df:6b',
                                    '48:60:bc:b1:75:76',
                                    '4c:80:93:3b:21:6c',
                                    '4c:8b:ef:a8:82:51',
                                    '4c:8d:79:e3:46:e2',
                                    '4c:8d:79:e6:cb:8a',
                                    '4c:8d:79:f2:47:f6',
                                    '4c:0f:6e:d9:d8:14',
                                    '4c:b1:99:c9:43:1c',
                                    '4c:ed:de:75:a0:29',
                                    '4c:ed:de:a3:ec:23',
                                    '08:00:27:3d:ca:12',
                                    '08:00:37:87:9a:1a',
                                    '08:00:37:2a:22:7a',
                                    '08:70:45:2a:5e:1a',
                                    '08:11:96:97:74:b4',
                                    '08:ed:b9:ba:81:f9',
                                    '08:ed:b9:06:34:2d',
                                    '08:ed:b9:3d:00:5c',
                                    '08:ed:b9:48:10:69',
                                    '08:ed:b9:4c:52:8b',
                                    '08:3e:8e:85:c8:65',
                                    '08:3e:8e:4b:dc:0b',
                                    '50:01:bb:cf:83:23',
                                    '50:63:13:c3:9e:07',
                                    '54:26:96:cf:53:1b',
                                    '5c:96:9d:89:d9:b9',
                                    '5c:ac:4c:16:01:7a',
                                    '5c:f9:dd:d6:35:d9',
                                    '5c:f9:dd:d6:36:0b',
                                    '5c:26:0a:70:51:c1',
                                    '5c:26:0a:81:07:6d',
                                    '5c:26:0a:81:07:77',
                                    '5c:26:0a:20:85:1a',
                                    '60:c5:47:8d:c6:ea',
                                    '60:c5:47:96:82:60',
                                    '60:d8:19:a7:0c:c2',
                                    '60:d8:19:58:fc:43',
                                    '60:fb:42:f8:fd:1c',
                                    '60:21:c0:12:21:9f',
                                    '60:33:4b:0e:00:81',
                                    '60:33:4b:1c:6d:af',
                                    '60:36:dd:8b:7f:c7',
                                    '60:36:dd:a5:dc:50',
                                    '60:36:dd:08:e9:7c',
                                    'd4:be:d9:91:26:5c',
                                    '24:fd:52:49:0e:5c',
                                    '5c:96:9d:7c:91:95',
                                    '00:24:36:e8:d2:76',
                                    '68:a8:6d:34:8f:c4',
                                    '60:36:dd:94:3e:00',
                                    '00:21:70:9f:b3:50',
                                    '70:73:cb:10:07:3c',
                                    '24:77:03:65:c2:50',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '50',
                        IFDESCR          => '50',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(424) 0:00:04.24',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5672) 0:00:56.72',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5693) 0:00:56.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3868) 0:00:38.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3889) 0:00:38.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3908) 0:00:39.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3926) 0:00:39.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3948) 0:00:39.48',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3966) 0:00:39.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(930) 0:00:09.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5667) 0:00:56.67',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3985) 0:00:39.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4006) 0:00:40.06',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4025) 0:00:40.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4043) 0:00:40.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4066) 0:00:40.66',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4085) 0:00:40.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4103) 0:00:41.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4125) 0:00:41.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4143) 0:00:41.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4738) 0:00:47.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4162) 0:00:41.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4183) 0:00:41.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4202) 0:00:42.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5713) 0:00:57.13',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4757) 0:00:47.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4780) 0:00:47.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4799) 0:00:47.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4220) 0:00:42.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4818) 0:00:48.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5733) 0:00:57.33',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4242) 0:00:42.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4261) 0:00:42.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4279) 0:00:42.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4301) 0:00:43.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4320) 0:00:43.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4338) 0:00:43.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4360) 0:00:43.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4379) 0:00:43.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4398) 0:00:43.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4419) 0:00:44.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4438) 0:00:44.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4457) 0:00:44.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4497) 0:00:44.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '114',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4840) 0:00:48.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '115',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4516) 0:00:45.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '118',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4860) 0:00:48.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '119',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4879) 0:00:48.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '120',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4901) 0:00:49.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '122',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4538) 0:00:45.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '123',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4920) 0:00:49.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '125',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '126',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '127',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4557) 0:00:45.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '128',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(880) 0:00:08.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '129',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4938) 0:00:49.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '130',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5646) 0:00:56.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '131',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5736) 0:00:57.36',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '133',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4960) 0:00:49.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4979) 0:00:49.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4998) 0:00:49.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5020) 0:00:50.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5039) 0:00:50.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4696) 0:00:46.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4577) 0:00:45.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4599) 0:00:45.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5058) 0:00:50.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5082) 0:00:50.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '150',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5101) 0:00:51.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '151',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5120) 0:00:51.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '154',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5142) 0:00:51.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '156',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5161) 0:00:51.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '158',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5181) 0:00:51.81',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '160',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5203) 0:00:52.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '162',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5222) 0:00:52.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '163',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5242) 0:00:52.42',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '164',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5263) 0:00:52.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5282) 0:00:52.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '184',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5737) 0:00:57.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '188',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5301) 0:00:53.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '196',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5324) 0:00:53.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '198',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5343) 0:00:53.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4618) 0:00:46.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '256',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5362) 0:00:53.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '260',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2737) 0:00:27.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '262',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4719) 0:00:47.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '263',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5384) 0:00:53.84',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '264',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5403) 0:00:54.03',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '266',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5422) 0:00:54.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '270',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5444) 0:00:54.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '272',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5463) 0:00:54.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259336383) 30 days, 0:22:43.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '302',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '306',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5738) 0:00:57.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '312',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5482) 0:00:54.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '315',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5504) 0:00:55.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '316',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5523) 0:00:55.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '317',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5543) 0:00:55.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '362',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4637) 0:00:46.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '363',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4659) 0:00:46.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '364',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '662',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4677) 0:00:46.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '668',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5565) 0:00:55.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '672',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5585) 0:00:55.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '676',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5604) 0:00:56.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '677',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1230) 0:00:12.30',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '908',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:18:fe:aa:a9:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5626) 0:00:56.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4158',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J4899C.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'ProCurve 2650 (J4899C)',
            DESCRIPTION  => 'ProCurve J4899C Switch 2650, revision H.10.108, ROM H.08.05 (/sw/code/build/fish)',

            SERIAL       => 'CN830FX04U',
            FIRMWARE     => 'H.08.05',
            UPTIME       => '(326690861) 37 days, 19:28:28.61',
            MAC          => '00:1d:b3:58:cf:80',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'ProCurve 2650 (J4899C)',
                COMMENTS     => 'ProCurve J4899C Switch 2650, revision H.10.108, ROM H.08.05 (/sw/code/build/fish)',
                SERIAL       => 'CN830FX04U',
                FIRMWARE     => 'H.08.05',
                UPTIME       => '(326690861) 37 days, 19:28:28.61',
                MAC          => '00:1d:b3:58:cf:80',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ff',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(231) 0:00:02.31',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(232) 0:00:02.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(191005471) 22 days, 2:34:14.71',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '488406426',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(237) 0:00:02.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302437849) 35 days, 0:06:18.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '69862514',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2697883774',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:21:b7:aa:dc:fa',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320362949) 37 days, 1:53:49.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '982820631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '671556436',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(245) 0:00:02.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(247) 0:00:02.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '9',
                        IFDESCR          => '9',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(250) 0:00:02.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '10',
                        IFDESCR          => '10',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326663439) 37 days, 19:23:54.39',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '159935594',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '862902745',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '11',
                        IFDESCR          => '11',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(255) 0:00:02.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '12',
                        IFDESCR          => '12',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(257) 0:00:02.57',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '13',
                        IFDESCR          => '13',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(260) 0:00:02.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '14',
                        IFDESCR          => '14',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(262) 0:00:02.62',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '15',
                        IFDESCR          => '15',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(265) 0:00:02.65',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '16',
                        IFDESCR          => '16',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(267) 0:00:02.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '17',
                        IFDESCR          => '17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ef',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300752470) 34 days, 19:25:24.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '303491',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2125850',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '18',
                        IFDESCR          => '18',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(301488430) 34 days, 21:28:04.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '628838',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1380876',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '19',
                        IFDESCR          => '19',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ed',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(275) 0:00:02.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '20',
                        IFDESCR          => '20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(277) 0:00:02.77',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '21',
                        IFDESCR          => '21',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324338026) 37 days, 12:56:20.26',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1518149151',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4207532599',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:45:22:82:0c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '22',
                        IFDESCR          => '22',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ea',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(324335496) 37 days, 12:55:54.96',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '258105141',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '247033878',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:26:0b:62:8d:4e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '23',
                        IFDESCR          => '23',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(101408394) 11 days, 17:41:23.94',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '534015997',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3543015836',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '78:ac:c0:3c:ff:be',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '24',
                        IFDESCR          => '24',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(287) 0:00:02.87',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '25',
                        IFDESCR          => '25',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(290) 0:00:02.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '26',
                        IFDESCR          => '26',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(292) 0:00:02.92',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '27',
                        IFDESCR          => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(295) 0:00:02.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '28',
                        IFDESCR          => '28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(297) 0:00:02.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '29',
                        IFDESCR          => '29',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(300) 0:00:03.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '30',
                        IFDESCR          => '30',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(302) 0:00:03.02',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '31',
                        IFDESCR          => '31',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(305) 0:00:03.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '32',
                        IFDESCR          => '32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:e0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(307) 0:00:03.07',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '33',
                        IFDESCR          => '33',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(310) 0:00:03.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '34',
                        IFDESCR          => '34',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(312) 0:00:03.12',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '35',
                        IFDESCR          => '35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(315) 0:00:03.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '36',
                        IFDESCR          => '36',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(317) 0:00:03.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '37',
                        IFDESCR          => '37',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(320) 0:00:03.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '38',
                        IFDESCR          => '38',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(322) 0:00:03.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '39',
                        IFDESCR          => '39',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(325) 0:00:03.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '40',
                        IFDESCR          => '40',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(327) 0:00:03.27',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '41',
                        IFDESCR          => '41',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(330) 0:00:03.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '42',
                        IFDESCR          => '42',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(333) 0:00:03.33',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '43',
                        IFDESCR          => '43',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(335) 0:00:03.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '44',
                        IFDESCR          => '44',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(337) 0:00:03.37',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '45',
                        IFDESCR          => '45',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(340) 0:00:03.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '46',
                        IFDESCR          => '46',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(342) 0:00:03.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '47',
                        IFDESCR          => '47',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(345) 0:00:03.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '48',
                        IFDESCR          => '48',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(347) 0:00:03.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '49',
                        IFNAME           => '49',
                        IFDESCR          => '49',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:cf',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(658) 0:00:06.58',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2070631954',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1558530795',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:74:b7:91:c9',
                                    '00:00:74:b7:91:cd',
                                    '00:00:74:b7:91:db',
                                    '00:00:74:b7:3c:bb',
                                    '00:00:74:b7:3e:9b',
                                    '00:00:74:cc:5e:5c',
                                    '00:00:74:d2:e1:b4',
                                    '00:00:74:d2:09:6a',
                                    '00:00:74:e1:98:3a',
                                    '00:00:74:ee:c8:3f',
                                    '00:00:74:f2:36:2d',
                                    '00:00:74:f2:36:4c',
                                    '00:00:85:8b:a7:3d',
                                    '00:00:85:94:e4:8e',
                                    '00:00:85:dc:86:7a',
                                    '00:00:85:de:04:93',
                                    '00:00:85:e6:a0:9c',
                                    '00:00:f0:a4:e7:89',
                                    '00:00:48:cc:35:90',
                                    '00:01:96:38:a8:40',
                                    '00:0a:95:d0:19:f0',
                                    '00:0a:95:d9:37:5e',
                                    '00:0a:95:36:a8:f7',
                                    '00:0a:95:37:50:37',
                                    '00:0a:48:20:66:37',
                                    '00:64:40:0b:65:82',
                                    '00:0b:db:74:76:57',
                                    '00:0b:db:3f:2b:51',
                                    '00:0b:db:3f:31:2d',
                                    '00:0b:db:5c:be:c1',
                                    '00:0d:93:69:ae:68',
                                    '00:0d:93:79:1a:be',
                                    '00:0d:93:9e:c4:01',
                                    '00:0d:54:a9:3f:06',
                                    '00:0d:54:f7:84:94',
                                    '00:0d:54:f7:84:f4',
                                    '00:0d:54:f7:85:ea',
                                    '00:0d:54:f7:85:18',
                                    '00:0d:54:f7:86:0b',
                                    '00:0d:54:f7:86:34',
                                    '00:0d:54:f7:87:ac',
                                    '00:0d:54:f7:88:20',
                                    '00:0d:54:24:ca:b9',
                                    '00:0d:54:3c:db:72',
                                    '00:0d:54:56:f7:76',
                                    '00:0d:56:0f:0d:9b',
                                    '00:0d:56:fb:00:9b',
                                    '00:0d:56:fb:00:a8',
                                    '00:0d:56:fb:0a:a8',
                                    '00:0d:56:fb:09:ac',
                                    '00:0d:56:fd:00:03',
                                    '00:0d:60:14:a6:ae',
                                    '00:88:65:35:2e:68',
                                    '00:88:65:3a:bf:72',
                                    '00:0e:6a:cd:85:7a',
                                    '00:0e:6a:d1:56:f2',
                                    '00:0e:6a:d3:14:f9',
                                    '00:0e:6a:d3:14:fc',
                                    '00:0e:6a:d3:18:72',
                                    '00:0e:6a:d5:b9:e5',
                                    '00:0e:6a:d5:b9:54',
                                    '00:0e:6a:d5:ba:53',
                                    '00:0e:6a:d5:bb:ef',
                                    '00:0e:6a:d5:bc:13',
                                    '00:0e:e8:fa:29:16',
                                    '00:0e:35:87:c6:99',
                                    '00:90:f5:cd:20:63',
                                    '00:90:f5:d7:e2:cf',
                                    '00:0f:cb:a6:ee:dd',
                                    '00:0f:cb:a6:ee:f8',
                                    '00:0f:fe:c9:3e:a5',
                                    '00:0f:fe:f8:c3:8e',
                                    '00:0f:fe:45:ec:60',
                                    '00:0f:1f:68:4f:95',
                                    '00:0f:1f:e5:2a:db',
                                    '00:10:83:55:6b:aa',
                                    '00:10:18:96:9e:74',
                                    '00:10:18:96:9e:76',
                                    '00:10:18:34:ba:68',
                                    '00:10:18:34:ba:61',
                                    '00:11:24:84:fd:10',
                                    '00:11:24:88:11:c4',
                                    '00:11:32:19:53:8d',
                                    '00:11:09:5b:c8:fa',
                                    '00:11:09:5b:ec:b4',
                                    '00:11:09:5b:19:70',
                                    '00:b0:d0:ba:2c:d9',
                                    '00:b0:d0:be:94:6e',
                                    '00:12:79:81:2b:81',
                                    '00:12:a9:07:0d:bd',
                                    '00:12:a9:07:0d:c9',
                                    '00:12:a9:07:0d:cf',
                                    '00:12:a9:07:0d:de',
                                    '00:12:a9:07:0d:e1',
                                    '00:12:f2:7e:89:40',
                                    '00:12:3f:19:5f:35',
                                    '00:bd:3a:ee:2a:aa',
                                    '00:13:72:81:e0:d2',
                                    '00:13:72:0d:2d:55',
                                    '00:13:72:86:e4:1f',
                                    '00:13:72:12:52:92',
                                    '00:13:72:eb:e6:23',
                                    '00:13:72:28:19:3b',
                                    '00:13:95:04:5d:df',
                                    '00:13:02:6b:a5:a5',
                                    '00:13:02:7d:a1:ab',
                                    '00:13:ce:b5:7e:10',
                                    '00:13:ce:ce:e7:87',
                                    '00:13:ce:f1:a3:6d',
                                    '00:13:20:b1:31:48',
                                    '00:c0:9f:23:4e:b7',
                                    '00:c0:b7:d5:09:ac',
                                    '00:c0:b7:24:44:62',
                                    '00:c0:b7:24:4b:97',
                                    '00:c0:b7:2f:30:d9',
                                    '00:c6:10:c5:1e:cc',
                                    '00:c6:10:24:d0:47',
                                    '00:c6:10:36:59:63',
                                    '00:14:7c:46:65:be',
                                    '00:14:7c:46:65:ed',
                                    '00:14:7c:46:66:78',
                                    '00:14:7c:46:66:0f',
                                    '00:14:7c:46:66:b0',
                                    '00:14:7c:46:66:5b',
                                    '00:14:7c:46:66:63',
                                    '00:14:7c:46:67:0c',
                                    '00:14:f1:b6:ee:00',
                                    '00:14:22:b3:d8:58',
                                    '00:14:22:c1:7a:83',
                                    '00:14:22:c5:00:e5',
                                    '00:14:22:28:35:34',
                                    '00:14:22:28:38:89',
                                    '00:14:22:3a:4f:be',
                                    '00:14:22:4c:9a:f2',
                                    '00:14:22:56:41:d1',
                                    '00:14:38:a1:6f:15',
                                    '00:14:38:a6:e3:63',
                                    '00:14:38:e5:de:fd',
                                    '00:14:38:5f:24:c7',
                                    '00:14:4f:79:3e:07',
                                    '00:14:4f:f7:67:9e',
                                    '00:14:4f:20:e1:6c',
                                    '00:14:4f:20:ea:f4',
                                    '00:d0:b7:47:4b:fe',
                                    '00:15:99:5d:fa:14',
                                    '00:15:c5:5f:c7:0e',
                                    '00:15:17:17:42:7d',
                                    '00:15:17:5c:16:00',
                                    '00:15:58:7d:d0:e8',
                                    '00:db:df:21:e1:25',
                                    '00:16:b6:a0:4d:1b',
                                    '00:16:b9:a3:05:40',
                                    '00:16:cb:87:00:11',
                                    '00:16:cb:9b:85:41',
                                    '00:16:cb:9c:13:16',
                                    '00:16:cb:c9:57:2b',
                                    '00:16:d4:d1:66:d3',
                                    '00:16:3e:6f:7c:12',
                                    '00:16:3e:72:59:58',
                                    '00:16:3e:74:af:0a',
                                    '00:16:3e:76:ca:03',
                                    '00:16:3e:79:51:a3',
                                    '00:16:3e:7e:1c:5f',
                                    '00:16:3e:8b:bd:8d',
                                    '00:16:3e:96:f9:d3',
                                    '00:16:3e:9b:cf:9a',
                                    '00:16:3e:11:9f:23',
                                    '00:16:3e:ae:95:6f',
                                    '00:16:3e:bf:41:19',
                                    '00:16:3e:c2:9a:b0',
                                    '00:16:3e:c2:61:f1',
                                    '00:16:3e:c4:c6:f6',
                                    '00:16:3e:16:b9:e6',
                                    '00:16:3e:ed:c9:19',
                                    '00:16:3e:fa:93:88',
                                    '00:16:3e:fb:80:c1',
                                    '00:16:3e:fc:e8:e7',
                                    '00:16:3e:1f:98:f8',
                                    '00:16:3e:21:8a:11',
                                    '00:16:3e:22:6e:92',
                                    '00:16:3e:25:14:e1',
                                    '00:16:3e:04:28:56',
                                    '00:16:3e:2a:13:0d',
                                    '00:16:3e:2b:2a:b0',
                                    '00:16:3e:2e:b1:d9',
                                    '00:16:3e:2f:3b:39',
                                    '00:16:3e:30:37:98',
                                    '00:16:3e:3a:0c:25',
                                    '00:16:3e:3e:a6:a3',
                                    '00:16:3e:44:9f:e7',
                                    '00:16:3e:47:a4:1d',
                                    '00:16:3e:47:3d:ec',
                                    '00:16:3e:4a:e7:53',
                                    '00:16:3e:5a:bb:e1',
                                    '00:16:3e:5c:00:ee',
                                    '00:16:3e:5f:d3:90',
                                    '00:16:3e:5f:ef:ed',
                                    '00:16:44:84:17:25',
                                    '00:16:46:3f:69:b1',
                                    '00:e0:d8:16:96:a7',
                                    '00:e0:d8:16:e1:d5',
                                    '00:17:a4:09:1e:c0',
                                    '00:17:c4:99:66:a7',
                                    '00:17:c4:23:03:09',
                                    '00:17:f2:c7:5d:a2',
                                    '00:17:f2:04:76:82',
                                    '00:17:08:91:36:dd',
                                    '00:18:8b:6e:6f:72',
                                    '00:18:8b:6e:42:0a',
                                    '00:18:8b:71:dd:45',
                                    '00:18:8b:73:03:84',
                                    '00:18:8b:c9:fe:e2',
                                    '00:18:8b:cf:87:6a',
                                    '00:18:8b:cf:88:02',
                                    '00:18:8b:e7:36:58',
                                    '00:18:8b:27:9f:c3',
                                    '00:18:f3:ed:a2:46',
                                    '00:18:fe:9e:e0:37',
                                    '00:18:fe:a3:2e:d5',
                                    '00:18:fe:a8:28:00',
                                    '00:18:fe:aa:67:00',
                                    '00:18:fe:aa:68:80',
                                    '00:18:fe:aa:69:00',
                                    '00:18:fe:aa:69:80',
                                    '00:18:fe:aa:72:00',
                                    '00:18:fe:aa:77:00',
                                    '00:18:fe:aa:77:80',
                                    '00:18:fe:aa:79:80',
                                    '00:18:fe:aa:a8:80',
                                    '00:18:fe:aa:a9:00',
                                    '00:18:fe:aa:a9:80',
                                    '00:18:fe:aa:c2:80',
                                    '00:18:fe:aa:c8:80',
                                    '00:18:fe:aa:d8:00',
                                    '00:18:fe:aa:e8:80',
                                    '00:18:fe:aa:e9:00',
                                    '00:18:fe:aa:27:00',
                                    '00:18:fe:aa:49:80',
                                    '00:18:fe:aa:51:00',
                                    '00:18:fe:aa:59:00',
                                    '00:18:fe:aa:09:00',
                                    '00:18:fe:df:ba:90',
                                    '00:19:94:33:9c:d1',
                                    '00:19:99:92:b5:5e',
                                    '00:19:99:dd:b0:64',
                                    '00:19:b9:0e:db:84',
                                    '00:19:b9:10:a9:43',
                                    '00:19:bb:99:c9:c0',
                                    '00:19:bb:99:2a:c0',
                                    '00:19:d1:9c:7e:97',
                                    '00:19:db:2f:3f:8a',
                                    '00:19:db:2f:41:1e',
                                    '00:19:db:2f:42:06',
                                    '00:19:e3:3b:89:0b',
                                    '00:19:e3:06:f1:59',
                                    '00:1a:6b:d2:b7:ac',
                                    '00:1a:73:5e:aa:83',
                                    '00:1a:80:d6:fe:65',
                                    '00:1a:92:15:ca:6d',
                                    '00:1a:a0:0c:0c:f4',
                                    '00:1a:a0:79:22:42',
                                    '00:1a:a0:ca:96:74',
                                    '00:1a:a0:d1:e7:46',
                                    '00:1a:a0:16:d8:53',
                                    '00:1a:a0:de:41:69',
                                    '00:1a:a0:e0:fb:73',
                                    '00:1a:a0:e9:01:33',
                                    '00:1a:a0:e9:04:98',
                                    '00:1a:a0:eb:0f:1e',
                                    '00:1a:a0:eb:3b:c6',
                                    '00:1a:a0:eb:3b:31',
                                    '00:1a:a0:eb:3c:cc',
                                    '00:1a:a0:3e:29:0b',
                                    '00:1a:4b:15:6f:8a',
                                    '00:1a:4b:30:d2:7e',
                                    '00:1b:77:3e:71:77',
                                    '00:1b:78:0e:22:bf',
                                    '00:1b:78:18:cc:80',
                                    '00:1b:8b:a3:f9:b8',
                                    '00:1b:b1:af:e0:d8',
                                    '00:1b:b1:4e:5c:9e',
                                    '00:1b:fc:3b:50:83',
                                    '00:1b:21:7d:7d:d8',
                                    '00:1b:21:7d:7f:00',
                                    '00:1b:38:a9:2b:c2',
                                    '00:1b:3f:77:2a:00',
                                    '00:1b:63:9e:cb:5f',
                                    '00:1c:bf:9d:90:e4',
                                    '00:1c:26:19:ec:39',
                                    '00:1c:2e:90:16:00',
                                    '00:1c:2e:bb:89:00',
                                    '00:1d:b3:06:47:c0',
                                    '00:1d:b3:58:8f:00',
                                    '00:1d:b3:59:b1:80',
                                    '00:1d:b3:59:f1:00',
                                    '00:1d:b3:60:bb:00',
                                    '00:1d:b3:61:71:00',
                                    '00:1d:b3:61:71:4e',
                                    '00:1d:4f:f8:44:db',
                                    '00:1d:09:65:e0:37',
                                    '00:1d:09:0b:5b:37',
                                    '00:1d:09:0b:5b:39',
                                    '00:1d:09:13:ba:7d',
                                    '00:1d:09:16:e1:68',
                                    '00:1d:09:17:5f:7e',
                                    '00:1d:09:19:59:19',
                                    '00:1d:09:03:1c:4f',
                                    '00:1d:09:2c:f3:07',
                                    '00:03:93:6a:4e:b2',
                                    '00:03:93:e2:7b:ed',
                                    '00:03:ba:08:58:9d',
                                    '00:1e:68:9b:3e:d3',
                                    '00:1e:68:2f:4e:48',
                                    '00:1e:68:37:8d:f6',
                                    '00:1e:68:37:92:26',
                                    '00:1e:68:37:94:da',
                                    '00:1e:0b:17:21:01',
                                    '00:1e:8c:53:90:43',
                                    '00:1e:13:6e:d9:70',
                                    '00:1e:c2:14:6b:1a',
                                    '00:1e:c2:17:0d:87',
                                    '00:1e:c9:64:4e:12',
                                    '00:1e:c9:7f:94:72',
                                    '00:1e:c9:7f:19:9d',
                                    '00:1e:c9:7f:19:c8',
                                    '00:1e:c9:40:76:11',
                                    '00:1e:c9:45:14:08',
                                    '00:1e:c9:48:b4:36',
                                    '00:1e:c9:4a:b5:5d',
                                    '00:1e:c9:4a:b7:ac',
                                    '00:1e:c9:4b:0b:40',
                                    '00:1e:c9:4b:0c:df',
                                    '00:1e:c9:4b:0d:b4',
                                    '00:1e:c9:4b:0d:13',
                                    '00:1e:c9:4b:0d:3c',
                                    '00:1e:c9:4b:ec:e1',
                                    '00:1e:c9:4b:fc:57',
                                    '00:1e:c9:4c:00:a0',
                                    '00:1e:c9:4c:01:85',
                                    '00:1e:c9:4c:05:75',
                                    '00:1e:c9:4c:05:a3',
                                    '00:1e:c9:4c:06:66',
                                    '00:1e:c9:4c:06:13',
                                    '00:1e:c9:63:bc:38',
                                    '00:1e:4f:c6:0d:ad',
                                    '00:1e:4f:d8:94:27',
                                    '00:1e:4f:f4:e1:b0',
                                    '00:1e:4f:f4:e1:d8',
                                    '00:1e:4f:f4:e1:ec',
                                    '00:1e:4f:f4:e6:22',
                                    '00:1e:52:ac:bf:43',
                                    '00:1f:e1:89:8e:6b',
                                    '00:1f:f3:d2:0d:de',
                                    '00:1f:f3:55:bd:c0',
                                    '00:1f:f3:5b:07:9a',
                                    '00:1f:28:4f:ee:00',
                                    '00:1f:29:1b:ab:21',
                                    '00:1f:29:1e:7f:2a',
                                    '00:1f:29:04:84:69',
                                    '00:1f:29:04:84:75',
                                    '00:1f:29:04:84:41',
                                    '00:1f:29:04:a4:b5',
                                    '00:1f:29:04:a4:dc',
                                    '00:1f:29:04:a4:e5',
                                    '00:1f:29:04:a4:f3',
                                    '00:1f:29:04:b4:e9',
                                    '00:1f:29:04:b4:f7',
                                    '00:1f:29:04:b4:ff',
                                    '00:1f:29:04:b4:41',
                                    '00:1f:29:04:b4:43',
                                    '00:1f:29:04:c4:05',
                                    '00:1f:29:04:c6:67',
                                    '00:1f:29:04:3e:fb',
                                    '00:1f:29:2b:70:ee',
                                    '00:1f:3b:d2:80:cd',
                                    '00:1f:3c:2e:40:5e',
                                    '00:1f:5b:b7:74:e2',
                                    '00:1f:5b:e8:f1:a1',
                                    '00:1f:5b:eb:56:51',
                                    '00:1f:5b:34:8a:5c',
                                    '00:20:85:f0:2a:e3',
                                    '00:20:85:fb:43:4e',
                                    '00:20:85:fd:16:85',
                                    '00:21:00:30:5b:33',
                                    '00:21:6a:8b:22:7a',
                                    '00:21:6a:c1:7e:84',
                                    '00:21:6b:af:9c:86',
                                    '00:21:70:9f:b3:f2',
                                    '00:21:70:9f:b3:50',
                                    '00:21:70:ba:36:13',
                                    '00:21:70:be:52:9f',
                                    '00:21:70:d6:4f:45',
                                    '00:21:70:ed:74:5c',
                                    '00:21:70:f3:4a:9f',
                                    '00:21:70:1b:a7:39',
                                    '00:21:70:1b:ea:6e',
                                    '00:21:70:1c:0f:9c',
                                    '00:21:70:1c:12:47',
                                    '00:21:70:46:e1:07',
                                    '00:21:70:46:f5:33',
                                    '00:21:85:6a:3f:cc',
                                    '00:21:85:39:73:30',
                                    '00:21:9b:6e:69:6f',
                                    '00:21:9b:71:aa:ee',
                                    '00:21:9b:76:20:1d',
                                    '00:21:9b:77:59:3f',
                                    '00:21:9b:78:fc:f4',
                                    '00:21:9b:79:44:c8',
                                    '00:21:9b:79:47:91',
                                    '00:21:9b:79:4a:19',
                                    '00:21:9b:f3:ea:f5',
                                    '00:21:9b:2c:d1:e4',
                                    '00:21:9b:37:bc:3e',
                                    '00:21:9b:37:c4:16',
                                    '00:21:9b:49:24:da',
                                    '00:21:9b:4d:dd:2f',
                                    '00:21:b7:6a:0a:ce',
                                    '00:21:b7:70:ac:f7',
                                    '00:21:b7:72:19:83',
                                    '00:21:b7:96:a7:46',
                                    '00:21:b7:a2:60:1f',
                                    '00:21:b7:12:ff:37',
                                    '00:21:b7:ba:7d:72',
                                    '00:21:b7:bc:98:d3',
                                    '00:21:b7:02:25:ff',
                                    '00:21:b7:02:61:1d',
                                    '00:21:b7:cc:1d:36',
                                    '00:21:b7:cc:2d:de',
                                    '00:21:b7:dc:20:ad',
                                    '00:21:b7:ea:37:df',
                                    '00:21:b7:fc:c8:a4',
                                    '00:21:b7:22:9e:df',
                                    '00:21:b7:2a:89:37',
                                    '00:21:b7:2c:be:98',
                                    '00:21:b7:34:cd:d0',
                                    '00:21:b7:42:a3:26',
                                    '00:21:b7:42:53:8b',
                                    '00:21:b7:42:53:03',
                                    '00:21:b7:42:63:c4',
                                    '00:21:b7:5c:7c:d7',
                                    '00:21:b7:5c:c2:51',
                                    '00:21:b7:5c:02:90',
                                    '00:21:b7:5c:02:a0',
                                    '00:21:b7:5c:5c:eb',
                                    '00:21:28:58:75:dd',
                                    '00:21:5a:8b:31:21',
                                    '00:21:5a:8e:61:ea',
                                    '00:21:5a:90:d5:99',
                                    '00:21:5a:96:38:bc',
                                    '00:21:5c:73:77:25',
                                    '00:21:5d:be:fe:94',
                                    '00:21:5d:1c:4a:52',
                                    '00:21:5d:2d:91:ba',
                                    '00:21:63:c4:6f:da',
                                    '00:22:15:5d:65:e1',
                                    '00:22:19:64:a2:dc',
                                    '00:22:19:64:a9:68',
                                    '00:22:19:64:a9:60',
                                    '00:22:19:67:cd:8c',
                                    '00:22:19:67:cd:8e',
                                    '00:22:19:67:cd:94',
                                    '00:22:19:85:39:3d',
                                    '00:22:19:8b:f7:c9',
                                    '00:22:19:1a:f0:bf',
                                    '00:22:19:1a:f0:5f',
                                    '00:22:19:1f:a5:04',
                                    '00:22:19:1f:bc:22',
                                    '00:22:19:24:c7:41',
                                    '00:22:19:24:38:0a',
                                    '00:22:19:31:b6:28',
                                    '00:22:19:31:b7:ad',
                                    '00:22:19:31:b7:36',
                                    '00:22:19:31:b8:be',
                                    '00:22:19:31:b8:cf',
                                    '00:22:fa:13:86:06',
                                    '00:22:fa:4a:ec:70',
                                    '00:22:fb:6d:aa:08',
                                    '00:22:fb:5f:22:1c',
                                    '00:22:41:f9:f4:38',
                                    '00:22:41:31:4a:77',
                                    '00:22:41:3c:2e:dd',
                                    '00:23:6c:91:7b:bf',
                                    '00:23:6c:9a:ea:9b',
                                    '00:23:6c:d3:a3:8c',
                                    '00:23:7d:7d:df:81',
                                    '00:23:7d:81:ba:1c',
                                    '00:23:7d:8e:7f:9f',
                                    '00:23:7d:8f:6b:75',
                                    '00:23:8b:97:9b:60',
                                    '00:23:8b:17:20:7b',
                                    '00:23:8b:03:d0:de',
                                    '00:23:8b:57:75:03',
                                    '00:23:8b:57:75:1f',
                                    '00:23:ae:70:df:a1',
                                    '00:23:ae:71:bf:1c',
                                    '00:23:ae:71:bf:2a',
                                    '00:23:ae:71:c0:7b',
                                    '00:23:ae:71:c0:37',
                                    '00:23:ae:71:c3:07',
                                    '00:23:ae:74:6b:2c',
                                    '00:23:ae:74:72:a7',
                                    '00:23:ae:74:7b:b2',
                                    '00:23:ae:74:7f:71',
                                    '00:23:ae:74:7f:f0',
                                    '00:23:ae:74:7f:fd',
                                    '00:23:ae:74:82:84',
                                    '00:23:ae:74:82:5f',
                                    '00:23:ae:74:aa:0f',
                                    '00:23:ae:7a:08:1c',
                                    '00:23:ae:7c:33:9c',
                                    '00:23:ae:ad:29:63',
                                    '00:23:ae:eb:d5:d4',
                                    '00:23:ae:fb:dc:34',
                                    '00:23:ae:fb:fb:80',
                                    '00:23:ae:fe:17:74',
                                    '00:23:12:11:2b:46',
                                    '00:23:12:22:19:6b',
                                    '00:23:12:08:18:65',
                                    '00:23:df:8c:75:7e',
                                    '00:23:24:26:e8:14',
                                    '00:23:24:33:bc:d2',
                                    '00:23:32:92:8a:b6',
                                    '00:23:32:9e:bb:4b',
                                    '00:23:32:9e:d5:8a',
                                    '00:23:32:9e:d5:c0',
                                    '00:23:4e:ac:61:d0',
                                    '00:23:54:91:3a:7f',
                                    '00:24:81:0b:96:48',
                                    '00:24:81:42:42:42',
                                    '00:24:be:95:2d:06',
                                    '00:24:be:42:3b:02',
                                    '00:24:d2:69:76:91',
                                    '00:24:d2:df:af:82',
                                    '00:24:d6:ad:cd:30',
                                    '00:24:d6:2d:d8:6c',
                                    '00:24:d6:32:2d:30',
                                    '00:24:d6:37:73:0c',
                                    '00:24:d7:71:63:14',
                                    '00:24:d7:76:f8:40',
                                    '00:24:d7:5c:2d:c4',
                                    '00:24:e8:0c:23:a9',
                                    '00:24:e8:aa:e3:3e',
                                    '00:24:e8:d7:0b:66',
                                    '00:24:e8:d8:1c:67',
                                    '00:24:e8:fc:10:ff',
                                    '00:24:e8:1b:cc:70',
                                    '00:24:e8:1d:9d:6a',
                                    '00:24:e8:1d:9d:03',
                                    '00:24:e8:1d:9e:bd',
                                    '00:24:e8:1d:9e:d4',
                                    '00:24:e8:1d:9f:fc',
                                    '00:24:e8:1d:48:a9',
                                    '00:24:e8:36:20:15',
                                    '00:24:e8:06:75:5d',
                                    '00:24:e8:3c:f5:55',
                                    '00:24:e8:3f:e0:d6',
                                    '00:24:e8:3f:e0:d8',
                                    '00:24:e8:46:d9:55',
                                    '00:24:e8:46:ed:38',
                                    '00:24:e8:48:e5:99',
                                    '00:24:36:b8:ce:e5',
                                    '00:24:36:e8:d2:76',
                                    '00:24:36:f5:09:90',
                                    '00:25:00:ef:13:b1',
                                    '00:25:00:ef:60:94',
                                    '00:25:00:42:a0:83',
                                    '00:25:64:e8:89:90',
                                    '00:25:64:e8:8c:be',
                                    '00:25:64:e8:8d:9f',
                                    '00:25:64:e8:90:8f',
                                    '00:25:64:e8:90:4f',
                                    '00:25:64:e8:91:e7',
                                    '00:25:64:e8:91:33',
                                    '00:25:b3:f1:68:bd',
                                    '00:25:45:22:88:12',
                                    '00:25:4b:8b:46:e6',
                                    '00:25:4b:fc:95:cf',
                                    '00:26:73:0e:e8:17',
                                    '00:26:73:0e:fb:c9',
                                    '00:26:73:12:13:52',
                                    '00:26:73:13:dc:e7',
                                    '00:26:73:13:ec:5e',
                                    '00:26:73:1e:01:98',
                                    '00:26:73:29:4a:8e',
                                    '00:26:73:2a:58:0f',
                                    '00:26:73:2b:78:9b',
                                    '00:26:73:2b:79:86',
                                    '00:26:73:2b:79:9f',
                                    '00:26:73:2b:a6:a2',
                                    '00:26:73:2b:a6:f9',
                                    '00:26:73:31:74:cb',
                                    '00:26:73:45:e9:76',
                                    '00:26:73:49:e0:c0',
                                    '00:26:73:4a:0d:e4',
                                    '00:26:b0:da:16:ba',
                                    '00:26:b0:e6:bf:9e',
                                    '00:26:b6:3e:b5:e5',
                                    '00:26:b9:85:dd:7e',
                                    '00:26:b9:a4:05:45',
                                    '00:26:b9:b9:71:92',
                                    '00:26:b9:b9:73:06',
                                    '00:26:b9:bc:b1:ad',
                                    '00:26:b9:bc:bf:a0',
                                    '00:26:b9:db:25:a0',
                                    '00:26:bb:67:df:00',
                                    '00:26:bb:6c:69:d3',
                                    '00:26:bb:13:1d:b1',
                                    '00:26:bb:1d:83:4c',
                                    '00:26:bb:03:b5:bd',
                                    '00:26:bb:04:06:07',
                                    '00:26:bb:63:17:2a',
                                    '00:26:c7:21:03:72',
                                    '00:26:cb:10:1f:c0',
                                    '00:26:cb:10:2e:b0',
                                    '00:26:cb:10:2e:c0',
                                    '00:26:cb:10:30:10',
                                    '00:26:cb:10:3a:20',
                                    '00:26:cb:10:3b:d0',
                                    '00:26:cb:10:40:30',
                                    '00:26:cb:10:42:80',
                                    '00:26:cb:11:05:00',
                                    '00:26:cb:b8:bf:f0',
                                    '00:26:cb:1b:c0:60',
                                    '00:26:cb:1b:c2:00',
                                    '00:26:cb:1d:79:a0',
                                    '00:26:cb:1d:7a:f0',
                                    '00:26:cb:1d:7c:e0',
                                    '00:26:cb:1d:7d:b0',
                                    '00:26:cb:1d:7d:c0',
                                    '00:26:cb:1d:7e:20',
                                    '00:26:cb:1d:7f:10',
                                    '00:26:cb:1d:92:30',
                                    '00:26:cb:1d:97:00',
                                    '00:26:cb:1d:9e:70',
                                    '00:26:cb:1d:a1:30',
                                    '00:26:cb:1d:a3:70',
                                    '00:26:cb:1d:aa:00',
                                    '00:26:cb:1d:ab:30',
                                    '00:26:cb:1d:59:60',
                                    '00:26:4a:08:cc:ce',
                                    '00:26:08:e1:6b:31',
                                    '00:26:08:e4:35:06',
                                    '00:26:55:48:a3:b3',
                                    '00:26:5e:70:43:c6',
                                    '00:27:10:e0:5e:48',
                                    '00:04:00:16:bf:e1',
                                    '00:04:00:16:38:9f',
                                    '00:04:00:de:da:e4',
                                    '00:04:00:f6:22:6c',
                                    '00:04:00:41:9e:3f',
                                    '00:04:75:82:55:64',
                                    '00:30:6e:1d:84:81',
                                    '00:30:48:27:28:2e',
                                    '00:30:48:42:41:27',
                                    '00:30:48:42:56:57',
                                    '00:30:48:57:ad:6a',
                                    '00:30:48:57:ad:cc',
                                    '00:30:48:5f:a7:54',
                                    '00:05:1a:66:58:40',
                                    '00:07:e9:06:f7:0d',
                                    '00:08:74:b2:d3:0a',
                                    '00:08:74:eb:9a:10',
                                    '00:08:74:fa:51:81',
                                    '00:08:74:22:20:9b',
                                    '00:08:02:bc:da:92',
                                    '00:50:da:d6:1f:5f',
                                    '00:50:56:a9:66:d5',
                                    '00:50:56:a9:6a:b9',
                                    '00:50:56:a9:14:30',
                                    '00:50:56:a9:31:2f',
                                    '00:50:56:a9:35:22',
                                    '00:50:56:a9:41:4c',
                                    '00:50:56:a9:45:f7',
                                    '00:50:56:a9:4d:64',
                                    '00:50:56:a9:4f:9c',
                                    '00:50:56:a9:4f:3a',
                                    '00:50:56:a9:5c:95',
                                    '00:50:56:b4:c8:28',
                                    '00:50:56:b4:30:d3',
                                    '00:50:56:b4:4c:67',
                                    '00:50:60:02:2f:e6',
                                    '00:09:3d:13:74:a0',
                                    '00:60:9f:80:06:14',
                                    '64:a3:cb:c3:b5:c3',
                                    '64:b9:e8:b9:b4:c8',
                                    '64:b9:e8:bd:11:c2',
                                    '64:b9:e8:c7:4d:68',
                                    '64:31:50:75:a0:48',
                                    '64:31:50:29:a7:c4',
                                    '68:94:23:6d:74:f3',
                                    '68:9c:70:aa:0f:d0',
                                    '68:9c:5e:2c:12:08',
                                    '68:a3:c4:43:57:70',
                                    '68:a8:6d:0b:74:e2',
                                    '68:a8:6d:23:a6:b0',
                                    '68:a8:6d:23:b5:b2',
                                    '68:a8:6d:34:8f:c4',
                                    '68:a8:6d:4a:c5:b2',
                                    '68:b5:99:90:3c:b2',
                                    '68:5b:35:7b:96:4e',
                                    '68:5d:43:0b:84:6b',
                                    '68:5d:43:0b:19:18',
                                    '6c:71:d9:6b:02:0a',
                                    '6c:71:d9:70:5f:32',
                                    '6c:71:d9:7f:fb:36',
                                    '6c:71:d9:80:49:6a',
                                    '6c:9c:ed:ec:22:e0',
                                    '6c:c2:6b:79:f6:ed',
                                    '6c:3e:6d:74:05:1e',
                                    '6c:3e:6d:98:74:66',
                                    '6c:3e:6d:37:67:06',
                                    '70:71:bc:b9:30:15',
                                    '70:11:24:8c:64:a5',
                                    '70:f1:a1:ca:c0:a8',
                                    '70:f3:95:e7:7c:65',
                                    '70:f9:27:c7:a9:a3',
                                    '70:56:81:93:45:c9',
                                    '70:56:81:ab:56:db',
                                    '74:a7:22:de:b9:56',
                                    '74:d0:2b:91:7c:55',
                                    '74:de:2b:2b:c1:69',
                                    '74:f0:6d:0a:1e:cd',
                                    '74:f0:6d:51:c4:34',
                                    '74:2f:68:8c:32:8d',
                                    '74:2f:68:ed:13:f8',
                                    '74:2f:68:2e:09:19',
                                    '74:2f:68:53:0a:13',
                                    '74:45:8a:67:6d:ad',
                                    '74:45:8a:53:cf:6d',
                                    '0c:74:c2:75:b8:4e',
                                    '0c:82:68:ad:2d:da',
                                    '0c:84:dc:9d:f6:4f',
                                    '0c:ee:e6:9f:09:0b',
                                    '0c:ee:e6:d5:ce:b4',
                                    '78:84:3c:30:37:37',
                                    '78:92:9c:95:38:a6',
                                    '78:92:9c:22:1e:e4',
                                    '78:92:9c:3d:6b:ba',
                                    '78:a1:06:2b:6c:83',
                                    '78:ac:c0:8f:89:53',
                                    '78:ac:c0:8f:63:b9',
                                    '78:ca:39:ae:e4:58',
                                    '78:ca:39:b7:1c:41',
                                    '78:ca:39:fe:3c:07',
                                    '78:d6:f0:b0:6d:64',
                                    '78:e4:00:0b:f5:4a',
                                    '78:e4:00:f4:ee:16',
                                    '78:1f:db:ac:93:66',
                                    '78:2b:cb:85:ff:81',
                                    '78:2b:cb:86:1b:11',
                                    '78:2b:cb:86:08:33',
                                    '78:2b:cb:98:c2:84',
                                    '78:2b:cb:98:c4:88',
                                    '78:2b:cb:98:c5:e9',
                                    '78:2b:cb:98:c6:ae',
                                    '78:2b:cb:98:c6:e9',
                                    '78:2b:cb:98:c6:fd',
                                    '78:2b:cb:98:c7:80',
                                    '78:2b:cb:98:c7:19',
                                    '78:2b:cb:98:c8:69',
                                    '78:2b:cb:98:24:86',
                                    '78:2b:cb:9a:15:14',
                                    '78:2b:cb:9a:18:8c',
                                    '78:2b:cb:9a:1a:da',
                                    '78:2b:cb:9e:86:a7',
                                    '78:2b:cb:9e:95:9d',
                                    '78:2b:cb:9e:96:38',
                                    '78:2b:cb:9e:b7:75',
                                    '78:2b:cb:9e:ca:b8',
                                    '78:2b:cb:9e:cb:3c',
                                    '78:2b:cb:b4:58:fa',
                                    '78:2b:cb:21:81:ab',
                                    '78:2b:cb:21:81:ad',
                                    '78:2b:cb:35:e7:b3',
                                    '78:2b:cb:60:2c:d6',
                                    '78:2b:cb:60:2c:d8',
                                    '78:2b:cb:60:34:44',
                                    '78:2b:cb:60:34:46',
                                    '7c:11:be:90:77:39',
                                    '7c:11:be:d1:3c:7f',
                                    '7c:c5:37:23:c0:a1',
                                    '7c:d1:c3:97:e5:c4',
                                    '7c:d1:c3:9b:96:be',
                                    '7c:d1:c3:40:b2:70',
                                    '7c:e9:d3:7e:cf:09',
                                    '7c:e9:d3:8c:07:d4',
                                    '7c:61:93:32:b5:10',
                                    '80:c1:6e:df:00:d9',
                                    '80:49:71:10:b8:db',
                                    '84:7a:88:81:81:b1',
                                    '84:8f:69:d5:ff:1a',
                                    '84:8f:69:ef:b7:4b',
                                    '84:8f:69:f1:d5:2d',
                                    '84:a6:c8:da:1d:cb',
                                    '84:fc:fe:cd:52:43',
                                    '84:2b:2b:9a:69:e0',
                                    '84:2b:2b:9b:d3:e1',
                                    '84:2b:2b:b1:69:8b',
                                    '84:2b:2b:bb:34:bb',
                                    '84:2b:2b:bb:4e:74',
                                    '84:2b:2b:bb:4e:25',
                                    '84:2b:2b:60:0e:cb',
                                    '84:38:35:54:50:1c',
                                    '84:3a:4b:7d:02:38',
                                    '84:4b:f5:16:e2:99',
                                    '84:4b:f5:29:b0:bb',
                                    '84:51:81:8c:43:a8',
                                    '88:c6:63:dc:ca:e3',
                                    '88:f0:77:59:83:8c',
                                    '88:1f:a1:0f:74:46',
                                    '88:1f:a1:18:dd:1a',
                                    '88:30:8a:25:a8:88',
                                    '88:32:9b:bc:83:10',
                                    '88:32:9b:e6:b1:5c',
                                    '88:53:95:9f:b0:08',
                                    '88:53:2e:30:b4:61',
                                    '8c:7b:9d:d5:d0:a4',
                                    '8c:89:a5:e1:2c:4e',
                                    '8c:fa:ba:4d:e8:6a',
                                    '8c:2d:aa:45:3e:c7',
                                    '90:84:0d:57:15:ea',
                                    '90:b1:1c:7d:98:0d',
                                    '90:b1:1c:7d:98:bb',
                                    '90:b1:1c:7d:98:5b',
                                    '90:b1:1c:7d:9b:8a',
                                    '90:b1:1c:7e:0d:9a',
                                    '90:b1:1c:7e:0d:aa',
                                    '90:b1:1c:7e:0f:5c',
                                    '90:b1:1c:82:f9:9f',
                                    '90:b1:1c:a5:18:cf',
                                    '90:b1:1c:a5:1e:37',
                                    '90:b1:1c:14:62:46',
                                    '90:b1:1c:f6:ad:e7',
                                    '90:b1:1c:44:48:e3',
                                    '90:18:7c:5f:7d:c3',
                                    '90:27:e4:fe:d9:4e',
                                    '90:4c:e5:8a:67:07',
                                    '90:4c:e5:1b:9c:05',
                                    '94:71:ac:f9:d0:8a',
                                    '94:d7:71:0f:10:f4',
                                    '98:0c:82:8c:8d:a9',
                                    '98:0c:82:15:33:2d',
                                    '98:0c:82:56:2c:50',
                                    '98:d6:bb:70:0e:08',
                                    '98:d6:bb:ae:2d:01',
                                    '98:d6:bb:cf:71:4b',
                                    '98:fe:94:3f:b9:36',
                                    '98:fe:94:41:ce:64',
                                    '98:fe:94:49:ea:04',
                                    '98:fe:94:59:5a:f9',
                                    '98:4b:e1:39:9e:a9',
                                    '98:52:b1:e2:28:bb',
                                    '9c:8e:99:87:eb:3a',
                                    '9c:b7:0d:3c:65:0a',
                                    '9c:2a:70:23:55:cd',
                                    '9c:2a:70:25:52:d9',
                                    '10:0b:a9:50:e2:f0',
                                    '10:0b:a9:52:72:94',
                                    '10:0b:a9:52:72:c0',
                                    '10:93:e9:0e:a4:78',
                                    '10:93:e9:04:7d:3c',
                                    '10:9a:dd:66:54:b1',
                                    '10:9a:dd:70:88:b3',
                                    '10:9a:dd:a1:f4:c0',
                                    '10:9a:dd:27:8d:8b',
                                    '10:9a:dd:44:a9:fe',
                                    '10:9a:dd:4b:47:64',
                                    '10:9a:dd:59:c2:84',
                                    '10:9a:dd:5d:cc:57',
                                    '10:9a:dd:5d:f3:a6',
                                    '10:9a:dd:5e:94:4b',
                                    '10:bf:48:e0:80:d8',
                                    '10:dd:b1:ad:b0:06',
                                    '10:dd:b1:bd:18:ba',
                                    '10:1c:0c:9f:9e:87',
                                    '10:1c:0c:28:32:91',
                                    '10:1f:74:0e:4a:f6',
                                    '10:40:f3:7c:30:6a',
                                    '10:40:f3:7c:40:8a',
                                    '10:40:f3:84:0d:86',
                                    '10:40:f3:86:62:02',
                                    '10:40:f3:98:36:56',
                                    '10:40:f3:f0:20:78',
                                    '10:60:4b:18:11:81',
                                    '10:60:4b:1a:6c:a6',
                                    'a0:6c:ec:6f:ea:16',
                                    'a0:82:1f:6c:55:99',
                                    'a0:f3:c1:fb:cd:0d',
                                    'a0:f3:c1:09:1c:30',
                                    'a0:f4:50:ef:81:cf',
                                    'a0:42:3f:01:97:7d',
                                    'a4:67:06:ba:8c:55',
                                    'a4:ba:db:f6:ab:b8',
                                    'a4:ba:db:f6:ad:cb',
                                    'a4:ba:db:f6:ad:cf',
                                    'a4:ba:db:f6:ae:86',
                                    'a4:ba:db:f6:ae:f2',
                                    'a4:ba:db:f6:ae:40',
                                    'a4:ba:db:f6:af:7c',
                                    'a4:ba:db:f6:af:7f',
                                    'a4:ba:db:f6:af:ea',
                                    'a4:ba:db:f6:af:fd',
                                    'a4:ba:db:f6:b0:82',
                                    'a4:ba:db:f6:b1:44',
                                    'a4:ba:db:f7:bb:ce',
                                    'a4:ba:db:f7:bb:54',
                                    'a4:ba:db:f8:0f:54',
                                    'a4:ba:db:f8:10:ec',
                                    'a4:ba:db:f8:11:de',
                                    'a4:ba:db:f8:12:a8',
                                    'a4:ba:db:f8:13:e4',
                                    'a4:d1:d2:0a:da:a0',
                                    'a4:17:31:1a:fc:df',
                                    'a4:17:31:09:9c:a7',
                                    'a6:72:d6:09:0c:8b',
                                    'a8:fa:d8:e5:a3:9a',
                                    'a8:20:66:0e:41:10',
                                    'a8:20:66:27:73:62',
                                    'a8:20:66:2c:d5:f1',
                                    'a8:20:66:2f:c4:02',
                                    'a8:20:66:38:dd:85',
                                    'a8:20:66:4f:de:c7',
                                    'ac:72:89:77:a9:4d',
                                    'ac:3c:0b:de:42:e0',
                                    'b0:65:bd:54:d3:71',
                                    'b4:74:9f:ae:f1:1f',
                                    'b4:99:ba:d7:54:30',
                                    'b4:b5:2f:af:88:c8',
                                    'b4:b5:2f:13:b4:8e',
                                    'b4:b5:2f:c3:b1:0a',
                                    'b4:b5:2f:f2:72:e0',
                                    'b4:b6:76:ac:14:35',
                                    'b4:b6:76:08:33:51',
                                    'b4:f0:ab:7e:bb:14',
                                    'b4:f0:ab:b4:50:11',
                                    'b4:07:f9:a5:03:b5',
                                    'b8:70:f4:77:b1:df',
                                    'b8:76:3f:26:05:a9',
                                    'b8:78:2e:84:9b:56',
                                    'b8:8d:12:00:2a:d6',
                                    'b8:8d:12:13:7d:80',
                                    'b8:8d:12:14:c3:26',
                                    'b8:8d:12:1b:df:e0',
                                    'b8:8d:12:1b:e0:62',
                                    'b8:8d:12:1b:e1:f0',
                                    'b8:8d:12:2e:60:06',
                                    'b8:8d:12:39:81:52',
                                    'b8:8d:12:08:0f:e0',
                                    'b8:8d:12:53:98:19',
                                    'b8:8d:12:54:54:55',
                                    'b8:ac:6f:81:b0:c8',
                                    'b8:ac:6f:0d:4a:d9',
                                    'b8:ac:6f:91:b2:e8',
                                    'b8:ac:6f:91:b4:c5',
                                    'b8:ac:6f:92:91:9f',
                                    'b8:ac:6f:95:d8:44',
                                    'b8:ac:6f:9c:bc:3e',
                                    'b8:ac:6f:a1:a4:04',
                                    'b8:ac:6f:28:c1:b8',
                                    'b8:ac:6f:44:5c:b3',
                                    'b8:c7:5d:c9:6d:00',
                                    'b8:c7:5d:ce:6b:4c',
                                    'b8:ca:3a:8c:71:cd',
                                    'b8:ca:3a:8c:76:6b',
                                    'b8:ca:3a:9e:65:2b',
                                    'b8:ca:3a:9e:0e:ab',
                                    'b8:ca:3a:9e:0e:b3',
                                    'b8:ca:3a:9e:0e:ba',
                                    'b8:ca:3a:9e:0e:d6',
                                    'b8:ca:3a:9e:0e:04',
                                    'b8:ca:3a:9e:0e:52',
                                    'b8:ca:3a:9e:0e:53',
                                    'b8:ca:3a:9e:13:85',
                                    'b8:ca:3a:9e:13:c5',
                                    'b8:ca:3a:9e:13:f7',
                                    'b8:ca:3a:9e:ce:6d',
                                    'b8:ca:3a:9e:44:3d',
                                    'b8:ca:3a:9e:45:76',
                                    'b8:ca:3a:9e:46:89',
                                    'b8:ca:3a:9e:46:41',
                                    'b8:ca:3a:9e:47:95',
                                    'b8:ca:3a:9e:49:ad',
                                    'b8:ca:3a:9e:49:4e',
                                    'b8:ca:3a:9e:4a:10',
                                    'b8:ca:3a:d3:6f:8f',
                                    'b8:ca:3a:d6:3e:7b',
                                    'bc:30:5b:dd:64:a9',
                                    'bc:30:5b:dd:64:b1',
                                    'bc:30:5b:e0:17:78',
                                    'bc:30:5b:e0:17:9f',
                                    'bc:30:5b:e6:a6:28',
                                    'bc:30:5b:ef:32:ea',
                                    'bc:3b:af:0e:e5:a1',
                                    'c0:65:99:97:78:3f',
                                    'c0:18:85:bb:e1:e3',
                                    'c4:0a:cb:65:9b:c0',
                                    'c4:0a:cb:65:b7:60',
                                    'c4:0a:cb:65:f0:20',
                                    'c4:0a:cb:a4:1c:c0',
                                    'c4:0a:cb:b2:2d:d0',
                                    'c4:0a:cb:24:70:00',
                                    'c4:0a:cb:24:73:80',
                                    'c4:0a:cb:24:43:10',
                                    'c4:0a:cb:24:47:80',
                                    'c4:0a:cb:24:47:60',
                                    'c4:0a:cb:24:49:b0',
                                    'c4:0a:cb:24:4b:90',
                                    'c4:0a:cb:24:54:80',
                                    'c4:0a:cb:2c:0d:30',
                                    'c4:0a:cb:2c:2a:e0',
                                    'c4:0a:cb:2c:2d:90',
                                    'c4:0a:cb:2c:05:e0',
                                    'c4:0a:cb:2c:09:c0',
                                    'c4:0a:cb:5d:ee:80',
                                    'c4:64:13:0f:8b:03',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                    'c4:6a:b7:6b:ee:fe',
                                    'c4:85:08:31:52:6d',
                                    'c4:17:fe:a6:ed:b7',
                                    'c4:2c:03:17:2a:97',
                                    'c4:2c:03:1e:ee:ae',
                                    'c4:2c:03:1f:b4:0f',
                                    'c4:2c:03:2e:96:48',
                                    'c4:2c:03:30:e6:d5',
                                    'c4:2c:03:32:39:43',
                                    'c4:46:19:1b:8f:48',
                                    '14:8f:c6:be:89:49',
                                    '14:8f:c6:4a:ff:a2',
                                    '14:8f:c6:4b:97:91',
                                    '14:10:9f:d0:cb:3b',
                                    '14:10:9f:d8:51:c1',
                                    '14:10:9f:dd:04:cf',
                                    '14:10:9f:e5:1c:4b',
                                    '14:10:9f:e9:eb:e2',
                                    '14:10:9f:f2:ac:e0',
                                    '14:10:9f:f4:0d:1e',
                                    '14:fe:b5:de:19:67',
                                    '14:fe:b5:f0:9f:57',
                                    '14:fe:b5:f0:9f:5e',
                                    '14:5a:05:c9:ab:98',
                                    '14:5a:05:21:20:b6',
                                    'c8:bc:c8:91:36:ac',
                                    'c8:bc:c8:94:cf:65',
                                    'c8:bc:c8:9b:22:77',
                                    'c8:bc:c8:9b:30:36',
                                    'c8:bc:c8:a2:31:9b',
                                    'c8:bc:c8:d9:7f:53',
                                    'c8:bc:c8:d9:63:1a',
                                    'c8:f7:33:a6:6b:e3',
                                    'c8:19:f7:ee:b7:95',
                                    'c8:2a:14:00:a4:e6',
                                    'c8:2a:14:0b:83:88',
                                    'c8:2a:14:12:70:0d',
                                    'c8:2a:14:17:d8:4e',
                                    'c8:2a:14:3e:9a:19',
                                    'c8:2a:14:4f:5f:41',
                                    'cc:af:78:c6:a5:a1',
                                    'cc:af:78:cf:c1:49',
                                    'cc:52:af:5e:a7:dc',
                                    'd0:67:e5:39:e6:48',
                                    'd0:67:e5:3d:0d:58',
                                    'd0:b3:3f:68:10:d6',
                                    'd0:b3:3f:9a:c1:1c',
                                    'd0:b3:3f:a6:b5:70',
                                    'd0:b3:3f:f5:ba:88',
                                    'd0:df:9a:5b:b3:55',
                                    'd4:85:64:14:42:10',
                                    'd4:9a:20:72:73:0d',
                                    'd4:9a:20:d6:a5:90',
                                    'd4:9a:20:57:16:45',
                                    'd4:a0:2a:10:38:c0',
                                    'd4:ae:52:84:24:5e',
                                    'd4:ae:52:84:24:60',
                                    'd4:ae:52:ba:a2:64',
                                    'd4:ae:52:ba:a2:6d',
                                    'd4:ae:52:bc:06:c0',
                                    'd4:ae:52:e5:70:61',
                                    'd4:ae:52:e5:72:47',
                                    'd4:be:d9:00:42:aa',
                                    'd4:be:d9:6b:0d:cf',
                                    'd4:be:d9:6b:ee:91',
                                    'd4:be:d9:6e:65:fc',
                                    'd4:be:d9:71:03:43',
                                    'd4:be:d9:74:3a:a7',
                                    'd4:be:d9:74:3a:e3',
                                    'd4:be:d9:7a:37:cb',
                                    'd4:be:d9:7d:26:a0',
                                    'd4:be:d9:7f:50:54',
                                    'd4:be:d9:86:23:e9',
                                    'd4:be:d9:8f:25:83',
                                    'd4:be:d9:8f:34:91',
                                    'd4:be:d9:8f:35:b2',
                                    'd4:be:d9:8f:35:e7',
                                    'd4:be:d9:91:ef:17',
                                    'd4:be:d9:91:ef:36',
                                    'd4:be:d9:91:f1:6a',
                                    'd4:be:d9:91:25:c4',
                                    'd4:be:d9:91:25:d5',
                                    'd4:be:d9:91:25:fb',
                                    'd4:be:d9:91:25:fd',
                                    'd4:be:d9:91:26:01',
                                    'd4:be:d9:91:26:0b',
                                    'd4:be:d9:91:26:85',
                                    'd4:be:d9:91:26:91',
                                    'd4:be:d9:91:26:9f',
                                    'd4:be:d9:91:26:e4',
                                    'd4:be:d9:91:26:f2',
                                    'd4:be:d9:91:26:fe',
                                    'd4:be:d9:91:26:03',
                                    'd4:be:d9:91:26:22',
                                    'd4:be:d9:91:26:04',
                                    'd4:be:d9:91:26:2d',
                                    'd4:be:d9:91:26:49',
                                    'd4:be:d9:91:26:5c',
                                    'd4:be:d9:91:26:61',
                                    'd4:be:d9:91:27:02',
                                    'd4:be:d9:91:27:08',
                                    'd4:be:d9:92:00:fd',
                                    'd4:be:d9:92:02:87',
                                    'd4:be:d9:92:02:95',
                                    'd4:be:d9:97:d4:24',
                                    'd4:be:d9:18:19:98',
                                    'd4:be:d9:18:1b:5a',
                                    'd4:be:d9:03:75:d8',
                                    'd4:be:d9:28:d6:f3',
                                    'd4:be:d9:2c:9c:e6',
                                    'd4:be:d9:07:e0:7f',
                                    'd8:d3:85:e8:4a:bf',
                                    'd8:24:bd:d5:1c:b0',
                                    'd8:24:bd:d5:2d:c0',
                                    'd8:24:bd:d5:33:f0',
                                    'd8:24:bd:d5:40:a0',
                                    'd8:24:bd:d5:41:80',
                                    'd8:24:bd:d5:44:d0',
                                    'd8:24:bd:d5:4a:c0',
                                    'd8:24:bd:d5:4c:c0',
                                    'd8:24:bd:d5:4c:20',
                                    'd8:24:bd:d5:50:30',
                                    'd8:24:bd:d5:51:00',
                                    'd8:24:bd:d5:51:b0',
                                    'd8:24:bd:d5:51:f0',
                                    'd8:24:bd:d5:52:c0',
                                    'd8:24:bd:d5:55:d0',
                                    'd8:24:bd:d5:58:40',
                                    'd8:24:bd:d5:5f:70',
                                    'd8:24:bd:d5:5f:50',
                                    'd8:24:bd:d5:60:b0',
                                    'd8:24:bd:d5:63:60',
                                    'd8:24:bd:e8:d4:10',
                                    'd8:24:bd:e8:e0:b0',
                                    'd8:24:bd:e8:e0:e0',
                                    'd8:24:bd:e8:ea:d0',
                                    'd8:24:bd:e8:f2:60',
                                    'd8:24:bd:e8:f5:60',
                                    'd8:24:bd:e8:f7:a0',
                                    'd8:24:bd:e9:00:00',
                                    'd8:24:bd:e9:0d:a0',
                                    'd8:24:bd:e9:82:40',
                                    'd8:24:bd:e9:11:50',
                                    'd8:24:bd:e9:14:70',
                                    'd8:24:bd:e9:14:b0',
                                    'd8:24:bd:e9:16:f0',
                                    'd8:24:bd:e9:18:a0',
                                    'd8:24:bd:e9:f5:b0',
                                    'd8:30:62:47:df:cf',
                                    'd8:30:62:48:06:bd',
                                    'd8:30:62:5e:1c:19',
                                    'd8:30:62:61:b9:18',
                                    '16:24:6e:a9:1f:07',
                                    'dc:85:de:0f:d2:25',
                                    'e0:b9:a5:ac:e6:6b',
                                    'e0:db:55:08:12:35',
                                    'e0:f8:47:10:85:1a',
                                    'e0:f8:47:a4:84:96',
                                    'e0:f8:47:19:58:32',
                                    'e0:f8:47:40:f9:de',
                                    'e0:f8:47:5f:8f:0a',
                                    'e0:06:e6:8a:02:b6',
                                    'e0:5f:b9:55:90:81',
                                    'e4:ce:8f:0c:a2:96',
                                    'e4:ce:8f:0f:7c:c8',
                                    'e4:ce:8f:20:49:5a',
                                    'e4:ce:8f:36:81:40',
                                    'e4:ce:8f:36:60:0c',
                                    'e4:ce:8f:3c:b3:b6',
                                    'e4:d5:3d:68:e0:02',
                                    'e4:d5:3d:96:42:3a',
                                    'e8:8d:28:55:d2:5d',
                                    'e8:99:c4:b6:37:20',
                                    'e8:99:c4:bd:ea:2c',
                                    'e8:11:32:6f:ba:51',
                                    'e8:39:df:95:9d:22',
                                    'e8:06:88:a4:22:6f',
                                    'e8:3e:b6:9f:b4:85',
                                    'ec:85:2f:a5:dc:13',
                                    'ec:9a:74:fc:0d:08',
                                    'ec:9a:74:30:c1:5e',
                                    'ec:55:f9:36:17:22',
                                    '18:a9:05:1e:d7:d5',
                                    '18:03:73:0a:88:55',
                                    '18:03:73:0a:20:57',
                                    '18:03:73:0a:42:f9',
                                    '18:03:73:0a:44:d8',
                                    '18:03:73:b8:cd:26',
                                    '18:03:73:b8:ee:45',
                                    '18:03:73:b9:0d:97',
                                    '18:03:73:bb:68:8f',
                                    '18:03:73:bb:69:0c',
                                    '18:03:73:bb:6a:6c',
                                    '18:03:73:bb:6a:39',
                                    '18:03:73:bb:6b:a1',
                                    '18:03:73:bb:6b:ff',
                                    '18:03:73:bb:6c:b1',
                                    '18:03:73:bb:6c:c9',
                                    '18:03:73:bb:6e:c2',
                                    '18:03:73:bb:54:78',
                                    '18:03:73:ca:52:98',
                                    '18:03:73:cd:8c:a1',
                                    '18:03:73:cd:1b:14',
                                    '18:03:73:ce:2e:25',
                                    '18:03:73:da:7d:57',
                                    '18:03:73:18:e4:bb',
                                    '18:03:73:18:ec:a2',
                                    '18:03:73:18:ef:2a',
                                    '18:03:73:18:f4:7e',
                                    '18:03:73:18:f5:57',
                                    '18:03:73:18:f6:ea',
                                    '18:03:73:18:fb:35',
                                    '18:03:73:19:46:0d',
                                    '18:03:73:1a:0f:50',
                                    '18:03:73:30:56:1b',
                                    '18:03:73:30:57:7e',
                                    '18:03:73:3d:45:00',
                                    '18:03:73:46:87:5e',
                                    '18:03:73:09:65:56',
                                    '18:03:73:09:65:57',
                                    '18:03:73:09:d0:a2',
                                    '18:03:73:09:d3:63',
                                    '18:03:73:09:31:ac',
                                    '18:03:73:09:32:88',
                                    '18:34:51:36:ce:a3',
                                    '18:3f:47:54:e4:2c',
                                    '18:46:17:e7:4b:ea',
                                    'f0:b4:79:14:db:4e',
                                    'f0:b4:79:1d:7b:ad',
                                    'f0:cb:a1:6b:66:18',
                                    'f0:1f:af:11:ad:05',
                                    'f0:1f:af:23:53:3a',
                                    'f0:4d:a2:0a:a7:ff',
                                    'f0:4d:a2:0a:a8:07',
                                    'f0:4d:a2:0a:c0:9b',
                                    'f0:4d:a2:0a:c0:9f',
                                    'f0:4d:a2:0a:c0:a3',
                                    'f0:4d:a2:0b:78:fb',
                                    'f0:62:81:75:ca:00',
                                    'f4:ce:46:33:ed:e2',
                                    'f4:ce:46:34:f5:44',
                                    'f4:ce:46:34:26:cf',
                                    'f4:ce:46:42:03:84',
                                    'f4:ce:46:43:e2:e4',
                                    'f4:ce:46:4b:a0:4f',
                                    'f4:ce:46:4c:20:7b',
                                    'f4:f1:5a:0c:75:af',
                                    'f4:f1:5a:c4:88:86',
                                    'f4:1b:a1:6e:eb:b7',
                                    'f8:db:7f:56:7a:4f',
                                    'f8:1e:df:8b:7b:b8',
                                    'f8:1e:df:9a:fc:67',
                                    'f8:1e:df:ad:af:1a',
                                    'f8:1e:df:dc:cb:28',
                                    'f8:1e:df:dc:da:84',
                                    'f8:1e:df:e5:f9:32',
                                    'f8:1e:df:e9:e5:b7',
                                    'f8:1e:df:ed:c7:48',
                                    '1c:65:9d:76:63:5f',
                                    '1c:75:08:41:19:26',
                                    '1c:ab:a7:8b:20:3b',
                                    '1c:b0:94:a3:4b:ea',
                                    '1c:c1:de:33:18:64',
                                    '1c:c1:de:33:1c:e1',
                                    '1c:c1:de:33:1c:e5',
                                    '1c:c1:de:33:1c:ed',
                                    '1c:c1:de:34:e0:95',
                                    '1c:c1:de:34:e0:97',
                                    '1c:c1:de:34:e0:99',
                                    '1c:c1:de:34:e0:9b',
                                    '1c:c1:de:34:e0:a5',
                                    '1c:c1:de:34:e0:f9',
                                    '1c:c1:de:34:e0:fd',
                                    '1c:c1:de:34:e0:2d',
                                    '1c:c1:de:34:e0:53',
                                    '1c:c1:de:34:f0:0b',
                                    '1c:c1:de:34:f0:05',
                                    '1c:c1:de:34:50:73',
                                    '20:64:32:89:4c:4c',
                                    '20:7d:74:71:52:f9',
                                    '20:10:7a:93:e3:e4',
                                    '20:10:7a:43:a8:46',
                                    '20:c9:d0:7e:a4:f7',
                                    '20:c9:d0:87:f6:77',
                                    '20:c9:d0:c2:96:3d',
                                    '20:c9:d0:d5:2a:6b',
                                    '20:c9:d0:da:b1:01',
                                    '20:c9:d0:de:87:47',
                                    '20:c9:d0:2a:c8:af',
                                    '20:c9:d0:49:16:05',
                                    '20:54:76:63:26:29',
                                    '24:77:03:65:c2:50',
                                    '24:77:03:ac:df:74',
                                    '24:77:03:bb:f0:50',
                                    '24:77:03:13:1f:b8',
                                    '24:77:03:c1:ac:14',
                                    '24:77:03:15:41:a0',
                                    '24:77:03:dc:15:7c',
                                    '24:77:03:23:c1:18',
                                    '24:77:03:2c:75:68',
                                    '24:77:03:2c:85:d8',
                                    '24:be:05:e2:b0:f5',
                                    '24:fd:52:79:06:ef',
                                    '24:fd:52:49:0e:5c',
                                    '04:0c:ce:88:1b:23',
                                    '04:f7:e4:77:b8:bd',
                                    '04:f7:e4:cc:92:33',
                                    '04:1e:64:08:e2:f7',
                                    '04:46:65:87:9a:a1',
                                    '04:54:53:a1:da:3c',
                                    '28:6a:ba:c8:45:28',
                                    '28:6a:ba:cd:d6:49',
                                    '28:94:0f:db:59:1d',
                                    '28:98:7b:2d:bf:5e',
                                    '28:cf:da:de:63:52',
                                    '28:cf:da:e7:ed:34',
                                    '28:cf:da:e7:4e:94',
                                    '28:cf:da:e9:75:d0',
                                    '28:cf:da:3d:93:d2',
                                    '28:cf:e9:65:17:cf',
                                    '28:cf:e9:13:4d:57',
                                    '28:cf:e9:15:25:6b',
                                    '28:cf:e9:55:b4:1d',
                                    '28:cf:e9:5c:1a:4f',
                                    '28:e0:2c:43:6d:3d',
                                    '28:37:37:b2:eb:d1',
                                    '28:37:37:19:5f:40',
                                    '28:37:37:1c:2e:3e',
                                    '2c:76:8a:04:f0:4c',
                                    '2c:27:d7:f0:25:cd',
                                    '2c:27:d7:f0:25:d5',
                                    '2c:27:d7:f0:25:d9',
                                    '2c:27:d7:f0:25:dd',
                                    '2c:27:d7:f0:25:df',
                                    '2c:27:d7:f0:25:e3',
                                    '2c:27:d7:f0:25:33',
                                    '2c:27:d7:f0:35:67',
                                    '2c:27:d7:f0:35:69',
                                    '2c:27:d7:f0:35:6d',
                                    '2c:27:d7:f0:35:3d',
                                    '2c:27:d7:f0:35:5b',
                                    '2c:27:d7:f0:35:5f',
                                    '2c:27:d7:f0:35:63',
                                    '2c:41:38:80:dc:71',
                                    '2c:41:38:9a:b7:43',
                                    '30:85:a9:07:fa:4b',
                                    '30:85:a9:5f:19:5b',
                                    '34:15:9e:8a:d8:c9',
                                    '34:15:9e:91:2f:cc',
                                    '34:15:9e:14:b5:be',
                                    '34:15:9e:21:2b:fc',
                                    '34:15:9e:21:32:76',
                                    '34:51:c9:c6:a6:55',
                                    '38:0f:4a:63:ab:aa',
                                    '38:aa:3c:1c:14:61',
                                    '3c:d9:2b:6c:10:52',
                                    '3c:d9:2b:6c:25:f0',
                                    '3c:43:8e:c4:0b:17',
                                    '3c:07:54:0e:ab:56',
                                    '3c:07:54:0f:f0:bb',
                                    '3c:07:54:1d:6d:91',
                                    '3c:07:54:23:69:6a',
                                    '3c:07:54:2c:0a:0a',
                                    '3c:07:54:42:cf:af',
                                    '3c:07:54:56:71:87',
                                    '3c:07:54:5b:52:6d',
                                    '40:6c:8f:0a:0f:0c',
                                    '40:6c:8f:3f:ee:c7',
                                    '40:6c:8f:56:a1:ab',
                                    '40:b3:95:e7:9e:c3',
                                    '40:f3:08:22:19:2a',
                                    '40:fc:89:8f:61:63',
                                    '40:25:c2:c9:5d:04',
                                    '40:30:04:4b:a3:ff',
                                    '44:6d:57:2a:bb:d6',
                                    '44:1e:a1:7a:43:c0',
                                    '48:5d:60:f9:18:29',
                                    '48:60:bc:b1:75:76',
                                    '48:60:bc:34:ba:c2',
                                    '4c:80:93:3b:21:6c',
                                    '4c:8b:ef:a8:82:51',
                                    '4c:8d:79:e3:46:e2',
                                    '4c:8d:79:e6:cb:8a',
                                    '4c:8d:79:f2:47:f6',
                                    '4c:0f:6e:d9:d8:14',
                                    '4c:b1:99:c9:43:1c',
                                    '4c:ed:de:75:a0:29',
                                    '4c:ed:de:a3:ec:23',
                                    '08:00:20:d8:76:9f',
                                    '08:00:27:34:98:f5',
                                    '08:00:27:3d:ca:12',
                                    '08:00:37:87:9a:1a',
                                    '08:00:37:2a:22:7a',
                                    '08:70:45:2a:5e:1a',
                                    '08:11:96:97:74:b4',
                                    '08:ed:b9:ba:81:f9',
                                    '08:ed:b9:06:34:2d',
                                    '08:ed:b9:3d:00:5c',
                                    '08:ed:b9:48:10:69',
                                    '08:ed:b9:4c:52:8b',
                                    '08:2e:5f:7e:6e:71',
                                    '08:3e:8e:85:c8:65',
                                    '08:3e:8e:4b:dc:0b',
                                    '50:01:bb:cf:83:23',
                                    '50:63:13:c3:9e:07',
                                    '52:54:00:d1:b7:9d',
                                    '52:54:00:fb:dd:7c',
                                    '52:54:00:2f:31:78',
                                    '54:26:96:9f:48:85',
                                    '54:26:96:cf:53:1b',
                                    '54:04:a6:13:00:c3',
                                    '58:94:6b:45:ba:c4',
                                    '58:55:ca:24:8e:5d',
                                    '5c:0a:5b:e0:ea:a4',
                                    '5c:96:9d:6d:30:8e',
                                    '5c:96:9d:7c:91:95',
                                    '5c:96:9d:89:d9:b9',
                                    '5c:96:9d:e7:dc:f4',
                                    '5c:ac:4c:16:01:7a',
                                    '5c:b5:24:e5:02:b5',
                                    '5c:e8:eb:e6:27:1c',
                                    '5c:f9:dd:d6:fe:30',
                                    '5c:f9:dd:d6:35:d9',
                                    '5c:f9:dd:d6:36:0b',
                                    '5c:f9:dd:d6:36:12',
                                    '5c:26:0a:70:51:c1',
                                    '5c:26:0a:81:8d:a7',
                                    '5c:26:0a:81:07:6d',
                                    '5c:26:0a:81:07:77',
                                    '5c:26:0a:85:8f:28',
                                    '5c:26:0a:12:46:d8',
                                    '5c:26:0a:12:46:d9',
                                    '5c:26:0a:12:46:df',
                                    '5c:26:0a:13:5e:ba',
                                    '5c:26:0a:18:45:a9',
                                    '5c:26:0a:25:81:c7',
                                    '5c:26:0a:25:82:0a',
                                    '5c:26:0a:48:64:9d',
                                    '5c:59:48:8e:0a:7d',
                                    '5c:63:bf:dd:c7:17',
                                    '5c:63:bf:dd:c8:75',
                                    '60:67:20:41:cd:6e',
                                    '60:c5:47:8d:c6:ea',
                                    '60:c5:47:96:82:60',
                                    '60:c5:47:98:dc:68',
                                    '60:d8:19:a7:0c:c2',
                                    '60:d8:19:58:fc:43',
                                    '60:eb:69:a9:de:8d',
                                    '60:fa:cd:5c:29:19',
                                    '60:fb:42:f1:c1:dc',
                                    '60:21:c0:12:21:9f',
                                    '60:21:c0:c4:ec:ef',
                                    '60:21:c0:17:21:f4',
                                    '60:21:c0:63:93:0c',
                                    '60:33:4b:0e:00:81',
                                    '60:33:4b:1c:6d:af',
                                    '60:33:4b:07:8d:4d',
                                    '60:36:dd:8b:7f:c7',
                                    '60:36:dd:94:95:8f',
                                    '60:36:dd:94:3e:00',
                                    '60:36:dd:a5:dc:50',
                                    '60:36:dd:08:e9:7c',
                                    '60:45:bd:81:ed:ee',
                                    '20:c9:d0:d9:b6:85',
                                    '04:1e:64:71:bc:6f',
                                    '00:00:aa:fa:18:d1',
                                    'f8:a4:5f:17:bd:d6',
                                    '20:c9:d0:e1:3f:7d',
                                    '00:0d:54:f7:85:c6',
                                    '00:0e:6a:d1:56:0f',
                                    'd8:24:bd:e9:0a:00',
                                    '18:03:73:30:57:13',
                                    'a8:20:66:30:e1:28',
                                    'a8:20:66:21:df:65',
                                    '00:16:3e:82:c9:c4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '50',
                        IFNAME           => '50',
                        IFDESCR          => '50',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:ce',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(349) 0:00:03.49',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '63',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '64',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5280) 0:00:52.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '65',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3856) 0:00:38.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '67',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3875) 0:00:38.75',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '68',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3897) 0:00:38.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '69',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3916) 0:00:39.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '70',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '71',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(716) 0:00:07.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '72',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '73',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '74',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '75',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3935) 0:00:39.35',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '76',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(738) 0:00:07.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '77',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3957) 0:00:39.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '78',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3978) 0:00:39.78',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '79',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3997) 0:00:39.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '80',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4000) 0:00:40.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '81',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '82',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4019) 0:00:40.19',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '83',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5300) 0:00:53.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '85',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '86',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4621) 0:00:46.21',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '87',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '88',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4038) 0:00:40.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '89',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(793) 0:00:07.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '90',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4057) 0:00:40.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '91',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4060) 0:00:40.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '92',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4641) 0:00:46.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '93',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4660) 0:00:46.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '94',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4683) 0:00:46.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '95',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4079) 0:00:40.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4702) 0:00:47.02',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '98',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4098) 0:00:40.98',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '99',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2100) 0:00:21.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '100',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4117) 0:00:41.17',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '101',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4139) 0:00:41.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '102',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4158) 0:00:41.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '103',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4177) 0:00:41.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '104',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4199) 0:00:41.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '105',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4218) 0:00:42.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '106',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4237) 0:00:42.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '107',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4259) 0:00:42.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '108',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4277) 0:00:42.77',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4296) 0:00:42.96',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4318) 0:00:43.18',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '111',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4337) 0:00:43.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '112',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4356) 0:00:43.56',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '113',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4378) 0:00:43.78',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '114',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4722) 0:00:47.22',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '115',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4397) 0:00:43.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '118',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4744) 0:00:47.44',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '119',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4763) 0:00:47.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '120',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4782) 0:00:47.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '122',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4416) 0:00:44.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '123',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4804) 0:00:48.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '125',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(943) 0:00:09.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '126',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2101) 0:00:21.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '127',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4438) 0:00:44.38',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '128',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(793) 0:00:07.93',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '129',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4824) 0:00:48.24',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '130',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3837) 0:00:38.37',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '131',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4843) 0:00:48.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '133',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4865) 0:00:48.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '134',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4885) 0:00:48.85',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '135',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4904) 0:00:49.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '136',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4926) 0:00:49.26',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '137',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4946) 0:00:49.46',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '138',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5320) 0:00:53.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '139',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4457) 0:00:44.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '140',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4479) 0:00:44.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '143',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4965) 0:00:49.65',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '144',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4989) 0:00:49.89',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '146',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1282) 0:00:12.82',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '150',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5008) 0:00:50.08',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '151',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5027) 0:00:50.27',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '154',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5049) 0:00:50.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '156',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5068) 0:00:50.68',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '158',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5340) 0:00:53.40',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '160',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5088) 0:00:50.88',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '162',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5110) 0:00:51.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '163',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5129) 0:00:51.29',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '164',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5149) 0:00:51.49',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '176',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5171) 0:00:51.71',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '184',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4501) 0:00:45.01',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '188',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5190) 0:00:51.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '196',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5210) 0:00:52.10',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '198',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5232) 0:00:52.32',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '200',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4520) 0:00:45.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '256',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5251) 0:00:52.51',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '260',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2143) 0:00:21.43',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '262',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(5362) 0:00:53.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '263',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3583) 0:00:35.83',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '264',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3604) 0:00:36.04',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '266',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3623) 0:00:36.23',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '270',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3641) 0:00:36.41',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '272',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3662) 0:00:36.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '299',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(259340059) 30 days, 0:23:20.59',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '302',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2162) 0:00:21.62',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '306',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2163) 0:00:21.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '312',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3681) 0:00:36.81',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '315',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3699) 0:00:36.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '316',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3720) 0:00:37.20',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '317',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3739) 0:00:37.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '362',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4539) 0:00:45.39',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '363',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4561) 0:00:45.61',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '364',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4580) 0:00:45.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '662',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(4599) 0:00:45.99',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '668',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3757) 0:00:37.57',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '672',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3779) 0:00:37.79',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '676',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3797) 0:00:37.97',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '677',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2163) 0:00:21.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '908',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:1d:b3:58:cf:80',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(3816) 0:00:38.16',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4158',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J8697A.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'ProCurve 5406zl (J8697A)',
            DESCRIPTION  => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_',

            SNMPHOSTNAME => 'oyapock CR2',
            LOCATION     => 'datacenter',
            CONTACT      => 'systeme@ac-guyane.fr',
            SERIAL       => 'SG707SU03Y',
            FIRMWARE     => 'K.15.28',
            UPTIME       => '(293555959) 33 days, 23:25:59.59',
            MAC          => '00:18:71:c1:e0:00',
            IPS          => {
                IP => [
                    '127.0.0.1',
                    '172.27.192.226',
                    '172.27.192.33',
                    '172.27.193.125',
                    '172.27.205.253',
                    '172.31.192.244',
                    '172.31.193.246',
                    '172.31.196.253',
                    '172.31.201.253',
                    '172.31.203.253',
                    '172.31.204.125',
                    '172.31.204.253',
                    '172.31.205.125',
                    '172.31.205.253',
                    '192.168.227.246',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'ProCurve 5406zl (J8697A)',
                COMMENTS     => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_',
                NAME         => 'oyapock CR2',
                LOCATION     => 'datacenter',
                CONTACT      => 'systeme@ac-guyane.fr',
                SERIAL       => 'SG707SU03Y',
                FIRMWARE     => 'K.15.28',
                UPTIME       => '(293555959) 33 days, 23:25:59.59',
                MAC          => '00:18:71:c1:e0:00',
                IPS          => {
                    IP => [
                        '127.0.0.1',
                        '172.27.192.226',
                        '172.27.192.33',
                        '172.27.193.125',
                        '172.27.205.253',
                        '172.31.192.244',
                        '172.31.193.246',
                        '172.31.196.253',
                        '172.31.201.253',
                        '172.31.203.253',
                        '172.31.204.125',
                        '172.31.204.253',
                        '172.31.205.125',
                        '172.31.205.253',
                        '192.168.227.246',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => 'A1',
                        IFDESCR          => 'A1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(137791) 0:22:57.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2281257823',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1349379502',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB010B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.140',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => 'A2',
                        IFDESCR          => 'A2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:fe',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(137791) 0:22:57.91',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1790849661',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '351638347',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0019BB010B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.140',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => 'A3',
                        IFDESCR          => 'A3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:fd',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(140056) 0:23:20.56',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2596611853',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1368455180',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB0D8100',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.141',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => 'A4',
                        IFDESCR          => 'A4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(140106) 0:23:21.06',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2096487256',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '205027037',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0019BB0D8100',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.141',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => 'A5',
                        IFDESCR          => 'A5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(98419) 0:16:24.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2759835685',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2189748070',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0016B9138000',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.142',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => 'A6',
                        IFDESCR          => 'A6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:fa',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(98419) 0:16:24.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '710340837',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1497261298',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0016B9138000',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.142',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => 'A7',
                        IFDESCR          => 'A7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(133722) 0:22:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '264235442',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1045414825',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0016B9142B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.143',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => 'A8',
                        IFDESCR          => 'A8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(133722) 0:22:17.22',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2740877036',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1496580095',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0016B9142B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.143',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => 'A9',
                        IFDESCR          => 'A9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(171654) 0:28:36.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1383661651',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1593815865',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB1B4D00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.150',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => 'A10',
                        IFDESCR          => 'A10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(171654) 0:28:36.54',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2224332599',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1552508202',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0019BB1B4D00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.150',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => 'A11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => 'A12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => 'A13',
                        IFDESCR          => 'A13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(147598) 0:24:35.98',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3735158120',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2302731832',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB1ACC00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.151',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => 'A14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:f2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => 'A15',
                        IFDESCR          => 'A15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:f1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(154728) 0:25:47.28',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3361365604',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '284146569',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB01A600',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.160',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => 'A16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => 'A17',
                        IFDESCR          => 'A17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(152568) 0:25:25.68',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '348605692',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2435360597',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB058200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.161',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => 'A18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => 'A19',
                        IFDESCR          => 'A19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(143621) 0:23:56.21',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28689859',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1786194494',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '262',
                                SYSNAME  => '0x0018FEF9A800',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.162',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => 'A20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:ec',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => 'A21',
                        IFDESCR          => 'A21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:eb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94699) 0:15:46.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2943397531',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1009676074',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '262',
                                SYSNAME  => '0x001C2EE58B00',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.163',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => 'A22',
                        IFDESCR          => 'A22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:ea',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57936) 0:09:39.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3614341248',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '372261477',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '22',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => 'A23',
                        IFDESCR          => 'A23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57936) 0:09:39.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1968825162',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3322662505',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '23',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => 'A24',
                        IFDESCR          => 'A24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57936) 0:09:39.36',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3412112397',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2284145698',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '24',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => 'B1',
                        IFDESCR          => 'B1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(147667) 0:24:36.67',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1056898244',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1169469549',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0019BB1ACC00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.151',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => 'B2',
                        IFDESCR          => 'B2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(147617) 0:24:36.17',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3042721785',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '558861009',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB1ACC00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.151',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => 'B3',
                        IFDESCR          => 'B3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(154748) 0:25:47.48',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3237184662',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '146927983',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB01A600',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.160',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => 'B4',
                        IFDESCR          => 'B4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(154797) 0:25:47.97',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2288807394',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3299335483',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '143',
                                SYSNAME  => '0x0019BB01A600',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.160',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => 'B5',
                        IFDESCR          => 'B5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(152588) 0:25:25.88',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3318685559',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2809203793',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '141',
                                SYSNAME  => '0x0019BB058200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.161',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => 'B6',
                        IFDESCR          => 'B6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2632) 0:00:26.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => 'B7',
                        IFDESCR          => 'B7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(143699) 0:23:56.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3012845819',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2231577010',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '285',
                                SYSNAME  => '0x0018FEF9A800',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.162',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => 'B8',
                        IFDESCR          => 'B8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:e0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(143699) 0:23:56.99',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3323194516',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3764354101',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '287',
                                SYSNAME  => '0x0018FEF9A800',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.162',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => 'B9',
                        IFDESCR          => 'B9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:df',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94732) 0:15:47.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3754573618',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '20030667',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '285',
                                SYSNAME  => '0x001C2EE58B00',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.163',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => 'B10',
                        IFDESCR          => 'B10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:de',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94732) 0:15:47.32',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1557689030',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2884232004',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '287',
                                SYSNAME  => '0x001C2EE58B00',
                                SYSDESCR => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.163',
                                MODEL    => 'ProCurve J8698A Switch 5412zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => 'B11',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => 'B12',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => 'B13',
                        IFDESCR          => 'B13',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:db',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(137672) 0:22:56.72',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1205644070',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1019288656',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB010B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.140',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => 'B14',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => 'B15',
                        IFDESCR          => 'B15',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d9',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(139982) 0:23:19.82',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2981067194',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3131610378',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB0D8100',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.141',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => 'B16',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => 'B17',
                        IFDESCR          => 'B17',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d7',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(98347) 0:16:23.47',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2496990832',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1435860196',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0016B9138000',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.142',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => 'B18',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => 'B19',
                        IFDESCR          => 'B19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d5',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(133655) 0:22:16.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3225589631',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2304461112',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0016B9142B00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.143',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => 'B20',
                        IFTYPE           => '6',
                        IFSPEED          => '0',
                        IFMTU            => '0',
                        MAC              => '00:18:71:c1:f0:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => 'B21',
                        IFDESCR          => 'B21',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d3',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(171619) 0:28:36.19',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3403667845',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4215478562',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '118',
                                SYSNAME  => '0x0019BB1B4D00',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.196.150',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => 'B22',
                        IFDESCR          => 'B22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57873) 0:09:38.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2524887906',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '986787144',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '46',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => 'B23',
                        IFDESCR          => 'B23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57873) 0:09:38.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1647940696',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1527530290',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '47',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => 'B24',
                        IFDESCR          => 'B24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:f0:d0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57873) 0:09:38.73',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2411859653',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2515291862',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CDP        => 1,
                            CONNECTION => {
                                IFDESCR  => '48',
                                SYSNAME  => '0x0019BB172200',
                                SYSDESCR => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                                IP       => '172.31.192.245',
                                MODEL    => 'ProCurve J8697A Switch 5406zl, revision K.15.04.0015m, ROM K.15.28 (/ws/swbuildm/ec_rel_charleston_qaoff/code/build/btm(ec_rel_charleston_qaoff))',
                            }
                        }
                    },
                    {
                        IFNUMBER         => '291',
                        IFNAME           => 'Trk2',
                        IFDESCR          => 'Trk2',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(140222) 0:23:22.22',
                        IFINOCTETS       => '3379199007',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '410125299',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:bb:0d:81:00',
                                    '00:19:bb:0d:91:71',
                                    '00:19:bb:0d:91:73',
                                    '00:19:bb:0d:91:8a',
                                    '00:05:1e:bf:07:e0',
                                    '00:50:56:00:00:06',
                                    '00:50:56:70:c4:44',
                                    '00:50:56:7b:aa:a5',
                                    '00:50:56:46:51:9d',
                                    '00:50:56:49:71:8c',
                                    '02:a0:98:12:b5:20',
                                    '00:00:00:00:fe:00',
                                    '00:00:00:00:fe:01',
                                    '00:90:fb:2e:03:34',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '293',
                        IFNAME           => 'Trk4',
                        IFDESCR          => 'Trk4',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(152649) 0:25:26.49',
                        IFINOCTETS       => '3667291251',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '949597094',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:f0:ac:ea:a9',
                                    '00:19:bb:05:82:00',
                                    '00:19:bb:05:92:73',
                                    '00:19:bb:05:92:8a',
                                    '00:19:db:a9:28:04',
                                    '00:1e:68:5d:33:46',
                                    '00:1e:68:5e:3d:b6',
                                    '00:21:5a:97:2a:b7',
                                    '00:22:f3:9d:20:4b',
                                    '00:22:f3:c7:d7:8b',
                                    '00:23:7d:76:e3:8c',
                                    '00:25:b3:f4:fc:f6',
                                    '00:26:22:d3:a0:29',
                                    '00:08:5d:13:57:d2',
                                    '00:08:5d:2b:65:12',
                                    '00:08:5d:2c:c0:02',
                                    '10:78:d2:e8:73:41',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '295',
                        IFNAME           => 'Trk6',
                        IFDESCR          => 'Trk6',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(147706) 0:24:37.06',
                        IFINOCTETS       => '3539810853',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4031062390',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:f0:a9:62:13',
                                    '00:0b:84:00:6c:8a',
                                    '00:13:72:f6:e2:4e',
                                    '00:14:7c:2b:86:20',
                                    '00:16:17:c2:e9:f0',
                                    '00:18:71:85:a3:9b',
                                    '00:19:bb:1a:cc:00',
                                    '00:19:bb:1a:dc:71',
                                    '00:19:bb:1a:dc:73',
                                    '00:19:bb:1a:dc:8a',
                                    '00:19:db:7a:b6:94',
                                    '00:19:db:88:99:46',
                                    '00:19:db:bc:81:f8',
                                    '00:19:db:bc:82:f3',
                                    '00:1a:4b:19:26:0d',
                                    '00:1d:92:dc:f6:68',
                                    '00:1d:92:dd:6b:f0',
                                    '00:1d:92:df:6f:ae',
                                    '00:1f:29:99:cb:bb',
                                    '00:1f:29:99:db:41',
                                    '00:1f:29:14:87:74',
                                    '00:21:85:d0:32:c9',
                                    '00:21:85:d0:32:08',
                                    '00:21:85:d0:33:7b',
                                    '00:22:f3:9d:1f:c7',
                                    '00:22:f3:c7:d7:86',
                                    '00:22:f3:c8:02:cf',
                                    '00:22:f3:c8:02:2e',
                                    '00:22:f3:c8:04:16',
                                    '00:23:ea:db:05:48',
                                    '00:23:47:25:aa:c0',
                                    '00:04:00:9d:44:34',
                                    '00:04:00:b9:19:c4',
                                    '00:04:00:cd:d3:85',
                                    '00:08:5d:86:d5:65',
                                    '00:08:5d:86:d7:64',
                                    '00:08:5d:13:42:22',
                                    '00:08:5d:13:56:d1',
                                    '00:08:5d:13:57:e1',
                                    '00:08:5d:13:57:f4',
                                    '00:08:5d:13:58:16',
                                    '00:08:5d:13:58:1b',
                                    '00:08:5d:13:58:1c',
                                    '00:08:5d:13:58:1d',
                                    '00:08:5d:13:58:1e',
                                    '00:08:5d:13:58:1f',
                                    '00:08:5d:13:58:22',
                                    '00:08:5d:13:58:25',
                                    '00:08:5d:13:59:97',
                                    '00:08:5d:1b:73:36',
                                    '00:08:5d:1b:75:0f',
                                    '00:08:5d:1b:75:14',
                                    '00:08:5d:1b:7b:33',
                                    '00:08:5d:24:ce:50',
                                    '00:08:5d:24:cf:84',
                                    '00:08:5d:24:cf:89',
                                    '00:08:5d:24:cf:a4',
                                    '00:08:5d:24:cf:5f',
                                    '00:08:5d:24:cf:62',
                                    '00:08:5d:2b:f1:8b',
                                    '00:08:5d:2b:f1:91',
                                    '00:08:5d:2c:c2:68',
                                    '00:50:fc:6d:a5:52',
                                    '00:60:2e:02:13:61',
                                    '10:78:d2:e3:8b:91',
                                    '10:78:d2:e3:8b:b9',
                                    '10:78:d2:e6:df:cb',
                                    '10:78:d2:e9:8f:bc',
                                    '10:1f:74:47:ef:cf',
                                    'b8:ac:6f:23:1a:05',
                                    'b8:ac:6f:25:c8:40',
                                    'b8:ac:6f:3e:36:5f',
                                    '08:00:71:03:dd:41',
                                    '08:2e:5f:32:7a:91',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '297',
                        IFNAME           => 'Trk8',
                        IFDESCR          => 'Trk8',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(171701) 0:28:37.01',
                        IFINOCTETS       => '2716694799',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3066835333',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:82:08:65:49',
                                    '00:0b:84:00:6d:33',
                                    '00:11:0a:fc:d2:d4',
                                    '00:16:17:5c:be:45',
                                    '00:e0:d8:0a:a8:e1',
                                    '00:e0:d8:0a:a8:e2',
                                    '00:e0:d8:0a:2e:1f',
                                    '00:18:fe:a5:0d:fd',
                                    '00:19:bb:1b:4d:00',
                                    '00:19:bb:1b:5d:71',
                                    '00:19:bb:1b:5d:73',
                                    '00:19:bb:1b:5d:8a',
                                    '00:19:db:7a:b5:f3',
                                    '00:19:db:c0:d8:ae',
                                    '00:1d:92:dc:f6:ba',
                                    '00:1d:92:dd:74:b6',
                                    '00:1f:29:25:4c:ad',
                                    '00:22:f3:c7:d6:a2',
                                    '00:23:18:91:db:8d',
                                    '00:24:21:0c:3a:fb',
                                    '00:24:21:0c:3d:6a',
                                    '00:24:21:0c:3d:5b',
                                    '00:04:f2:e4:26:4f',
                                    '00:08:5d:1b:7b:25',
                                    '00:08:5d:1b:7b:2d',
                                    '00:08:5d:1b:7b:34',
                                    '00:08:5d:1b:7b:38',
                                    '00:08:5d:1b:7c:66',
                                    '00:08:5d:2c:c7:00',
                                    '00:08:5d:2c:c7:1f',
                                    '00:08:5d:2c:c7:32',
                                    '10:78:d2:e3:8b:c7',
                                    '10:78:d2:e6:e2:78',
                                    'b8:ac:6f:23:19:08',
                                    '00:1a:4b:30:67:61',
                                    '00:30:05:38:78:53',
                                    '00:30:05:38:78:5b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '299',
                        IFNAME           => 'Trk10',
                        IFDESCR          => 'Trk10',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(143756) 0:23:57.56',
                        IFINOCTETS       => '2069762898',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3487158309',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:38:4a:d0:31',
                                    '00:16:17:a5:09:24',
                                    '00:16:17:c4:6e:55',
                                    '00:16:17:e3:9c:68',
                                    '00:16:17:e3:23:ee',
                                    '00:17:08:86:1a:84',
                                    '00:18:71:88:a6:54',
                                    '00:18:fe:f9:a8:00',
                                    '00:18:fe:f9:a8:e1',
                                    '00:18:fe:f9:a8:e3',
                                    '00:18:fe:f9:a8:fa',
                                    '00:1b:78:25:73:b6',
                                    '00:1b:78:09:58:79',
                                    '00:1d:92:dd:6b:ec',
                                    '00:1d:92:dd:6f:b1',
                                    '00:1d:92:dd:75:8e',
                                    '00:1e:0b:0c:89:db',
                                    '00:1f:29:99:bb:9d',
                                    '00:1f:29:16:44:44',
                                    '00:21:85:d0:32:f9',
                                    '00:22:f3:9d:0f:d9',
                                    '00:22:f3:9d:20:56',
                                    '00:22:f3:c7:d8:20',
                                    '00:04:00:9d:84:a8',
                                    '00:04:00:9d:f8:e0',
                                    '00:04:00:ad:e9:50',
                                    '00:08:5d:13:57:05',
                                    '00:08:5d:2c:c0:6a',
                                    '00:08:5d:2c:c0:cf',
                                    '00:08:5d:2c:c0:27',
                                    '10:78:d2:e9:8e:4b',
                                    'b8:ac:6f:22:aa:e0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '301',
                        IFNAME           => 'Trk12',
                        IFDESCR          => 'Trk12',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(137833) 0:22:58.33',
                        IFINOCTETS       => '982784258',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2720306505',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:19:bb:01:0b:00',
                                    '00:19:bb:01:1b:71',
                                    '00:19:bb:01:1b:73',
                                    '00:19:bb:01:1b:8a',
                                    '00:50:56:72:2c:1a',
                                    '00:50:56:7e:e7:85',
                                    '00:50:56:8b:65:0a',
                                    '00:50:56:8b:29:26',
                                    '00:50:56:44:71:b5',
                                    '00:50:56:47:e1:b4',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '303',
                        IFNAME           => 'Trk14',
                        IFDESCR          => 'Trk14',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(133781) 0:22:17.81',
                        IFINOCTETS       => '1935734813',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '551488736',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:b9:14:2b:00',
                                    '00:16:b9:14:3b:71',
                                    '00:16:b9:14:3b:73',
                                    '00:16:b9:14:3b:8a',
                                    '00:1e:c9:b7:b8:b3',
                                    '00:1e:c9:b7:b8:f4',
                                    '00:50:56:72:d9:74',
                                    '00:50:56:44:df:2d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '305',
                        IFNAME           => 'Trk16',
                        IFDESCR          => 'Trk16',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(98455) 0:16:24.55',
                        IFINOCTETS       => '1672200058',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '827902268',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:b9:13:80:00',
                                    '00:16:b9:13:90:71',
                                    '00:16:b9:13:90:73',
                                    '00:16:b9:13:90:8a',
                                    '00:e0:86:07:6b:79',
                                    '00:05:1e:bd:62:db',
                                    '00:50:56:73:17:d4',
                                    '00:50:56:76:7e:16',
                                    '00:50:56:76:fc:2f',
                                    '00:50:56:8b:72:94',
                                    '00:50:56:8b:45:38',
                                    '00:50:56:42:5b:6b',
                                    '00:50:56:4d:f7:97',
                                    '00:50:56:4f:3b:1c',
                                    '02:a0:98:12:7a:68',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '307',
                        IFNAME           => 'Trk18',
                        IFDESCR          => 'Trk18',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(94806) 0:15:48.06',
                        IFINOCTETS       => '3960692883',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3913938745',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:85:bb:5f:e9',
                                    '00:14:38:e1:1d:33',
                                    '00:15:99:1f:52:cd',
                                    '00:16:17:e2:35:6a',
                                    '00:19:db:a7:6f:dc',
                                    '00:19:db:a7:70:84',
                                    '00:19:db:aa:f4:65',
                                    '00:19:db:ad:68:bb',
                                    '00:19:db:bc:82:dc',
                                    '00:1a:4b:32:21:62',
                                    '00:1c:2e:e5:8b:00',
                                    '00:1c:2e:e5:8b:e1',
                                    '00:1c:2e:e5:8b:e3',
                                    '00:1c:2e:e5:8b:fa',
                                    '00:1d:92:dd:6b:f5',
                                    '00:1d:92:dd:6e:3b',
                                    '00:1d:92:dd:75:f5',
                                    '00:1d:92:dd:76:d1',
                                    '00:1f:29:16:34:b2',
                                    '00:21:85:d0:32:dd',
                                    '00:22:f3:9d:1b:8f',
                                    '00:22:f3:c7:d7:03',
                                    '00:22:f3:c8:04:99',
                                    '00:23:7d:75:a5:00',
                                    '00:23:7d:76:e3:42',
                                    '00:25:b3:f4:ec:86',
                                    '00:04:00:67:c7:7c',
                                    '00:04:00:9c:6c:25',
                                    '00:30:05:5d:68:4f',
                                    '00:08:5d:13:42:8c',
                                    '00:08:5d:24:d0:dd',
                                    '00:08:5d:2c:c0:d2',
                                    '78:e7:d1:aa:af:a3',
                                    '10:78:d2:e3:8b:66',
                                    'b8:ac:6f:25:d9:bc',
                                    'b8:ac:6f:3e:3b:09',
                                    'f0:de:f1:00:e3:76',
                                    'f0:de:f1:00:e3:c5',
                                    '1c:75:08:75:f0:c2',
                                    '1c:c1:de:cb:7d:95',
                                    '44:1e:a1:34:0b:a0',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '309',
                        IFNAME           => 'Trk20',
                        IFDESCR          => 'Trk20',
                        IFTYPE           => '161',
                        IFSPEED          => '3000000000',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(154845) 0:25:48.45',
                        IFINOCTETS       => '297423068',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3730410035',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:0b:84:00:1f:7d',
                                    '00:13:21:ef:3f:59',
                                    '00:16:76:2d:72:2f',
                                    '00:16:35:65:bf:8c',
                                    '00:19:bb:01:a6:00',
                                    '00:19:bb:01:b6:71',
                                    '00:19:bb:01:b6:73',
                                    '00:19:bb:01:b6:8a',
                                    '00:1d:92:dc:f5:de',
                                    '00:1d:92:dd:6b:c6',
                                    '00:1d:92:dd:6b:d5',
                                    '00:1d:92:dd:6b:e0',
                                    '00:1f:29:28:88:e4',
                                    '00:21:5a:7c:ec:35',
                                    '00:21:5a:97:1b:32',
                                    '00:22:f3:9d:1f:3b',
                                    '00:08:5d:2b:f1:48',
                                    'b8:ac:6f:3e:3a:c5',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '310',
                        IFNAME           => 'Trk21',
                        IFDESCR          => 'Trk21',
                        IFTYPE           => '161',
                        IFSPEED          => '4294967295',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57970) 0:09:39.70',
                        IFINOCTETS       => '2695065174',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2418744384',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:00:00:fe:00',
                                    '00:00:00:00:fe:01',
                                    '00:00:5e:00:01:01',
                                    '00:00:5e:00:01:0a',
                                    '00:00:5e:00:01:0b',
                                    '00:00:5e:00:01:0c',
                                    '00:00:5e:00:01:0d',
                                    '00:00:5e:00:01:02',
                                    '00:00:5e:00:01:17',
                                    '00:00:5e:00:01:1a',
                                    '00:00:5e:00:01:1b',
                                    '00:00:5e:00:01:1e',
                                    '00:00:5e:00:01:1f',
                                    '00:00:5e:00:01:07',
                                    '00:00:5e:00:01:08',
                                    '00:0c:29:21:58:a3',
                                    '00:0d:a2:10:26:66',
                                    '00:90:fb:2e:03:32',
                                    '00:90:fb:2e:03:33',
                                    '00:90:fb:2e:03:34',
                                    '00:90:fb:2e:03:35',
                                    '00:90:fb:2e:03:36',
                                    '00:12:f2:7c:72:30',
                                    '00:12:f2:7c:39:d0',
                                    '00:13:7f:f5:55:d8',
                                    '00:13:d4:81:69:4b',
                                    '00:14:5e:de:c3:4f',
                                    '00:19:bb:17:22:00',
                                    '00:19:bb:17:32:d0',
                                    '00:19:bb:17:32:d1',
                                    '00:19:bb:17:32:d2',
                                    '00:19:bb:17:32:e8',
                                    '00:19:bb:17:32:e9',
                                    '00:19:bb:17:32:ea',
                                    '00:1a:4b:30:67:61',
                                    '00:03:a0:8a:52:18',
                                    '00:1e:c9:b9:0c:6e',
                                    '00:1e:c9:b9:11:cd',
                                    '00:22:19:5c:65:f6',
                                    '00:26:b9:8a:f1:0a',
                                    '00:26:b9:8e:4a:11',
                                    '00:30:05:38:78:53',
                                    '00:30:05:38:78:5b',
                                    '00:50:56:00:00:01',
                                    '00:50:56:00:00:02',
                                    '00:50:56:00:00:03',
                                    '00:50:56:00:00:04',
                                    '00:50:56:00:00:08',
                                    '00:50:56:8b:64:98',
                                    '00:50:56:8b:64:f3',
                                    '00:50:56:8b:68:41',
                                    '00:50:56:8b:6a:f8',
                                    '00:50:56:8b:6b:43',
                                    '00:50:56:8b:70:48',
                                    '00:50:56:8b:72:cb',
                                    '00:50:56:8b:76:a6',
                                    '00:50:56:8b:78:f1',
                                    '00:50:56:8b:7e:a7',
                                    '00:50:56:8b:7f:71',
                                    '00:50:56:8b:0e:1f',
                                    '00:50:56:8b:10:d2',
                                    '00:50:56:8b:13:0e',
                                    '00:50:56:8b:1b:1b',
                                    '00:50:56:8b:1d:11',
                                    '00:50:56:8b:03:d4',
                                    '00:50:56:8b:21:ba',
                                    '00:50:56:8b:23:4f',
                                    '00:50:56:8b:24:e6',
                                    '00:50:56:8b:29:6d',
                                    '00:50:56:8b:30:70',
                                    '00:50:56:8b:32:35',
                                    '00:50:56:8b:35:1c',
                                    '00:50:56:8b:38:fe',
                                    '00:50:56:8b:3a:66',
                                    '00:50:56:8b:3e:65',
                                    '00:50:56:8b:42:2b',
                                    '00:50:56:8b:4d:90',
                                    '00:50:56:8b:52:11',
                                    '00:50:56:8b:5c:9a',
                                    '00:50:56:8b:5d:3f',
                                    '00:50:56:8b:5e:39',
                                    '00:09:0f:09:3f:02',
                                    '00:09:0f:09:3f:03',
                                    '00:09:0f:09:3f:04',
                                    '02:12:f2:7c:72:3a',
                                    '02:12:f2:7c:72:3b',
                                    '02:12:f2:7c:72:3c',
                                    '02:12:f2:7c:72:3d',
                                    '02:12:f2:7c:72:3e',
                                    '02:12:f2:7c:72:3f',
                                    '02:12:f2:7c:39:da',
                                    '02:12:f2:7c:39:db',
                                    '02:12:f2:7c:39:dc',
                                    '02:12:f2:7c:39:dd',
                                    '02:12:f2:7c:39:de',
                                    '02:12:f2:7c:39:df',
                                    '02:12:f2:a8:df:fa',
                                    '02:12:f2:a8:df:fb',
                                    '02:12:f2:62:e2:22',
                                    '02:12:f2:62:e2:23',
                                    '02:12:f2:62:e2:24',
                                    '02:12:f2:62:e2:26',
                                    '02:12:f2:62:e2:27',
                                    '02:12:f2:62:e2:28',
                                    '02:12:f2:62:e2:29',
                                    '02:12:f2:62:e2:2a',
                                    '02:12:f2:62:e2:2b',
                                    '02:12:f2:62:e2:2c',
                                    '02:12:f2:62:e2:2d',
                                    '02:12:f2:62:e2:2e',
                                    '02:12:f2:62:e2:2f',
                                    '02:12:f2:62:e2:30',
                                    '02:12:f2:62:e2:31',
                                    '02:12:f2:62:e2:32',
                                    '02:12:f2:62:e2:33',
                                    '02:12:f2:62:e2:34',
                                    '02:12:f2:62:e2:35',
                                    '02:12:f2:62:e2:36',
                                    '02:12:f2:62:e2:39',
                                    '02:12:f2:62:e2:3a',
                                    '02:12:f2:62:e2:3b',
                                    '02:e0:52:76:0e:16',
                                    '02:e0:52:20:5e:10',
                                    'd4:be:d9:af:75:1b',
                                    '00:22:19:16:fb:69',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '578',
                        IFNAME           => 'DEFAULT_VLAN',
                        IFDESCR          => 'DEFAULT_VLAN',
                        IFALIAS          => 'DEFAULT_VLAN',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '579',
                        IFNAME           => 'VLAN2',
                        IFDESCR          => 'VLAN2',
                        IFALIAS          => 'SERVERS',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.192.244',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '580',
                        IFNAME           => 'VLAN3',
                        IFDESCR          => 'VLAN3',
                        IFALIAS          => 'ZONE_PUBLIQUE',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '581',
                        IFNAME           => 'VLAN4',
                        IFDESCR          => 'VLAN4',
                        IFALIAS          => 'INTERCO_RACINE_API',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '582',
                        IFNAME           => 'VLAN5',
                        IFDESCR          => 'VLAN5',
                        IFALIAS          => 'DMZ',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '583',
                        IFNAME           => 'VLAN6',
                        IFDESCR          => 'VLAN6',
                        IFALIAS          => 'AGRIATES',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '584',
                        IFNAME           => 'VLAN7',
                        IFDESCR          => 'VLAN7',
                        IFALIAS          => 'ACCUEIL_ETABLISSEMENTS',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '590',
                        IFNAME           => 'VLAN13',
                        IFDESCR          => 'VLAN13',
                        IFALIAS          => 'VOIP_ASTERISK',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.27.192.226',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '591',
                        IFNAME           => 'VLAN14',
                        IFDESCR          => 'VLAN14',
                        IFALIAS          => 'DMZ227',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '592',
                        IFNAME           => 'VLAN15',
                        IFDESCR          => 'VLAN15',
                        IFALIAS          => 'INTERCO-CSS',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '593',
                        IFNAME           => 'VLAN16',
                        IFDESCR          => 'VLAN16',
                        IFALIAS          => 'SERVEUR-CSS',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '594',
                        IFNAME           => 'VLAN17',
                        IFDESCR          => 'VLAN17',
                        IFALIAS          => 'INTER_EQUANT_RECTORAT',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '595',
                        IFNAME           => 'VLAN18',
                        IFDESCR          => 'VLAN18',
                        IFALIAS          => 'INT_EQUANT_ETABLISSEMENTS',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '599',
                        IFNAME           => 'VLAN22',
                        IFDESCR          => 'VLAN22',
                        IFALIAS          => 'DMZ_HD',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '607',
                        IFNAME           => 'VLAN30',
                        IFDESCR          => 'VLAN30',
                        IFALIAS          => 'RESEAU_DRRT-PUG',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '726',
                        IFNAME           => 'VLAN149',
                        IFDESCR          => 'VLAN149',
                        IFALIAS          => 'COLLECTE_IP_RIHDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '727',
                        IFNAME           => 'VLAN150',
                        IFDESCR          => 'VLAN150',
                        IFALIAS          => 'RENATER',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '729',
                        IFNAME           => 'VLAN152',
                        IFDESCR          => 'VLAN152',
                        IFALIAS          => 'FW-DMZ-INFRA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '730',
                        IFNAME           => 'VLAN153',
                        IFDESCR          => 'VLAN153',
                        IFALIAS          => 'FW-VLAN-LIBRE',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '731',
                        IFNAME           => 'VLAN154',
                        IFDESCR          => 'VLAN154',
                        IFALIAS          => 'FW-INTERCO-FOUNDRY',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '732',
                        IFNAME           => 'VLAN155',
                        IFDESCR          => 'VLAN155',
                        IFALIAS          => 'FW-DMZ',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '733',
                        IFNAME           => 'VLAN156',
                        IFDESCR          => 'VLAN156',
                        IFALIAS          => 'FW-Libre_Service',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '734',
                        IFNAME           => 'VLAN157',
                        IFDESCR          => 'VLAN157',
                        IFALIAS          => 'FW-DMZ-PEDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '735',
                        IFNAME           => 'VLAN158',
                        IFDESCR          => 'VLAN158',
                        IFALIAS          => 'FW-DMZ-INFRA2',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '736',
                        IFNAME           => 'VLAN159',
                        IFDESCR          => 'VLAN159',
                        IFALIAS          => 'FW-PUG-DRRT',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '737',
                        IFNAME           => 'VLAN160',
                        IFDESCR          => 'VLAN160',
                        IFALIAS          => 'ToIP_RIHDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.27.192.33',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '739',
                        IFNAME           => 'VLAN162',
                        IFDESCR          => 'VLAN162',
                        IFALIAS          => 'LIBR_SERVICE',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(110183700) 12 days, 18:03:57.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '747',
                        IFNAME           => 'VLAN170',
                        IFDESCR          => 'VLAN170',
                        IFALIAS          => 'DATA_RIHDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.203.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '748',
                        IFNAME           => 'VLAN171',
                        IFDESCR          => 'VLAN171',
                        IFALIAS          => 'DATA_POLY',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '749',
                        IFNAME           => 'VLAN172',
                        IFDESCR          => 'VLAN172',
                        IFALIAS          => 'DATA_CEPE',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.193.246',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '757',
                        IFNAME           => 'VLAN180',
                        IFDESCR          => 'VLAN180',
                        IFALIAS          => 'video_RIHDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.27.193.125',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '767',
                        IFNAME           => 'VLAN190',
                        IFDESCR          => 'VLAN190',
                        IFALIAS          => 'postesIP_RIHDA',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.27.205.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '773',
                        IFNAME           => 'VLAN196',
                        IFDESCR          => 'VLAN196',
                        IFALIAS          => 'ADMIN_RESEAU',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.196.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '778',
                        IFNAME           => 'VLAN201',
                        IFDESCR          => 'VLAN201',
                        IFALIAS          => 'PERIPHERIQUES',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.201.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '779',
                        IFNAME           => 'VLAN202',
                        IFDESCR          => 'VLAN202',
                        IFALIAS          => 'UTIL_NVEAU_BAT',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '781',
                        IFNAME           => 'VLAN204',
                        IFDESCR          => 'VLAN204',
                        IFALIAS          => 'UTIL_FORMATION',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.204.125',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '782',
                        IFNAME           => 'VLAN205',
                        IFDESCR          => 'VLAN205',
                        IFALIAS          => 'UTIL_CATI',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.205.125',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '791',
                        IFNAME           => 'VLAN214',
                        IFDESCR          => 'VLAN214',
                        IFALIAS          => 'UTIL_INVITES',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.204.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '792',
                        IFNAME           => 'VLAN215',
                        IFDESCR          => 'VLAN215',
                        IFALIAS          => 'UTIL_SYST_RESEAUX',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '172.31.205.253',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2663) 0:00:26.63',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '978',
                        IFNAME           => 'VLAN401',
                        IFDESCR          => 'VLAN401',
                        IFALIAS          => 'VLAN401',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(110183690) 12 days, 18:03:56.90',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '979',
                        IFNAME           => 'VLAN402',
                        IFDESCR          => 'VLAN402',
                        IFALIAS          => 'wifi_recteur',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '980',
                        IFNAME           => 'VLAN403',
                        IFDESCR          => 'VLAN403',
                        IFALIAS          => 'DMZ_ELGG',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2658) 0:00:26.58',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3577',
                        IFNAME           => 'VLAN3000',
                        IFDESCR          => 'VLAN3000',
                        IFALIAS          => 'COLLECTE-TEST',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        IP               => '192.168.227.246',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57880) 0:09:38.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3579',
                        IFNAME           => 'VLAN3002',
                        IFDESCR          => 'VLAN3002',
                        IFALIAS          => 'TEST-APPLI',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57880) 0:09:38.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3583',
                        IFNAME           => 'VLAN3006',
                        IFDESCR          => 'VLAN3006',
                        IFALIAS          => 'TEST-AGRIATE',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57880) 0:09:38.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3584',
                        IFNAME           => 'VLAN3007',
                        IFDESCR          => 'VLAN3007',
                        IFALIAS          => 'TEST-ETAB',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1500',
                        MAC              => '00:18:71:c1:e0:00',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(57880) 0:09:38.80',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4672',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '65535',
                        IP               => '127.0.0.1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '7893971',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '7774747',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4673',
                        IFNAME           => 'lo1',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo1',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4674',
                        IFNAME           => 'lo2',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo2',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4675',
                        IFNAME           => 'lo3',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo3',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4676',
                        IFNAME           => 'lo4',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo4',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4677',
                        IFNAME           => 'lo5',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo5',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4678',
                        IFNAME           => 'lo6',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo6',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4679',
                        IFNAME           => 'lo7',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo7',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '9198',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '2',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J9022A.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'ProCurve 2810-48G (J9022A)',
            DESCRIPTION  => 'ProCurve J9022A Switch 2810-48G, revision N.11.52, ROM N.10.01 (/sw/code/build/bass(N_bh2))',

            LOCATION     => 'Local Autocommutateur',
            SERIAL       => 'CN738XJ0FI',
            FIRMWARE     => 'N.10.01',
            UPTIME       => '(1389024840) 160 days, 18:24:08.40',
            MAC          => '00:19:bb:99:f9:c0',
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'ProCurve 2810-48G (J9022A)',
                COMMENTS     => 'ProCurve J9022A Switch 2810-48G, revision N.11.52, ROM N.10.01 (/sw/code/build/bass(N_bh2))',
                LOCATION     => 'Local Autocommutateur',
                SERIAL       => 'CN738XJ0FI',
                FIRMWARE     => 'N.10.01',
                UPTIME       => '(1389024840) 160 days, 18:24:08.40',
                MAC          => '00:19:bb:99:f9:c0',
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ff',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388914355) 160 days, 18:05:43.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2878345723',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1232224058',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '10:9a:dd:5f:55:2c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:fe',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1363290555) 157 days, 18:55:05.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3362276813',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '4200290675',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:fd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1387389510) 160 days, 13:51:35.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1753235758',
                        IFINERRORS       => '2',
                        IFOUTOCTETS      => '1842805351',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:fc',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388901070) 160 days, 18:03:30.70',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1615135848',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3401754039',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:10:18:b1:c3:40',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:fb',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388964025) 160 days, 18:14:00.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '635570041',
                        IFINERRORS       => '187',
                        IFOUTOCTETS      => '3822368469',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c4:2c:03:30:f1:1e',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:fa',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(836588430) 96 days, 19:51:24.30',
                        IFPORTDUPLEX     => '2',
                        IFINOCTETS       => '2253641219',
                        IFINERRORS       => '26',
                        IFOUTOCTETS      => '1673312412',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '7',
                        IFNAME           => '7',
                        IFDESCR          => '7',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1355007195) 156 days, 19:54:31.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '440440422',
                        IFINERRORS       => '150',
                        IFOUTOCTETS      => '126856654',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '8',
                        IFNAME           => '8',
                        IFDESCR          => '8',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1302265360) 150 days, 17:24:13.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '153722068',
                        IFINERRORS       => '268',
                        IFOUTOCTETS      => '489992623',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '9',
                        IFNAME           => '9',
                        IFDESCR          => '9',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1331449240) 154 days, 2:28:12.40',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '396514109',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1126248185',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '10',
                        IFNAME           => '10',
                        IFDESCR          => '10',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f6',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(530) 0:00:05.30',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3755400409',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '769788783',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c4:2c:03:27:b9:0f',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '11',
                        IFNAME           => '11',
                        IFDESCR          => '11',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1244614655) 144 days, 1:15:46.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1561139719',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '873291655',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '12',
                        IFNAME           => '12',
                        IFDESCR          => '12',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1323293075) 153 days, 3:48:50.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2068271767',
                        IFINERRORS       => '27',
                        IFOUTOCTETS      => '2978897416',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '13',
                        IFNAME           => '13',
                        IFDESCR          => '13',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185) 0:00:01.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '14',
                        IFNAME           => '14',
                        IFDESCR          => '14',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f2',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1234319775) 142 days, 20:39:57.75',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1676847289',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '99213971',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '15',
                        IFNAME           => '15',
                        IFDESCR          => '15',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185) 0:00:01.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '16',
                        IFNAME           => '16',
                        IFDESCR          => '16',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:f0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185) 0:00:01.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '17',
                        IFNAME           => '17',
                        IFDESCR          => '17',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ef',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1372554155) 158 days, 20:39:01.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '90442475',
                        IFINERRORS       => '8',
                        IFOUTOCTETS      => '3662368205',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1b:78:16:f8:cd',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '18',
                        IFNAME           => '18',
                        IFDESCR          => '18',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ee',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(185) 0:00:01.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '19',
                        IFNAME           => '19',
                        IFDESCR          => '19',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ed',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388686025) 160 days, 17:27:40.25',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '488341657',
                        IFINERRORS       => '105',
                        IFOUTOCTETS      => '3304202260',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'a8:20:66:53:a4:b9',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '20',
                        IFNAME           => '20',
                        IFDESCR          => '20',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ec',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1379376285) 159 days, 15:36:02.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4245376885',
                        IFINERRORS       => '53',
                        IFOUTOCTETS      => '3894323797',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '40:6c:8f:19:af:cc',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '21',
                        IFNAME           => '21',
                        IFDESCR          => '21',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:eb',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(190) 0:00:01.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '22',
                        IFNAME           => '22',
                        IFDESCR          => '22',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:ea',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1233541755) 142 days, 18:30:17.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1373673400',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2040146199',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '10:9a:dd:51:49:8b',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '23',
                        IFNAME           => '23',
                        IFDESCR          => '23',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(786842405) 91 days, 1:40:24.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '166412344',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '855417653',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '24',
                        IFNAME           => '24',
                        IFDESCR          => '24',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e8',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388872250) 160 days, 17:58:42.50',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '838585355',
                        IFINERRORS       => '58',
                        IFOUTOCTETS      => '246106120',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '58:b0:35:fa:09:db',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '25',
                        IFNAME           => '25',
                        IFDESCR          => '25',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(190) 0:00:01.90',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '26',
                        IFNAME           => '26',
                        IFDESCR          => '26',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(195) 0:00:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '27',
                        IFNAME           => '27',
                        IFDESCR          => '27',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(195) 0:00:01.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '28',
                        IFNAME           => '28',
                        IFDESCR          => '28',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e4',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1388526210) 160 days, 17:01:02.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2478225265',
                        IFINERRORS       => '14',
                        IFOUTOCTETS      => '3995499070',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:1f:f3:fc:7b:33',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '29',
                        IFNAME           => '29',
                        IFDESCR          => '29',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1330715545) 154 days, 0:25:55.45',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '680317917',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1068310810',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '30',
                        IFNAME           => '30',
                        IFDESCR          => '30',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1330253700) 153 days, 23:08:57.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4177670453',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1970826181',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '31',
                        IFNAME           => '31',
                        IFDESCR          => '31',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e1',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1363348955) 157 days, 19:04:49.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '151349228',
                        IFINERRORS       => '110',
                        IFOUTOCTETS      => '305376087',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '32',
                        IFNAME           => '32',
                        IFDESCR          => '32',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:e0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(480) 0:00:04.80',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2587186053',
                        IFINERRORS       => '7',
                        IFOUTOCTETS      => '1319473461',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    'c4:2c:03:30:ef:91',
                                    '40:6c:8f:2e:cc:11',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '33',
                        IFNAME           => '33',
                        IFDESCR          => '33',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:df',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383042895) 160 days, 1:47:08.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2204543075',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '911642847',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '34',
                        IFNAME           => '34',
                        IFDESCR          => '34',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:de',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '35',
                        IFNAME           => '35',
                        IFDESCR          => '35',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:dd',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1331337560) 154 days, 2:09:35.60',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '34840840',
                        IFINERRORS       => '3',
                        IFOUTOCTETS      => '127880818',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '36',
                        IFNAME           => '36',
                        IFDESCR          => '36',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:dc',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '37',
                        IFNAME           => '37',
                        IFDESCR          => '37',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:db',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1330865915) 154 days, 0:50:59.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '28066227',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '839912103',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '38',
                        IFNAME           => '38',
                        IFDESCR          => '38',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:da',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(200) 0:00:02.00',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '39',
                        IFNAME           => '39',
                        IFDESCR          => '39',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d9',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(326559985) 37 days, 19:06:39.85',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '19942',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '44438',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '40',
                        IFNAME           => '40',
                        IFDESCR          => '40',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d8',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1330791515) 154 days, 0:38:35.15',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1405872326',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '729604430',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '41',
                        IFNAME           => '41',
                        IFDESCR          => '41',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d7',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1331614620) 154 days, 2:55:46.20',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '4097361308',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1892037049',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '42',
                        IFNAME           => '42',
                        IFDESCR          => '42',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d6',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(205) 0:00:02.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '43',
                        IFNAME           => '43',
                        IFDESCR          => '43',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d5',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1383183455) 160 days, 2:10:34.55',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1869684759',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '3157126516',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '44',
                        IFNAME           => '44',
                        IFDESCR          => '44',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d4',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(205) 0:00:02.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '45',
                        IFNAME           => '45',
                        IFDESCR          => '45',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d3',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(205) 0:00:02.05',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '46',
                        IFNAME           => '46',
                        IFDESCR          => '46',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d2',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210) 0:00:02.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '47',
                        IFNAME           => '47',
                        IFDESCR          => '47',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d1',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(535) 0:00:05.35',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2082404015',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1194319401',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:00:00:00:00:00',
                                    '00:00:74:d2:52:37',
                                    '00:00:74:ee:76:72',
                                    '00:00:74:ee:c8:5c',
                                    '00:00:aa:f6:d7:fd',
                                    '00:00:48:09:d2:7e',
                                    '00:01:96:38:a8:40',
                                    '00:01:e3:7b:e7:aa',
                                    '00:01:e3:7b:e7:af',
                                    '00:01:e3:7e:47:bc',
                                    '00:01:e3:7e:47:25',
                                    '00:01:e3:7e:47:27',
                                    '00:01:e3:7e:47:2a',
                                    '00:01:e3:7e:47:33',
                                    '00:01:e3:7e:47:51',
                                    '00:01:e3:82:71:7e',
                                    '00:01:e3:82:71:81',
                                    '00:01:e3:82:71:83',
                                    '00:01:e3:82:71:85',
                                    '00:01:e3:83:78:24',
                                    '00:01:e3:83:78:29',
                                    '00:01:e3:83:e9:67',
                                    '00:01:e3:83:e9:68',
                                    '00:01:e3:83:e9:60',
                                    '00:01:e3:83:ea:81',
                                    '00:01:e3:83:ea:82',
                                    '00:01:e3:83:ea:83',
                                    '00:01:e3:83:ea:85',
                                    '00:01:e3:83:ea:86',
                                    '00:01:e6:7c:88:1f',
                                    '00:01:e6:55:a3:f4',
                                    '00:01:42:d1:11:80',
                                    '00:0b:db:94:f4:95',
                                    '00:0b:45:b7:ad:80',
                                    '00:0c:c3:33:03:72',
                                    '00:0d:54:6e:d3:f8',
                                    '00:0d:54:a9:3f:7f',
                                    '00:0d:54:a9:3f:06',
                                    '00:0d:54:bc:8c:ee',
                                    '00:0d:54:f7:84:94',
                                    '00:0d:54:f7:84:f4',
                                    '00:0d:54:f7:85:ea',
                                    '00:0d:54:f7:85:18',
                                    '00:0d:54:f7:85:2f',
                                    '00:0d:54:f7:85:53',
                                    '00:0d:54:f7:86:0b',
                                    '00:0d:54:f7:86:34',
                                    '00:0d:54:f7:87:6e',
                                    '00:0d:54:f7:87:ac',
                                    '00:0d:54:f7:88:20',
                                    '00:0d:54:fc:46:da',
                                    '00:0d:56:fd:00:03',
                                    '00:88:65:c0:73:f6',
                                    '00:88:65:35:2e:68',
                                    '00:88:65:3a:bf:72',
                                    '00:0e:6a:b5:3d:7d',
                                    '00:0e:6a:bd:48:50',
                                    '00:0e:6a:be:10:69',
                                    '00:0e:6a:be:10:6a',
                                    '00:0e:6a:cd:77:50',
                                    '00:0e:6a:cd:85:7a',
                                    '00:0e:6a:d1:51:ae',
                                    '00:0e:6a:d1:52:0e',
                                    '00:0e:6a:d1:56:0f',
                                    '00:0e:6a:d1:56:f2',
                                    '00:0e:6a:d3:14:f9',
                                    '00:0e:6a:d3:14:fc',
                                    '00:0e:6a:d3:18:72',
                                    '00:0e:6a:d5:b9:54',
                                    '00:0e:6a:d5:ba:53',
                                    '00:0e:6a:d5:bb:8f',
                                    '00:0e:6a:d5:bb:ef',
                                    '00:0e:6a:d5:bc:13',
                                    '00:0e:6a:ed:6c:86',
                                    '00:0e:6a:1c:a2:07',
                                    '00:0e:35:87:c6:99',
                                    '00:0f:cb:7f:30:44',
                                    '00:0f:cb:0e:fe:5c',
                                    '00:0f:cb:a6:ee:dd',
                                    '00:0f:cb:a6:ee:f8',
                                    '00:9c:02:c9:03:0a',
                                    '00:10:18:80:a2:d8',
                                    '00:10:18:80:b8:b8',
                                    '00:10:18:96:9e:76',
                                    '00:10:18:97:47:d8',
                                    '00:10:18:b1:97:3a',
                                    '00:10:18:b2:59:11',
                                    '00:10:18:d9:a2:24',
                                    '00:10:18:48:15:ec',
                                    '00:10:18:5a:9e:06',
                                    '00:10:18:5a:b7:f3',
                                    '00:10:18:61:54:ac',
                                    '00:11:0a:fc:20:84',
                                    '00:12:a9:0b:af:10',
                                    '00:12:a9:71:17:6f',
                                    '00:12:a9:1a:9d:d4',
                                    '00:12:a9:07:0d:bd',
                                    '00:12:a9:07:0d:c9',
                                    '00:12:a9:07:0d:cb',
                                    '00:12:a9:07:0d:cf',
                                    '00:12:a9:07:0d:de',
                                    '00:12:a9:07:0d:e1',
                                    '00:12:f2:7e:89:40',
                                    '00:bd:3a:ee:2a:aa',
                                    '00:13:02:6b:a5:a5',
                                    '00:13:02:7d:a1:ab',
                                    '00:13:ce:b5:7e:10',
                                    '00:13:ce:ce:e7:87',
                                    '00:13:ce:f1:a3:6d',
                                    '00:c0:b7:d5:09:ac',
                                    '00:c0:b7:24:03:d6',
                                    '00:c0:b7:24:44:62',
                                    '00:c0:b7:24:4b:97',
                                    '00:c0:b7:2f:30:d9',
                                    '00:c0:b7:50:45:8f',
                                    '00:c6:10:24:d0:47',
                                    '00:c6:10:36:59:63',
                                    '00:02:1c:f8:00:ac',
                                    '00:14:7c:0e:25:f2',
                                    '00:14:7c:bf:82:d3',
                                    '00:14:7c:06:1e:f9',
                                    '00:14:7c:42:4b:b0',
                                    '00:14:7c:46:65:be',
                                    '00:14:7c:46:65:ed',
                                    '00:14:7c:46:65:2a',
                                    '00:14:7c:46:66:0b',
                                    '00:14:7c:46:66:86',
                                    '00:14:7c:46:66:0f',
                                    '00:14:7c:46:66:b0',
                                    '00:14:7c:46:66:4b',
                                    '00:14:7c:46:66:09',
                                    '00:14:7c:46:66:5b',
                                    '00:14:7c:46:67:0c',
                                    '00:14:7c:48:7f:d3',
                                    '00:14:f1:b6:ee:00',
                                    '00:15:c5:73:b6:9e',
                                    '00:15:c5:5f:c7:0e',
                                    '00:db:df:21:e1:25',
                                    '00:16:b6:a0:4d:1b',
                                    '00:16:d4:70:dd:f9',
                                    '00:16:3e:74:af:0a',
                                    '00:16:3e:11:9f:23',
                                    '00:16:3e:1f:98:f8',
                                    '00:16:44:84:17:25',
                                    '00:16:46:3f:69:b1',
                                    '00:e0:d8:0a:49:b7',
                                    '00:e0:d8:16:96:a7',
                                    '00:e0:d8:16:e1:d5',
                                    '00:17:a4:09:1e:c0',
                                    '00:17:c4:99:66:a7',
                                    '00:17:c4:23:03:09',
                                    '00:17:c4:41:83:f5',
                                    '00:18:8b:71:de:e6',
                                    '00:18:8b:80:90:df',
                                    '00:18:8b:17:4f:8a',
                                    '00:18:f3:ed:a2:46',
                                    '00:18:fe:df:ba:90',
                                    '00:19:94:33:9c:d1',
                                    '00:19:bb:99:c9:c0',
                                    '00:19:bb:99:2a:c0',
                                    '00:19:bb:a7:b5:00',
                                    '00:19:e3:06:f1:59',
                                    '00:1a:73:5e:aa:83',
                                    '00:1a:80:fa:42:90',
                                    '00:1a:a0:de:91:0b',
                                    '00:1a:4b:13:a6:0f',
                                    '00:1a:4b:1d:11:13',
                                    '00:1b:77:3e:71:77',
                                    '00:1b:78:12:a6:ac',
                                    '00:1b:78:16:3e:8c',
                                    '00:1b:78:28:d6:8a',
                                    '00:1b:b1:af:e0:d8',
                                    '00:1b:b1:4e:5c:9e',
                                    '00:1b:63:a5:19:20',
                                    '00:1b:63:a6:a4:31',
                                    '00:1b:63:ac:01:45',
                                    '00:1c:b3:7c:67:bf',
                                    '00:1c:bf:9d:90:e4',
                                    '00:1c:2e:bb:89:00',
                                    '00:1d:b3:60:bb:00',
                                    '00:1d:4f:f8:44:db',
                                    '00:1d:09:0a:21:d0',
                                    '00:1d:09:65:e0:37',
                                    '00:1d:09:07:0d:0f',
                                    '00:1d:09:07:a3:08',
                                    '00:1e:13:6e:d9:70',
                                    '00:1e:be:a7:f8:70',
                                    '00:1e:c2:14:48:36',
                                    '00:1e:4f:94:52:75',
                                    '00:1e:4f:98:91:9a',
                                    '00:1e:52:ac:bf:43',
                                    '00:1f:6c:ab:87:20',
                                    '00:1f:6c:ab:88:a0',
                                    '00:1f:9e:27:ff:10',
                                    '00:1f:9e:28:54:d0',
                                    '00:1f:e1:89:8e:6b',
                                    '00:1f:28:4f:ee:00',
                                    '00:1f:3b:d2:80:cd',
                                    '00:1f:3c:2e:40:5e',
                                    '00:1f:3c:30:44:7a',
                                    '00:1f:5b:b7:74:e2',
                                    '00:1f:5b:c5:ec:e1',
                                    '00:20:85:fb:43:4e',
                                    '00:20:a6:ec:83:4b',
                                    '00:20:4a:d7:4c:75',
                                    '00:21:00:30:5b:33',
                                    '00:21:6a:8b:22:7a',
                                    '00:21:6a:c1:7e:84',
                                    '00:21:6b:af:9c:86',
                                    '00:21:70:86:71:d1',
                                    '00:21:9b:79:44:c8',
                                    '00:21:9b:5b:5b:66',
                                    '00:21:5c:73:77:25',
                                    '00:21:5d:be:fe:94',
                                    '00:21:5d:1c:4a:52',
                                    '00:21:5d:2d:91:ba',
                                    '00:21:63:c4:6f:da',
                                    '00:22:19:00:2e:67',
                                    '00:22:19:85:39:3d',
                                    '00:22:19:8b:f7:c9',
                                    '00:22:19:12:da:a6',
                                    '00:22:19:ce:dc:80',
                                    '00:22:19:22:e9:e4',
                                    '00:22:19:26:4e:8e',
                                    '00:22:fb:17:cc:ce',
                                    '00:22:fb:5f:22:1c',
                                    '00:22:41:f9:f4:38',
                                    '00:22:41:24:c1:09',
                                    '00:23:6c:8a:52:58',
                                    '00:23:6c:91:7b:bf',
                                    '00:23:6c:9a:ea:9b',
                                    '00:23:6c:d3:a3:8c',
                                    '00:23:ae:eb:d5:d4',
                                    '00:23:ae:fb:dc:34',
                                    '00:23:ae:fb:fb:80',
                                    '00:23:ae:fe:17:74',
                                    '00:23:12:11:2b:46',
                                    '00:23:12:22:19:6b',
                                    '00:23:12:08:18:65',
                                    '00:23:df:de:73:07',
                                    '00:23:32:b1:3c:f0',
                                    '00:23:32:c2:b9:82',
                                    '00:23:4d:5c:6f:0b',
                                    '00:23:4e:ac:61:d0',
                                    '00:24:d6:ad:cd:30',
                                    '00:24:d6:2d:d8:6c',
                                    '00:24:d6:37:73:0c',
                                    '00:24:d7:71:7f:d4',
                                    '00:24:d7:71:63:14',
                                    '00:24:d7:76:f8:40',
                                    '00:24:d7:8b:67:1c',
                                    '00:24:e8:cd:de:d7',
                                    '00:24:e8:e8:f2:91',
                                    '00:24:2c:55:6a:e9',
                                    '00:24:36:b8:ce:e5',
                                    '00:24:36:e8:d2:76',
                                    '00:25:00:f1:7e:a4',
                                    '00:25:00:3d:ff:7d',
                                    '00:25:00:42:a0:83',
                                    '00:25:64:aa:c9:f0',
                                    '00:25:4b:6a:63:7c',
                                    '00:25:4b:8b:46:e6',
                                    '00:25:4b:93:53:2e',
                                    '00:25:4b:49:57:11',
                                    '00:26:b0:7c:18:21',
                                    '00:26:b6:3e:b5:e5',
                                    '00:26:b9:aa:1f:b3',
                                    '00:26:b9:ea:7d:76',
                                    '00:26:bb:13:1d:b1',
                                    '00:26:bb:1d:83:4c',
                                    '00:26:bb:03:b5:bd',
                                    '00:26:bb:04:06:07',
                                    '00:26:cb:10:0c:50',
                                    '00:26:cb:10:1f:c0',
                                    '00:26:cb:10:2e:b0',
                                    '00:26:cb:10:2e:c0',
                                    '00:26:cb:10:30:10',
                                    '00:26:cb:10:39:90',
                                    '00:26:cb:10:3a:20',
                                    '00:26:cb:10:3b:d0',
                                    '00:26:cb:10:40:30',
                                    '00:26:cb:10:41:50',
                                    '00:26:cb:10:42:80',
                                    '00:26:cb:10:09:60',
                                    '00:26:cb:11:1a:80',
                                    '00:26:cb:11:05:00',
                                    '00:26:cb:b8:bf:f0',
                                    '00:26:cb:1b:c2:00',
                                    '00:26:cb:1d:79:a0',
                                    '00:26:cb:1d:7a:f0',
                                    '00:26:cb:1d:7c:e0',
                                    '00:26:cb:1d:7d:b0',
                                    '00:26:cb:1d:7d:c0',
                                    '00:26:cb:1d:7e:20',
                                    '00:26:cb:1d:7f:10',
                                    '00:26:cb:1d:92:30',
                                    '00:26:cb:1d:94:30',
                                    '00:26:cb:1d:97:00',
                                    '00:26:cb:1d:9d:20',
                                    '00:26:cb:1d:9e:70',
                                    '00:26:cb:1d:a1:30',
                                    '00:26:cb:1d:a2:20',
                                    '00:26:cb:1d:a2:60',
                                    '00:26:cb:1d:a3:70',
                                    '00:26:cb:1d:a6:20',
                                    '00:26:cb:1d:a9:60',
                                    '00:26:cb:1d:aa:00',
                                    '00:26:cb:1d:ab:30',
                                    '00:26:cb:1d:59:60',
                                    '00:26:4a:19:56:ba',
                                    '00:26:08:73:3d:1b',
                                    '00:26:08:02:15:e0',
                                    '00:26:08:e1:6b:31',
                                    '00:26:08:e4:35:06',
                                    '00:26:5e:70:43:c6',
                                    '00:27:10:e0:5e:48',
                                    '00:05:1e:0d:38:23',
                                    '00:05:1e:84:d0:56',
                                    '00:05:1e:87:05:98',
                                    '00:37:6d:da:f6:3a',
                                    '00:08:14:00:37:aa',
                                    '00:50:56:b2:3a:42',
                                    '00:60:9f:80:06:14',
                                    '64:a3:cb:c3:b5:c3',
                                    '64:b9:e8:87:51:6f',
                                    '64:b9:e8:c7:44:cc',
                                    '68:94:23:6d:74:f3',
                                    '68:9c:70:aa:0f:d0',
                                    '68:a3:c4:dc:16:ce',
                                    '68:a3:c4:43:57:70',
                                    '68:a8:6d:0b:74:e2',
                                    '68:a8:6d:23:a6:b0',
                                    '68:a8:6d:34:8f:c4',
                                    '68:a8:6d:4a:c5:b2',
                                    '68:09:27:b9:55:4d',
                                    '68:5d:43:0b:84:6b',
                                    '68:5d:43:0b:19:18',
                                    '68:5d:43:57:d9:9c',
                                    '6c:71:d9:6b:02:0a',
                                    '6c:71:d9:70:5f:32',
                                    '6c:71:d9:7f:fb:36',
                                    '6c:71:d9:80:49:6a',
                                    '6c:83:36:a6:73:66',
                                    '6c:9c:ed:ec:22:e0',
                                    '6c:c2:6b:79:f6:ed',
                                    '6c:c2:6b:88:95:50',
                                    '6c:3e:6d:74:05:1e',
                                    '70:73:cb:10:07:3c',
                                    '70:aa:b2:76:bd:b6',
                                    '70:cd:60:a9:8d:fe',
                                    '70:f3:95:e1:ac:f9',
                                    '70:f3:95:e7:7c:65',
                                    '70:f9:27:c7:a9:a3',
                                    '70:56:81:91:11:e3',
                                    '70:56:81:93:45:c9',
                                    '74:de:2b:2b:c1:69',
                                    '74:e1:b6:7d:d2:cb',
                                    '74:e5:43:71:ab:36',
                                    '74:f0:6d:0a:1e:cd',
                                    '74:2f:68:8c:32:8d',
                                    '74:2f:68:4d:f0:0a',
                                    '74:2f:68:53:0a:13',
                                    '74:45:8a:67:6d:ad',
                                    '74:45:8a:53:cf:6d',
                                    '0c:74:c2:75:b8:4e',
                                    '0c:74:c2:7a:2b:7c',
                                    '0c:84:dc:9d:f6:4f',
                                    '0c:ee:e6:9f:09:0b',
                                    '0c:ee:e6:d5:ce:b4',
                                    '78:92:9c:73:3e:70',
                                    '78:92:9c:22:1e:e4',
                                    '78:a3:e4:cf:4c:fa',
                                    '78:ac:c0:77:93:00',
                                    '78:ca:39:ae:e4:58',
                                    '78:ca:39:b7:1c:41',
                                    '78:d6:f0:b0:6d:64',
                                    '78:dd:08:e1:21:7a',
                                    '78:e4:00:0b:f5:4a',
                                    '78:e4:00:f4:ee:16',
                                    '78:1f:db:ac:93:66',
                                    '78:2b:cb:35:e7:b3',
                                    '7c:11:be:90:77:39',
                                    '7c:11:be:d1:3c:7f',
                                    '7c:d1:c3:97:e5:c4',
                                    '7c:d1:c3:99:c6:0e',
                                    '7c:d1:c3:9b:96:be',
                                    '7c:d1:c3:ec:0f:f9',
                                    '7c:d1:c3:40:b2:70',
                                    '7c:e9:d3:8c:07:d4',
                                    '7c:61:93:32:b5:10',
                                    '80:c1:6e:fc:0d:f4',
                                    '80:49:71:10:61:21',
                                    '84:74:2a:fe:69:e7',
                                    '84:85:06:69:c3:86',
                                    '84:8f:69:d6:6d:fa',
                                    '84:8f:69:d6:6d:54',
                                    '84:a6:c8:b2:fd:86',
                                    '84:a6:c8:da:1d:cb',
                                    '84:25:db:67:a7:92',
                                    '84:2b:2b:9b:0a:6b',
                                    '84:2b:2b:9b:48:91',
                                    '84:2b:2b:a2:81:bc',
                                    '84:2b:2b:b7:8b:f3',
                                    '84:38:35:4c:73:70',
                                    '84:38:35:54:50:1c',
                                    '84:3a:4b:7d:02:38',
                                    '84:4b:f5:16:e2:99',
                                    '84:4b:f5:29:b0:bb',
                                    '84:51:81:8c:43:a8',
                                    '88:c6:63:dc:ca:e3',
                                    '88:c6:63:f3:55:cc',
                                    '88:cb:87:ac:70:46',
                                    '88:f0:77:36:77:e0',
                                    '88:1f:a1:0f:74:46',
                                    '88:1f:a1:18:dd:1a',
                                    '88:32:9b:bc:83:10',
                                    '88:32:9b:e6:b1:5c',
                                    '88:32:9b:24:e9:d8',
                                    '88:53:95:9f:b0:08',
                                    '88:53:95:d3:23:4e',
                                    '88:53:95:62:5a:68',
                                    '88:53:d4:27:c9:ff',
                                    '8c:70:5a:dc:4d:c8',
                                    '8c:7b:9d:d5:c6:4d',
                                    '8c:7b:9d:d5:d0:a4',
                                    '8c:fa:ba:4d:e8:6a',
                                    '8c:2d:aa:45:3e:c7',
                                    '8c:2d:aa:4a:a1:d1',
                                    '90:84:0d:9a:91:8f',
                                    '90:84:0d:53:b7:8b',
                                    '90:b1:1c:96:55:f5',
                                    '90:b1:1c:5e:c8:b9',
                                    '90:b1:1c:5e:f2:d2',
                                    '90:b1:1c:5e:f4:fb',
                                    '90:b1:1c:5e:f6:cc',
                                    '90:b1:1c:5e:f8:52',
                                    '90:18:7c:1b:c3:e8',
                                    '90:18:7c:37:c2:1f',
                                    '90:18:7c:58:7d:e3',
                                    '90:18:7c:5f:7d:c3',
                                    '90:27:e4:fe:d9:4e',
                                    '90:4c:e5:8a:67:07',
                                    '90:4c:e5:1b:9c:05',
                                    '94:71:ac:f9:d0:8a',
                                    '94:94:26:01:87:2e',
                                    '94:d7:71:0f:10:f4',
                                    '94:39:e5:c4:c1:93',
                                    '98:0c:82:8c:8d:a9',
                                    '98:0c:82:15:33:2d',
                                    '98:0c:82:56:2c:50',
                                    '98:d6:bb:70:0e:08',
                                    '98:d6:bb:ae:2d:01',
                                    '98:d6:f7:6a:1f:84',
                                    '98:d6:f7:5d:fe:8b',
                                    '98:fe:94:06:52:96',
                                    '98:fe:94:41:ce:64',
                                    '98:fe:94:49:ea:04',
                                    '98:fe:94:59:5a:f9',
                                    '9c:93:4e:1e:7d:42',
                                    '9c:b7:0d:3c:65:0a',
                                    '9c:02:98:19:2a:f3',
                                    '9c:eb:e8:0d:77:25',
                                    '9c:eb:e8:04:f6:4e',
                                    '9c:04:eb:1d:8f:33',
                                    '9c:2a:70:25:52:d9',
                                    '10:68:3f:85:31:4e',
                                    '10:68:3f:46:63:50',
                                    '10:0b:a9:50:e2:f0',
                                    '10:0b:a9:52:72:94',
                                    '10:0b:a9:52:72:c0',
                                    '10:93:e9:0e:a4:78',
                                    '10:9a:dd:a1:f4:c0',
                                    '10:dd:b1:a6:8d:c6',
                                    '10:1c:0c:9f:9e:87',
                                    '10:1c:0c:28:32:91',
                                    '10:1c:0c:40:04:20',
                                    '10:40:f3:7c:30:6a',
                                    '10:40:f3:7c:40:8a',
                                    '10:40:f3:82:e5:76',
                                    '10:40:f3:86:62:02',
                                    '10:40:f3:f0:20:78',
                                    'a0:6c:ec:6f:ea:16',
                                    'a0:82:1f:6c:55:99',
                                    'a0:f3:c1:09:1c:30',
                                    'a0:f4:50:ef:81:cf',
                                    'a4:67:06:ba:8c:55',
                                    'a4:67:06:54:b2:27',
                                    'a4:ba:db:ef:fa:28',
                                    'a4:ba:db:f0:44:d7',
                                    'a4:ba:db:f0:44:dd',
                                    'a4:ba:db:f8:50:d4',
                                    'a4:d1:d2:0a:da:a0',
                                    'a4:17:31:09:9c:a7',
                                    'a4:ee:57:92:52:cf',
                                    'a8:88:08:1b:e6:62',
                                    'a8:fa:d8:e5:a3:9a',
                                    'a8:20:66:25:77:1b',
                                    'ac:72:89:77:a9:4d',
                                    'b0:65:bd:0b:a3:92',
                                    'b0:65:bd:72:07:1b',
                                    'b0:65:bd:54:d3:71',
                                    'b4:74:9f:ae:f1:1f',
                                    'b4:99:ba:d7:54:30',
                                    'b4:b6:76:10:6c:56',
                                    'b4:b6:76:ac:14:35',
                                    'b4:b6:76:08:33:51',
                                    'b4:f0:ab:7e:bb:14',
                                    'b4:f0:ab:b4:50:11',
                                    'b4:07:f9:d5:f8:d6',
                                    'b8:70:f4:57:63:a9',
                                    'b8:76:3f:26:05:a9',
                                    'b8:78:2e:84:9b:56',
                                    'b8:8d:12:14:c3:26',
                                    'b8:8d:12:1b:df:e0',
                                    'b8:8d:12:1b:e0:62',
                                    'b8:8d:12:1b:e1:f0',
                                    'b8:8d:12:2e:60:06',
                                    'b8:8d:12:08:0f:e0',
                                    'b8:ac:6f:92:5e:ee',
                                    'b8:ac:6f:92:61:6c',
                                    'b8:ac:6f:97:a2:49',
                                    'bc:67:78:0c:bf:02',
                                    'bc:72:b1:78:df:3a',
                                    'bc:cf:cc:75:93:53',
                                    'bc:cf:cc:ca:d7:a6',
                                    'bc:30:5b:d0:72:20',
                                    'bc:3b:af:0e:e5:a1',
                                    'bc:47:60:9e:7a:2d',
                                    'c0:65:99:8d:d6:03',
                                    'c0:65:99:8e:4f:0b',
                                    'c0:18:85:bb:e1:e3',
                                    'c0:f8:da:38:71:6c',
                                    'c4:0a:cb:65:9a:00',
                                    'c4:0a:cb:65:9b:c0',
                                    'c4:0a:cb:65:b5:f0',
                                    'c4:0a:cb:65:b7:60',
                                    'c4:0a:cb:65:f0:20',
                                    'c4:0a:cb:a4:1c:c0',
                                    'c4:0a:cb:b2:2d:d0',
                                    'c4:0a:cb:24:6f:f0',
                                    'c4:0a:cb:24:70:00',
                                    'c4:0a:cb:24:70:a0',
                                    'c4:0a:cb:24:73:80',
                                    'c4:0a:cb:24:43:10',
                                    'c4:0a:cb:24:47:60',
                                    'c4:0a:cb:24:49:b0',
                                    'c4:0a:cb:24:4b:90',
                                    'c4:0a:cb:24:52:50',
                                    'c4:0a:cb:24:54:80',
                                    'c4:0a:cb:2c:0a:90',
                                    'c4:0a:cb:2c:0b:a0',
                                    'c4:0a:cb:2c:03:c0',
                                    'c4:0a:cb:2c:04:80',
                                    'c4:0a:cb:2c:29:a0',
                                    'c4:0a:cb:2c:2a:e0',
                                    'c4:0a:cb:2c:2d:90',
                                    'c4:0a:cb:2c:05:e0',
                                    'c4:0a:cb:2c:09:c0',
                                    'c4:0a:cb:5d:ee:80',
                                    'c4:64:13:11:31:81',
                                    'c4:64:13:11:31:60',
                                    'c4:64:13:2b:f2:25',
                                    'c4:85:08:31:52:6d',
                                    'c4:17:fe:a6:ed:b7',
                                    'c4:2c:03:3b:ea:71',
                                    'c4:46:19:1b:8f:48',
                                    '14:8f:c6:be:89:49',
                                    '14:8f:c6:4a:ff:a2',
                                    '14:8f:c6:4b:97:91',
                                    '14:10:9f:d0:cb:3b',
                                    '14:10:9f:d4:12:57',
                                    '14:10:9f:dd:04:cf',
                                    '14:10:9f:e5:1c:4b',
                                    '14:10:9f:e9:eb:e2',
                                    '14:10:9f:f1:73:38',
                                    '14:10:9f:f1:5c:ea',
                                    '14:10:9f:f2:ac:e0',
                                    '14:10:9f:f4:0d:1e',
                                    '14:5a:05:c9:ab:98',
                                    '14:5a:05:21:20:b6',
                                    'c8:aa:21:19:d9:44',
                                    'c8:bc:c8:98:5b:62',
                                    'c8:bc:c8:c2:ea:fa',
                                    'c8:bc:c8:d9:7f:53',
                                    'c8:bc:c8:d9:63:1a',
                                    'c8:e0:eb:e1:ee:02',
                                    'c8:f7:33:a6:6b:e3',
                                    'c8:19:f7:ee:b7:95',
                                    'c8:2a:14:18:4a:84',
                                    'c8:2a:14:51:5d:42',
                                    'cc:78:5f:68:90:6e',
                                    'cc:af:78:c6:a5:a1',
                                    'cc:af:78:cf:c1:49',
                                    'cc:08:e0:c4:93:a2',
                                    'cc:52:af:5e:a7:dc',
                                    'd0:b3:3f:68:0c:80',
                                    'd0:b3:3f:68:10:d6',
                                    'd0:b3:3f:7e:e3:7a',
                                    'd0:b3:3f:9a:c1:1c',
                                    'd0:b3:3f:9a:c2:69',
                                    'd0:b3:3f:a6:b5:70',
                                    'd0:b3:3f:f5:ba:88',
                                    'd0:23:db:31:af:58',
                                    'd0:57:85:57:c0:99',
                                    'd4:85:64:7f:4f:cf',
                                    'd4:9a:20:57:16:45',
                                    'd4:a0:2a:10:38:c0',
                                    'd4:be:d9:0c:f2:43',
                                    'd8:9e:3f:ac:bd:ee',
                                    'd8:9e:3f:b8:4a:0a',
                                    'd8:9e:3f:36:3d:db',
                                    'd8:a2:5e:a1:50:90',
                                    'd8:24:bd:d5:1c:b0',
                                    'd8:24:bd:d5:22:00',
                                    'd8:24:bd:d5:24:c0',
                                    'd8:24:bd:d5:26:d0',
                                    'd8:24:bd:d5:2d:c0',
                                    'd8:24:bd:d5:2e:70',
                                    'd8:24:bd:d5:2e:50',
                                    'd8:24:bd:d5:33:f0',
                                    'd8:24:bd:d5:34:40',
                                    'd8:24:bd:d5:39:a0',
                                    'd8:24:bd:d5:40:a0',
                                    'd8:24:bd:d5:41:80',
                                    'd8:24:bd:d5:43:c0',
                                    'd8:24:bd:d5:44:d0',
                                    'd8:24:bd:d5:45:f0',
                                    'd8:24:bd:d5:47:a0',
                                    'd8:24:bd:d5:4a:c0',
                                    'd8:24:bd:d5:4c:c0',
                                    'd8:24:bd:d5:4c:20',
                                    'd8:24:bd:d5:4f:e0',
                                    'd8:24:bd:d5:50:30',
                                    'd8:24:bd:d5:51:00',
                                    'd8:24:bd:d5:51:b0',
                                    'd8:24:bd:d5:51:d0',
                                    'd8:24:bd:d5:51:f0',
                                    'd8:24:bd:d5:55:d0',
                                    'd8:24:bd:d5:55:50',
                                    'd8:24:bd:d5:58:30',
                                    'd8:24:bd:d5:58:40',
                                    'd8:24:bd:d5:5f:70',
                                    'd8:24:bd:d5:5f:50',
                                    'd8:24:bd:d5:60:b0',
                                    'd8:24:bd:d5:60:40',
                                    'd8:24:bd:d5:61:80',
                                    'd8:24:bd:d5:63:60',
                                    'd8:24:bd:e8:d0:b0',
                                    'd8:24:bd:e8:d4:10',
                                    'd8:24:bd:e8:d9:90',
                                    'd8:24:bd:e8:e0:b0',
                                    'd8:24:bd:e8:e0:e0',
                                    'd8:24:bd:e8:e8:90',
                                    'd8:24:bd:e8:ea:d0',
                                    'd8:24:bd:e8:ee:10',
                                    'd8:24:bd:e8:f2:60',
                                    'd8:24:bd:e8:f4:80',
                                    'd8:24:bd:e8:f4:c0',
                                    'd8:24:bd:e8:f5:60',
                                    'd8:24:bd:e8:f7:a0',
                                    'd8:24:bd:e8:f9:70',
                                    'd8:24:bd:e9:00:00',
                                    'd8:24:bd:e9:0a:00',
                                    'd8:24:bd:e9:0d:a0',
                                    'd8:24:bd:e9:0d:30',
                                    'd8:24:bd:e9:82:40',
                                    'd8:24:bd:e9:14:70',
                                    'd8:24:bd:e9:14:b0',
                                    'd8:24:bd:e9:16:f0',
                                    'd8:24:bd:e9:18:a0',
                                    'd8:24:bd:e9:f5:80',
                                    'd8:24:bd:e9:f5:b0',
                                    'd8:24:bd:e9:fb:e0',
                                    'd8:24:bd:e9:fd:20',
                                    'd8:30:62:c4:da:ec',
                                    'd8:30:62:5e:1c:19',
                                    'd8:30:62:61:b9:18',
                                    'd8:57:ef:37:44:bb',
                                    'dc:85:de:0f:d2:25',
                                    'e0:b9:a5:ac:e6:6b',
                                    'e0:db:55:e2:96:d7',
                                    'e0:f8:47:10:85:1a',
                                    'e0:f8:47:a4:84:96',
                                    'e0:f8:47:19:58:32',
                                    'e0:f8:47:40:f9:de',
                                    'e0:f8:47:5f:8f:0a',
                                    'e0:2a:82:9f:be:5f',
                                    'e4:ce:8f:0c:a2:96',
                                    'e4:ce:8f:0f:7c:c8',
                                    'e4:ce:8f:a7:c3:33',
                                    'e4:ce:8f:b8:af:50',
                                    'e4:ce:8f:36:81:40',
                                    'e4:ce:8f:3c:b3:b6',
                                    'e4:d5:3d:68:e0:02',
                                    'e4:d5:3d:96:42:3a',
                                    'e4:2d:02:03:29:c7',
                                    'e8:99:c4:b6:37:20',
                                    'e8:99:c4:bd:ea:2c',
                                    'e8:cb:a1:ff:5a:9d',
                                    'e8:39:df:95:9d:22',
                                    'e8:06:88:a4:22:6f',
                                    'ec:85:2f:a5:dc:13',
                                    'ec:89:f5:60:fa:e2',
                                    'ec:35:86:5f:04:a8',
                                    'ec:55:f9:82:2e:fe',
                                    'ec:55:f9:36:17:22',
                                    '18:03:73:0a:20:57',
                                    '18:03:73:0a:42:f9',
                                    '18:03:73:0a:44:d8',
                                    '18:03:73:de:b4:ce',
                                    '18:03:73:09:65:56',
                                    '18:03:73:09:65:57',
                                    '18:03:73:09:d0:a2',
                                    '18:03:73:09:d3:63',
                                    '18:03:73:09:31:ac',
                                    '18:03:73:09:32:88',
                                    '18:33:9d:29:8b:20',
                                    '18:34:51:36:ce:a3',
                                    '18:3f:47:54:e4:2c',
                                    '18:46:17:e7:4b:ea',
                                    'f0:6b:ca:1b:25:d4',
                                    'f0:b4:79:14:db:4e',
                                    'f0:cb:a1:66:e1:cb',
                                    'f0:cb:a1:6b:66:18',
                                    'f0:cb:a1:a4:f5:ff',
                                    'f4:f1:5a:0c:75:af',
                                    'f4:f1:5a:bd:41:76',
                                    'f4:1b:a1:6e:eb:b7',
                                    'f8:a4:5f:17:bd:d6',
                                    'f8:1e:df:8b:7b:b8',
                                    'f8:1e:df:9a:fc:67',
                                    'f8:1e:df:9c:0c:43',
                                    'f8:1e:df:ad:af:1a',
                                    'f8:1e:df:dc:cb:28',
                                    'f8:1e:df:dc:da:84',
                                    'f8:1e:df:e5:f9:32',
                                    'f8:1e:df:e9:e5:b7',
                                    'f8:1e:df:ed:c7:48',
                                    '1c:65:9d:76:63:5f',
                                    '1c:ab:a7:8b:20:3b',
                                    '1c:b0:94:a3:4b:ea',
                                    '1c:b0:94:cf:fd:09',
                                    '20:64:32:89:4c:4c',
                                    '20:68:9d:04:4c:60',
                                    '20:10:7a:93:e3:e4',
                                    '20:10:7a:43:a8:46',
                                    '20:c9:d0:7e:a4:f7',
                                    '20:c9:d0:87:f6:77',
                                    '20:c9:d0:c2:96:3d',
                                    '20:c9:d0:c3:a2:f5',
                                    '20:c9:d0:d5:2a:6b',
                                    '20:c9:d0:d9:b6:85',
                                    '20:c9:d0:da:b1:01',
                                    '20:c9:d0:de:87:47',
                                    '20:c9:d0:2b:4c:35',
                                    '20:16:d8:05:6f:6a',
                                    '20:54:76:4c:8e:1d',
                                    '24:77:03:65:c2:50',
                                    '24:77:03:bb:f0:50',
                                    '24:77:03:13:1f:b8',
                                    '24:77:03:c1:ac:14',
                                    '24:77:03:15:41:a0',
                                    '24:77:03:23:c1:18',
                                    '24:77:03:2c:75:68',
                                    '24:fd:52:79:06:ef',
                                    '04:0c:ce:88:1b:23',
                                    '04:0c:ce:d8:a3:a2',
                                    '04:e5:36:40:91:fa',
                                    '04:f7:e4:cc:92:33',
                                    '04:1e:64:44:b0:12',
                                    '04:1e:64:08:e2:f7',
                                    '04:46:65:87:9a:a1',
                                    '04:46:65:52:4f:e5',
                                    '04:54:53:a1:da:3c',
                                    '28:6a:ba:11:0b:7d',
                                    '28:6a:ba:b3:41:f8',
                                    '28:6a:ba:f3:1f:95',
                                    '28:94:0f:db:59:1d',
                                    '28:cf:da:de:63:52',
                                    '28:cf:da:e7:ed:34',
                                    '28:cf:da:e7:4e:94',
                                    '28:cf:da:e8:04:76',
                                    '28:cf:da:e9:75:d0',
                                    '28:cf:da:3d:93:d2',
                                    '28:cf:e9:65:17:cf',
                                    '28:cf:e9:15:25:6b',
                                    '28:cf:e9:55:b4:1d',
                                    '28:cf:e9:5c:1a:4f',
                                    '28:e0:2c:02:b8:f7',
                                    '28:e0:2c:43:6d:3d',
                                    '28:37:37:b2:eb:d1',
                                    '28:37:37:19:5f:40',
                                    '2c:27:d7:19:f5:5b',
                                    '30:85:a9:07:fa:4b',
                                    '30:85:a9:5f:19:5b',
                                    '34:15:9e:01:98:b6',
                                    '34:15:9e:8a:d8:c9',
                                    '34:15:9e:91:2f:cc',
                                    '34:15:9e:f4:cb:fe',
                                    '34:23:ba:16:cd:57',
                                    '34:51:c9:98:c6:ab',
                                    '34:51:c9:c6:a6:55',
                                    '38:0f:4a:63:ab:aa',
                                    '38:aa:3c:1c:14:61',
                                    '38:aa:3c:51:fc:4e',
                                    '38:e7:d8:d8:95:12',
                                    '38:60:77:be:eb:0b',
                                    '3c:d0:f8:4c:28:d9',
                                    '3c:e0:72:2b:14:20',
                                    '3c:e0:72:32:1a:76',
                                    '3c:43:8e:c4:0b:17',
                                    '3c:07:54:7e:ad:c6',
                                    '40:6c:8f:12:ac:a1',
                                    '40:6c:8f:b9:89:17',
                                    '40:6c:8f:bc:01:dc',
                                    '40:b3:95:8d:19:cc',
                                    '40:b3:95:e7:9e:c3',
                                    '40:b3:95:4d:8e:c1',
                                    '40:f3:08:22:19:2a',
                                    '40:25:c2:c9:5d:04',
                                    '40:30:04:4b:a3:ff',
                                    '44:2a:60:a4:4d:e0',
                                    '48:5d:60:f9:18:29',
                                    '48:60:bc:7b:43:c9',
                                    '48:60:bc:95:df:6b',
                                    '48:60:bc:b1:75:76',
                                    '48:60:bc:21:f6:b3',
                                    '48:60:bc:34:ba:c2',
                                    '4c:80:93:51:cd:8b',
                                    '4c:8b:ef:a8:82:51',
                                    '4c:8d:79:e3:46:e2',
                                    '4c:8d:79:e6:cb:8a',
                                    '4c:8d:79:f2:47:f6',
                                    '4c:0f:6e:d9:d8:14',
                                    '4c:b1:99:ee:64:3f',
                                    '08:70:45:69:38:be',
                                    '08:70:45:2a:5e:1a',
                                    '08:11:96:97:74:b4',
                                    '08:ed:b9:ba:81:f9',
                                    '08:ed:b9:06:34:2d',
                                    '08:ed:b9:3d:00:5c',
                                    '08:ed:b9:48:10:69',
                                    '08:3e:8e:85:c8:65',
                                    '08:3e:8e:da:ab:27',
                                    '08:3e:8e:4b:dc:0b',
                                    '50:01:bb:cf:83:23',
                                    '50:ea:d6:92:f2:41',
                                    '50:63:13:c3:9e:07',
                                    '54:26:96:9f:48:85',
                                    '54:26:96:cf:53:1b',
                                    '54:53:ed:32:0f:bd',
                                    '58:94:6b:45:ba:c4',
                                    '58:b0:35:f5:89:45',
                                    '58:b0:35:36:17:c3',
                                    '58:1f:aa:c8:3e:73',
                                    '5c:0a:5b:e0:ea:a4',
                                    '5c:95:ae:02:91:b6',
                                    '5c:96:9d:7c:91:95',
                                    '5c:96:9d:89:d9:b9',
                                    '5c:96:9d:e7:dc:f4',
                                    '5c:ac:4c:16:01:7a',
                                    '5c:b5:24:e5:02:b5',
                                    '5c:e8:eb:e6:27:1c',
                                    '5c:f9:dd:d6:fe:30',
                                    '5c:f9:dd:d6:35:d9',
                                    '5c:f9:dd:d6:36:0b',
                                    '5c:f9:dd:d6:36:12',
                                    '5c:ff:35:2a:03:8e',
                                    '5c:26:0a:01:89:a1',
                                    '5c:26:0a:5d:70:04',
                                    '5c:59:48:8e:0a:7d',
                                    '5c:59:48:35:0c:d9',
                                    '60:a4:4c:71:a5:91',
                                    '60:c5:47:77:04:4b',
                                    '60:c5:47:8d:c6:ea',
                                    '60:c5:47:96:82:60',
                                    '60:c5:47:98:dc:68',
                                    '60:c5:47:ec:9f:91',
                                    '60:d8:19:a7:0c:c2',
                                    '60:fa:cd:5c:29:19',
                                    '60:21:c0:12:21:9f',
                                    '60:21:c0:63:93:0c',
                                    '60:33:4b:0e:00:81',
                                    '60:36:dd:8b:7f:c7',
                                    '60:36:dd:94:95:8f',
                                    '60:36:dd:a5:dc:50',
                                    '60:45:bd:81:ed:ee',
                                    '00:0c:c3:33:03:77',
                                    '60:36:dd:08:e9:7c',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '48',
                        IFNAME           => '48',
                        IFDESCR          => '48',
                        IFTYPE           => '6',
                        IFSPEED          => '10000000',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:d0',
                        IFSTATUS         => '2',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(210) 0:00:02.10',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '97',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '109',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '110',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '123',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '133',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '159',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '160',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '161',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '162',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '165',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '169',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '171',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(555) 0:00:05.55',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '177',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446435) 160 days, 0:07:44.35',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '178',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '294',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '297',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '298',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '300',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '304',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '306',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(1382446425) 160 days, 0:07:44.25',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '336',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(560) 0:00:05.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '340',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(560) 0:00:05.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '711',
                        IFTYPE           => '53',
                        IFSPEED          => '0',
                        IFMTU            => '1514',
                        MAC              => '00:19:bb:99:f9:c0',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(560) 0:00:05.60',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4192',
                        IFNAME           => 'lo0',
                        IFDESCR          => 'HP ProCurve Switch software loopback interface',
                        IFALIAS          => 'lo0',
                        IFTYPE           => '24',
                        IFSPEED          => '0',
                        IFMTU            => '32768',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(0) 0:00:00.00',
                        IFINOCTETS       => '0',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '0',
                        IFOUTERRORS      => '0',
                    },
                ]
            },
        },
    ],
    'hewlett-packard/ProCurve_J9050A.walk' => [
        {
            TYPE         => 'NETWORKING',
            MANUFACTURER => 'Hewlett-Packard',
            MODEL        => 'ProCurve 2900-48g (J9050A)',
            DESCRIPTION  => 'ProCurve J9050A Switch 2900-48G, revision T.13.80, ROM K.12.12 (/sw/code/build/mbm)',

            LOCATION     => 'salle serveur',
            SERIAL       => 'SG840KJ009',
            FIRMWARE     => 'K.12.12',
            UPTIME       => '(485451519) 56 days, 4:28:35.19',
            MAC          => '00:21:f7:1e:01:40',
            IPS          => {
                IP => [
                    '10.100.205.43',
                    '127.0.0.1',
                ],
            },
        },
        {
            INFO => {
                ID           => undef,
                TYPE         => 'NETWORKING',
                MANUFACTURER => 'Hewlett-Packard',
                MODEL        => 'ProCurve 2900-48g (J9050A)',
                COMMENTS     => 'ProCurve J9050A Switch 2900-48G, revision T.13.80, ROM K.12.12 (/sw/code/build/mbm)',
                LOCATION     => 'salle serveur',
                SERIAL       => 'SG840KJ009',
                FIRMWARE     => 'K.12.12',
                UPTIME       => '(485451519) 56 days, 4:28:35.19',
                MAC          => '00:21:f7:1e:01:40',
                IPS          => {
                    IP => [
                        '10.100.205.43',
                        '127.0.0.1',
                    ],
                },
            },
            PORTS => {
                PORT => [
                    {
                        IFNUMBER         => '1',
                        IFNAME           => '1',
                        IFDESCR          => '1',
                        IFALIAS          => 'Eckmuhl',
                        IFTYPE           => '6',
                        IFSPEED          => '100000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:f7:1e:01:7f',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2542) 0:00:25.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '2983144385',
                        IFINERRORS       => '625267584',
                        IFOUTOCTETS      => '2069399941',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:16:17:da:19:fe',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '2',
                        IFNAME           => '2',
                        IFDESCR          => '2',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:f7:1e:01:7e',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2595) 0:00:25.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '1305858701',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2351404174',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:25:64:c4:5a:b1',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '3',
                        IFNAME           => '3',
                        IFDESCR          => '3',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '9216',
                        MAC              => '00:21:f7:1e:01:7d',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2995) 0:00:29.95',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '129229212',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1500245318',
                        IFOUTERRORS      => '0',
                    },
                    {
                        IFNUMBER         => '4',
                        IFNAME           => '4',
                        IFDESCR          => '4',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:f7:1e:01:7c',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2542) 0:00:25.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '3926128368',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '1171162763',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:14:22:7c:3e:98',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '5',
                        IFNAME           => '5',
                        IFDESCR          => '5',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:f7:1e:01:7b',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(7765813) 21:34:18.13',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '267753976',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '614750429',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '00:15:c5:5f:c7:0d',
                                ],
                            }
                        }
                    },
                    {
                        IFNUMBER         => '6',
                        IFNAME           => '6',
                        IFDESCR          => '6',
                        IFTYPE           => '6',
                        IFSPEED          => '1000000000',
                        IFMTU            => '1500',
                        MAC              => '00:21:f7:1e:01:7a',
                        IFSTATUS         => '1',
                        IFINTERNALSTATUS => '1',
                        IFLASTCHANGE     => '(2542) 0:00:25.42',
                        IFPORTDUPLEX     => '3',
                        IFINOCTETS       => '580654715',
                        IFINERRORS       => '0',
                        IFOUTOCTETS      => '2337407222',
                        IFOUTERRORS      => '0',
                        CONNECTIONS      => {
                            CONNECTION => {
                                MAC => [
                                    '18:03:73:0d:0e:11',
                                ],
                            }
                        }
                    },
                    {