package Business::EDI::CodeList::ProcessTypeDescriptionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 7187;
my $usage       = 'B';

# 7187  Process type description code                           [B]
# Desc: Code specifying a type of process.
# Repr: an..17

my %code_hash = (
'1' => [ 'Wood preparation',
    'A process to prepare wood.' ],
'2' => [ 'Causticizing',
    'Treatment with a caustic agent.' ],
'3' => [ 'Digesting',
    'A process of digesting.' ],
'4' => [ 'Brownstock washing',
    'Washing with brownstock.' ],
'5' => [ 'Bleaching',
    'Removing colour by treatment with an oxidizing agent (a bleach).' ],
'6' => [ 'Pulp drying',
    'The process of drying pulp.' ],
'7' => [ 'Freezing',
    'Freezing process.' ],
'8' => [ 'Processing of structured information',
    'The information to be processed is in structured form.' ],
'9' => [ 'Processing of identical information in structured and',
    'unstructured form The information to be processed is identical and given in structured and unstructured form.' ],
'10' => [ 'Processing of different information in structured and',
    'unstructured form The information to be processed is different and is given in structured and unstructured form.' ],
'11' => [ 'Processing of unstructured information',
    'The information to be processed is in unstructured form.' ],
'12' => [ 'Slaughter',
    'Slaughter process.' ],
'13' => [ 'Packing',
    'Packing process.' ],
'14' => [ 'Heat sterilisation',
    'Treated by heat sterilisation.' ],
'15' => [ 'Chemical sterilisation',
    'Treated by chemical sterilisation.' ],
'16' => [ 'Fumigation',
    'Treated by fumigation.' ],
'17' => [ 'Irradiation',
    'Treated by irradiation.' ],
'18' => [ 'Fueling',
    'Fueling process.' ],
'19' => [ 'Acceptance of business conditions',
    'Code specifying the process of accepting the terms and conditions under which business will be conducted.' ],
'20' => [ 'Pathology service',
    'The provision of a pathology service.' ],
'21' => [ 'Radiology service',
    'The provision of a radiology service.' ],
'22' => [ 'Contribution payment',
    'The payment of a contribution.' ],
'23' => [ 'Clinical donation',
    'The process of providing a clinical donation.' ],
'24' => [ 'Medical general practice',
    'The provision of general medical services.' ],
'25' => [ 'Specialist medical service',
    'The provision of specialist medical services, other than pathology or radiology.' ],
'26' => [ 'Dispensing of medicine',
    'The process performed by a pharmacist to prepare and dispense medicine according to a prescription.' ],
'27' => [ 'Planning',
    'The process of developing plans.' ],
'28' => [ 'Trading',
    'The process of trading.' ],
'29' => [ 'Operating',
    'The process of operating.' ],
'30' => [ 'Metering',
    'The process of metering.' ],
'31' => [ 'Settlement',
    'The process of settling.' ],
'32' => [ 'Chilling',
    "To reduce a product's temperature to above 273K." ],
'33' => [ 'Collecting',
    'To gather or extract from a number of persons or sources.' ],
'34' => [ 'Cutting',
    'To penetrate with or as if with an edged instrument.' ],
'35' => [ 'Harvesting',
    'To gather, catch, hunt, or kill.' ],
'36' => [ 'Inspecting',
    'To examine officially.' ],
'37' => [ 'Manufacturing',
    'To make from raw materials by hand or by machinery.' ],
'38' => [ 'Preserving',
    'To can, pickle, or similarly prepare for future use.' ],
'39' => [ 'Processing',
    'To subject to or handle through an established usually routine set of procedures.' ],
'40' => [ 'Producing',
    'To make produce by growing.' ],
'41' => [ 'Rendering (agriculture)',
    'To extract by melting in order to extract proteins, fats, and other usable parts.' ],
'42' => [ 'Sampling',
    'To take a sample of or from the product.' ],
'43' => [ 'Storing',
    'To place or leave in a location (as a warehouse, library, or computer memory) for preservation.' ],
'44' => [ 'Transferring',
    'To convey from one person, place, or situation to another.' ],
'45' => [ 'Treating',
    'To act upon e.g. with some agent.' ],
'46' => [ 'Grinding',
    'Treated by grinding.' ],
'47' => [ 'Addition of secondary inhibitors',
    'The process of adding secondary inhibitors.' ],
'48' => [ 'Metals recovery',
    'The process of recovering metals e.g. retorting, smelting, chemical process.' ],
'49' => [ 'Solvents recovery',
    'The process of recovering solvents e.g. distillation, extraction.' ],
'50' => [ 'Recovery for reuse',
    'The process of recovering (reclaiming) materials for reuse, e.g. acid regeneration, organics recovery.' ],
'51' => [ 'Incineration',
    'The process of destruction through the application of heat.' ],
'52' => [ 'On-site fuel recovery',
    'The process of recovering a material for reuse as a fuel on the same site.' ],
'53' => [ 'Fuel blending',
    'The process of blending fuels.' ],
'54' => [ 'Chemical reduction',
    'The process of chemical reduction.' ],
'55' => [ 'Cyanide destruction',
    'The process of destruction through the application of cyanide.' ],
'56' => [ 'Chemical oxidation',
    'The process of chemical oxidation.' ],
'57' => [ 'Wet air oxidation',
    'The process of wet air oxidation.' ],
'58' => [ 'Chemical precipitation',
    'The process of chemical precipitation.' ],
'59' => [ 'Biological treatment',
    'The process of biological treatment.' ],
'60' => [ 'Adsorption',
    'The process of adsorption.' ],
'61' => [ 'Air or steam stripping',
    'The process of air or steam stripping.' ],
'62' => [ 'Dewatering',
    'The process of removing water.' ],
'63' => [ 'Absorption',
    'The process of absorption.' ],
'64' => [ 'Stabilization',
    'The process of stabilization e.g. chemical fixation.' ],
'65' => [ 'Macro-encapsulation',
    'The process of macro-encapsulation.' ],
'66' => [ 'Neutralization',
    'The process of neutralization.' ],
'67' => [ 'Evaporation',
    'The process of evaporation.' ],
'68' => [ 'Phase separation',
    'The process of phase separation.' ],
'69' => [ 'Unspecified treatment',
    'Treatment without specification.' ],
'70' => [ 'Landfill or surface impoundment disposal',
    'The process of disposing waste as landfill or in a surface impoundment that will be closed as landfill.' ],
'71' => [ 'Deep well or underground injection',
    'The process of filling up a deep well or underground pocket.' ],
'72' => [ 'Discharge to sewer',
    'The process of discharging materials into the public sewer system.' ],
'73' => [ 'Collection and storage, temporary',
    'The process of collecting and temporarily storing objects.' ],
'74' => [ 'Cold treatment',
    'The process of cold treatment.' ],
'75' => [ 'Hot air treatment',
    'The process of hot air treatment.' ],
'76' => [ 'Hot water treatment',
    'The process of hot water treatment.' ],
'77' => [ 'Methyl bromide treatment',
    'The process of treating with methyl bromide.' ],
'78' => [ 'Phosphine treatment',
    'The process of treating with phosphine.' ],
'79' => [ 'Depulping',
    'The process of removing pulp.' ],
'80' => [ 'Manual removal',
    'The process of removing by hand.' ],
'81' => [ 'Sulfuryl fluoride fumigation',
    'The process of fumigating with sulfuryl fluoride.' ],
'82' => [ 'Steam treatment',
    'The process of treating with steam.' ],
'83' => [ 'Vapor heat',
    'The process of treating with vapor heat.' ],
'84' => [ 'Assembling',
    'The process of assembling.' ],
'85' => [ 'Boiling',
    'The process of boiling.' ],
'86' => [ 'Canning',
    'The process of sealing in an airtight container.' ],
'87' => [ 'Chipping',
    'The process of chipping.' ],
'88' => [ 'Cleaning',
    'The process of making clean.' ],
'89' => [ 'Coating',
    'The process of coating.' ],
'90' => [ 'Dehydration',
    'The process of dehydrating.' ],
'91' => [ 'Devitalization',
    'The process of devitalizing.' ],
'92' => [ 'Disinfection',
    'The process of disinfecting.' ],
'93' => [ 'Drying',
    'The process of drying.' ],
'94' => [ 'Dyeing',
    'The process of dyeing.' ],
'95' => [ 'Heat treatment',
    'The process of heat treatment.' ],
'96' => [ 'Husking',
    'The process of removing husk.' ],
'97' => [ 'Liquification',
    'The process of liquifying.' ],
'98' => [ 'Shelling',
    'The process of removing shells.' ],
'99' => [ 'Washing',
    'The process of washing.' ],
'100' => [ 'Land treatment or application',
    'The process of using bio remediation for treating waste e.g. Tilling the land for aerating the waste.' ],
'ZZZ' => [ 'Mutually defined',
    'Process type mutually agreed between interchanging parties.' ],
);
sub get_codes { return \%code_hash; }

1;
