package Business::EDI::CodeList::PartyFunctionCodeQualifier;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {3035;}
my $usage       = 'C';

# 3035  Party function code qualifier                           [C]
# Desc: Code giving specific meaning to a party.
# Repr: an..3

my %code_hash = (
'AA' => [ 'Party to be billed (AAR Accounting rule 11)',
    'Party to be billed in accordance with AAR Accounting rule 11.' ],
'AB' => [ "Buyer's agent/representative",
    'Third party who arranged the purchase of merchandise on behalf of the actual buyer.' ],
'AE' => [ "Declarant's agent/representative",
    'Any natural or legal person who makes a declaration to an official body on behalf of another natural or legal person, where legally permitted (CCC).' ],
'AF' => [ 'Transit principal',
    'Natural or legal person responsible for the satisfactory performance of a Customs transit operation. Source: CCC.' ],
'AG' => [ 'Agent',
    '(3196) Party authorized to act on behalf of another party. Synonym: Representative.' ],
'AH' => [ "Transit principal's agent/representative",
    'Agent acting on behalf of the transit principal (CCC).' ],
'AI' => [ 'Successful job applicant',
    'Person who has been chosen for a job.' ],
'AJ' => [ 'Party issuing mutually agreed codes',
    'The party which has issued all mutually agreed codes used in the message.' ],
'AK' => [ 'Acknowledgement recipient',
    'Party to whom acknowledgement should be sent.' ],
'AL' => [ 'Principal responsible party',
    '(3340) Party accepting liability for goods held or moving (e.g. transit) under a Customs authorization and - when applicable - a guarantee.' ],
'AM' => [ 'Authorized official',
    'Employee of a company or firm authorized to act on behalf of that company or firm e.g. to make a Customs declaration.' ],
'AN' => [ 'Approved importer',
    'Person or company which is authorised by the relevant Customs authority to import goods without payment all taxes or specific taxes at the point of entry into the country.' ],
'AO' => [ 'Account of',
    'Party account is assigned to.' ],
'AP' => [ 'Accepting party',
    '(3336) Party accepting goods, products, services, etc.' ],
'AQ' => [ 'Approved consignor',
    'Person or company approved by the relevant authority in the country to pack and export specific goods under Customs supervision.' ],
'AR' => [ 'Authorized exporter',
    'Exporter authorized/approved by Customs for special Customs procedures e.g. simplified procedure.' ],
'AS' => [ 'Account servicing financial institution',
    'Identifies the financial institution servicing the account(s).' ],
'AT' => [ 'Authorized importer',
    'Importer authorized/approved by Customs for special Customs procedures e.g. simplified procedure.' ],
'AU' => [ 'Authorized trader (transit)',
    'Trader authorized/approved by Customs for special transit procedures e.g. simplified procedure.' ],
'AV' => [ 'Authorizing official',
    'Party that has delegated the authority to take a certain action on behalf of a company or agency.' ],
'AW' => [ "Applicant's bank",
    '(3234) Financial institution which is requested to issue the documentary credit.' ],
'AX' => [ 'Authenticating party',
    'Party which certifies that a document is authentic.' ],
'AY' => [ 'Animal being investigated',
    'Animal being investigated.' ],
'AZ' => [ 'Issuing bank',
    "Financial institution which issues the documentary credit, if the applicant's bank is not acting as the issuing bank." ],
'B1' => [ 'Contact bank 1',
    'Identifies an additional bank which must be informed of certain aspects of the message.' ],
'B2' => [ 'Contact bank 2',
    'Identifies an additional bank which must be informed of certain aspects of the message.' ],
'BA' => [ 'Booking agent',
    'Party acting as a booking office for transport and forwarding services.' ],
'BB' => [ 'Buyer bank identification',
    '[3421]To identify a bank employed by the buyer to make a payment.' ],
'BC' => [ 'Negotiating bank',
    'Financial institution to whom a negotiable documentary credit is directed.' ],
'BD' => [ 'Documentary credit reimbursing bank',
    'A financial institution which reimburses documentary credit.' ],
'BE' => [ 'Beneficiary',
    'The ultimate recipient of the funds. Normally the account owner who is reimbursed by the payer.' ],
'BF' => [ "Beneficiary's bank",
    'Identifies the account servicer for the beneficiary or the payee.' ],
'BG' => [ 'Employer',
    'A party that keeps a person in service for payment.' ],
'BH' => [ 'Previous employer',
    'Previous employer of a person(s).' ],
'BI' => [ "Buyer's financial institution",
    'Financial institution designated by buyer to make payment.' ],
'BJ' => [ 'Release to party',
    'Party to which the goods or container(s) is (are) to be released.' ],
'BK' => [ 'Financial institution',
    'Party acting as financial institution.' ],
'BL' => [ 'Bill of lading recipient',
    'Party to receive B/L.' ],
'BM' => [ 'Insured',
    'Party which is the object of an insurance contract.' ],
'BN' => [ 'Insurance beneficiary',
    'Party which benefits from insurance coverage.' ],
'BO' => [ 'Broker or sales office',
    'Party acting in the name of the seller as broker or as sales office.' ],
'BP' => [ 'Building site purchaser',
    'Party at the building site responsible for the purchasing of goods and services for that particular site.' ],
'BQ' => [ 'Cheque drawn bank',
    'Identifies the bank on which the cheque should be drawn, as instructed by the ordering customer.' ],
'BS' => [ 'Bill and ship to',
    'Party receiving goods and relevant invoice.' ],
'BT' => [ 'Party to be billed for other than freight (bill to)',
    'Party receiving invoice excluding freight costs.' ],
'BU' => [ 'Service bureau',
    'Party carrying out service bureau processing work, (e.g. a payroll bureau).' ],
'BV' => [ 'Member',
    'Member of a group (e.g. of a group of persons or a service scheme).' ],
'BW' => [ 'Borrower',
    'A person who acquires something temporarily with the promise or intention of returning.' ],
'BX' => [ 'Building site engineer',
    'Party at the building site responsible for engineering matters for that particular site.' ],
'BY' => [ 'Buyer',
    '[3002] Party to which merchandise or services are sold.' ],
'BZ' => [ 'Building site forwarder',
    'Party at the building site responsible for forwarding the received goods on that particular site.' ],
'C1' => [ 'In care of party no. 1',
    'A person taking responsibility on behalf of party no. 1.' ],
'C2' => [ 'In care of party no. 2',
    'A person taking responsibility on behalf of party no. 2.' ],
'CA' => [ 'Carrier',
    '[3126] Party undertaking or arranging transport of goods between named points.' ],
'CB' => [ 'Customs broker',
    'Agent or representative or a professional Customs clearing agent who deals directly with Customs on behalf of the importer or exporter (CCC).' ],
'CC' => [ 'Claimant',
    'Party who claims goods or insurance.' ],
'CD' => [ "Agent's bank",
    'Bank of the agent.' ],
'CE' => [ 'Ceding company',
    'Company which cedes something to someone.' ],
'CF' => [ 'Container operator/lessee',
    'Party to whom the possession of specified property (e.g. container) has been conveyed for a period of time in return for rental payments.' ],
'CG' => [ "Carrier's agent",
    'Party authorized to act for or on behalf of carrier.' ],
'CH' => [ 'Connecting carrier',
    'Owner or operator of a transportation conveyance to which goods in a given transaction will be transferred.' ],
'CI' => [ 'Commission processor',
    'Party who provides extra treatment to goods on commission base.' ],
'CJ' => [ 'Previous member',
    'Previous member of a group of persons or a service scheme.' ],
'CK' => [ 'Empty equipment despatch party',
    'Party from whose premises empty equipment will be or has been despatched.' ],
'CL' => [ 'Container location party',
    'Party from whose premises container will be or has been despatched.' ],
'CM' => [ 'Customs',
    'Identification of customs authority relevant to the transaction or shipment.' ],
'CN' => [ 'Consignee',
    '[3132] Party to which goods are consigned.' ],
'CNX' => [ 'Cash pool top account servicing financial institution',
    'Identification of a financial institution servicing the top account of a cash pool.' ],
'CNY' => [ 'Cash pool level account servicing financial institution',
    'Identification of a financial institution servicing the level account of a cash pool.' ],
'CNZ' => [ 'Cash pool sub-account servicing financial institution',
    'Identification of a financial institution servicing the sub-account of a cash pool.' ],
'CO' => [ 'Corporate office',
    'Identification of the Head Office within a company.' ],
'COA' => [ 'Entity in which a financial interest is held',
    'Business in which a financial interest is held.' ],
'COB' => [ 'Intermediate level parent company',
    'Identifies an intermediate parent company.' ],
'COC' => [ 'Transshipment party',
    'A party responsible for transshipment.' ],
'COD' => [ 'Quotation requesting party',
    'Party sending a request for a quotation.' ],
'COE' => [ 'Party maintaining the codes used in the message',
    'The party which maintains the codes used in the message.' ],
'COF' => [ 'Party maintaining the identifiers used in the message',
    'The party which maintains the identifiers used in the message.' ],
'COG' => [ 'Dispatcher',
    'An individual responsible for sending something to a destination.' ],
'COH' => [ 'Submitter of sample',
    'An entity responsible for the submission of a sample.' ],
'COI' => [ 'Institutional provider',
    'The institution providing the service.' ],
'COJ' => [ 'Primary health care provider',
    'Health care provider that has primary responsibility for patient.' ],
'COK' => [ 'Assistant surgeon',
    'Physician assisting in surgery.' ],
'COL' => [ 'Admitting health care provider',
    'Health care provider that admitted the patient.' ],
'COM' => [ 'Referring health care provider',
    'Health care provider that referred patient to current provider of services.' ],
'CON' => [ 'Supervising health care provider',
    'Health care provider that supervised the rendering of a service.' ],
'COO' => [ 'Party providing financing',
    'Identifies the party providing the financing.' ],
'COP' => [ 'Convoying party',
    'Party designated to escort the transported goods.' ],
'COQ' => [ 'Nominated bank',
    'Identifies the nominated bank.' ],
'COR' => [ 'Family member',
    'Identifies a family member.' ],
'COS' => [ 'Co-participant',
    'Identifies another party who participates in an activity.' ],
'COT' => [ 'Involved party',
    'Party which is involved in an activity.' ],
'COU' => [ 'Assigner',
    'Identifies the entity who assigns.' ],
'COV' => [ 'Registered principal',
    'An individual who is registered as a principal for an entity.' ],
'COW' => [ 'Freight payer on behalf of the consignor',
    'Freight payer is a third party acting on behalf of the consignor.' ],
'COX' => [ 'Freight payer on behalf of the consignee',
    'Freight payer is a third party acting on behalf of the consignee.' ],
'COY' => [ 'Party responsible for disinfection',
    'Party responsible for performing disinfection operations.' ],
'COZ' => [ 'Party responsible for refueling',
    'Party responsible for performing refueling operations.' ],
'CP' => [ 'Party to receive certificate of compliance',
    'Party acting for or on behalf of seller in matters concerning compliance.' ],
'CPA' => [ 'Advising bank',
    'Identifies the financial institution used by the issuing bank to advise the documentary credit.' ],
'CPB' => [ 'Reimbursing bank',
    'Identifies the financial institution through which the reimbursement is to be effected.' ],
'CPC' => [ 'Advise through bank',
    'Identifies the financial institution through which the advising bank is to advise.' ],
'CPD' => [ 'Charges payer at destination',
    'Party, other than the ordering party, which has to pay the charges concerning the destination operations.' ],
'CPE' => [ 'Transport means master name',
    '[3408] Name of the Master of a means of transport such as vessel.' ],
'CPF' => [ 'Means of transport charterer',
    'Charterer of the means of transport.' ],
'CPG' => [ 'Excise party',
    'Party to whom excise must be paid.' ],
'CPH' => [ 'Copy report to',
    'Party receiving a copy of a report.' ],
'CPI' => [ 'Related healthcare party',
    'A healthcare party related to the subject.' ],
'CPJ' => [ 'Clinical information provider',
    'Party providing clinical information.' ],
'CPK' => [ 'Service requester',
    'Party requesting a service.' ],
'CPL' => [ 'Patient admitted by',
    'Party who admitted a patient.' ],
'CPM' => [ 'Patient discharged to',
    'The party who receives the discharged patient.' ],
'CPN' => [ 'Patient hosted by',
    'The party hosting the patient.' ],
'CPO' => [ "Prescriber's contact person",
    'Contact person for the prescriber.' ],
'CQ' => [ 'Cheque order',
    'Party to which the cheque will be ordered, when different from the beneficiary.' ],
'CR' => [ 'Empty equipment return party',
    'Party to whose premises empty equipment will be or has been returned.' ],
'CS' => [ 'Consolidator',
    'Party consolidating various consignments, payments etc.' ],
'CT' => [ 'Consignee to be specified',
    'The party to be identified at a later time as the consignee.' ],
'CU' => [ 'Container return company',
    'The company to which containers have to be returned.' ],
'CV' => [ 'Consignee of vessel',
    'Party to which the vessel shall be delivered.' ],
'CW' => [ 'Equipment owner',
    'Owner of equipment (container, etc.).' ],
'CX' => [ "Consignee's agent",
    'Party authorized to act on behalf of the consignee.' ],
'CY' => [ 'Commissionable agent',
    'IATA cargo agent entitled to commission.' ],
'CZ' => [ 'Consignor',
    '[3336] Party which, by contract with a carrier, consigns or sends goods with the carrier, or has them conveyed by him. Synonym: shipper, sender.' ],
'DA' => [ 'Available with bank (documentary credits)',
    'Financial institution with whom the documentary credit is available.' ],
'DB' => [ 'Distributor branch',
    'The affiliate of a retailer or distributor.' ],
'DC' => [ 'Deconsolidator',
    'Party that splits up a large consignment composed of separate consignments of goods. The smaller consignments of goods were grouped together into that large consignment for carriage as a larger unit in order to obtain a reduced rate.' ],
'DCP' => [ 'Despatch charge payer',
    'Party, other than the ordering party, which has to pay the charges concerning the despatch operations.' ],
'DCQ' => [ 'Prescription database owner',
    'Organisation or person owning a prescription database.' ],
'DCR' => [ 'Original prescriber',
    'The doctor who issued the original prescription.' ],
'DCS' => [ 'Temporary employee',
    'A person employed on a temporary basis.' ],
'DCT' => [ 'Designer',
    'A party who designs.' ],
'DCU' => [ 'Quotation delivered to',
    'Party to whom the quotation is to be or has been delivered.' ],
'DCV' => [ 'Developer',
    'A party who develops.' ],
'DCW' => [ 'Test execution party',
    'The party performing a test.' ],
'DCX' => [ 'Party to receive refund',
    'Party to whom a refund is given.' ],
'DCY' => [ 'Authorised issuer of prescription',
    'Party authorised to issue a prescription.' ],
'DCZ' => [ 'Authorised dispenser of medicine',
    'Organisation or person authorised to dispense medicine.' ],
'DD' => [ "Documentary credit account party's bank",
    'Bank of the documentary credit account party.' ],
'DDA' => [ 'Report responsible party',
    'The party or person taking responsibility for a report.' ],
'DDB' => [ 'Initial sender',
    'The party who does the initial sending.' ],
'DDC' => [ 'The party authorising the original prescription',
    'The party authorising the issuer of the original prescription.' ],
'DDD' => [ 'Applicant',
    'A party who applies for something.' ],
'DDE' => [ 'Meter reader',
    'A party physically reading the meter.' ],
'DDF' => [ 'Primary electronic business contact',
    "Code specifying a party who serves as a business entity's primary contact for matters related to electronic business." ],
'DDG' => [ 'Alternate electronic business contact',
    "Code specifying a party who serves as a business entity's alternate contact for matters related to electronic business." ],
'DDH' => [ 'Primary government business contact',
    "Code specifying a party who serves as a business entity's primary contact for matters related to doing business with the government." ],
'DDI' => [ 'Alternate government business contact',
    "Code specifying a party who serves as a business entity's alternate contact for matters related to doing business with the government." ],
'DDJ' => [ 'Past performance contact',
    "Code specifying a party who serves as a business entity's contact for matters related to the past performance of that entity." ],
'DDK' => [ 'Balance responsible party',
    'A party responsible for balancing supply and consumption.' ],
'DDL' => [ 'Group of passengers',
    'A group of persons conveyed by a means of transport, other than the crew.' ],
'DDM' => [ 'Grid operator',
    'A party operating a grid.' ],
'DDN' => [ 'First financial institution in the transaction chain',
    'Identifies the financial institution that is the point of entry into the interbank transaction chain.' ],
'DDO' => [ 'Location manager',
    'Party responsible for the management of the location.' ],
'DDP' => [ 'Group leader',
    'Party responsible for leading the group.' ],
'DDQ' => [ 'Balance power supplier',
    'The supplier of balance power.' ],
'DDR' => [ "Consignor's freight forwarder",
    'Identification of freight forwarder giving services to the consignor.' ],
'DDS' => [ "Consignee's freight forwarder",
    'Identification of freight forwarder giving services to the consignee.' ],
'DDT' => [ 'In transit crew member',
    'The movement of a crew member from one country to another via the territory of an intermediate country for which no entry is intended.' ],
'DDU' => [ 'In transit passenger',
    'The movement of a passenger from one country to another via the territory of an intermediate country for which no entry is intended.' ],
'DDV' => [ 'Energy consumption imbalance responsible party',
    'A party who can be brought to rights, legally and financially, for any imbalance between energy bought and consumed for all associated metering points.' ],
'DDW' => [ 'Energy production imbalance responsible party',
    'A party who can be brought to rights, legally and financially, for any imbalance between energy sold and produced for all associated metering points.' ],
'DDX' => [ 'Imbalance settlement responsible party',
    'A party that is responsible for settlement of the difference between planned and realised quantities.' ],
'DDY' => [ 'Transmission capacity allocator',
    'A party managing the allocation of transmission capacity.' ],
'DDZ' => [ 'Metering point administrator',
    'A party responsible for registering the technical specifications of metering points and the parties linked to them.' ],
'DE' => [ 'Depositor',
    'Party depositing goods, financial payments or documents.' ],
'DEA' => [ 'Metered data aggregator',
    'A party responsible for aggregation of metered data.' ],
'DEB' => [ 'Meter operator',
    'A party responsible for the operation of a meter, including installing  maintaining, testing, certifying and decommissioning.' ],
'DEC' => [ 'Party connected to grid',
    'A party that contracts for the right to consume or produce electricity at a metering point.' ],
'DED' => [ 'Profile maintenance party',
    'A party that maintains profiles.' ],
'DEE' => [ 'Stowaway',
    'A person who hides on a conveyance in order to obtain free passage.' ],
'DEF' => [ 'Meat cutter',
    'Person whose job is to cut up and/or mince meat.' ],
'DEG' => [ 'Consortium Carrier (maritime)',
    'A marine carrier that transports goods for more than one shipping line between named points.' ],
'DEH' => [ 'Non-vessel operating carrier',
    'A carrier that does not operate the vessel.' ],
'DEI' => [ 'Means of transport operator',
    'The operator of a means of transport, e.g. the captain of a vessel.' ],
'DEJ' => [ 'Stuffing address',
    'Address where cargo is loaded into the transport equipment e.g. container. Synonyms; vanning address / place of vanning.' ],
'DEK' => [ 'Mooring service provider',
    'Party responsible for mooring the vessel at the berth in the port. Synonym: Boatmen.' ],
'DEL' => [ 'Pilotage service provider',
    'Party responsible for the pilotage of the vessel.' ],
'DEM' => [ 'Berth towage service provider',
    'Party responsible for towing the vessel to/from the berth in the port.' ],
'DEN' => [ 'Agent/representative, direct representation',
    'Party authorised to act in the name and on behalf of another person.' ],
'DEO' => [ 'Agent/representative, indirect representation',
    'Party authorised to act in its own name but on behalf of another person.' ],
'DEP' => [ 'Stevedore',
    'A party which handles the loading and unloading of marine vessels from several terminals.' ],
'DEQ' => [ 'Shipper',
    'Party responsible for the shipment of goods.' ],
'DER' => [ 'Source data pool',
    'A data pool that supports the functionality required by a data source such as data loading, publication, notification, registration, etc.' ],
'DES' => [ 'Brand owner',
    'The owner of a brand.' ],
'DET' => [ 'Cockpit crew',
    'Cockpit crew and personnel inside cockpit.' ],
'DEU' => [ 'Cabin crew',
    'Crew members operating in passenger cabin.' ],
'DEV' => [ 'Airline operations management, not in cockpit',
    'Personnel of the airline operations management department positioned outside the cockpit.' ],
'DEW' => [ 'Cargo non-cockpit crew and/or non-crew personnel',
    'Employees of the carrier, cargo groomers, or special cargo handlers, that are not authorized to ride in the cockpit.' ],
'DEX' => [ 'Pilots seated outside cockpit',
    'Pilots currently not in charge of flying the aircraft and not present in the cockpit.' ],
'DEY' => [ 'Commercial verifier',
    'A party recognized under relevant legislation to undertake official verification.' ],
'DEZ' => [ 'Authorized issuer',
    'A person authorized under relevant legislation for the purpose of issuing official assurances.' ],
'DF' => [ 'Documentary credit applicant',
    "Party at whose request the applicant's bank/issuing bank is to issue a documentary credit." ],
'DFA' => [ 'Bank for deposit of duties/taxes/fees',
    'Bank that is authorized to receive the deposit for duties, taxes, and fees.' ],
'DFB' => [ 'Company security officer (IMO Circular MSC 1130)',
    'The company security officer as described in IMO Circular MSC 1130.' ],
'DFC' => [ 'Distiller',
    'The party providing distillation services.' ],
'DFD' => [ 'Drayman/lighterman',
    'The bonded (insured) party that moves goods within port limits.' ],
'DFE' => [ 'Exhibitor',
    'The party who offers items for exhibit or show.' ],
'DFF' => [ 'Feedlot',
    'A commercial establishment that feeds livestock.' ],
'DFG' => [ 'Government official',
    'A person appointed to some position of responsibility or authority in the government.' ],
'DFH' => [ 'Government service requestor',
    'The party requesting inspection, grading, or other government service.' ],
'DFI' => [ 'Crop grower',
    'The party who grows crops.' ],
'DFJ' => [ 'ISPS Responsible Party',
    'The responsible party as identified and defined in the International Ship and Port Facility Security Code (ISPS).' ],
'DFK' => [ 'LPCO authorized party',
    'The party to whom the License, Permit, Certificate, or Other required document (LPCO) is issued.' ],
'DFL' => [ 'Operator of property, registered',
    'The registered operator of the property.' ],
'DFM' => [ 'Organic growth certifier, accredited',
    'An organization that is accredited to certify organic growth processes.' ],
'DFN' => [ 'Party holding Certificate of Financial Responsibility',
    'The party holding the Certificate of Financial Responsibility (COFR).' ],
'DFO' => [ 'Port facility security officer',
    'The individual (person) designated as the port facility security officer responsible for port security requirements.' ],
'DFP' => [ 'Vehicle owner',
    'The owner of the vehicle.' ],
'DFQ' => [ 'Security certificate issuer, recognized',
    'Organization recogized for issuing security certificates.' ],
'DFR' => [ 'Ship Security Officer',
    'The person who is appointed as Ship Security Officer (SSO).' ],
'DFS' => [ 'Certificate issuer, veterinary',
    'The person who issues veterinary certificates.' ],
'DFT' => [ 'Assembler',
    'The party putting together various components or parts into a product or commodity.' ],
'DG' => [ 'Documentary credit beneficiary',
    "Party in whose favour the documentary credit is to be issued and the party that must comply with the credit's terms and conditions." ],
'DH' => [ 'Documentary credit account party',
    "Party which is responsible for the payment settlement of the documentary credit with the applicant's bank/issuing bank, if different from the documentary credit applicant." ],
'DI' => [ 'Documentary credit second beneficiary',
    'Party to whom the documentary credit can be transferred.' ],
'DJ' => [ 'Party according to documentary credit transaction',
    'Party related to documentary credit transaction.' ],
'DK' => [ "Documentary credit beneficiary's bank",
    'Financial institution with which the beneficiary of the documentary credit maintains an account.' ],
'DL' => [ 'Factor',
    'Company offering a financial service whereby a firm sells or transfers title to its accounts receivable to the factoring company.' ],
'DM' => [ 'Party to whom documents are to be presented',
    'Party to whom documents are to be presented.' ],
'DN' => [ 'Owner of operation',
    'Owner of the operation.' ],
'DO' => [ 'Document recipient',
    '[1370] Party which should receive a specified document.' ],
'DP' => [ 'Delivery party',
    '[3144] Party to which goods should be delivered, if not identical with consignee, such as the place where a container is to be, or has been, positioned.' ],
'DQ' => [ "Owner's agent",
    'Person acting on delegation of powers of the owner.' ],
'DR' => [ 'Driver',
    'Person who drives a means of transport.' ],
'DS' => [ 'Distributor',
    'Party distributing goods, financial payments or documents.' ],
'DT' => [ 'Declarant',
    '[3140] Party which makes a declaration to an official body or - where legally permitted - in whose name, or on whose behalf, a declaration to an official body is made.' ],
'DU' => [ "Owner's representative",
    'Person commissioned by the owner to represent him in certain circumstances.' ],
'DV' => [ 'Project management office',
    'Party commissioned by the owner to follow through the execution of all works.' ],
'DW' => [ 'Drawee',
    'Party on whom drafts must be drawn.' ],
'DX' => [ 'Engineer (construction)',
    'Party representing the contractor to advise and supervise engineering aspects of the works.' ],
'DY' => [ 'Engineer, resident (construction)',
    'Party commissioned by the owner to advise and supervise engineering aspects of the works.' ],
'DZ' => [ 'Architect',
    'A designer who prepares plans for buildings, ships, etc. and supervises their construction.' ],
'EA' => [ 'Architect-designer',
    'Designer of the construction project.' ],
'EB' => [ 'Building inspectorate',
    'Party controlling the conformity of works to legal and regulation rules.' ],
'EC' => [ 'Exchanger',
    'Party exchanging currencies or goods.' ],
'ED' => [ 'Engineer, consultant',
    'Party providing professional engineering services.' ],
'EE' => [ 'Location of goods for customs examination before clearance',
    'The location where the goods are examined by customs before clearance.' ],
'EF' => [ 'Project coordination office',
    'Party responsible for technical coordination of works.' ],
'EG' => [ 'Surveyor, topographical',
    'Party responsible for topographical measurements.' ],
'EH' => [ 'Engineer, measurement',
    'Party responsible for quantity measurements.' ],
'EI' => [ 'Controller, quality',
    'Party controlling the quality of goods and workmanship for the project.' ],
'EJ' => [ 'Surveyor, quantity',
    'Party responsible for the quantification and valuation of the works on behalf of the contractor.' ],
'EK' => [ 'Surveyor (professional), quantity',
    'Party responsible to the owner for the quantification and valuation of the works.' ],
'EL' => [ 'Project',
    'Party responsible for a project, e.g. a construction project.' ],
'EM' => [ 'Party to receive electronic memo of invoice',
    'Party being informed about invoice issue (via EDI).' ],
'EN' => [ 'Tenderer',
    'Firm answering an invitation to tender.' ],
'EO' => [ 'Owner of equipment',
    'Party who owns equipment.' ],
'EP' => [ 'Equipment drop-off party',
    'The party which drops off equipment.' ],
'EQ' => [ 'Empty container responsible party',
    'Party responsible for the empty container.' ],
'ER' => [ 'Empty container return agent',
    'Party, designated by owner of containers, responsible for their collection as agreed between the owner and customer/ consignee.' ],
'ES' => [ 'Contractor, lead',
    'Leader representing a grouping of co-contractors.' ],
'ET' => [ 'Co-contractor',
    'Member of a grouping of co-contractors.' ],
'EU' => [ 'Contractor, general',
    'Single contractor for the whole construction project, working by his own or with subcontractors.' ],
'EV' => [ 'Subcontractor',
    'Firm carrying out a part of the works for a contractor.' ],
'EW' => [ 'Subcontractor with direct payment',
    'Subcontractor benefiting from direct payments.' ],
'EX' => [ 'Exporter',
    '[3030] Party who makes, or on whose behalf the export declaration is made, and who is the owner of the goods or has similar rights of disposal over them at the time when the declaration is accepted.' ],
'EY' => [ 'Subcontractor, nominated',
    'Subcontractor authorized by the owner after having been proposed.' ],
'EZ' => [ 'Operator, essential services',
    'Operator of essential services e.g. water, sewerage system, power.' ],
'FA' => [ 'Operator, communication channel',
    'Operator of a communication channel.' ],
'FB' => [ 'Nominated freight company',
    'Party nominated to act as transport company or carrier for the goods.' ],
'FC' => [ 'Contractor, main',
    'Firm or grouping of co-contractors which has been awarded the contract.' ],
'FD' => [ "Buyer's parent company",
    'Parent company, e.g. holding company.' ],
'FE' => [ 'Credit rating agency',
    'A party which evaluates another party for credit rating.' ],
'FF' => [ 'Factor, correspondent',
    'Factoring company engaged by another factoring company to assist the letter with the services provided to the clients (sellers).' ],
'FG' => [ 'Buyer as officially registered',
    'Buying party as officially registered with government.' ],
'FH' => [ 'Seller as officially registered',
    'Selling party as officially registered with government.' ],
'FI' => [ 'Copy message to',
    'Party that is to receive a copy of a message.' ],
'FJ' => [ 'Trade Union',
    'Organisation representing employees.' ],
'FK' => [ 'Previous Trade Union',
    'Employee organisation who previously represented an employee .' ],
'FL' => [ 'Passenger',
    'A person conveyed by a means of transport, other than the crew.' ],
'FM' => [ 'Crew member',
    'A person manning a means of transport.' ],
'FN' => [ 'Tariff issuer',
    'The issuer of a tariff, e.g. a freight tariff.' ],
'FO' => [ 'Party performing inspection',
    'A party which inspects something.' ],
'FP' => [ 'Freight/charges payer',
    'Party responsible for the payment of freight.' ],
'FQ' => [ 'Container survey agent',
    'The container survey agency that will survey the containers.' ],
'FR' => [ 'Message from',
    'Party where the message comes from.' ],
'FS' => [ 'Party authorized to make definite a contract action',
    'Party who has the authority to make definite a contract action.' ],
'FT' => [ 'Financial settlement party',
    '[3450] Party responsible for either the transfer or repatriation of the funds relating to a transaction.' ],
'FU' => [ 'Hazardous material office',
    'The office responsible for providing information regarding hazardous material.' ],
'FV' => [ 'Party providing government furnished property',
    'The party responsible for providing government furnished property.' ],
'FW' => [ 'Freight forwarder',
    'Party arranging forwarding of goods.' ],
'FX' => [ 'Current receiver',
    'Current receiver of the goods in a multi-step transportation process (indirect flow) involving at least one grouping centre.' ],
'FY' => [ 'Current sender',
    'Current sender of the goods in a multi-step transportation process (indirect flow) involving at least one grouping centre.' ],
'FZ' => [ 'Grouping centre',
    'A party in charge of groupage, including degroupage and regroupage.' ],
'GA' => [ 'Road carrier',
    'A road carrier moving cargo.' ],
'GB' => [ 'Chamber of commerce',
    'Name of the Chamber of Commerce of the town where the company is registered.' ],
'GC' => [ 'Goods custodian',
    '[3024] Party responsible for the keeping of goods.' ],
'GD' => [ 'Producer',
    'Party or person who has produced the produce.' ],
'GE' => [ 'Registration tribunal',
    'Name of the tribunal where the company is registered.' ],
'GF' => [ 'Slot charter party',
    'An identification code of a participant or user that books slots (space) on a ship, more likely on a long term basis on a series of sailings. He pays for the space whether he uses it or not.' ],
'GH' => [ 'Applicant for job',
    'A person who applied for a job.' ],
'GI' => [ 'Spouse',
    'Person is a spouse.' ],
'GJ' => [ 'Mother',
    'Person is a mother.' ],
'GK' => [ 'Father',
    'Person is a father.' ],
'GL' => [ 'Socially insured person',
    'A person who is registered in a social security scheme.' ],
'GM' => [ 'Inventory controller',
    'To specifically identify the party in charge of inventory control.' ],
'GN' => [ 'Processor',
    'Party or person who has or will apply a process.' ],
'GO' => [ 'Goods owner',
    'The party which owns the goods.' ],
'GP' => [ 'Packer',
    'Party or person who has undertaken or will undertake packing.' ],
'GQ' => [ 'Slaughterer',
    'Party or person who has undertaken or will undertake a slaughter.' ],
'GR' => [ 'Goods releasing party',
    '[3026] Party entitled to authorize release of goods from custodian.' ],
'GS' => [ "Consignor's representative",
    'Party authorised to represent the consignor.' ],
'GT' => [ 'Rail carrier',
    'A carrier moving cargo, including containers, via rail.' ],
'GU' => [ 'Originator of article number',
    'A code identifying the party which created a specific article number.' ],
'GV' => [ 'Procurement responsibility for order',
    'A code used to identify the organization which is responsible for the procurement.' ],
'GW' => [ 'Party fulfilling all operations',
    "Code indicating the fact that the party identified carries out all operations within that company's activities." ],
'GX' => [ 'Central catalogue party',
    'Party controlling a central catalogue.' ],
'GY' => [ 'Inventory reporting party',
    'Party reporting inventory information.' ],
'GZ' => [ 'Substitute supplier',
    'Party which may be in a position to supply products or services should the main usual supplier be unable to do so.' ],
'HA' => [ 'Party which delivers consignments to the terminal',
    'Party which delivers consignments to a terminal.' ],
'HB' => [ 'Party which picks up consignments from the terminal',
    'Party which picks up consignments from a terminal.' ],
'HC' => [ 'Transit freight forwarder',
    'Freight forwarder to whom transit consignments are addressed, and from whom they are to be on-forwarded.' ],
'HD' => [ 'Inspection and acceptance party',
    'The party who will perform inspection and acceptance.' ],
'HE' => [ 'Transportation office',
    'The office that provides transportation information.' ],
'HF' => [ 'Contract administration office',
    'The office responsible for the administration of a contract.' ],
'HG' => [ 'Investigator',
    'A party who conducts investigations.' ],
'HH' => [ 'Audit office',
    'The office responsible for conducting audits.' ],
'HI' => [ 'Requestor',
    'The party requesting an action.' ],
'HJ' => [ 'Foreign disclosure information office',
    'The office that reviews sensitive information for foreign disclosure.' ],
'HK' => [ 'Mark-for party',
    'The party within an organization for whom the material is marked to be delivered.' ],
'HL' => [ 'Party to receive reports',
    'The party to whom reports are to be submitted.' ],
'HM' => [ 'Alternative manufacturer',
    'Party identification of an alternative manufacturer for a product.' ],
'HN' => [ 'Service performer',
    'The party who is performing a service.' ],
'HO' => [ "Shipper's association",
    'An association of shippers.' ],
'HP' => [ 'Final message recipient',
    'To identify the final recipient of the message.' ],
'HQ' => [ 'Account owner',
    'Identifies the owner of the account.' ],
'HR' => [ 'Shipping line service',
    'Identifies the shipping line service organization.' ],
'HS' => [ 'Creditor',
    'Party to whom payment is due.' ],
'HT' => [ 'Clearing house',
    'Institution through which funds will be paid.' ],
'HU' => [ 'Ordering bank',
    'Bank which instructed the sender to act on the transaction(s).' ],
'HV' => [ 'Receiver of funds',
    'Identifies the financial party that receives the funds.' ],
'HW' => [ 'Sender of funds',
    'Identifies the party that sends the funds.' ],
'HX' => [ 'Debtor',
    'Party from whom payment is due.' ],
'HY' => [ 'Presenting bank',
    'The bank which presents documents to the drawee.' ],
'HZ' => [ 'Work team',
    'Team responsible for performing work.' ],
'I1' => [ 'Intermediary bank 1',
    "A financial institution between the ordered bank and the beneficiary's bank." ],
'I2' => [ 'Intermediary bank 2',
    "A financial institution between the ordered bank and the beneficiary's bank." ],
'IB' => [ 'Intermediary/broker',
    'A person intervening between parties to produce agreement or reconciliation.' ],
'IC' => [ 'Intermediate consignee',
    'The intermediate consignee.' ],
'ID' => [ 'Replacing manufacturer',
    'A code used to identify a party who replaces the previous party for the manufacture of an article.' ],
'IE' => [ 'Non-resident third party company with whom financial',
    'account is held Identifies the non-resident third party company with whom the financial account is held.' ],
'IF' => [ 'Non-resident group company with whom financial account is',
    'held Identifies the non-resident group company with whom the financial account is held.' ],
'IG' => [ 'Non-resident beneficiary',
    'The ultimate non-resident recipient of the funds. Normally the account owner who is reimbursed by the payer.' ],
'IH' => [ 'Resident beneficiary',
    'The ultimate resident recipient of the funds. Normally the account owner who is reimbursed by the payer.' ],
'II' => [ 'Invoice issuer',
    '[3028] Party issuing an invoice.' ],
'IJ' => [ 'Non-resident instructing party',
    'Identifies the non-resident party originating the instruction.' ],
'IL' => [ 'Resident instructing party',
    'Identifies the resident party originating the instruction.' ],
'IM' => [ 'Importer',
    '[3020] Party who makes - or on whose behalf a Customs clearing agent or other authorized person makes - an import declaration. This may include a person who has possession of the goods or to whom the goods are consigned.' ],
'IN' => [ 'Insurer',
    'A person or company offering insurance policies for premiums.' ],
'IO' => [ 'Insurance company',
    'A company engaged in the business of insurance.' ],
'IP' => [ 'Insurance claim adjuster',
    'A party which adjusts losses on behalf of an insurer.' ],
'IQ' => [ 'Domestic financial institution',
    'Domestic party acting as financial institution.' ],
'IR' => [ 'Non-domestic financial institution',
    'Non-domestic party acting as financial institution.' ],
'IS' => [ 'Party to receive certified inspection report',
    'Party (at buyer) to receive certified inspection report.' ],
'IT' => [ 'Installation on site',
    'A party who possesses the site on which an installation shall be made.' ],
'IU' => [ 'Non-resident debtor',
    'Non-resident party who makes the payment or against whom a claim exists.' ],
'IV' => [ 'Invoicee',
    '[3006] Party to whom an invoice is issued.' ],
'IW' => [ 'Non-resident creditor',
    'Non-resident party receiving the payment or against whom a liability exists.' ],
'IX' => [ 'Supplier work team',
    "The supplier's team responsible for performing the work." ],
'IY' => [ 'Tenant manager',
    'A code to identify the party who rents the rights to use the goodwill and facilities of an enterprise.' ],
'IZ' => [ 'Party mandated to liquidate an enterprise',
    'A code to identify the party who has been legally mandated to sell off an enterprise.' ],
'JA' => [ 'Certified accountant',
    'Code identifying the party as a certified accountant.' ],
'JB' => [ 'Goods collection party',
    'Party that will collect or has collected the goods.' ],
'JC' => [ 'Party at final place of positioning',
    'Identifies the party at the final place of positioning.' ],
'JD' => [ 'Customs office of clearance',
    'Identifies the office where customs clearance procedures take place.' ],
'JE' => [ 'Party from whom customs documents are to be picked up',
    'Identification of the party from whom customs documents are to be picked up.' ],
'JF' => [ 'Party from whom non-customs documents are to be picked up',
    'Identification of the party from whom non-customs documents are to be picked up.' ],
'JG' => [ 'Party to receive customs documents',
    'Identification of the party to whom customs documents are to be delivered.' ],
'JH' => [ 'Party to receive non-customs documents',
    'Identification of the party to whom non-customs documents are to be delivered.' ],
'LA' => [ 'Party designated to provide living animal care',
    'Party responsible to take care of transported living animals.' ],
'LB' => [ 'Co-producer',
    'A code used to identify a party who participates in production.' ],
'LC' => [ 'Party declaring the Value Added Tax (VAT)',
    'A code to identify the party who is responsible for declaring the Value Added Tax (VAT) on the sale of goods or services.' ],
'LD' => [ 'Party recovering the Value Added Tax (VAT)',
    'A code to identify the party who is eligible to recover the Value Added Tax (VAT) on the sale of goods or services.' ],
'LE' => [ 'Person on claim',
    'To identify the person who is the subject of the claim.' ],
'LF' => [ "Buyer's corporate office",
    "The identification of the buyer's corporate office." ],
'LG' => [ "Supplier's corporate office",
    "The identification of the supplier's corporate office." ],
'LH' => [ 'Liquidator',
    'The party responsible for settling or paying a debt.' ],
'LI' => [ 'Account coordinator',
    'An individual with coordination responsibilities for a specific account.' ],
'LJ' => [ 'Inspection leader',
    'An individual responsible for an inspection team.' ],
'LK' => [ 'Patient',
    'A person receiving or registered to receive medical treatment.' ],
'LL' => [ 'Patient companion',
    'Person accompanying the patient.' ],
'LM' => [ 'Medical treatment executant',
    'The party who executes a medical treatment.' ],
'LN' => [ 'Lender',
    'Party lending goods or equipment.' ],
'LO' => [ 'Medical treatment prescriber',
    'The party who prescribes a medical treatment.' ],
'LP' => [ 'Loading party',
    'Party responsible for the loading when other than carrier.' ],
'LQ' => [ 'Debt payment authorisation party',
    'A party which authorises the payment of a debt.' ],
'LR' => [ 'Administration centre',
    'Identification of an administration centre.' ],
'LS' => [ 'Product services and repairs centre',
    'A centre which services and repairs products.' ],
'LT' => [ 'Secretariat',
    'Party is a secretariat.' ],
'LU' => [ 'Entry point technical assessment group',
    'Party acts as an entry point for technical assessment.' ],
'LV' => [ 'Party assigning a status',
    'Party responsible for assigning a status.' ],
'MA' => [ 'Party for whom item is ultimately intended',
    'Party for whom item is ultimately intended.' ],
'MAD' => [ 'Meter administrator',
    'A party responsible for keeping a register of meters and related characteristics.' ],
'MDR' => [ 'Metered data responsible',
    'A party responsible for the establishment and validation of metered data received from the Metered Data Collector.' ],
'MF' => [ 'Manufacturer of goods',
    '[3513] Party who manufactures the goods.' ],
'MG' => [ 'Party designated to execute re-icing',
    'Party designated to execute re-icing, selected in the official list of mandatories competent for this kind of operation.' ],
'MI' => [ 'Planning schedule/material release issuer',
    'A party issuing a planning schedule/material release.' ],
'MP' => [ 'Manufacturing unit',
    'A party acting as a particular production unit of a manufacturer.' ],
'MR' => [ 'Message recipient',
    'A party to receive a message or messages.' ],
'MS' => [ 'Document/message issuer/sender',
    'Issuer of a document and/or sender of a message.' ],
'MT' => [ 'Party designated to execute sanitary procedures',
    'A party which is designated to execute sanitary procedures.' ],
'N2' => [ 'Notify party no. 2',
    'The second party which is to be notified.' ],
'NI' => [ 'Notify party',
    '[3180] Party to be notified. Synonym: Notify party No. 1.' ],
'OA' => [ 'Break bulk berth operator',
    'Party who offers facilities for berthing of vessels, handling and storage of break bulk cargo.' ],
'OB' => [ 'Ordered by',
    'Party who issued an order.' ],
'OC' => [ 'Party data responsible party',
    'The party responsible for all party data.' ],
'OD' => [ 'Equipment repair party',
    'A party making repairs to equipment.' ],
'OE' => [ 'Owner of property',
    'Party owning a property.' ],
'OF' => [ 'On behalf of',
    'Party on behalf of which an action is executed.' ],
'OG' => [ "Owner or lessor's surveyor",
    'Surveyor hired by the owner or lessor of the item.' ],
'OH' => [ "Lessee's surveyor",
    'Surveyor hired by the lessee of the item.' ],
'OI' => [ 'Outside inspection agency',
    'Third party inspecting goods or equipment.' ],
'OJ' => [ 'Third party',
    'Another party besides the two principals.' ],
'OK' => [ "Receiver's sub-entity",
    "Identifies a sub-entity within the receiver's organization." ],
'OL' => [ 'Case of need party',
    'Party to be approached in case of difficulty.' ],
'OM' => [ 'Collecting bank',
    'Any bank, other than the remitting bank, involved in processing the collection.' ],
'ON' => [ 'Remitting bank',
    'The bank to which the principal has entrusted the handling of a collection.' ],
'OO' => [ 'Order of the shipper party',
    'The owner of goods under consignment which are moving under a negotiable transport document and will only be released upon receipt of the original transport document.' ],
'OP' => [ 'Operator of property or equipment',
    'The party which operates property or a unit of equipment.' ],
'OQ' => [ 'Collection principal',
    'The party entrusting the handling of a collection to a bank.' ],
'OR' => [ 'Ordered bank',
    'Identifies the bank servicing the account for the ordering customer or payer.' ],
'OS' => [ 'Original shipper',
    'The original supplier of the goods.' ],
'OT' => [ 'Outside test agency',
    'Third party testing goods, equipment or services.' ],
'OU' => [ "Account owner's servicing bank on the sending side",
    "Identifies the financial institution on the sending side which services the account owner's bank account(s)." ],
'OV' => [ 'Transport means owner',
    'Party owning the means of transport. No synonym of carrier (= CA).' ],
'OW' => [ "Account owner's servicing bank on the receiving side",
    "Identifies the financial institution on the receiving side which services the account owner's bank account(s)." ],
'OX' => [ "Sender's correspondent bank",
    'The account, or branch of the sender, or another financial institution, through which the sender will reimburse the receiver.' ],
'OY' => [ 'Ordering customer',
    'Identifies the originator of the instruction.' ],
'OZ' => [ "Receiver's correspondent bank",
    'The branch of the receiver, or another financial institution, at which the funds will be made available to the receiver.' ],
'P1' => [ 'Contact party 1',
    'First party to contact.' ],
'P2' => [ 'Contact party 2',
    'Second party to contact.' ],
'P3' => [ 'Contact party 3',
    'Third party to contact.' ],
'P4' => [ 'Contact party 4',
    'Fourth party to contact.' ],
'PA' => [ 'Party to receive inspection report',
    'Party to whom the inspection report should be sent.' ],
'PB' => [ 'Paying financial institution',
    'Financial institution designated to make payment.' ],
'PC' => [ "Actual purchaser's customer",
    'Party the purchaser within the actual message is selling the ordered goods or services to.' ],
'PD' => [ "Purchaser's department buyer",
    'Purchasing department of buyer.' ],
'PE' => [ 'Payee',
    'Identifies the credit party when other than the beneficiary.' ],
'PF' => [ 'Party to receive freight bill',
    'Party to whom the freight bill should be sent.' ],
'PG' => [ 'Prime contractor',
    'Party responsible for the whole project if other than the buyer.' ],
'PH' => [ "Payer's financial institution",
    'Institution chosen by the payer to execute financial transactions on his behalf.' ],
'PI' => [ "Payee's company name/ID",
    'Receiving company name/ID (ACH transfers).' ],
'PJ' => [ 'Party to receive correspondence',
    'Second party designated by a first party to receive certain correspondence in lieu of it being mailed directly to this first party.' ],
'PK' => [ 'Contact party',
    'Party to contact.' ],
'PM' => [ 'Party to receive paper memo of invoice',
    'Party being informed about invoice issue (via paper).' ],
'PN' => [ 'Party to receive shipping notice',
    'The party is to be the recipient of the shipping notice.' ],
'PO' => [ 'Ordering party',
    'To be used only if ordering party and buyer are not identical.' ],
'PQ' => [ 'Certifying party',
    'A party which certifies something.' ],
'PR' => [ 'Payer',
    '[3308] Party responsible for making a payment.' ],
'PS' => [ "Payer's company name/ID (Check, Draft or Wire)",
    'Party to send cheque, draft or wire for payment.' ],
'PT' => [ 'Party to receive test report',
    'A party which is named to be the recipient of test reports.' ],
'PW' => [ 'Despatch party',
    '[3282] Party where goods are to be, or have been, taken over by a carrier such as the place where a container is picked-up.' ],
'PX' => [ 'Party to receive all documents',
    'A party which is named to be the recipient of all documents.' ],
'PY' => [ 'Checking party',
    'Party or contact designated on behalf of carrier or his agent to establish the actual figures for quantities, weight, volume and/or (cube) measurements of goods or containers which are to appear in the transport contract and on which charges will be based.' ],
'PZ' => [ 'Party to print some document',
    'The party that is to print a specific document.' ],
'RA' => [ 'Central bank or regulatory authority',
    'Identifies central bank or regulatory authority which must be informed of certain aspects of a message.' ],
'RB' => [ 'Receiving financial institution',
    'Financial institution designated to receive payment.' ],
'RE' => [ 'Party to receive commercial invoice remittance',
    'Party to whom payment for a commercial invoice or bill should be remitted.' ],
'RF' => [ 'Received from',
    'Name of a person or department which actually delivers the goods.' ],
'RH' => [ "Seller's financial institution",
    'Financial institution designated by seller to receive payment. RDFI (ACH transfers).' ],
'RI' => [ 'Reinsurance intermediary/broker',
    'Intermediary party between ceding company and reinsurance.' ],
'RL' => [ 'Reporting carrier (Customs)',
    'Party who makes the cargo report to Customs.' ],
'RM' => [ "Reporting carrier's nominated agent/representative",
    '(Customs) Agent who formally makes a cargo report to Customs on behalf of the carrier.' ],
'RP' => [ 'Routing party',
    'Party responsible for the selection of the carrier(s).' ],
'RS' => [ 'Party to receive statement of account',
    'Party to whom the statement of account should be sent.' ],
'RV' => [ 'Receiver of cheque',
    'Identifies the party which is to receive the actual cheque, when different from the receiver of funds.' ],
'RW' => [ 'Issuer of waybill',
    'Party issuing the contract (waybill) for carriage.' ],
'SB' => [ 'Sales responsibility',
    'A party being responsible for sales.' ],
'SE' => [ 'Seller',
    '[3346] Party selling merchandise or services to a buyer.' ],
'SF' => [ 'Ship from',
    'Identification of the party from where goods will be or have been shipped.' ],
'SG' => [ 'Store group',
    'A chain of shops or stores.' ],
'SI' => [ 'Shipping schedule issuer',
    'The party which issues a shipping schedule.' ],
'SN' => [ 'Store keeper',
    'A party keeping a shop or store.' ],
'SO' => [ 'Sold to if different than bill to',
    'Party to whom the goods have been sold, if different to the bill to party.' ],
'SR' => [ 'Seller agent',
    '[3254] Party representing the seller for the purpose of a trade transaction.' ],
'SS' => [ "Social securities collector's office",
    'Party collecting social securities premiums.' ],
'ST' => [ 'Ship to',
    'Identification of the party to where goods will be or have been shipped.' ],
'SU' => [ 'Supplier',
    'Party who supplies goods and or services.' ],
'SX' => [ 'Surety for additions',
    'Natural of legal person (generally a bank of insurance company) who accepts responsibility in due legal form for the financial guarantee to Customs of the payment of additional duties or fees that become due against a particular shipment, which have not previously been covered by surety.' ],
'SY' => [ 'Surety',
    "Natural or legal person (generally a bank or insurance company) who accepts responsibility in due legal form for the financial consequences of non-fulfillment of another's obligations to the Customs (CCC)." ],
'SZ' => [ 'Surety for antidumping/countervailing duty',
    'Natural or legal person that has been contracted by the importer to guarantee to Customs the payment of antidumping and/or countervailing duties that become due against a particular shipment.' ],
'TA' => [ 'Legal receiver',
    'The party responsible for a receivership.' ],
'TB' => [ 'Submitter',
    'To specify that the party is a submitter.' ],
'TC' => [ "Tax collector's office",
    'Party collecting taxes.' ],
'TCP' => [ 'Transit charge payer',
    'Party, other than the ordering party, which has to pay the charges concerning the transit operations.' ],
'TCR' => [ 'Transport capacity responsible party',
    'Party responsible for transport capacity.' ],
'TD' => [ 'Party to receive technical documentation',
    'Party to whom technical documentation should be sent.' ],
'TE' => [ 'Bankruptcy referee',
    'To specify that the party is a referee in a bankruptcy case.' ],
'TF' => [ 'Source of information',
    'To specify that the party is the source of information.' ],
'TG' => [ 'Judge',
    'To specify that the party is a judge.' ],
'TH' => [ 'Attorney',
    'To specify that the party is an attorney.' ],
'TI' => [ 'Law firm',
    'To specify that the party is a law firm.' ],
'TJ' => [ 'Trustee',
    'To specify that the party is a trustee.' ],
'TK' => [ 'Signatory',
    'To specify that the party is a signatory.' ],
'TL' => [ 'Occupant',
    'The party is an occupant.' ],
'TM' => [ 'Co-occupant',
    'The party is a co-occupant.' ],
'TN' => [ 'Subject of inquiry',
    'The party is the subject of an inquiry.' ],
'TO' => [ 'Lessor',
    'The party is a lessor.' ],
'TP' => [ 'Owner of residence',
    'Identifies the owner of a residence.' ],
'TQ' => [ 'Founder',
    'Identifies the founder.' ],
'TR' => [ 'Terminal operator',
    'A party which handles the loading and unloading of marine vessels.' ],
'TS' => [ 'Party to receive certified test results',
    'Party to whom the certified test results should be sent.' ],
'TT' => [ 'Transfer to',
    'The party which is the recipient of a transfer.' ],
'TU' => [ 'President',
    'Identifies the president.' ],
'TV' => [ 'Chairperson',
    'Identifies the chairperson.' ],
'TW' => [ 'Legal title holder',
    'Identifies the legal title holder.' ],
'TX' => [ 'Shareholder',
    'Identifies a shareholder.' ],
'TY' => [ 'Provider',
    'Identifies the provider.' ],
'TZ' => [ 'Military branch',
    'Identifies the branch of the military.' ],
'UA' => [ 'Educational institution',
    'Identifies a university, college or school.' ],
'UB' => [ 'Assignor',
    'Identifies the assignor.' ],
'UC' => [ 'Ultimate consignee',
    'Party who has been designated on the invoice or packing list as the final recipient of the stated merchandise.' ],
'UD' => [ 'Ultimate customer',
    'The final recipient of goods.' ],
'UE' => [ 'Advisor',
    'Identifies the advisor.' ],
'UF' => [ 'Co-defendant',
    'Identifies the co-defendant.' ],
'UG' => [ 'Merged company with retained identity',
    'Company whose identity has been retained from a merger.' ],
'UH' => [ 'Party represented',
    'Identifies the party represented.' ],
'UHP' => [ 'Unexpected handling party',
    'Party authorized (during a voyage) to apply unexpected handling procedures or party having applied these procedures.' ],
'UI' => [ 'Assignee',
    'Identifies the assignee.' ],
'UJ' => [ 'Key person',
    'Identifies the key person.' ],
'UK' => [ 'Author',
    'Identifies the author.' ],
'UL' => [ 'Ultimate parent company',
    'Identifies the ultimate parent company.' ],
'UM' => [ 'Party not to be confused with',
    'Identifies a party not to be confused with another party.' ],
'UN' => [ 'Accountant',
    'Identifies the accountant.' ],
'UO' => [ 'Plaintiff',
    'Identifies the plaintiff.' ],
'UP' => [ 'Unloading party',
    'A party to unload the goods.' ],
'UQ' => [ 'Parent company',
    'Identifies the parent company.' ],
'UR' => [ 'Affiliated company',
    'Identifies the affiliated company.' ],
'US' => [ 'Bailiff',
    'Identifies the bailiff.' ],
'UT' => [ 'Merged company',
    'Identifies the company involved in a merger.' ],
'UU' => [ 'Defendant',
    'Identifies the defendant.' ],
'UV' => [ 'Petitioning creditor',
    'Identifies the petitioning creditor.' ],
'UW' => [ 'Guarantee agency',
    'Identifies the guarantee agency.' ],
'UX' => [ 'Organization group',
    'Identifies the organization group.' ],
'UY' => [ 'Subsidiary',
    'Identifies the subsidiary.' ],
'UZ' => [ 'Industry association',
    'Identifies the industry association.' ],
'VA' => [ 'Joint owner',
    'Identifies the joint owner.' ],
'VB' => [ 'Joint venture',
    'Identifies the joint venture.' ],
'VC' => [ 'Filing office',
    'Identifies the filing office.' ],
'VE' => [ 'Court',
    'Identifies the court.' ],
'VF' => [ 'Liability holder',
    'Identifies the liability holder.' ],
'VG' => [ 'Local government sponsor',
    'Identifies the local government sponsor.' ],
'VH' => [ 'Mortgage company',
    'Identifies the mortgage company.' ],
'VI' => [ 'Notary public',
    'Identifies the notary public.' ],
'VJ' => [ 'Officer',
    'Identifies the officer.' ],
'VK' => [ 'Publisher',
    'Identifies the publisher.' ],
'VL' => [ 'Party manufactured for',
    'Identifies the party for whom manufacturing of goods is done.' ],
'VM' => [ 'Previous owner',
    'Identifies the previous owner.' ],
'VN' => [ 'Vendor',
    'Party vending goods or services.' ],
'VO' => [ 'Purchased company',
    'Identifies the purchased company.' ],
'VP' => [ 'Receiver manager',
    'Manager of a business which is in receivership status and which will not be liquidated.' ],
'VQ' => [ 'Responsible government agency',
    'Identifies the responsible government agency.' ],
'VR' => [ 'Sole proprietor',
    'Identifies the sole proprietor.' ],
'VS' => [ 'Auctioneer',
    'Identifies the auctioneer.' ],
'VT' => [ 'Branch',
    'Identifies the branch.' ],
'VU' => [ 'Business',
    'Identifies the business.' ],
'VV' => [ 'Ultimate same country parent company',
    'Identifies the highest level parent company in the same country.' ],
'VW' => [ 'Responsible party',
    'Identifies the party that can be called to account.' ],
'VX' => [ 'Secured party',
    'Identifies a party that is guaranteed against loss.' ],
'VY' => [ 'Other related party',
    'Identifies an entity as an unspecified but related party.' ],
'VZ' => [ 'Co-debtor',
    'Identifies an entity as a joint or mutual debtor.' ],
'WA' => [ 'Company which holds financial interest',
    'Identifies a company which holds any financial stake in an undertaking or organization.' ],
'WB' => [ 'Rating organization',
    'Identifies an organization responsible for assigning a classification or rating.' ],
'WC' => [ 'Information reference agency',
    'The agency responsible for the reference of information.' ],
'WD' => [ 'Warehouse depositor',
    '[3004] Party depositing goods in a warehouse.' ],
'WE' => [ 'Compilation agency',
    'The agency responsible for the compilation of information.' ],
'WF' => [ 'Information maintenance agency',
    'The agency responsible for the maintenance of information.' ],
'WG' => [ 'Information dissemination agency',
    'The agency responsible for the dissemination of information.' ],
'WH' => [ 'Warehouse keeper',
    '[3022] Party taking responsibility for goods entered into a warehouse.' ],
'WI' => [ 'Inspection address',
    'Specifies the address for an inspection.' ],
'WJ' => [ 'Refusal party',
    'Identification of the party responsible for a refusal.' ],
'WK' => [ 'Value added network provider',
    'A party that provides telecommunications interconnectivity services in an electronic data interchange environment.' ],
'WL' => [ 'Agency',
    'The business or establishment of an agent.' ],
'WM' => [ 'Works manager',
    'A party managing works.' ],
'WN' => [ 'Party to receive order to supply',
    'Party designated by the registering party to receive a binding direction to supply something.' ],
'WO' => [ 'Party to receive invitation to offer',
    'An entity to receive an invitation to offer.' ],
'WP' => [ 'Sub-entity',
    'A part into which an entity has been divided.' ],
'WPA' => [ 'Weighting party',
    'Party designated (legally accepted) to ascertain the weight.' ],
'WQ' => [ 'Doing business as',
    'The name under which business is conducted.' ],
'WR' => [ 'Party submitting quote',
    'The party stating the price of something to be purchased.' ],
'WS' => [ 'Wholesaler',
    'Seller of articles, often in large quantities, to be retailed by others.' ],
'WT' => [ 'Affiliated party',
    'A party attached or connected to another party.' ],
'WU' => [ 'Previous name',
    'Name of an entity used before the current name.' ],
'WV' => [ 'Party performing task',
    'An entity responsible for performing a task to be undertaken.' ],
'WW' => [ 'Registering party',
    'Party performing the registration.' ],
'WX' => [ 'Inland clearance depot operator',
    'Party that offers the facility for the goods or container(s) to be cleared by customs authorities or other governmental authorities in the interior of a country.' ],
'WY' => [ 'Destination terminal operator',
    'Party that operates a terminal to which goods or containers are destined.' ],
'WZ' => [ 'Departure terminal operator',
    'Party that operates a terminal from which goods or containers have departed or will depart.' ],
'ZZZ' => [ 'Mutually defined',
    'Party specification mutually agreed between interchanging parties.' ],
);
sub get_codes { return \%code_hash; }

1;
