package {{$name}};
use strict;
use warnings;
use Data::Password::zxcvbn;
use Exporter 'import';
our @EXPORT_OK=qw(password_strength);
# VERSION
# ABSTRACT: Dropbox's password estimation logic, with {{ (split /::/,$name)[-1] }} defaults

=for Pod::Coverage password_strength

=head1 SYNOPSIS

  use {{$name}} qw(password_strength);

  my $strength = password_strength($my_password);
  warn $strength->{warning} if $strength->{score} < 3;

=head1 DESCRIPTION

This is a variant of L<< C<Data::Password::zxcvbn> >> with {{ (split /::/,$name)[-1] }}
data. See that distribution for all the documentation.

=cut

sub password_strength {
    my ($password, $opts) = @_;

    my %actual_opts = %{ $opts // {} };
    $actual_opts{ranked_dictionaries} //= do {
        require {{$name}}::RankedDictionaries;
        \%{{$name}}::RankedDictionaries::ranked_dictionaries;
    };
    $actual_opts{graphs} //= do {
        require {{$name}}::RankedDictionaries;
        \%{{$name}}::AdjacencyGraph::graphs;
    };

    return Data::Password::zxcvbn::password_strength(
        $password,
        \%actual_opts,
    );
}

1;
