use strict;
use warnings;

use Amazon::API::SecretsManager;
use Amazon::Credentials;
use Text::ASCIITable;
use English qw(-no_match_vars);

use Data::Dumper;

my $credentials = Amazon::Credentials->new( no_passkey_warning => 1 );

my $secrets = Amazon::API::SecretsManager->new( credentials => $credentials );

my $result = $secrets->ListSecrets( {} );

my $t = Text::ASCIITable->new( { headingText => 'Secrets' } );

$t->setCols(qw(Name Value Created));

my $token = eval {
  require IO::Pager;

  IO::Pager::open( *STDOUT, '|-:utf8', 'Unbuffered' );
};

if ( ref $result ) {
  my @secrets = @{ $result->{SecretList} };

  foreach (@secrets) {
    my $result = $secrets->GetSecretValue( { SecretId => $_->{Name} } );
    $t->addRow( $_->{Name}, $_->{CreatedDate}, $result->{SecretString} );
  }

  print {*STDOUT} $t;
}

1;
