package DBIx::Class::ServiceProxy;

use strict;
use warnings;

use base qw(DBIx::Class);

__PACKAGE__->mk_classdata('service_class' => '');
__PACKAGE__->mk_classdata('schema');

=head1 NAME

DBIx::Class::ServiceProxy - Service proxy class for DBIx::Class::Service

=head1 VERSION

version 0.02

=cut

our $VERSION = '0.02';

=head1 SYNOPSIS

This module is base class of internal classes by the concreate service classes.
It is generated by automatically.

=head1 METHODS

=head2 DBIx::Class::Service service_class()

It will be returned class name inherited from DBIx::Class::Service.

=head2 DBIx::Class::Schema schema()

It will be returned object inherited from DBIx::Class::Schema.

=head1 SEE ALSO

=over 4

=item DBIx::Class::Service

=item DBIx::Class::ServiceManager

=back

=head1 AUTHOR

Toru Yamaguchi, C<< <zigorou@cpan.org> >>

=head1 BUGS

Please report any bugs or feature requests to
C<bug-dbix-class-serviceproxy@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.  I will be notified, and then you'll automatically be
notified of progress on your bug as I make changes.

=head1 COPYRIGHT & LICENSE

Copyright 2008 Toru Yamaguchi, All Rights Reserved.

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=cut

1; # End of DBIx::Class::ServiceProxy
