package [% this.get_namespace %]::Control::Container::[% this.get_service %]::[% name %];

use strict;
use warnings;

use Class::Std::Storable;
use base qw(Hyper::Control::Container);

[% FOREACH attribute = data.attributes %]
my %[% attribute %] :ATTR(:default<()> :get<[% attribute %]> :set<[% attribute %]>);
[% END; FOREACH step = data.step_data ; IF step.value.action %]
sub _action_of_[% step.key %] :RESTRICTED {
    my $self = shift;
    [% step.value.action %]
}
[% END -%]
[%- IF step.value.transitions %]
sub _get_destination_of_[% step.key %] :RESTRICTED {
    my $self = shift;
[% PERL %]
    my @transitions = @{$stash->get('step.value.transitions')};

    print join "\n", map {
        my ($destination, $condition) = splice @transitions, 0, 2;
        defined $condition && length $condition
            ? "    return '$destination' if $condition;"
            : defined $destination
                  ? "    return '$destination';"
                  : "    return;";
        } 0..$#transitions/2;[% END %]
}
[% END ; IF step.value.control %]
sub ACTION_[% step.key %] {
    my $self     = shift;
    my $template = $self->get_template();

    # place all custom data before map - map regards them as argument
    $template->param(
        map {
            $_ => $self->get_object($_);
        } qw([% step.value.control.join(' ')%])
    );
    $template->output();

    return $self;
}
[% END; END %]
1;

__END__
[%# work around for CPAN's indexer, which gets disturbed by pod in templates -%]
[% pod = BLOCK %]=pod[% END -%]

=head1 NAME

[% this.get_namespace %]::Control::Container::[% this.get_service %]::[% name %] - auto-generated by Hyper Framework

=head1 CAVEATS

Don't touch this module - your changes will be lost on the next generator run.

[%- basename = name;
basename = basename.replace('_', '') -%]

Edit [% this.get_namespace %]::Control::Container::[% this.get_service %]::[% basename %] instead.

=head1 METHODS
[%- FOREACH step = data.step_data -%]
[% IF step.value.control %]
=head2 ACTION_[% step.key %]

Sets all control elements as template params.

The list of control elements is:
[% FOREACH control = data.step_data.value.control %]
 [% control %]
[%- END -%]
[% END -%]
[% END %]

=head1 COPYING


=head1 AUTHOR

 Generated by Hyper::Generator::Flow

=cut

