# Generated by default/object.tt
package Paws::Appflow::SourceConnectorProperties;
  use Moose;
  has Amplitude => (is => 'ro', isa => 'Paws::Appflow::AmplitudeSourceProperties');
  has Datadog => (is => 'ro', isa => 'Paws::Appflow::DatadogSourceProperties');
  has Dynatrace => (is => 'ro', isa => 'Paws::Appflow::DynatraceSourceProperties');
  has GoogleAnalytics => (is => 'ro', isa => 'Paws::Appflow::GoogleAnalyticsSourceProperties');
  has InforNexus => (is => 'ro', isa => 'Paws::Appflow::InforNexusSourceProperties');
  has Marketo => (is => 'ro', isa => 'Paws::Appflow::MarketoSourceProperties');
  has S3 => (is => 'ro', isa => 'Paws::Appflow::S3SourceProperties');
  has Salesforce => (is => 'ro', isa => 'Paws::Appflow::SalesforceSourceProperties');
  has ServiceNow => (is => 'ro', isa => 'Paws::Appflow::ServiceNowSourceProperties');
  has Singular => (is => 'ro', isa => 'Paws::Appflow::SingularSourceProperties');
  has Slack => (is => 'ro', isa => 'Paws::Appflow::SlackSourceProperties');
  has Trendmicro => (is => 'ro', isa => 'Paws::Appflow::TrendmicroSourceProperties');
  has Veeva => (is => 'ro', isa => 'Paws::Appflow::VeevaSourceProperties');
  has Zendesk => (is => 'ro', isa => 'Paws::Appflow::ZendeskSourceProperties');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::SourceConnectorProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::SourceConnectorProperties object:

  $service_obj->Method(Att1 => { Amplitude => $value, ..., Zendesk => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::SourceConnectorProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Amplitude

=head1 DESCRIPTION

Specifies the information that is required to query a particular
connector.

=head1 ATTRIBUTES


=head2 Amplitude => L<Paws::Appflow::AmplitudeSourceProperties>

Specifies the information that is required for querying Amplitude.


=head2 Datadog => L<Paws::Appflow::DatadogSourceProperties>

Specifies the information that is required for querying Datadog.


=head2 Dynatrace => L<Paws::Appflow::DynatraceSourceProperties>

Specifies the information that is required for querying Dynatrace.


=head2 GoogleAnalytics => L<Paws::Appflow::GoogleAnalyticsSourceProperties>

Specifies the information that is required for querying Google
Analytics.


=head2 InforNexus => L<Paws::Appflow::InforNexusSourceProperties>

Specifies the information that is required for querying Infor Nexus.


=head2 Marketo => L<Paws::Appflow::MarketoSourceProperties>

Specifies the information that is required for querying Marketo.


=head2 S3 => L<Paws::Appflow::S3SourceProperties>

Specifies the information that is required for querying Amazon S3.


=head2 Salesforce => L<Paws::Appflow::SalesforceSourceProperties>

Specifies the information that is required for querying Salesforce.


=head2 ServiceNow => L<Paws::Appflow::ServiceNowSourceProperties>

Specifies the information that is required for querying ServiceNow.


=head2 Singular => L<Paws::Appflow::SingularSourceProperties>

Specifies the information that is required for querying Singular.


=head2 Slack => L<Paws::Appflow::SlackSourceProperties>

Specifies the information that is required for querying Slack.


=head2 Trendmicro => L<Paws::Appflow::TrendmicroSourceProperties>

Specifies the information that is required for querying Trend Micro.


=head2 Veeva => L<Paws::Appflow::VeevaSourceProperties>

Specifies the information that is required for querying Veeva.


=head2 Zendesk => L<Paws::Appflow::ZendeskSourceProperties>

Specifies the information that is required for querying Zendesk.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

