#!/usr/bin/perl
use strict;
use warnings;

use Dancer ':syntax';
use Dancer::Test;
use Log::Any qw{$log};
use Test::More import => ['!pass'];

setting log => 'core';
setting LogAny => {category => 'Bar', logger => ['Test']};
setting logger => 'LogAny';

# Log::Any after 0.90 changes the class where msgs() lives
my $msg_source = $log->can('msgs') ? $log : $log->adapter;

for my $level (qw{core debug info warning error}) {
    my $route = "/$level";
    my $message = "$level-whatever";
    my $sub = "Dancer::Logger::$level";
    get $route => sub {
        no strict 'refs';
        &$sub ($message);
        return $message;
    };
    route_exists [GET => $route];
    response_content_is ([GET => $route], $message);
    # There's a lot of messages generated by core we don't want to worry with
    my $messages = $msg_source->msgs;
    is_deeply (pop @{$messages}, {category => 'Bar', level => ($level eq 'core' ? 'info' : $level), message => $message}, "Compare message recieved to expected");
    $msg_source->clear;
}

done_testing;
