/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractConnection;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Arrows;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionTranslatable;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondFoo1;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FtileWhile
extends AbstractFtile {
    private final Ftile whileBlock;
    private final Ftile diamond1;
    private final TextBlock supplementarySouthText;

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> hashSet = new HashSet<Swimlane>(this.whileBlock.getSwimlanes());
        hashSet.add(this.getSwimlaneIn());
        return hashSet;
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.diamond1.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    private FtileWhile(Ftile ftile, Ftile ftile2, TextBlock textBlock) {
        super(ftile.shadowing());
        this.whileBlock = ftile;
        this.diamond1 = ftile2;
        this.supplementarySouthText = textBlock;
    }

    private static TextBlock createLabel1(Display display, Display display2, UFont uFont, ISkinSimple iSkinSimple) {
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        TextBlock textBlock = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple);
        if (display == null) {
            return textBlock;
        }
        return TextBlockUtils.mergeTB(TextBlockUtils.create(display, fontConfiguration, HorizontalAlignment.LEFT, iSkinSimple), textBlock, HorizontalAlignment.CENTER);
    }

    public static Ftile create(Swimlane swimlane, Ftile ftile, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, Display display2, Display display3, UFont uFont, HtmlColor htmlColor4, LinkRendering linkRendering, FtileFactory ftileFactory, ConditionStyle conditionStyle, UFont uFont2) {
        AbstractFtile abstractFtile;
        TextBlock textBlock;
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
        FontConfiguration fontConfiguration2 = new FontConfiguration(uFont2, HtmlColorUtils.BLACK);
        TextBlock textBlock2 = TextBlockUtils.create(display2, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock textBlock3 = TextBlockUtils.create(display, fontConfiguration2, HorizontalAlignment.LEFT, ftileFactory);
        TextBlock textBlock4 = TextBlockUtils.create(display3, fontConfiguration, HorizontalAlignment.LEFT, ftileFactory);
        if (conditionStyle == ConditionStyle.INSIDE) {
            textBlock = TextBlockUtils.empty(0.0, 0.0);
            abstractFtile = new FtileDiamondInside(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock3).withNorth(textBlock2).withWest(textBlock4);
        } else if (conditionStyle == ConditionStyle.FOO1) {
            textBlock = TextBlockUtils.empty(0.0, 0.0);
            abstractFtile = new FtileDiamondFoo1(ftile.shadowing(), htmlColor2, htmlColor, swimlane, textBlock3).withNorth(textBlock2).withWest(textBlock4);
        } else if (conditionStyle == ConditionStyle.DIAMOND) {
            textBlock = FtileWhile.createLabel1(display, display2, uFont, ftileFactory);
            abstractFtile = new FtileDiamond(ftile.shadowing(), htmlColor2, htmlColor, swimlane).withWest(textBlock4).withSouth(textBlock);
        } else {
            throw new IllegalStateException();
        }
        FtileWhile ftileWhile = new FtileWhile(ftile, abstractFtile, textBlock);
        HtmlColor htmlColor5 = htmlColor3;
        if (linkRendering != null && linkRendering.getColor() != null) {
            htmlColor5 = linkRendering.getColor();
        }
        ArrayList<Connection> arrayList = new ArrayList<Connection>();
        FtileWhile ftileWhile2 = ftileWhile;
        ftileWhile2.getClass();
        arrayList.add(ftileWhile2.new ConnectionIn(LinkRendering.getColor(ftile.getInLinkRendering(), htmlColor3)));
        FtileWhile ftileWhile3 = ftileWhile;
        ftileWhile3.getClass();
        arrayList.add(ftileWhile3.new ConnectionBack(htmlColor4));
        FtileWhile ftileWhile4 = ftileWhile;
        ftileWhile4.getClass();
        arrayList.add(ftileWhile4.new ConnectionOut(htmlColor5));
        return FtileUtils.addConnection((Ftile)ftileWhile, arrayList);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.apply(this.getTranslateForWhile(stringBounder)).draw(this.whileBlock);
        uGraphic.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.supplementarySouthText.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.whileBlock.calculateDimension(stringBounder);
        double d = dimension2D.getWidth() - ftileGeometry2.getWidth();
        if (d > 0.0) {
            ftileGeometry2 = ftileGeometry2.addMarginX(d / 2.0);
        }
        FtileGeometry ftileGeometry3 = ftileGeometry.appendBottom(ftileGeometry2);
        double d2 = ftileGeometry3.getHeight() + 96.0 + dimension2D.getHeight();
        return new FtileGeometry(ftileGeometry3.getWidth() + 24.0 + 12.0, d2, ftileGeometry3.getLeft() + 24.0, 0.0, d2);
    }

    @Override
    public UTranslate getTranslateFor(Ftile ftile, StringBounder stringBounder) {
        if (ftile == this.whileBlock) {
            return this.getTranslateForWhile(stringBounder);
        }
        if (ftile == this.diamond1) {
            return this.getTranslateDiamond1(stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslateForWhile(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry3 = this.whileBlock.calculateDimension(stringBounder);
        double d = ftileGeometry.getHeight() + (ftileGeometry2.getHeight() - ftileGeometry.getHeight() - ftileGeometry3.getHeight()) / 2.0;
        double d2 = ftileGeometry2.getLeft() - ftileGeometry3.getLeft();
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry2 = this.diamond1.calculateDimension(stringBounder);
        double d = ftileGeometry.getLeft() - ftileGeometry2.getLeft();
        return new UTranslate(d, 0.0);
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    class ConnectionOut
    extends AbstractConnection {
        private final HtmlColor afterEndwhileColor;

        public ConnectionOut(HtmlColor htmlColor) {
            super(FtileWhile.this.diamond1, null);
            this.afterEndwhileColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        private Point2D getP2(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            return new Point2D.Double(ftileGeometry.getLeft(), ftileGeometry.getHeight());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.afterEndwhileColor);
            FtileGeometry ftileGeometry = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY() + ((Dimension2D)ftileGeometry).getHeight() / 2.0;
            double d3 = point2D2.getX();
            double d4 = point2D2.getY();
            snake.addPoint(d, d2);
            snake.addPoint(12.0, d2);
            snake.addPoint(12.0, d4);
            uGraphic.draw(snake);
            uGraphic = uGraphic.apply(new UChangeColor(this.afterEndwhileColor)).apply(new UChangeBackColor(this.afterEndwhileColor));
            uGraphic.apply(new UTranslate(12.0, (d2 + d4) / 2.0)).draw(Arrows.asToDown());
            Snake snake2 = new Snake(this.afterEndwhileColor, true);
            snake2.addPoint(12.0, d4);
            snake2.addPoint(d3, d4);
            uGraphic.draw(snake2);
        }
    }

    class ConnectionBack
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor endInlinkColor;

        public ConnectionBack(HtmlColor htmlColor) {
            super(FtileWhile.this.whileBlock, FtileWhile.this.diamond1);
            this.endInlinkColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            FtileGeometry ftileGeometry = FtileWhile.this.whileBlock.calculateDimension(stringBounder);
            if (!ftileGeometry.hasPointOut()) {
                return null;
            }
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(ftileGeometry.getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(new Point2D.Double(0.0, 0.0));
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            if (point2D == null) {
                return;
            }
            Point2D point2D2 = this.getP2(stringBounder);
            FtileGeometry ftileGeometry2 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double d = point2D.getX();
            double d2 = point2D.getY();
            double d3 = point2D2.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d4 = point2D2.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d2 + 12.0);
            double d5 = ((Dimension2D)ftileGeometry).getWidth();
            snake.addPoint(d5, d2 + 12.0);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic = uGraphic.apply(new UChangeColor(this.endInlinkColor)).apply(new UChangeBackColor(this.endInlinkColor));
            uGraphic.apply(new UTranslate(d5, (d2 + d4) / 2.0)).draw(Arrows.asToUp());
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.endInlinkColor, Arrows.asToLeft());
            FtileGeometry ftileGeometry = FtileWhile.this.calculateDimension(stringBounder);
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            FtileGeometry ftileGeometry2 = FtileWhile.this.diamond1.calculateDimension(stringBounder);
            double d = point2D3.getX();
            double d2 = point2D3.getY();
            double d3 = point2D4.getX() + ((Dimension2D)ftileGeometry2).getWidth();
            double d4 = point2D4.getY() + ((Dimension2D)ftileGeometry2).getHeight() / 2.0;
            snake.addPoint(d, d2);
            snake.addPoint(d, d2 + 12.0);
            double d5 = Math.max(uTranslate.getDx(), uTranslate2.getDx()) + ((Dimension2D)ftileGeometry).getWidth();
            snake.addPoint(d5, d2 + 12.0);
            snake.addPoint(d5, d4);
            snake.addPoint(d3, d4);
            uGraphic.draw(snake);
            uGraphic.apply(new UTranslate(d, d2 + 12.0)).draw(new UEmpty(5.0, 12.0));
            uGraphic = uGraphic.apply(new UChangeColor(this.endInlinkColor)).apply(new UChangeBackColor(this.endInlinkColor));
            uGraphic.apply(new UTranslate(d5, (d2 + d4) / 2.0)).draw(Arrows.asToUp());
        }
    }

    class ConnectionIn
    extends AbstractConnection
    implements ConnectionTranslatable {
        private final HtmlColor arrowColor;

        public ConnectionIn(HtmlColor htmlColor) {
            super(FtileWhile.this.diamond1, FtileWhile.this.whileBlock);
            this.arrowColor = htmlColor;
        }

        private Point2D getP1(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateDiamond1(stringBounder).getTranslated(this.getFtile1().calculateDimension(stringBounder).getPointOut());
        }

        private Point2D getP2(StringBounder stringBounder) {
            return FtileWhile.this.getTranslateForWhile(stringBounder).getTranslated(this.getFtile2().calculateDimension(stringBounder).getPointIn());
        }

        public void drawU(UGraphic uGraphic) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            snake.addPoint(this.getP1(stringBounder));
            snake.addPoint(this.getP2(stringBounder));
            uGraphic.draw(snake);
        }

        public void drawTranslate(UGraphic uGraphic, UTranslate uTranslate, UTranslate uTranslate2) {
            StringBounder stringBounder = uGraphic.getStringBounder();
            Point2D point2D = this.getP1(stringBounder);
            Point2D point2D2 = this.getP2(stringBounder);
            Snake snake = new Snake(this.arrowColor, Arrows.asToDown());
            Point2D point2D3 = uTranslate.getTranslated(point2D);
            Point2D point2D4 = uTranslate2.getTranslated(point2D2);
            double d = (point2D3.getY() + point2D4.getY()) / 2.0;
            snake.addPoint(point2D3);
            snake.addPoint(point2D3.getX(), d);
            snake.addPoint(point2D4.getX(), d);
            snake.addPoint(point2D4);
            uGraphic.draw(snake);
        }
    }
}

