#!/bin/bash
# Generates the simplistic datasets needed by updater_gpu unit-tests
# USAGE:
#  cd <xgboostRootDir>
#  ./plugin/updater_gpu/test/cpp/generate_data.sh
#  make PLUGIN_UPDATER_GPU=ON test


mkdir -p plugin/updater_gpu/test/cpp/data

echo "0 1:1 9:1 11:1 16:1
1 3:1 9:1 11:1 16:1
0 1:1 9:1 13:1 16:1
0 3:1 9:1 11:1 16:1
0 4:1 7:1 11:1 17:1
0 3:1 10:1 13:1 16:1
1 3:1 9:1 11:1 16:1
0 1:1 9:1 13:1 16:1
1 3:1 9:1 11:1 16:1
0 4:1 9:1 13:1 16:1
1 3:1 9:1 11:1 16:1
0 1:1 9:1 13:1 16:1
0 4:1 7:1 14:1 17:1
0 1:1 9:1 11:1 16:1
0 4:1 10:1 11:1 17:1" > plugin/updater_gpu/test/cpp/data/small.sample.libsvm

echo "0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 1:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 4:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 3:1 10:1 20:1 21:1 23:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 1:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 120:1
0 4:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 1:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 1:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 120:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 4:1 10:1 19:1 21:1 23:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 1:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 1:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 4:1 10:1 19:1 21:1 23:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 1:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 1:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 1:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 1:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 7:1 19:1 21:1 24:1 34:1 37:1 40:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
0 3:1 10:1 19:1 21:1 24:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
1 4:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 124:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 123:1
0 3:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 3:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 3:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 1:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 120:1
0 3:1 7:1 20:1 21:1 24:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 120:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 3:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 1:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
1 3:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 123:1
0 4:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 1:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 1:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 3:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 4:1 10:1 19:1 21:1 24:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 120:1
0 4:1 7:1 20:1 21:1 23:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 4:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 1:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 7:1 19:1 21:1 23:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 123:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 1:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 3:1 7:1 20:1 21:1 24:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 4:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 124:1
0 3:1 7:1 19:1 21:1 24:1 34:1 37:1 40:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 120:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 6:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 6:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 4:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 123:1
0 4:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 4:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 4:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 1:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 122:1
0 4:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 1:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
0 3:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 123:1
0 4:1 10:1 20:1 21:1 23:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 123:1
0 3:1 10:1 19:1 21:1 24:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 1:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 122:1
0 3:1 10:1 20:1 21:1 23:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 120:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 45:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 1:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
1 3:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 123:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 10:1 20:1 21:1 24:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 3:1 10:1 19:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
0 4:1 7:1 19:1 21:1 24:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 19:1 21:1 23:1 34:1 37:1 40:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 123:1
0 4:1 10:1 20:1 21:1 23:1 34:1 37:1 40:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 120:1
0 4:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
0 4:1 10:1 20:1 21:1 24:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
1 3:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 10:1 19:1 21:1 23:1 34:1 37:1 40:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 1:1 10:1 19:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 4:1 7:1 19:1 21:1 24:1 34:1 37:1 40:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 1:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 10:1 20:1 21:1 24:1 34:1 37:1 40:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 111:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 123:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 123:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 6:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
1 3:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
1 4:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 9:1 19:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 124:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 11:1 21:1 24:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 123:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
1 3:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 3:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 51:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 116:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 1:1 10:1 20:1 21:1 24:1 34:1 36:1 39:1 42:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 122:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 48:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 1:1 9:1 19:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 116:1 122:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
1 3:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 124:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 4:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 124:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 9:1 20:1 21:1 24:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 11:1 21:1 23:1 34:1 36:1 39:1 42:1 53:1 60:1 65:1 67:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 1:1 10:1 20:1 21:1 23:1 34:1 36:1 39:1 41:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 9:1 20:1 21:1 23:1 34:1 36:1 39:1 45:1 53:1 56:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 120:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
1 4:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 120:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 124:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
1 4:1 10:1 11:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 124:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 114:1 120:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 120:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 51:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 124:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 19:1 21:1 30:1 34:1 36:1 40:1 42:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 120:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 9:1 11:1 21:1 30:1 34:1 36:1 40:1 41:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 124:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 117:1 120:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 9:1 19:1 21:1 30:1 34:1 36:1 40:1 48:1 53:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 124:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 39:1 41:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 10:1 19:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 10:1 11:1 22:1 29:1 34:1 37:1 39:1 42:1 54:1 58:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 106:1 114:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 44:1 54:1 58:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 25:1 34:1 36:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 54:1 58:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 98:1 105:1 117:1 120:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 37:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 37:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 19:1 22:1 25:1 34:1 36:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 36:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 16:1 22:1 25:1 34:1 37:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 16:1 22:1 25:1 34:1 36:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 16:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 14:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 14:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 25:1 34:1 36:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 14:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 36:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 25:1 34:1 37:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 3:1 7:1 14:1 22:1 25:1 34:1 36:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 42:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 117:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 10:1 14:1 22:1 25:1 34:1 37:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 7:1 19:1 22:1 25:1 34:1 36:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 117:1 126:1
1 3:1 7:1 16:1 22:1 25:1 34:1 37:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 10:1 16:1 22:1 25:1 34:1 37:1 40:1 49:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
0 4:1 7:1 11:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 3:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 42:1 54:1 55:1 65:1 69:1 73:1 82:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 4:1 7:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 14:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 73:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
0 4:1 7:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 49:1 54:1 55:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 102:1 105:1 119:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 102:1 106:1 119:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 3:1 10:1 18:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 3:1 9:1 17:1 22:1 29:1 34:1 36:1 40:1 44:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 4:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 10:1 19:1 22:1 25:1 34:1 36:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 73:1 84:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 1:1 9:1 19:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 3:1 7:1 14:1 22:1 25:1 34:1 36:1 40:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 105:1 118:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 5:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
0 5:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
1 3:1 10:1 14:1 22:1 25:1 34:1 36:1 40:1 48:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 106:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 5:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
0 5:1 7:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
0 4:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
0 5:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 4:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
0 3:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 4:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 3:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 44:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 118:1 126:1
0 5:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
0 5:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 5:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 3:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
0 5:1 7:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 20:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 87:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 1:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 3:1 7:1 20:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 87:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 4:1 10:1 18:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 3:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 3:1 7:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 65:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 1:1 9:1 19:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 5:1 9:1 20:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 9:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 7:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 20:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 4:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 3:1 7:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 123:1
1 1:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 46:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
0 4:1 10:1 18:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
0 5:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 4:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 4:1 9:1 19:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
0 4:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 44:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
0 5:1 7:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 65:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
0 3:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 3:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 9:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 65:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 19:1 21:1 29:1 34:1 36:1 39:1 46:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
0 5:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 3:1 7:1 11:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 87:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 4:1 9:1 18:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
0 5:1 7:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 9:1 13:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 66:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
0 4:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
0 3:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 4:1 7:1 11:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 55:1 62:1 69:1 77:1 79:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 76:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
0 5:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 3:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 1:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 46:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 4:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
0 4:1 9:1 15:1 22:1 29:1 34:1 36:1 40:1 49:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 118:1 126:1
1 3:1 9:1 20:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 64:1 67:1 77:1 87:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 14:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 123:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 120:1
1 4:1 9:1 19:1 21:1 29:1 34:1 36:1 39:1 46:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 44:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
0 3:1 9:1 17:1 22:1 29:1 34:1 36:1 40:1 51:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 44:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
0 4:1 9:1 15:1 22:1 29:1 34:1 36:1 40:1 49:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 118:1 126:1
0 5:1 10:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 1:1 10:1 19:1 21:1 29:1 34:1 36:1 39:1 46:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
1 4:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 19:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 3:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 62:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
0 3:1 10:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 61:1 65:1 69:1 76:1 85:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 71:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 4:1 10:1 12:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
1 1:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 122:1
1 1:1 10:1 19:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
1 3:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 51:1 54:1 55:1 62:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 118:1 124:1
0 4:1 9:1 16:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
0 4:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 48:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 120:1
1 3:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 80:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 7:1 14:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 71:1 84:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 3:1 10:1 14:1 21:1 27:1 34:1 36:1 39:1 48:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 120:1
0 3:1 9:1 15:1 22:1 29:1 34:1 36:1 40:1 49:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
0 5:1 10:1 18:1 21:1 29:1 34:1 36:1 39:1 50:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 98:1 112:1 115:1 125:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 118:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 75:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 4:1 10:1 19:1 21:1 27:1 34:1 36:1 39:1 44:1 54:1 55:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 102:1 108:1 117:1 124:1
1 4:1 7:1 20:1 22:1 27:1 34:1 36:1 39:1 48:1 53:1 55:1 64:1 68:1 70:1 79:1 88:1 92:1 95:1 100:1 108:1 119:1 126:1
1 1:1 9:1 12:1 21:1 29:1 34:1 36:1 39:1 45:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 109:1 118:1 120:1
0 3:1 9:1 19:1 22:1 29:1 34:1 36:1 40:1 48:1 53:1 61:1 65:1 66:1 77:1 86:1 88:1 92:1 95:1 99:1 108:1 119:1 126:1
1 4:1 9:1 20:1 22:1 27:1 34:1 36:1 39:1 45:1 53:1 55:1 64:1 68:1 70:1 84:1 88:1 92:1 95:1 100:1 108:1 119:1 120:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 115:1 121:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 107:1 118:1 121:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 118:1 121:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 5:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 118:1 121:1
0 3:1 9:1 13:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 4:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 1:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 4:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 10:1 11:1 22:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 63:1 67:1 70:1 79:1 88:1 92:1 96:1 102:1 112:1 119:1 126:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 4:1 10:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 110:1 118:1 121:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 106:1 118:1 121:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 115:1 121:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 118:1 121:1
0 3:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 1:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 1:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
1 4:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 107:1 115:1 121:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 3:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 4:1 9:1 18:1 22:1 28:1 34:1 36:1 39:1 52:1 53:1 56:1 64:1 67:1 72:1 81:1 88:1 92:1 94:1 101:1 112:1 115:1 126:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 115:1 121:1
1 4:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 118:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 1:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 5:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 4:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 10:1 13:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 110:1 115:1 121:1
1 3:1 9:1 13:1 22:1 28:1 32:1 36:1 39:1 51:1 53:1 56:1 64:1 67:1 72:1 81:1 88:1 92:1 94:1 101:1 112:1 115:1 126:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 107:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 118:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 107:1 115:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 28:1 32:1 36:1 39:1 52:1 53:1 56:1 64:1 67:1 72:1 81:1 88:1 92:1 94:1 101:1 112:1 115:1 126:1
1 4:1 9:1 20:1 22:1 29:1 34:1 37:1 40:1 52:1 53:1 56:1 63:1 67:1 78:1 87:1 88:1 93:1 95:1 98:1 112:1 115:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 106:1 118:1 121:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 63:1 67:1 70:1 79:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 1:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 1:1 9:1 20:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 56:1 63:1 67:1 78:1 87:1 88:1 93:1 95:1 98:1 112:1 115:1 121:1
0 5:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 118:1 121:1
1 4:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 107:1 118:1 121:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 115:1 121:1
0 3:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 4:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
0 1:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
0 4:1 9:1 13:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 16:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 118:1 123:1
1 2:1 9:1 20:1 22:1 29:1 34:1 37:1 40:1 51:1 53:1 56:1 63:1 67:1 78:1 87:1 88:1 93:1 95:1 98:1 112:1 115:1 121:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 9:1 11:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 118:1 123:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 115:1 121:1
0 1:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 1:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 1:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 5:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 106:1 118:1 121:1
1 3:1 10:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 10:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 115:1 121:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 28:1 34:1 36:1 39:1 51:1 53:1 56:1 64:1 67:1 72:1 81:1 88:1 92:1 94:1 101:1 112:1 115:1 126:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 107:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 118:1 121:1
0 5:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 4:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 115:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 107:1 118:1 121:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 110:1 115:1 121:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 3:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 9:1 11:1 22:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 63:1 67:1 70:1 79:1 88:1 92:1 96:1 102:1 112:1 119:1 126:1
1 5:1 9:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 3:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 115:1 121:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 4:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
1 3:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 9:1 13:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 118:1 123:1
0 1:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 110:1 115:1 121:1
0 1:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 110:1 118:1 121:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 3:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 4:1 10:1 11:1 22:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 63:1 67:1 70:1 79:1 88:1 92:1 96:1 102:1 112:1 119:1 126:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 115:1 121:1
1 5:1 9:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 4:1 10:1 11:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 75:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 106:1 118:1 121:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
1 4:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 3:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 3:1 9:1 14:1 21:1 29:1 34:1 36:1 39:1 51:1 53:1 55:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 119:1 123:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 47:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 118:1 121:1
1 5:1 10:1 11:1 22:1 31:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 69:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
1 5:1 10:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 123:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 113:1 118:1 121:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 42:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 90:1 95:1 102:1 113:1 118:1 121:1
0 1:1 7:1 14:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 27:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1
0 1:1 10:1 14:1 22:1 29:1 34:1 37:1 39:1 45:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
0 5:1 7:1 19:1 22:1 29:1 34:1 37:1 39:1 51:1 53:1 61:1 64:1 68:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 117:1 120:1
0 5:1 10:1 19:1 22:1 29:1 34:1 37:1 39:1 48:1 53:1 61:1 65:1 69:1 77:1 86:1 88:1 92:1 96:1 102:1 112:1 116:1 120:1
1 5:1 9:1 18:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 64:1 68:1 75:1 84:1 88:1 92:1 95:1 98:1 112:1 118:1 126:1
0 5:1 10:1 11:1 22:1 29:1 32:1 36:1 39:1 52:1 53:1 61:1 65:1 69:1 74:1 83:1 88:1 91:1 95:1 102:1 107:1 115:1 121:1
1 5:1 9:1 11:1 22:1 26:1 34:1 36:1 40:1 43:1 54:1 61:1 65:1 68:1 77:1 86:1 88:1 92:1 95:1 98:1 112:1 118:1 121:1" > plugin/updater_gpu/test/cpp/data/sample.libsvm
